/*
 * Decompiled with CFR 0.152.
 */
package pxv;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import pxv.Image;
import pxv.PixivAPI;

public class User {
    private final PixivAPI api;
    private final int id;
    private final String name;
    private final URL mobileURL;
    private final String ename;

    User(PixivAPI api, String[] data) throws IOException {
        assert (data.length >= 25);
        this.api = api;
        this.id = Integer.parseInt(data[1]);
        this.name = data[5];
        this.mobileURL = new URL(data[6]);
        this.ename = data[24];
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public URL getMobileURL() {
        return this.mobileURL;
    }

    public String getEname() {
        return this.ename;
    }

    public int getImageSize() {
        return this.api.getImageSize(this.getId());
    }

    public List<Image> getImages(int page) {
        return this.api.getImages(this.getId(), page);
    }

    public int getMyPixivSize() {
        return this.api.getMyPixivSize(this.getId());
    }

    public List<User> getMyPixivUsers(int page) {
        return this.api.getMyPixivUsers(this.getId(), page);
    }

    public int getBookmarkedUserSize() {
        return this.api.getBookmarkedUserSize(this.getId());
    }

    public List<User> getBookmarkedUsers(int page) {
        return this.api.getBookmarkedUsers(this.getId(), page);
    }

    public int getBookmarkSize() {
        return this.api.getBookmarkSize(this.getId());
    }

    public List<Image> getBookmarks(int page) {
        return this.api.getBookmarks(this.getId(), page);
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append(this.getClass().getName());
        ret.append("[id: ");
        ret.append(this.getId());
        ret.append(", name: ");
        ret.append(this.getName());
        ret.append(", mobile url: ");
        ret.append(this.getMobileURL());
        ret.append(", ename: ");
        ret.append(this.getEname());
        ret.append("]");
        return ret.toString();
    }

    public int hashCode() {
        return Integer.valueOf(this.getId()).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof User) {
            User that = (User)obj;
            return this.getId() == that.getId();
        }
        return super.equals(obj);
    }
}

