import unittest
import lirs

class LIRSTestCase(unittest.TestCase):
    def test_parse_lirs_line(self):
        self.assertEquals( lirs.parse_lirs_line("a,b,c,d"),['a','b','c','d'])
        self.assertEquals( lirs.parse_lirs_line("a,b,c,d"),['a','b','c','d'])
        self.assertEquals( lirs.parse_lirs_line("a,,b"),["a","","b"])
        self.assertEquals( lirs.parse_lirs_line("a\\,,b"),["a,","b"])
        self.assertEquals( lirs.parse_lirs_line("\\\\"),["\\"])


def suite():
    return unittest.makeSuite(HelloTestCase)

if __name__ == '__main__':
    unittest.main()
