# coding: utf-8
import Tkinter
try:
    import ttk
except ImportError:
    ttk_imported = True
from term import event, Terminal

def node(owner,name):
    return getattr(owner.__class__,name).attr(owner).node

class Entry(Tkinter.Entry,object):
    def __init__(self,master=None,cnf={},**kw):
        Tkinter.Entry.__init__(self,master,cnf,**kw)
        self.bind('<Return>',self._backward) # RETURNキーが押されたら値を確定する
    @event()
    def value(self): self._forward()
    def _forward(self,*args):
        self.delete(0,len(self.get()))
        self.insert(0,self.value)
    def _backward(self,*args):
        self.value = type(node(self,'value').value)(self.get())
        
class Button(Tkinter.Button,object):
    value = Terminal()
    def __init__(self,master=None,cnf={},**kw):
        Tkinter.Button.__init__(self,master,cnf,**kw)
        self.configure(command=self.clicked) # ボタンへのコールバックを設定する
    def clicked(self): self.value = self.value
    
class LatchedButton(Tkinter.Button,object):
    @event()
    def value(self): self._forward()
    def __init__(self,master=None,positive=True,cnf={},**kw):
        Tkinter.Button.__init__(self,master,cnf,**kw)
        self.configure(command=self._backward)
        if positive:
            self.state = {True:Tkinter.NORMAL,False:Tkinter.DISABLED}
        else:
            self.state = {True:Tkinter.DISABLED,False:Tkinter.NORMAL}
    def _backward(self):
        self.configure(state=Tkinter.DISABLED)
        for k,v in self.state.iteritems():
            if v is Tkinter.DISABLED:
                self.value = k
    def _forward(self):
        self.configure(state=self.state[self.value])
        
class Label(Tkinter.Label,object):
    @event('')
    def value(self): self._forward()
    def __init__(self,master=None,value='',format='%s',cnf={},**kw):
        Tkinter.Label.__init__(self,master,cnf,**kw)
        self.format = format
        self.value = value # この時点でイベントルールが起動するので、format を先に定義しておかしないとエラーになる
    def _forward(self):
        self.configure(text=self.format % self.value) # set の後に get されるので無限ループに陥ることがあるので、FW側でカットする機構を入れた
        
class Checkbutton(Tkinter.Checkbutton,object):
    @event(False)
    def value(self): self._forward()
    def __init__(self,master=None,cnf={},**kw):
        self.v = Tkinter.IntVar()
        Tkinter.Checkbutton.__init__(self,master,cnf,variable=self.v,command=self._backward,**kw)
    def _forward(self,*args):
        if self.value == 1:
            self.select()
        else:
            self.deselect()
    def _backward(self,*args):
        if self.v.get() == 1:
            self.value = True
        else:
            self.value = False
            
class MultipleEntries(Tkinter.Frame,object):
    @event()
    def value(self): self._forward()
    # def __init__(self,master=None,name=None,column=2,projection=None,frameoption={},cnf={},**kw):
    def __init__(self,master=None,name=None,column=2,frameoption={},cnf={},**kw):
        Tkinter.Frame.__init__(self,master,name=name,cnf=frameoption)
        self.joint      = []
        self.column     = column
        # self.projection = projection
        for i in range(column):
            w = Tkinter.Entry(self,cnf,name='item%d' % i,**kw)
            w.bind('<Return>',self._backward)
            w.grid(row=0,column=i)
    def _forward(self,*args):
        for i in range(self.column):
            w = self.children['item%d' % i]
            w.delete(0,len(w.get()))
            w.insert(0,self.value[i])
    def _backward(self,*args):
        value = []
        for i in range(self.column):
            value.append(type(self.value[i])(self.children['item%d' % i].get()))
        self.value = value

class AutoTrigWidget(Tkinter.Frame,object):
    interval = Terminal(100)
    value = Terminal()
    @event(False)
    def switch(self):
        if self.switch: self._polling()
    def __init__(self,master=None,cnf={},**kw):
        Tkinter.Frame.__init__(self,master,cnf,**kw)
        self.id = None
    def _polling(self):
        if self.switch:
            self.value
            self.id = self.after(self.interval,self._polling)
        else:
            if self.id: # self.id is not None
                self.after_cancel(self.id)
                self.id = None
