/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console.util;

import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LabelledComponent
extends JPanel {
    public static final int NORTH = 0;
    public static final int CENTER = 1;
    public static final int SOUTH = 2;
    private JLabel label;
    private JLabel label2;
    private JComponent component;
    private JPanel panel;
    private int align = 1;
    private Object userData = null;

    public LabelledComponent(String string, JComponent jComponent) {
        this(string, jComponent, 1);
    }

    public LabelledComponent(String string, JComponent jComponent, int n) {
        this(new JLabel(string, 4), jComponent, null, n);
    }

    public LabelledComponent(String string, JComponent jComponent, String string2) {
        this(string, jComponent, string2, 1);
    }

    public LabelledComponent(String string, JComponent jComponent, String string2, int n) {
        this(new JLabel(string, 4), jComponent, new JLabel(string2, 4), n);
    }

    public LabelledComponent(JLabel jLabel, JComponent jComponent, JLabel jLabel2, int n) {
        this.label = jLabel;
        this.label2 = jLabel2;
        this.component = jComponent;
        this.align = n;
        this.initPanel();
    }

    public JPanel getLabelledComponent() {
        return this.panel;
    }

    public JLabel getLabel() {
        return this.label;
    }

    public JComponent getComponent() {
        return this.component;
    }

    public int getLabelWidth() {
        return this.label.getPreferredSize().width;
    }

    public int getComponentWidth() {
        return this.component.getPreferredSize().width;
    }

    public void setClientData(Object object) {
        this.userData = object;
    }

    public Object getClientData() {
        return this.userData;
    }

    public void setLabelText(String string) {
        if (this.label == null || string == null) {
            return;
        }
        this.label.setText(string);
    }

    public void setLabelFont(Font font) {
        if (this.label == null || font == null) {
            return;
        }
        this.label.setFont(font);
    }

    public void setEnabled(boolean bl) {
        if (this.label != null) {
            this.label.setEnabled(bl);
        }
        if (this.label2 != null) {
            this.label2.setEnabled(bl);
        }
        if (this.component != null) {
            this.enableComponents(this.component, bl);
        }
    }

    private void enableComponents(JComponent jComponent, boolean bl) {
        for (int i = 0; i < jComponent.getComponentCount(); ++i) {
            jComponent.getComponent(i).setEnabled(bl);
        }
    }

    private void initPanel() {
        int n;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.label.setHorizontalAlignment(4);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        switch (this.align) {
            case 0: {
                n = 12;
                break;
            }
            case 1: {
                n = 10;
                break;
            }
            case 2: {
                n = 14;
                break;
            }
            default: {
                n = 10;
            }
        }
        gridBagConstraints.anchor = n;
        gridBagLayout.setConstraints(this.label, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.component, gridBagConstraints);
        this.add(this.label);
        this.add(this.component);
        if (this.label2 != null) {
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints.anchor = n;
            gridBagConstraints.weightx = 0.0;
            gridBagLayout.setConstraints(this.label2, gridBagConstraints);
            this.add(this.label2);
        }
    }
}

