/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.SidePaneUI;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.SidePaneGroup;
import java.util.ArrayList;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SidePane
extends JPanel
implements SwingConstants,
Accessible {
    private final List<SidePaneGroup> _groups = new ArrayList<SidePaneGroup>();
    private int _attachedSide;
    private boolean _rollover = true;
    private static final String uiClassID = "SidePaneUI";

    public SidePane(int n) {
        this.setAttachedSide(n);
    }

    @Override
    public SidePaneUI getUI() {
        return (SidePaneUI)this.ui;
    }

    public void setUI(SidePaneUI sidePaneUI) {
        super.setUI(sidePaneUI);
    }

    @Override
    public void updateUI() {
        if (UIDefaultsLookup.get(uiClassID) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this.setUI((SidePaneUI)UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public void addGroup(SidePaneGroup sidePaneGroup) {
        this.getGroups().add(sidePaneGroup);
    }

    public void removeGroup(SidePaneGroup sidePaneGroup) {
        this.getGroups().remove(sidePaneGroup);
    }

    public void removeGroup(int n) {
        this.removeGroup(this.getGroups().get(n));
    }

    public List<SidePaneGroup> getGroups() {
        return this._groups;
    }

    public int getAttachedSide() {
        return this._attachedSide;
    }

    public void setAttachedSide(int n) {
        if (n != 1 && n != 5 && n != 7 && n != 3) {
            throw new IllegalArgumentException("illegal attached side: must be NORTH, SOUTH, WEST, or EAST");
        }
        this._attachedSide = n;
        this.updateUI();
    }

    public boolean isRollover() {
        return this._rollover;
    }

    public void setRollover(boolean bl) {
        this._rollover = bl;
        this.updateUI();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSidePane();
        }
        return this.accessibleContext;
    }

    protected class AccessibleSidePane
    extends JPanel.AccessibleJPanel {
        protected AccessibleSidePane() {
            super(SidePane.this);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            return accessibleStateSet;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PAGE_TAB_LIST;
        }
    }
}

