/*
 * Decompiled with CFR 0.152.
 */
package com.qbrowser.persist;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Zipper {
    private ArrayList alltargetdirs = new ArrayList();
    private HashSet alljyogai = new HashSet();
    private static final int COMPRESS_LEVEL = 0;

    void getAllTargetFile(File rootdir) {
        File[] files = rootdir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            this.alltargetdirs.add(files[i]);
            if (!files[i].isDirectory()) continue;
            this.processDirectory(files[i]);
        }
    }

    void processDirectory(File dir) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            this.alltargetdirs.add(files[i]);
            if (!files[i].isDirectory()) continue;
            this.processDirectory(files[i]);
        }
    }

    String extractRelativeZipPath(String original, String exclude) {
        int i = original.indexOf(exclude);
        if (i != -1) {
            return original.substring(i + exclude.length() + 1);
        }
        return original;
    }

    String convertZipEntrySeparator(String input) {
        StringBuffer result = new StringBuffer();
        char[] inputc = input.toCharArray();
        for (int i = 0; i < inputc.length; ++i) {
            if (inputc[i] == '\\') {
                result.append('/');
                continue;
            }
            result.append(inputc[i]);
        }
        return result.toString();
    }

    public String zipForDir(File jarnameDir, File zipFile, boolean printProgress, String extension) throws IOException {
        this.alltargetdirs.clear();
        this.getAllTargetFile(jarnameDir);
        String zipnonamaehakorenisubeshi = jarnameDir.getName() + extension;
        ZipOutputStream output = new ZipOutputStream(new FileOutputStream(zipFile));
        int allsize = this.alltargetdirs.size();
        for (int i = 0; i < allsize; ++i) {
            File tfile = (File)this.alltargetdirs.get(i);
            String directparent = tfile.getParentFile().getName();
            if (!tfile.isDirectory()) {
                this.writeEntry(tfile, output, jarnameDir);
            }
            if (!printProgress) continue;
            System.out.println("Zip\u4e2d\u30fb\u30fb\u30fb(" + i + "/" + allsize + ")");
        }
        output.finish();
        output.close();
        this.alltargetdirs.clear();
        return zipnonamaehakorenisubeshi;
    }

    private void writeEntry(File file, ZipOutputStream output, File oya) throws IOException {
        int b;
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
        String fn = this.extractRelativeZipPath(file.getAbsolutePath(), oya.getAbsolutePath());
        ZipEntry entry = new ZipEntry(this.convertZipEntrySeparator(fn));
        output.putNextEntry(entry);
        while ((b = input.read()) != -1) {
            output.write(b);
        }
        input.close();
        output.closeEntry();
    }

    private long getCRCValue(File file) throws IOException {
        int b;
        CRC32 crc = new CRC32();
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
        while ((b = input.read()) != -1) {
            crc.update(b);
        }
        input.close();
        return crc.getValue();
    }

    private long getCompressedSize(File file) throws IOException {
        int b;
        ZipEntry entry = new ZipEntry(file.getName());
        entry.setMethod(8);
        ZipOutputStream out = new ZipOutputStream(new IdleOutputStream());
        out.setLevel(0);
        out.putNextEntry(entry);
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
        while ((b = input.read()) != -1) {
            out.write(b);
        }
        input.close();
        out.closeEntry();
        out.close();
        return entry.getCompressedSize();
    }

    private class IdleOutputStream
    extends OutputStream {
        private IdleOutputStream() {
        }

        public void write(int b) throws IOException {
        }
    }
}

