/*
 * Decompiled with CFR 0.152.
 */
package com.qbrowser.tree;

import com.qbrowser.QBrowserV2;
import com.qbrowser.icons.QBrowserIconsFactory;
import com.qbrowser.localstore.LocalStoreProperty;
import com.qbrowser.util.QBrowserUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class TreeIconPanel
extends JPanel
implements TreeSelectionListener {
    private JTree tree;
    private static boolean DEBUG = false;
    DefaultMutableTreeNode top = null;
    String hostandport = null;
    QBrowserV2 qb;
    JScrollPane treeView;

    public TreeIconPanel(String vhostandport, QBrowserV2 vqb) {
        this.qb = vqb;
        this.hostandport = vhostandport;
        this.top = new DefaultMutableTreeNode(new DestInfo(this.hostandport, "BKR", null));
        this.createNodes(this.top);
        this.tree = new JTree(this.top);
        this.tree.getSelectionModel().setSelectionMode(1);
        ImageIcon leafIconTPC = QBrowserIconsFactory.getImageIcon("icons/flag4_ns.png");
        ImageIcon leafIconQUE = QBrowserIconsFactory.getImageIcon("icons/flag1.png");
        ImageIcon leafIconLS = QBrowserIconsFactory.getImageIcon("icons/flag7.png");
        ImageIcon globeIcon = QBrowserIconsFactory.getImageIcon("icons/globe16.png");
        ImageIcon foIcon = QBrowserIconsFactory.getImageIcon("icons/folder_open.png");
        ImageIcon fcIcon = QBrowserIconsFactory.getImageIcon("icons/folder.png");
        ImageIcon qIconp = QBrowserIconsFactory.getImageIcon("icons/flag1_p.png");
        ImageIcon tIconp = QBrowserIconsFactory.getImageIcon("icons/flag4_p.png");
        ImageIcon lIconp = QBrowserIconsFactory.getImageIcon("icons/flag7_p.png");
        ImageIcon tIcons = QBrowserIconsFactory.getImageIcon("icons/flag4_s.png");
        QBTreeRenderer qbt = new QBTreeRenderer(tIcons, qIconp, tIconp, lIconp, foIcon, fcIcon, globeIcon, leafIconQUE, leafIconTPC, leafIconLS);
        this.tree.setCellRenderer(qbt);
        this.tree.addTreeSelectionListener(this);
        this.treeView = new JScrollPane(this.tree);
        this.treeView.setPreferredSize(new Dimension(180, 520));
        this.treeView.setMinimumSize(new Dimension(0, 0));
        this.treeView.getViewport().setMinimumSize(new Dimension(0, 0));
        this.treeView.setVerticalScrollBarPolicy(20);
        this.treeView.setHorizontalScrollBarPolicy(32);
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
        this.add(this.treeView);
    }

    public JScrollPane getTreeView() {
        return this.treeView;
    }

    public JTree getTree() {
        return this.tree;
    }

    public void refreshTree() {
        this.top.removeAllChildren();
        this.createNodes(this.top);
        this.tree.updateUI();
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
    }

    public DestInfo getSelectedDestInfo() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node != null) {
            Object nodeInfo = node.getUserObject();
            if (nodeInfo instanceof DestInfo) {
                DestInfo dest = (DestInfo)nodeInfo;
                return dest;
            }
            return null;
        }
        return null;
    }

    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object nodeInfo = node.getUserObject();
        if (node.isLeaf()) {
            DestInfo dest = (DestInfo)nodeInfo;
        }
    }

    private void createNodes(DefaultMutableTreeNode top) {
        DestInfo vdesti;
        int i;
        DefaultMutableTreeNode category = null;
        DefaultMutableTreeNode dest = null;
        category = new DefaultMutableTreeNode(new DestInfo("Queue", "FD", null));
        top.add(category);
        for (i = 0; i < QBrowserV2.destinationNamesForDisplayQueue.size(); ++i) {
            String qn = (String)QBrowserV2.destinationNamesForDisplayQueue.get(i);
            dest = new DefaultMutableTreeNode(new DestInfo(qn, "QUEUE", qn + " : Queue"));
            category.add(dest);
        }
        category = new DefaultMutableTreeNode(new DestInfo("Topic", "FD", null));
        top.add(category);
        for (i = 0; i < QBrowserV2.destinationNamesForDisplayTopic.size(); ++i) {
            String tn = (String)QBrowserV2.destinationNamesForDisplayTopic.get(i);
            dest = new DefaultMutableTreeNode(new DestInfo(tn, "TOPIC", tn + " : Topic"));
            category.add(dest);
            String dest_with_suffix = tn + " : Topic";
            ArrayList<String> local_dests = QBrowserV2.lsm.getCopyToListOfTheDestination(dest_with_suffix);
            if (local_dests == null) continue;
            for (int j = 0; j < local_dests.size(); ++j) {
                String local_dest = local_dests.get(j);
                if (!this.qb.isSubscriberThreadRunning(dest_with_suffix)) continue;
                vdesti = new DestInfo(local_dest, "C_LOCAL_STORE", local_dest + " : LOCAL_STORE");
                vdesti.parent_with_suffix = dest_with_suffix;
                DefaultMutableTreeNode ldest = new DefaultMutableTreeNode(vdesti);
                dest.add(ldest);
            }
        }
        category = new DefaultMutableTreeNode(new DestInfo("LocalStore", "FD", null));
        top.add(category);
        Collection<LocalStoreProperty> lspcol = QBrowserV2.lsm.listLocalStoreProperties();
        for (LocalStoreProperty lsp : lspcol) {
            dest = new DefaultMutableTreeNode(new DestInfo(lsp.getDestName(), "LOCAL_STORE", lsp.getDestName() + " : LOCAL_STORE"));
            category.add(dest);
            for (String listen_dest_name_with_suffix : lsp.getFromDests().keySet()) {
                String listen_dest_name_without_suffix = QBrowserUtil.getPureDestName(listen_dest_name_with_suffix);
                if (QBrowserV2.destinationNamesForDisplayTopic.contains(listen_dest_name_without_suffix)) {
                    vdesti = new DestInfo(listen_dest_name_without_suffix, "C_TOPIC", listen_dest_name_with_suffix);
                    vdesti.parent_with_suffix = lsp.getDestNameWithSuffix();
                    DefaultMutableTreeNode sdest = new DefaultMutableTreeNode(vdesti);
                    dest.add(sdest);
                    continue;
                }
                try {
                    lsp.removeFromDests(listen_dest_name_with_suffix);
                    QBrowserV2.lsm.updateAndSaveLocalStoreProperty(lsp);
                    QBrowserV2.lsm.removeRelatedEntryOfSubscribeDest(listen_dest_name_with_suffix);
                }
                catch (Exception removee) {
                    removee.printStackTrace();
                }
            }
        }
    }

    protected static ImageIcon createImageIcon(String path) {
        URL imgURL = TreeIconPanel.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    private class QBTreeRenderer
    extends DefaultTreeCellRenderer {
        Icon queueIcon;
        Icon topicIcon;
        Icon localstoreIcon;
        Icon globeIcon;
        Icon foIcon;
        Icon fcIcon;
        Icon queueIconp;
        Icon topicIconp;
        Icon lsIconp;
        Icon topicIcons;

        public QBTreeRenderer(Icon vtopicIcons, Icon vqueueIconp, Icon vtopicIconp, Icon vlsIconp, Icon vfoIcon, Icon vfcIcon, Icon vglobeIcon, Icon vqueueIcon, Icon vtopicIcon, Icon vlocalstoreIcon) {
            this.queueIcon = vqueueIcon;
            this.topicIcon = vtopicIcon;
            this.localstoreIcon = vlocalstoreIcon;
            this.globeIcon = vglobeIcon;
            this.foIcon = vfoIcon;
            this.fcIcon = vfcIcon;
            this.queueIconp = vqueueIconp;
            this.topicIconp = vtopicIconp;
            this.lsIconp = vlsIconp;
            this.topicIcons = vtopicIcons;
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.setPreferredSize(new Dimension(160, 20));
            if (row == 0) {
                this.adjustGlobal(value);
                this.setIcon(this.globeIcon);
            } else if (this.isQueue(value)) {
                if (this.isPaused(value)) {
                    this.setIcon(this.queueIconp);
                } else {
                    this.setIcon(this.queueIcon);
                }
                this.setToolTipText("Queue");
            } else if (this.isTopic(value)) {
                if (this.isPaused(value)) {
                    this.setIcon(this.topicIconp);
                } else if (this.isSubscribed(value)) {
                    this.setIcon(this.topicIcons);
                } else {
                    this.setIcon(this.topicIcon);
                }
                this.setToolTipText("Topic");
            } else if (this.isLocalStore(value)) {
                if (this.isLocalStorePaused(value)) {
                    this.setIcon(this.lsIconp);
                } else {
                    this.setIcon(this.localstoreIcon);
                }
                this.setToolTipText("LocalStore");
            } else if (!leaf) {
                this.setOpenIcon(this.foIcon);
                this.setClosedIcon(this.fcIcon);
            }
            return this;
        }

        protected boolean isQueue(Object value) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object obj = node.getUserObject();
            if (obj instanceof DestInfo) {
                DestInfo nodeInfo = (DestInfo)obj;
                String type = nodeInfo.destinationType;
                if (type.equals("QUEUE")) {
                    this.adjustSize(nodeInfo, 150);
                    return true;
                }
            }
            return false;
        }

        protected void adjustGlobal(Object value) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object obj = node.getUserObject();
            if (obj instanceof DestInfo) {
                DestInfo nodeInfo = (DestInfo)obj;
                this.adjustSize(nodeInfo, 170);
            }
        }

        protected boolean isPaused(Object value) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object obj = node.getUserObject();
            if (obj instanceof DestInfo) {
                DestInfo nodeInfo = (DestInfo)obj;
                String state = TreeIconPanel.this.qb.getStateOfDestination(nodeInfo.destinationType, nodeInfo.destinationName);
                if (state.equals("PAUSED")) {
                    return true;
                }
            }
            return false;
        }

        protected void adjustSize(DestInfo nodeInfo, int basesize) {
            int sum = basesize + (nodeInfo.destinationName.length() - 13) * 5;
            this.setPreferredSize(new Dimension(sum, 20));
        }

        protected boolean isLocalStorePaused(Object value) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object obj = node.getUserObject();
            if (obj instanceof DestInfo) {
                DestInfo nodeInfo = (DestInfo)obj;
                try {
                    if (!QBrowserV2.lsm.getLocalStoreProperty(nodeInfo.destinationName).isValid()) {
                        this.adjustSize(nodeInfo, 170);
                        return true;
                    }
                    return false;
                }
                catch (Throwable thex) {
                    return false;
                }
            }
            return false;
        }

        protected boolean isSubscribed(Object value) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object obj = node.getUserObject();
            if (obj instanceof DestInfo) {
                DestInfo nodeInfo = (DestInfo)obj;
                if (TreeIconPanel.this.qb.isSubscriberThreadRunning(nodeInfo.name_with_suffix)) {
                    this.adjustSize(nodeInfo, 170);
                    return true;
                }
                return false;
            }
            return false;
        }

        protected boolean isTopic(Object value) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object obj = node.getUserObject();
            if (obj instanceof DestInfo) {
                DestInfo nodeInfo = (DestInfo)node.getUserObject();
                String type = nodeInfo.destinationType;
                if (type.equals("TOPIC") || type.equals("C_TOPIC")) {
                    this.adjustSize(nodeInfo, 160);
                    return true;
                }
            }
            return false;
        }

        protected boolean isLocalStore(Object value) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object obj = node.getUserObject();
            if (obj instanceof DestInfo) {
                DestInfo nodeInfo = (DestInfo)node.getUserObject();
                String type = nodeInfo.destinationType;
                if (type.equals("LOCAL_STORE") || type.equals("C_LOCAL_STORE")) {
                    this.adjustSize(nodeInfo, 160);
                    return true;
                }
            }
            return false;
        }
    }

    public static class DestInfo {
        public String destinationName;
        public String destinationType;
        public String name_with_suffix;
        public String parent_with_suffix;

        public DestInfo(String vdest, String vtype, String vname_with_suffix) {
            this.destinationName = vdest;
            this.destinationType = vtype;
            this.name_with_suffix = vname_with_suffix;
        }

        public String toString() {
            return this.destinationName;
        }
    }
}

