/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util;

public class DestType {
    public static final int DEST_TYPE_QUEUE = 1;
    public static final int DEST_TYPE_TOPIC = 2;
    public static final int DEST_TEMP = 16;
    public static final int DEST_AUTO = 32;
    public static final int DEST_INTERNAL = 64;
    public static final int DEST_ADMIN = 128;
    public static final int DEST_DMQ = 4096;
    public static final int DEST_LOCAL = 8192;
    public static final int DEST_FLAVOR_SINGLE = 256;
    public static final int DEST_FLAVOR_RROBIN = 512;
    public static final int DEST_FLAVOR_FAILOVER = 1024;
    public static final String INTERNAL_DEST_PREFIX = "mq.";
    public static final String QUEUESTR = "queue";
    public static final String TOPICSTR = "topic";

    public static String queueOrTopic(int n) {
        if ((n & 0x10) > 0) {
            return null;
        }
        if ((n & 1) > 0) {
            return DestType.toString(1);
        }
        if ((n & 2) > 0) {
            return DestType.toString(2);
        }
        return null;
    }

    public static boolean isQueue(int n) {
        return (n & 1) == 1;
    }

    public static boolean isTopic(int n) {
        return (n & 2) == 2;
    }

    public static boolean isTemporary(int n) {
        return (n & 0x10) == 16;
    }

    public static boolean isLocal(int n) {
        return (n & 0x2000) == 8192;
    }

    public static boolean isAutoCreated(int n) {
        return (n & 0x20) == 32;
    }

    public static boolean isAdmin(int n) {
        return (n & 0x80) == 128;
    }

    public static boolean isInternal(int n) {
        return (n & 0x40) == 64;
    }

    public static boolean isDMQ(int n) {
        return (n & 0x1000) == 4096;
    }

    public static boolean destNameIsInternal(String string) {
        return string != null && string.startsWith(INTERNAL_DEST_PREFIX);
    }

    public static boolean destNameIsInternalLogging(String string) {
        return string != null && string.startsWith("mq.log.broker");
    }

    public static boolean isSingle(int n) {
        return (n & 0x100) == 256;
    }

    public static boolean isRRobin(int n) {
        return (n & 0x200) == 512;
    }

    public static boolean isFailover(int n) {
        return (n & 0x400) == 1024;
    }

    public static String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (DestType.isQueue(n)) {
            stringBuffer.append(QUEUESTR);
        } else if (DestType.isTopic(n)) {
            stringBuffer.append(TOPICSTR);
        } else {
            stringBuffer.append("?????");
        }
        if (DestType.isTemporary(n)) {
            stringBuffer.append(":temporary");
        }
        if (DestType.isAutoCreated(n)) {
            stringBuffer.append(":autocreated");
        }
        if (DestType.isInternal(n)) {
            stringBuffer.append(":internal");
        }
        if (DestType.isAdmin(n)) {
            stringBuffer.append(":admin");
        }
        if (DestType.isLocal(n)) {
            stringBuffer.append(":local");
        }
        if (DestType.isSingle(n)) {
            stringBuffer.append(":single");
        } else if (DestType.isRRobin(n)) {
            stringBuffer.append(":roundrobin");
        } else if (DestType.isFailover(n)) {
            stringBuffer.append(":failover");
        }
        return stringBuffer.toString();
    }
}

