/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.selector;

public class RegularExpression {
    String expression = null;
    Character escape = null;

    public RegularExpression(String string, String string2) {
        this.expression = string;
        if (string2 != null) {
            this.escape = new Character(string2.charAt(0));
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RegularExpression)) {
            return false;
        }
        RegularExpression regularExpression = (RegularExpression)object;
        return this.expression.equals(regularExpression.expression) && this.escape.equals(regularExpression.escape);
    }

    public String toString() {
        return "{re=" + this.expression + ", esc=" + this.escape + "}";
    }

    public String getExpression() {
        return this.expression;
    }

    public Character getEscape() {
        return this.escape;
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    public boolean match(String string) {
        return this.match(this.expression, 0, string, 0);
    }

    private boolean match(String string, int n, String string2, int n2) {
        int n3 = string.length();
        int n4 = string2.length();
        int n5 = n;
        int n6 = n2;
        char c = '\u0000';
        if (this.escape != null) {
            c = this.escape.charValue();
        }
        boolean bl = false;
        do {
            char c2 = string.charAt(n5);
            if (this.escape != null && c2 == c) {
                bl = true;
                ++n5;
                continue;
            }
            switch (c2) {
                case '_': {
                    if (bl) {
                        bl = false;
                        if (c2 == string2.charAt(n6)) {
                            ++n5;
                            ++n6;
                            break;
                        }
                        return false;
                    }
                    ++n5;
                    ++n6;
                    break;
                }
                case '%': {
                    if (bl) {
                        bl = false;
                        if (c2 == string2.charAt(n6)) {
                            ++n5;
                            ++n6;
                            break;
                        }
                        return false;
                    }
                    if (++n5 == n3) {
                        return true;
                    }
                    do {
                        if (!this.match(string, n5, string2, n6)) continue;
                        return true;
                    } while (++n6 < n4);
                    return false;
                }
                default: {
                    if (c2 == string2.charAt(n6)) {
                        ++n5;
                        ++n6;
                        bl = false;
                        break;
                    }
                    return false;
                }
            }
        } while (n6 < n4 && n5 < n3);
        while (n5 < n3 && string.charAt(n5) == '%') {
            ++n5;
        }
        return n6 == n4 && n5 == n3;
    }

    public static void main(String[] stringArray) {
        String[][] stringArrayArray = new String[][]{{"abcd", "abcd", null, "true"}, {"a_cd", "abcd", null, "true"}, {"_bcd", "abcd", null, "true"}, {"_bc_", "abcd", null, "true"}, {"____", "abcd", null, "true"}, {"_X__", "abcd", null, "false"}, {"a%d", "abcd", null, "true"}, {"a%d", "ad", null, "true"}, {"%cd", "abcd", null, "true"}, {"%cd", "cd", null, "true"}, {"ab%", "abcd", null, "true"}, {"ab%", "ab", null, "true"}, {"ab%%", "ab", null, "true"}, {"%%ab", "ab", null, "true"}, {"a%c%", "abcd", null, "true"}, {"a%%d", "abcd", null, "true"}, {"%%%%", "abcd", null, "true"}, {"a%cd", "acdcdbcd", null, "true"}, {"X%cd", "acdcdbcd", null, "false"}, {"a%_cd", "abcd", null, "true"}, {"a%_cd", "abbbbcd", null, "true"}, {"a%_%d", "abbbbcd", null, "true"}, {"a%_%d", "ad", null, "false"}, {"a~_c", "abc", "~", "false"}, {"a~_c", "a_c", "~", "true"}, {"a~%c", "abc", "~", "false"}, {"a~%c", "a%c", "~", "true"}, {"a%c", "abc", "~", "true"}, {"~a%c", "abc", "~", "true"}};
        int n = 0;
        for (int i = 0; i < stringArrayArray.length; ++i) {
            String string;
            RegularExpression regularExpression = new RegularExpression(stringArrayArray[i][0], stringArrayArray[i][2]);
            boolean bl = Boolean.valueOf(stringArrayArray[i][3]);
            boolean bl2 = regularExpression.match(stringArrayArray[i][1]);
            if (bl2 == bl) {
                string = "      PASS";
            } else {
                string = "***** FAIL";
                ++n;
            }
            System.out.println(string + " " + stringArrayArray[i][0] + "=" + stringArrayArray[i][1] + (stringArrayArray[i][2] != null ? " (esc=" + stringArrayArray[i][2] + ")" : "") + " : expected=" + bl + " actual=" + bl2 + " ");
        }
        System.out.println(stringArrayArray.length + " tests: " + (stringArrayArray.length - n) + " passed " + n + " failed ");
        if (n > 0) {
            System.exit(1);
        } else {
            System.exit(0);
        }
    }
}

