/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.broker;

import com.sun.messaging.jmq.admin.apps.broker.BrokerCmdOptions;
import com.sun.messaging.jmq.admin.apps.broker.BrokerCmdPrinter;
import com.sun.messaging.jmq.admin.bkrutil.BrokerConstants;
import com.sun.messaging.jmq.admin.resources.AdminResources;
import com.sun.messaging.jmq.admin.util.Globals;

public class HelpPrinter
implements BrokerCmdOptions,
BrokerConstants {
    private AdminResources ar = Globals.getAdminResources();

    public void printShortHelp(int n) {
        this.printUsage();
        this.printSubcommands();
        this.printOptions();
        System.exit(n);
    }

    public void printLongHelp() {
        this.printUsage();
        this.printSubcommands();
        this.printOptions();
        this.printAttributes();
        this.printExamples();
        System.exit(0);
    }

    private void printUsage() {
        Globals.stdOutPrintln(this.ar.getString("A1150"));
    }

    private void printSubcommands() {
        Globals.stdOutPrintln(this.ar.getString("A1151"));
    }

    private void printOptions() {
        Globals.stdOutPrintln(this.ar.getString("A1152"));
    }

    private void printAttributes() {
        int n;
        Object[] objectArray = new Object[]{"queueDeliveryPolicy", "maxTotalMsgBytes", "maxBytesPerMsg", "maxNumMsgs"};
        String string = "maxBytesPerMsg";
        Globals.stdOutPrintln(this.ar.getString("A1153"));
        Globals.stdOutPrintln(this.ar.getString("A1154"));
        this.printQueueAttrs();
        Globals.stdOutPrintln(this.ar.getString("A1155", string));
        this.printTopicAttrs();
        Globals.stdOutPrintln(this.ar.getString("A1175"));
        for (n = 0; n < DEST_ATTRS_UNLIMITED.length; ++n) {
            Globals.stdOutPrintln("    " + DEST_ATTRS_UNLIMITED[n]);
        }
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(this.ar.getString("A1170", "limitBehavior"));
        Globals.stdOutPrint("\t");
        for (n = 0; n < BKR_LIMIT_BEHAV_VALID_VALUES.length; ++n) {
            Globals.stdOutPrint(BKR_LIMIT_BEHAV_VALID_VALUES[n]);
            if (n + 1 >= BKR_LIMIT_BEHAV_VALID_VALUES.length) continue;
            Globals.stdOutPrint(" ");
        }
        Globals.stdOutPrintln("\n");
        Globals.stdOutPrintln(this.ar.getString("A1163"));
        this.printBrokerAttrs();
        Globals.stdOutPrintln(this.ar.getString("A1164"));
        this.printServiceAttrs();
    }

    private void printExamples() {
        Globals.stdOutPrintln(this.ar.getString("A1156"));
        Globals.stdOutPrintln(this.ar.getString("A1157"));
        Globals.stdOutPrintln(this.ar.getString("A1158"));
        Globals.stdOutPrintln(this.ar.getString("A1159"));
        Globals.stdOutPrintln(this.ar.getString("A1160"));
        Globals.stdOutPrintln(this.ar.getString("A1161"));
        Globals.stdOutPrintln(this.ar.getString("A1162"));
        Globals.stdOutPrintln(this.ar.getString("A1165"));
        Globals.stdOutPrintln(this.ar.getString("A1166"));
        Globals.stdOutPrintln(this.ar.getString("A1167"));
        Globals.stdOutPrintln(this.ar.getString("A1168"));
        Globals.stdOutPrintln(this.ar.getString("A1169"));
        Globals.stdOutPrintln(this.ar.getString("A1171"));
        Globals.stdOutPrintln(this.ar.getString("A1172"));
        Globals.stdOutPrintln(this.ar.getString("A1173"));
    }

    private void printBrokerAttrs() {
        int n;
        BrokerCmdPrinter brokerCmdPrinter = new BrokerCmdPrinter(2, 4);
        Object[] objectArray = new String[2];
        String string = "    ";
        objectArray[0] = string + "imq.portmapper.port";
        objectArray[1] = this.ar.getString("A1441");
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = string + "imq.autocreate.topic";
        objectArray[1] = this.ar.getString("A1526");
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = string + "imq.autocreate.queue";
        objectArray[1] = this.ar.getString("A1527");
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = string + "imq.log.level";
        objectArray[1] = this.ar.getString("A1528");
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = string + "imq.log.file.rolloverbytes";
        objectArray[1] = this.ar.getString("A1529");
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = string + "imq.log.file.rolloversecs";
        objectArray[1] = this.ar.getString("A1530");
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = string + "imq.system.max_count";
        objectArray[1] = this.ar.getString("A1534");
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = string + "imq.system.max_size";
        objectArray[1] = this.ar.getString("A1535");
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = string + "imq.message.max_size";
        objectArray[1] = this.ar.getString("A1536");
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = string + "imq.cluster.url";
        objectArray[1] = this.ar.getString("A1575");
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = string + "imq.autocreate.queue.maxNumActiveConsumers";
        objectArray[1] = this.ar.getString("A1654");
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = string + "imq.autocreate.queue.maxNumBackupConsumers";
        objectArray[1] = this.ar.getString("A1655");
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = string + "imq.destination.logDeadMsgs";
        objectArray[1] = this.ar.getString("A1683");
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = string + "imq.destination.DMQ.truncateBody";
        objectArray[1] = this.ar.getString("A1686");
        brokerCmdPrinter.add(objectArray);
        brokerCmdPrinter.print();
        Globals.stdOutPrintln("");
        Globals.stdOutPrint(string);
        Globals.stdOutPrintln(this.ar.getString("A1170", "imq.log.level"));
        Globals.stdOutPrint("\t");
        for (n = 0; n < BKR_LOG_LEVEL_VALID_VALUES.length; ++n) {
            Globals.stdOutPrint(BKR_LOG_LEVEL_VALID_VALUES[n]);
            if (n + 1 >= BKR_LOG_LEVEL_VALID_VALUES.length) continue;
            Globals.stdOutPrint(" ");
        }
        Globals.stdOutPrintln("\n");
        Globals.stdOutPrintln(this.ar.getString("A1176"));
        for (n = 0; n < BKR_ATTRS_UNLIMITED.length; ++n) {
            Globals.stdOutPrintln("    " + BKR_ATTRS_UNLIMITED[n]);
        }
        Globals.stdOutPrintln("");
    }

    private void printQueueAttrs() {
        BrokerCmdPrinter brokerCmdPrinter = new BrokerCmdPrinter(2, 4);
        Object[] objectArray = new String[2];
        String string = "    ";
        objectArray[0] = string + "maxNumMsgs";
        objectArray[1] = this.ar.getString("A1407");
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = string + "maxTotalMsgBytes";
        objectArray[1] = this.ar.getString("A1406");
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = string + "maxBytesPerMsg";
        objectArray[1] = this.ar.getString("A1408");
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = string + "maxNumBackupConsumers";
        objectArray[1] = this.ar.getString("A1409");
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = string + "maxNumActiveConsumers";
        objectArray[1] = this.ar.getString("A1410");
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = string + "isLocalOnly" + " " + this.ar.getString("A1174");
        objectArray[1] = this.ar.getString("A1411");
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = string + "limitBehavior";
        objectArray[1] = this.ar.getString("A1412");
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = string + "localDeliveryPreferred";
        objectArray[1] = this.ar.getString("A1413");
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = string + "consumerFlowLimit";
        objectArray[1] = this.ar.getString("A1414");
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = string + "maxNumProducers";
        objectArray[1] = this.ar.getString("A1415");
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = string + "useDMQ";
        objectArray[1] = this.ar.getString("A1446");
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = string + "validateXMLSchemaEnabled";
        objectArray[1] = this.ar.getString("A1447");
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = string + "XMLSchemaURIList";
        objectArray[1] = this.ar.getString("A1448");
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = string + "reloadXMLSchemaOnFailure";
        objectArray[1] = this.ar.getString("A1449");
        brokerCmdPrinter.add(objectArray);
        brokerCmdPrinter.print();
        Globals.stdOutPrintln("");
    }

    private void printTopicAttrs() {
        BrokerCmdPrinter brokerCmdPrinter = new BrokerCmdPrinter(2, 4);
        Object[] objectArray = new String[2];
        String string = "    ";
        objectArray[0] = string + "maxNumMsgs";
        objectArray[1] = this.ar.getString("A1407");
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = string + "maxTotalMsgBytes";
        objectArray[1] = this.ar.getString("A1406");
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = string + "maxBytesPerMsg";
        objectArray[1] = this.ar.getString("A1408");
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = string + "isLocalOnly" + " " + this.ar.getString("A1174");
        objectArray[1] = this.ar.getString("A1411");
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = string + "limitBehavior";
        objectArray[1] = this.ar.getString("A1412");
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = string + "consumerFlowLimit";
        objectArray[1] = this.ar.getString("A1414");
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = string + "maxNumProducers";
        objectArray[1] = this.ar.getString("A1415");
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = string + "useDMQ";
        objectArray[1] = this.ar.getString("A1446");
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = string + "validateXMLSchemaEnabled";
        objectArray[1] = this.ar.getString("A1447");
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = string + "XMLSchemaURIList";
        objectArray[1] = this.ar.getString("A1448");
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = string + "reloadXMLSchemaOnFailure";
        objectArray[1] = this.ar.getString("A1449");
        brokerCmdPrinter.add(objectArray);
        brokerCmdPrinter.print();
        Globals.stdOutPrintln("");
    }

    private void printServiceAttrs() {
        BrokerCmdPrinter brokerCmdPrinter = new BrokerCmdPrinter(2, 4);
        Object[] objectArray = new String[2];
        String string = "    ";
        objectArray[0] = string + "port";
        objectArray[1] = this.ar.getString("A1421");
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = string + "minThreads";
        objectArray[1] = this.ar.getString("A1423");
        brokerCmdPrinter.add(objectArray);
        objectArray[0] = string + "maxThreads";
        objectArray[1] = this.ar.getString("A1424");
        brokerCmdPrinter.add(objectArray);
        brokerCmdPrinter.println();
    }
}

