/*
 * Decompiled with CFR 0.152.
 */
package jp.sun.util;

import com.sun.messaging.jmq.admin.apps.broker.BrokerCmdException;
import com.sun.messaging.jmq.admin.apps.broker.BrokerCmdOptions;
import com.sun.messaging.jmq.admin.apps.broker.BrokerCmdProperties;
import com.sun.messaging.jmq.admin.apps.console.event.AdminEvent;
import com.sun.messaging.jmq.admin.apps.console.event.AdminEventListener;
import com.sun.messaging.jmq.admin.apps.console.event.BrokerCmdStatusEvent;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdmin;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdminException;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdminUtil;
import com.sun.messaging.jmq.admin.bkrutil.BrokerConstants;
import com.sun.messaging.jmq.admin.resources.AdminResources;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.io.DestMetricsCounters;
import com.sun.messaging.jmq.io.MetricCounters;
import com.sun.messaging.jmq.jmsclient.GenericPortMapperClient;
import com.sun.messaging.jmq.util.DebugPrinter;
import com.sun.messaging.jmq.util.DestLimitBehavior;
import com.sun.messaging.jmq.util.DestState;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.FileUtil;
import com.sun.messaging.jmq.util.Password;
import com.sun.messaging.jmq.util.ServiceState;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.admin.DestinationInfo;
import com.sun.messaging.jmq.util.admin.DurableInfo;
import com.sun.messaging.jmq.util.admin.ServiceInfo;
import com.sun.messaging.jms.management.server.BrokerState;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import jp.sun.util.BrokerCmdPrinter;

public class CmdRunner
implements BrokerCmdOptions,
BrokerConstants,
AdminEventListener {
    private static final int METRICS_TOTALS = 0;
    private static final int METRICS_RATES = 1;
    private static final int METRICS_CONNECTIONS = 2;
    private static final int METRICS_CONSUMER = 3;
    private static final int METRICS_DISK = 4;
    private static final int METRICS_REMOVE = 5;
    private static final int LIST_ALL = 0;
    private static final int LIST_TOPIC = 1;
    private static final int LIST_QUEUE = 2;
    private int[] zeroNegOneInt = new int[]{0, -1};
    private long[] zeroNegOneLong = new long[]{0L, -1L};
    private String[] zeroNegOneString = new String[]{"0", "-1"};
    private String[] negOneString = new String[]{"-1"};
    private AdminResources ar = Globals.getAdminResources();
    private BrokerCmdProperties brokerCmdProps;
    private BrokerAdmin admin;
    private int filter_transactionstate = -1;

    public CmdRunner(BrokerCmdProperties props) {
        this.brokerCmdProps = props;
    }

    public void setFilter_transactionstate(int value) {
        this.filter_transactionstate = value;
    }

    public String runCommands(StringBuffer result) {
        int exitcode = 0;
        if (this.brokerCmdProps.debugModeSet()) {
            exitcode = this.runDebug(this.brokerCmdProps, result);
            return String.valueOf(exitcode);
        }
        String cmd = this.brokerCmdProps.getCommand();
        if (cmd.equals("list")) {
            exitcode = this.runList(this.brokerCmdProps, result);
        } else if (cmd.equals("pause")) {
            exitcode = this.runPause(this.brokerCmdProps, result);
        } else if (cmd.equals("resume")) {
            exitcode = this.runResume(this.brokerCmdProps, result);
        } else if (cmd.equals("shutdown")) {
            exitcode = this.runShutdown(this.brokerCmdProps, result);
        } else if (cmd.equals("restart")) {
            exitcode = this.runRestart(this.brokerCmdProps, result);
        } else if (cmd.equals("create")) {
            exitcode = this.runCreate(this.brokerCmdProps, result);
        } else if (cmd.equals("destroy")) {
            exitcode = this.runDestroy(this.brokerCmdProps, result);
        } else if (cmd.equals("purge")) {
            exitcode = this.runPurge(this.brokerCmdProps, result);
        } else if (cmd.equals("update")) {
            exitcode = this.runUpdate(this.brokerCmdProps, result);
        } else if (cmd.equals("query")) {
            exitcode = this.runQuery(this.brokerCmdProps, result);
        } else if (cmd.equals("metrics")) {
            exitcode = this.runMetrics(this.brokerCmdProps, result);
        } else if (cmd.equals("reload")) {
            exitcode = this.runReload(this.brokerCmdProps, result);
        } else if (cmd.equals("commit")) {
            exitcode = this.runCommit(this.brokerCmdProps, result);
        } else if (cmd.equals("rollback")) {
            exitcode = this.runRollback(this.brokerCmdProps, result);
        } else if (cmd.equals("compact")) {
            exitcode = this.runCompact(this.brokerCmdProps, result);
        } else if (cmd.equals("quiesce")) {
            exitcode = this.runQuiesce(this.brokerCmdProps, result);
        } else if (cmd.equals("takeover")) {
            exitcode = this.runTakeover(this.brokerCmdProps, result);
        } else if (cmd.equals("unquiesce")) {
            exitcode = this.runUnquiesce(this.brokerCmdProps, result);
        } else if (cmd.equals("reset")) {
            exitcode = this.runReset(this.brokerCmdProps, result);
        } else if (cmd.equals(".exists")) {
            exitcode = this.runExists(this.brokerCmdProps, result);
        } else if (cmd.equals(".getattr")) {
            exitcode = this.runGetAttr(this.brokerCmdProps, result);
        } else if (cmd.equals("._kill")) {
            exitcode = this.runUngracefulKill(this.brokerCmdProps, result);
        } else if (cmd.equals(".purgeall")) {
            exitcode = this.runPurgeAll(this.brokerCmdProps, result);
        } else if (cmd.equals(".destroyall")) {
            exitcode = this.runDestroyAll(this.brokerCmdProps, result);
        }
        return String.valueOf(exitcode);
    }

    public void adminEventDispatched(AdminEvent e) {
        BrokerCmdStatusEvent be;
        int type;
        if (e instanceof BrokerCmdStatusEvent && (type = (be = (BrokerCmdStatusEvent)e).getType()) == 31) {
            int numRetriesAttempted = be.getNumRetriesAttempted();
            int maxNumRetries = be.getMaxNumRetries();
            long retryTimeount = be.getRetryTimeount();
            Object[] args = new Object[]{Integer.toString(numRetriesAttempted), Integer.toString(maxNumRetries), Long.toString(retryTimeount)};
            String s = this.ar.getString("A1350", args);
            Globals.stdOutPrintln((String)s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList retrieveDestinations(boolean isQueue) {
        BrokerAdmin broker = this.init();
        if (broker == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        try {
            this.connectToBroker(broker);
            broker.sendGetDestinationsMessage(null, -1);
            Vector dests = broker.receiveGetDestinationsReplyMessage();
            Enumeration thisEnum = dests.elements();
            while (thisEnum.hasMoreElements()) {
                DestinationInfo dInfo = (DestinationInfo)thisEnum.nextElement();
                if ("__JMQAdmin".equals(dInfo.name) || DestType.isInternal((int)dInfo.fulltype) || DestType.isTemporary((int)dInfo.type)) continue;
                if (DestType.isTopic((int)dInfo.type) && !isQueue) {
                    result.add(dInfo.name);
                }
                if (!DestType.isQueue((int)dInfo.type) || !isQueue) continue;
                result.add(dInfo.name);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (broker != null) {
                broker.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DestinationInfo getSpecifiedDestinationInfo() {
        BrokerAdmin broker = this.init();
        if (broker == null) {
            return null;
        }
        DestinationInfo retval = null;
        String destName = this.brokerCmdProps.getTargetName();
        int destTypeMask = this.getDestTypeMask(this.brokerCmdProps);
        try {
            this.connectToBroker(broker);
            broker.sendGetDestinationsMessage(destName, destTypeMask);
            Vector dest = broker.receiveGetDestinationsReplyMessage();
            if (dest != null && dest.size() == 1) {
                DestinationInfo dInfo;
                Enumeration thisEnum = dest.elements();
                retval = dInfo = (DestinationInfo)thisEnum.nextElement();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (broker != null) {
                broker.close();
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStateOfSpecifiedDestination() {
        BrokerAdmin broker = this.init();
        if (broker == null) {
            return null;
        }
        String retval = null;
        String destName = this.brokerCmdProps.getTargetName();
        int destTypeMask = this.getDestTypeMask(this.brokerCmdProps);
        try {
            this.connectToBroker(broker);
            broker.sendGetDestinationsMessage(destName, destTypeMask);
            Vector dest = broker.receiveGetDestinationsReplyMessage();
            if (dest != null && dest.size() == 1) {
                Enumeration thisEnum = dest.elements();
                DestinationInfo dInfo = (DestinationInfo)thisEnum.nextElement();
                retval = DestState.toString((int)dInfo.destState);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (broker != null) {
                broker.close();
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String retrieveInstanceName() {
        BrokerAdmin broker = this.init();
        if (broker == null) {
            return null;
        }
        String retval = null;
        try {
            this.connectToBroker(broker);
            broker.sendGetBrokerPropsMessage();
            Properties bkrProps = broker.receiveGetBrokerPropsReplyMessage();
            retval = bkrProps.getProperty("imq.instancename", "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (broker != null) {
                broker.close();
            }
        }
        return retval;
    }

    private int runList(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        boolean listAll;
        BrokerAdmin broker = this.init();
        String commandArg = brokerCmdProps.getCommandArg();
        String destTypeStr = brokerCmdProps.getDestType();
        int destTypeMask = this.getDestTypeMask(brokerCmdProps);
        boolean bl = listAll = destTypeStr == null;
        if ("dst".equals(commandArg)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1203")).append("\n");
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            if (listAll) {
                sb.append(this.ar.getString("A1201")).append("\n");
            } else if (DestType.isQueue((int)destTypeMask)) {
                sb.append(this.ar.getString("A1291")).append("\n");
            } else if (DestType.isTopic((int)destTypeMask)) {
                sb.append(this.ar.getString("A1290")).append("\n");
            }
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
                broker.sendGetDestinationsMessage(null, -1);
                Vector dests = broker.receiveGetDestinationsReplyMessage();
                if (dests != null) {
                    if (listAll) {
                        this.listDests(brokerCmdProps, dests, 0);
                    } else if (DestType.isTopic((int)destTypeMask)) {
                        this.listDests(brokerCmdProps, dests, 1);
                    } else if (DestType.isQueue((int)destTypeMask)) {
                        this.listDests(brokerCmdProps, dests, 2);
                    }
                } else {
                    sb.append(this.ar.getString("A1203")).append("\n");
                    return 1;
                }
                sb.append(this.ar.getString("A1202")).append("\n");
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1203")).append("\n");
                return 1;
            }
        }
        if ("svc".equals(commandArg)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1206")).append("\n");
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            sb.append(this.ar.getString("A1204")).append("\n");
            this.printBrokerInfo(broker);
            try {
                BrokerCmdPrinter bcp;
                this.connectToBroker(broker);
                broker.sendGetServicesMessage(null);
                Vector svcs = broker.receiveGetServicesReplyMessage();
                if (svcs != null) {
                    bcp = new BrokerCmdPrinter(3, 4, "-");
                    Object[] row = new String[3];
                    row[0] = this.ar.getString("A1420");
                    row[1] = this.ar.getString("A1421");
                    row[2] = this.ar.getString("A1422");
                    bcp.addTitle((String[])row);
                    Enumeration thisEnum = svcs.elements();
                    while (thisEnum.hasMoreElements()) {
                        ServiceInfo sInfo = (ServiceInfo)thisEnum.nextElement();
                        row[0] = sInfo.name;
                        if (sInfo.port == -1) {
                            row[1] = "-";
                        } else if (sInfo.dynamicPort) {
                            switch (sInfo.state) {
                                case -1: {
                                    row[1] = this.ar.getString("A1520");
                                    break;
                                }
                                default: {
                                    row[1] = new Integer(sInfo.port).toString() + " (" + this.ar.getString("A1520") + ")";
                                    break;
                                }
                            }
                        } else {
                            row[1] = new Integer(sInfo.port).toString() + " (" + this.ar.getString("A1521") + ")";
                        }
                        row[2] = ServiceState.getString((int)sInfo.state);
                        bcp.add(row);
                    }
                } else {
                    sb.append(this.ar.getString("A1206")).append("\n");
                    return 1;
                }
                bcp.println();
                sb.append(this.ar.getString("A1205")).append("\n");
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1206")).append("\n");
                return 1;
            }
        }
        if ("dur".equals(commandArg)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1553")).append("\n");
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String destName = brokerCmdProps.getDestName();
            sb.append(this.ar.getString("A1551", (Object)destName)).append("\n");
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1553")).append("\n");
                return 1;
            }
            try {
                this.isDestTypeTopic(broker, destName);
            }
            catch (BrokerAdminException bae) {
                if (7 == bae.getType()) {
                    bae.setBrokerErrorStr(this.ar.getString("A1001") + this.ar.getKString("A3111", (Object)destName));
                }
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1553")).append("\n");
                return 1;
            }
            try {
                BrokerCmdPrinter bcp;
                broker.sendGetDurablesMessage(destName, null);
                Vector durs = broker.receiveGetDurablesReplyMessage();
                if (durs != null) {
                    bcp = new BrokerCmdPrinter(4, 3, "-");
                    Object[] row = new String[4];
                    row[0] = this.ar.getString("A1430");
                    row[1] = this.ar.getString("A1431");
                    row[2] = this.ar.getString("A1432");
                    row[3] = this.ar.getString("A1433");
                    bcp.addTitle((String[])row);
                    Enumeration thisEnum = durs.elements();
                    while (thisEnum.hasMoreElements()) {
                        DurableInfo dInfo = (DurableInfo)thisEnum.nextElement();
                        row[0] = dInfo.name == null ? "" : dInfo.name;
                        row[1] = dInfo.clientID == null ? "" : dInfo.clientID;
                        row[2] = new Integer(dInfo.nMessages).toString();
                        row[3] = dInfo.isActive ? this.ar.getString("A1510") : this.ar.getString("A1511");
                        bcp.add(row);
                    }
                } else {
                    sb.append(this.ar.getString("A1553")).append("\n");
                    return 1;
                }
                bcp.setKeyCriteria(new int[]{0, 1});
                bcp.println();
                sb.append(this.ar.getString("A1552")).append("\n");
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1553")).append("\n");
                return 1;
            }
        }
        if ("txn".equals(commandArg)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1253")).append("\n");
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            sb.append(this.ar.getString("A1250")).append("\n");
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
                broker.sendGetTxnsMessage();
                Vector txns = broker.receiveGetTxnsReplyMessage();
                if (txns != null && txns.size() > 0) {
                    BrokerCmdPrinter bcp = new BrokerCmdPrinter(5, 3, "-");
                    BrokerCmdPrinter bcp_local = new BrokerCmdPrinter(4, 3, "-");
                    BrokerCmdPrinter bcp_remote = new BrokerCmdPrinter(4, 3, "-");
                    Object[] row = new String[5];
                    row[0] = this.ar.getString("A1263");
                    row[1] = this.ar.getString("A1269");
                    row[2] = this.ar.getString("A1270");
                    row[3] = this.ar.getString("A1272");
                    row[4] = this.ar.getString("A1266");
                    bcp.addTitle((String[])row);
                    row[0] = this.ar.getString("A1263");
                    row[1] = this.ar.getString("A1269");
                    row[2] = this.ar.getString("A1270");
                    row[3] = this.ar.getString("A1266");
                    bcp_local.addTitle((String[])row);
                    row[0] = this.ar.getString("A1263");
                    row[1] = this.ar.getString("A1269");
                    row[2] = "# Acks";
                    row[3] = "Remote broker";
                    bcp_remote.addTitle((String[])row);
                    Enumeration thisEnum = txns.elements();
                    while (thisEnum.hasMoreElements()) {
                        String tmpStr2;
                        String tmpStr;
                        Integer tmpInt;
                        Long tmpLong;
                        Hashtable txnInfo = (Hashtable)thisEnum.nextElement();
                        Integer type = (Integer)txnInfo.get("type");
                        if (type == 0) {
                            tmpLong = (Long)txnInfo.get("txnid");
                            row[0] = this.checkNullAndPrint(tmpLong);
                            tmpInt = (Integer)txnInfo.get("state");
                            row[1] = this.getTxnStateString(tmpInt);
                            tmpStr = (String)txnInfo.get("user");
                            row[2] = this.checkNullAndPrint(tmpStr);
                            tmpInt = (Integer)txnInfo.get("nmsgs");
                            tmpStr = this.checkNullAndPrint(tmpInt);
                            tmpInt = (Integer)txnInfo.get("nacks");
                            tmpStr2 = this.checkNullAndPrint(tmpInt);
                            row[3] = tmpStr + "/" + tmpStr2;
                            tmpLong = (Long)txnInfo.get("timestamp");
                            row[4] = this.checkNullAndPrintTimestamp(tmpLong);
                            bcp.add(row);
                            continue;
                        }
                        if (type == 1) {
                            tmpLong = (Long)txnInfo.get("txnid");
                            row[0] = this.checkNullAndPrint(tmpLong);
                            tmpInt = (Integer)txnInfo.get("state");
                            row[1] = this.getTxnStateString(tmpInt);
                            tmpStr = (String)txnInfo.get("user");
                            row[2] = this.checkNullAndPrint(tmpStr);
                            tmpLong = (Long)txnInfo.get("timestamp");
                            row[3] = this.checkNullAndPrintTimestamp(tmpLong);
                            bcp_local.add(row);
                            continue;
                        }
                        if (type != 2) continue;
                        tmpLong = (Long)txnInfo.get("txnid");
                        row[0] = this.checkNullAndPrint(tmpLong);
                        tmpInt = (Integer)txnInfo.get("state");
                        row[1] = this.getTxnStateString(tmpInt);
                        tmpInt = (Integer)txnInfo.get("nacks");
                        row[2] = tmpStr2 = this.checkNullAndPrint(tmpInt);
                        tmpStr = (String)txnInfo.get("homebroker");
                        row[3] = this.checkNullAndPrint(tmpStr);
                        bcp_remote.add(row);
                    }
                    sb.append("Transactions that are owned by this broker\n");
                    bcp.println();
                    sb.append("   Transactions that involve remote brokers\n");
                    bcp_local.setIndent(3);
                    bcp_local.println();
                    sb.append("Transactions that are owned by a remote broker\n");
                    bcp_remote.println();
                    sb.append(this.ar.getString("A1251")).append("\n");
                }
                sb.append(this.ar.getString("A1252")).append("\n");
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1253")).append("\n");
                return 1;
            }
        } else if ("cxn".equals(commandArg)) {
            String svcName = brokerCmdProps.getService();
            if (broker == null) {
                sb.append(this.ar.getString("A1321")).append("\n");
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            if (svcName == null) {
                sb.append(this.ar.getString("A1318")).append("\n");
                this.printBrokerInfo(broker);
            } else {
                sb.append(this.ar.getString("A1319")).append("\n");
                this.printServiceInfo(svcName);
                sb.append(this.ar.getString("A1200")).append("\n");
                this.printBrokerInfo(broker);
            }
            try {
                this.connectToBroker(broker);
                broker.sendGetConnectionsMessage(svcName, null);
                Vector cxnList = broker.receiveGetConnectionsReplyMessage();
                if (cxnList != null && cxnList.size() > 0) {
                    BrokerCmdPrinter bcp = new BrokerCmdPrinter(6, 2, "-");
                    Object[] row = new String[6];
                    int i = 0;
                    int n = i++;
                    row[n] = this.ar.getString("A1323");
                    int n2 = i++;
                    row[n2] = this.ar.getString("A1327");
                    int n3 = i++;
                    row[n3] = this.ar.getString("A1331");
                    int n4 = i++;
                    row[n4] = this.ar.getString("A1328");
                    int n5 = i++;
                    row[n5] = this.ar.getString("A1329");
                    int n6 = i++;
                    row[n6] = this.ar.getString("A1325");
                    bcp.addTitle((String[])row);
                    Enumeration thisEnum = cxnList.elements();
                    while (thisEnum.hasMoreElements()) {
                        Hashtable cxnInfo = (Hashtable)thisEnum.nextElement();
                        i = 0;
                        Long tmpLong = (Long)cxnInfo.get("cxnid");
                        row[i++] = this.checkNullAndPrint(tmpLong);
                        String tmpStr = (String)cxnInfo.get("user");
                        row[i++] = this.checkNullAndPrint(tmpStr);
                        tmpStr = (String)cxnInfo.get("service");
                        row[i++] = this.checkNullAndPrint(tmpStr);
                        Integer tmpInt = (Integer)cxnInfo.get("nproducers");
                        row[i++] = this.checkNullAndPrint(tmpInt);
                        tmpInt = (Integer)cxnInfo.get("nconsumers");
                        row[i++] = this.checkNullAndPrint(tmpInt);
                        tmpStr = (String)cxnInfo.get("host");
                        row[i++] = this.checkNullAndPrint(tmpStr);
                        bcp.add(row);
                    }
                    bcp.println();
                    sb.append(this.ar.getString("A1320")).append("\n");
                }
                sb.append(this.ar.getString("A1322")).append("\n");
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1321")).append("\n");
                return 1;
            }
        } else if ("bkr".equals(commandArg)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1713")).append("\n");
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            sb.append(this.ar.getString("A1712")).append("\n");
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
                broker.sendGetBrokerPropsMessage();
                Properties bkrProps = broker.receiveGetBrokerPropsReplyMessage();
                BrokerCmdPrinter haBcp = new BrokerCmdPrinter(2, 3, null);
                Object[] haInfoRow = new String[2];
                String value = bkrProps.getProperty("imq.cluster.ha");
                boolean isHA = Boolean.valueOf(value);
                if (isHA) {
                    haInfoRow[0] = this.ar.getString("A1709");
                    haInfoRow[1] = value = bkrProps.getProperty("imq.cluster.clusterid", "");
                    haBcp.add(haInfoRow);
                }
                haInfoRow[0] = this.ar.getString("A1710");
                haInfoRow[1] = !isHA ? Boolean.FALSE.toString() : Boolean.TRUE.toString();
                haBcp.add(haInfoRow);
                haBcp.println();
                broker.sendGetClusterMessage(true);
                Vector bkrList = broker.receiveGetClusterReplyMessage();
                if (bkrList != null && bkrList.size() > 0) {
                    BrokerCmdPrinter bcp;
                    if (isHA) {
                        bcp = new BrokerCmdPrinter(6, 3, "-");
                        Object[] row = new String[6];
                        bcp.setSortNeeded(false);
                        bcp.setTitleAlign(1);
                        int i = 0;
                        row[i++] = "";
                        row[i++] = "";
                        row[i++] = "";
                        row[i++] = "";
                        int n = i++;
                        row[n] = this.ar.getString("A1720");
                        int n7 = i++;
                        row[n7] = this.ar.getString("A1721");
                        bcp.addTitle((String[])row);
                        i = 0;
                        int n8 = i++;
                        row[n8] = this.ar.getString("A1716");
                        int n9 = i++;
                        row[n9] = this.ar.getString("A1717");
                        int n10 = i++;
                        row[n10] = this.ar.getString("A1718");
                        int n11 = i++;
                        row[n11] = this.ar.getString("A1719");
                        int n12 = i++;
                        row[n12] = this.ar.getString("A1736");
                        int n13 = i++;
                        row[n13] = this.ar.getString("A1737");
                        bcp.addTitle((String[])row);
                        Enumeration thisEnum = bkrList.elements();
                        while (thisEnum.hasMoreElements()) {
                            Hashtable bkrClsInfo = (Hashtable)thisEnum.nextElement();
                            i = 0;
                            row[i++] = this.checkNullAndPrint(bkrClsInfo.get("ID"));
                            row[i++] = this.checkNullAndPrint(bkrClsInfo.get("Address"));
                            Integer tmpInt = (Integer)bkrClsInfo.get("State");
                            row[i++] = tmpInt != null ? BrokerState.toString((int)tmpInt) : "";
                            Long tmpLong = (Long)bkrClsInfo.get("NumMsgs");
                            row[i++] = this.checkNullAndPrint(tmpLong);
                            row[i++] = this.checkNullAndPrint(bkrClsInfo.get("TakeoverBrokerID"));
                            tmpLong = (Long)bkrClsInfo.get("StatusTimestamp");
                            if (tmpLong != null) {
                                long idle = System.currentTimeMillis() - tmpLong;
                                row[i++] = this.getTimeString(idle);
                            } else {
                                row[i++] = "";
                            }
                            bcp.add(row);
                        }
                    } else {
                        bcp = new BrokerCmdPrinter(2, 3, "-");
                        Object[] row = new String[2];
                        bcp.setSortNeeded(false);
                        bcp.setTitleAlign(1);
                        int i = 0;
                        int n = i++;
                        row[n] = this.ar.getString("A1717");
                        int n14 = i++;
                        row[n14] = this.ar.getString("A1718");
                        bcp.addTitle((String[])row);
                        Enumeration thisEnum = bkrList.elements();
                        while (thisEnum.hasMoreElements()) {
                            Hashtable bkrClsInfo = (Hashtable)thisEnum.nextElement();
                            i = 0;
                            row[i++] = this.checkNullAndPrint(bkrClsInfo.get("Address"));
                            Integer tmpInt = (Integer)bkrClsInfo.get("State");
                            row[i++] = tmpInt != null ? BrokerState.toString((int)tmpInt) : "";
                            bcp.add(row);
                        }
                    }
                    bcp.println();
                    sb.append(this.ar.getString("A1714")).append("\n");
                }
                sb.append("ar.getString(ar.I_JMQCMD_LIST_BKR_NONE)").append("\n");
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1713")).append("\n");
                return 1;
            }
        } else if ("abtxn".equals(commandArg)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1253")).append("\n");
                return 1;
            }
            boolean flag4 = brokerCmdProps.forceModeSet();
            flag4 = true;
            if (!flag4) {
                broker = this.promptForAuthentication(broker);
            }
            sb.append(this.ar.getString("A1250")).append("\n");
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
                broker.sendGetTxnsMessage();
                Vector vector3 = broker.receiveGetTxnsReplyMessage();
                if (vector3 != null && vector3.size() > 0) {
                    BrokerCmdPrinter brokercmdprinter2 = new BrokerCmdPrinter(5, 3, "-");
                    BrokerCmdPrinter brokercmdprinter4 = new BrokerCmdPrinter(4, 3, "-");
                    BrokerCmdPrinter brokercmdprinter5 = new BrokerCmdPrinter(4, 3, "-");
                    Object[] as3 = new String[]{this.ar.getString("A1263"), this.ar.getString("A1269"), this.ar.getString("A1270"), this.ar.getString("A1272"), this.ar.getString("A1266")};
                    brokercmdprinter2.addTitle((String[])as3);
                    as3[0] = this.ar.getString("A1263");
                    as3[1] = this.ar.getString("A1269");
                    as3[2] = this.ar.getString("A1270");
                    as3[3] = this.ar.getString("A1266");
                    brokercmdprinter4.addTitle((String[])as3);
                    as3[0] = this.ar.getString("A1263");
                    as3[1] = this.ar.getString("A1269");
                    as3[2] = "# Acks";
                    as3[3] = "Remote broker";
                    brokercmdprinter5.addTitle((String[])as3);
                    Enumeration enumeration4 = vector3.elements();
                    while (enumeration4.hasMoreElements()) {
                        String s10;
                        Hashtable hashtable1 = (Hashtable)enumeration4.nextElement();
                        Integer integer4 = (Integer)hashtable1.get("type");
                        if (integer4 == 0) {
                            Long long4 = (Long)hashtable1.get("txnid");
                            as3[0] = this.checkNullAndPrint(long4);
                            Integer integer1 = (Integer)hashtable1.get("state");
                            int current_txn_state = integer1;
                            as3[1] = this.getTxnStateString(integer1);
                            String s6 = (String)hashtable1.get("user");
                            as3[2] = this.checkNullAndPrint(s6);
                            integer1 = (Integer)hashtable1.get("nmsgs");
                            s6 = this.checkNullAndPrint(integer1);
                            integer1 = (Integer)hashtable1.get("nacks");
                            String s9 = this.checkNullAndPrint(integer1);
                            as3[3] = s6 + "/" + s9;
                            long4 = (Long)hashtable1.get("timestamp");
                            as3[4] = this.checkNullAndPrintTimestamp(long4);
                            if (this.filter_transactionstate != -1 && this.filter_transactionstate != current_txn_state && (this.filter_transactionstate != 8 || current_txn_state == 1)) continue;
                            brokercmdprinter2.add(as3);
                            continue;
                        }
                        if (integer4 == 1) {
                            Long long5 = (Long)hashtable1.get("txnid");
                            as3[0] = this.checkNullAndPrint(long5);
                            Integer integer2 = (Integer)hashtable1.get("state");
                            as3[1] = this.getTxnStateString(integer2);
                            String s7 = (String)hashtable1.get("user");
                            as3[2] = this.checkNullAndPrint(s7);
                            long5 = (Long)hashtable1.get("timestamp");
                            as3[3] = this.checkNullAndPrintTimestamp(long5);
                            brokercmdprinter4.add(as3);
                            continue;
                        }
                        Long long6 = (Long)hashtable1.get("txnid");
                        as3[0] = this.checkNullAndPrint(long6);
                        Integer integer3 = (Integer)hashtable1.get("state");
                        as3[1] = this.getTxnStateString(integer3);
                        integer3 = (Integer)hashtable1.get("nacks");
                        as3[2] = s10 = this.checkNullAndPrint(integer3);
                        String s8 = (String)hashtable1.get("homebroker");
                        as3[3] = this.checkNullAndPrint(s8);
                        brokercmdprinter5.add(as3);
                    }
                    brokercmdprinter2.println();
                    sb.append(this.ar.getString("A1251")).append("\n");
                }
                sb.append(this.ar.getString("A1252")).append("\n");
            }
            catch (BrokerAdminException brokeradminexception4) {
                this.handleBrokerAdminException(brokeradminexception4);
                sb.append(this.ar.getString("A1253")).append("\n");
                return 1;
            }
        } else if ("jmx".equals(commandArg)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1723")).append("\n");
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            sb.append(this.ar.getString("A1722")).append("\n");
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
                broker.sendGetJMXConnectorsMessage(null);
                Vector jmxList = broker.receiveGetJMXConnectorsReplyMessage();
                if (jmxList != null) {
                    BrokerCmdPrinter bcp = new BrokerCmdPrinter(3, 4, null);
                    Object[] row = new String[3];
                    row[0] = this.ar.getString("A1726");
                    row[1] = this.ar.getString("A1727");
                    row[2] = this.ar.getString("A1728");
                    bcp.addTitle((String[])row);
                    Enumeration thisEnum = jmxList.elements();
                    while (thisEnum.hasMoreElements()) {
                        Hashtable jmxInfo = (Hashtable)thisEnum.nextElement();
                        int i = 0;
                        row[i++] = this.checkNullAndPrint(jmxInfo.get("name"));
                        row[i++] = this.checkNullAndPrint(jmxInfo.get("active"));
                        row[i++] = this.checkNullAndPrint(jmxInfo.get("url"));
                        bcp.add(row);
                    }
                    bcp.println();
                    sb.append(this.ar.getString("A1724")).append("\n");
                }
                sb.append(this.ar.getString("A1725")).append("\n");
                sb.append("").append("\n");
                sb.append(this.ar.getString("A1724")).append("\n");
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1723")).append("\n");
                return 1;
            }
        } else if ("msg".equals(commandArg)) {
            if (broker == null) {
                sb.append("Listing messages failed.").append("\n");
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String destName = brokerCmdProps.getTargetName();
            destTypeMask = this.getDestTypeMask(brokerCmdProps);
            Long maxNumMsgsRetrieved = brokerCmdProps.getMaxNumMsgsRetrieved();
            Long startMsgIndex = brokerCmdProps.getStartMsgIndex();
            sb.append("Listing messages for the destination").append("\n");
            this.printDestinationInfo();
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
                broker.sendGetMessagesMessage(destName, destTypeMask, false, null, startMsgIndex, maxNumMsgsRetrieved);
                Vector msgList = broker.receiveGetMessagesReplyMessage();
                if (msgList != null && msgList.size() != 0) {
                    BrokerCmdPrinter bcp = new BrokerCmdPrinter(4, 3, "-");
                    Object[] row = new String[4];
                    bcp.setSortNeeded(false);
                    int i = 0;
                    row[i++] = "Message #";
                    row[i++] = "Message IDs";
                    row[i++] = "Priority";
                    row[i++] = "Body Type";
                    bcp.addTitle((String[])row);
                    long start = 0L;
                    if (startMsgIndex != null) {
                        start = startMsgIndex;
                    }
                    Enumeration thisEnum = msgList.elements();
                    while (thisEnum.hasMoreElements()) {
                        HashMap oneMsg = (HashMap)thisEnum.nextElement();
                        i = 0;
                        row[i++] = Long.toString(start++);
                        row[i++] = this.checkNullAndPrint(oneMsg.get("MessageID"));
                        row[i++] = this.checkNullAndPrint(oneMsg.get("Priority"));
                        row[i++] = this.checkNullAndPrintMsgBodyType((Integer)oneMsg.get("MessageBodyType"), false);
                        bcp.add(row);
                    }
                    bcp.println();
                    sb.append("Successfully listed messages.").append("\n");
                } else {
                    sb.append("There are no messages.").append("\n");
                    sb.append("").append("\n");
                    sb.append("Successfully listed messages.").append("\n");
                }
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append("Listing messages failed.").append("\n");
                return 1;
            }
        }
        broker.close();
        return 0;
    }

    private String getTimeString(long millis) {
        String ret = null;
        if (millis < 1000L) {
            ret = millis + " milliseconds";
        } else if (millis < 60000L) {
            long seconds = millis / 1000L;
            ret = seconds + " seconds";
        } else if (millis < 3600000L) {
            long mins = millis / 60000L;
            ret = mins + " minutes";
        } else {
            ret = "> 1 hour";
        }
        return ret;
    }

    private void listDests(BrokerCmdProperties brokerCmdProps, Vector dests, int listType) {
        BrokerCmdPrinter bcp = this.setupListDestTitle(listType);
        Object[] row = new String[11];
        boolean i = false;
        Enumeration thisEnum = dests.elements();
        while (thisEnum.hasMoreElements()) {
            Hashtable h;
            String destType;
            DestinationInfo dInfo = (DestinationInfo)thisEnum.nextElement();
            int j = 0;
            float avgMsgSize = 0.0f;
            if ("__JMQAdmin".equals(dInfo.name) || DestType.isInternal((int)dInfo.fulltype)) continue;
            if (DestType.isTemporary((int)dInfo.type)) {
                if (!brokerCmdProps.showTempDestModeSet()) continue;
                destType = BrokerAdminUtil.getDestinationType((int)dInfo.type) + " (" + this.ar.getString("A1631") + ")";
            } else {
                destType = BrokerAdminUtil.getDestinationType((int)dInfo.type);
            }
            if (listType == 1 && !DestType.isTopic((int)dInfo.type) || listType == 2 && !DestType.isQueue((int)dInfo.type)) continue;
            int numMsgs = dInfo.nMessages - dInfo.nTxnMessages;
            long totalMsgSize = dInfo.nMessageBytes;
            if (numMsgs > 0) {
                avgMsgSize = (float)totalMsgSize / (float)numMsgs;
            }
            row[j++] = dInfo.name;
            row[j++] = destType;
            row[j++] = DestState.toString((int)dInfo.destState);
            row[j++] = new Integer(dInfo.nProducers).toString();
            if (DestType.isTopic((int)dInfo.type)) {
                h = dInfo.producerWildcards;
                row[j++] = Integer.toString(this.getWildcardCount(h));
            } else {
                row[j++] = "-";
            }
            if (DestType.isTopic((int)dInfo.type)) {
                row[j++] = new Integer(dInfo.nConsumers).toString();
                h = dInfo.consumerWildcards;
                row[j++] = Integer.toString(this.getWildcardCount(h));
            } else if (listType == 2) {
                row[j++] = new Integer(dInfo.naConsumers).toString();
                row[j++] = new Integer(dInfo.nfConsumers).toString();
            } else {
                row[j++] = new Integer(dInfo.naConsumers + dInfo.nfConsumers).toString();
                row[j++] = "-";
            }
            row[j++] = new Integer(numMsgs).toString();
            row[j++] = new Integer(dInfo.nRemoteMessages).toString();
            row[j++] = new Integer(dInfo.nUnackMessages).toString();
            row[j++] = new Float(avgMsgSize).toString();
            bcp.add(row);
        }
        bcp.setKeyCriteria(new int[]{0, 1});
        bcp.println();
    }

    private int getWildcardCount(Hashtable h) {
        int count = 0;
        if (h == null) {
            return 0;
        }
        Enumeration keys = h.keys();
        while (keys.hasMoreElements()) {
            String wildcard = (String)keys.nextElement();
            Integer val = (Integer)h.get(wildcard);
            count += val.intValue();
        }
        return count;
    }

    private String getTxnStateString(Integer txnState) {
        if (txnState == null) {
            return "";
        }
        int tmpInt = txnState;
        switch (tmpInt) {
            case 0: {
                return this.ar.getString("A1280");
            }
            case 1: {
                return this.ar.getString("A1281");
            }
            case 2: {
                return this.ar.getString("A1282");
            }
            case 3: {
                return this.ar.getString("A1283");
            }
            case 4: {
                return this.ar.getString("A1284");
            }
            case 5: {
                return this.ar.getString("A1285");
            }
            case 6: {
                return this.ar.getString("A1286");
            }
            case 7: {
                return this.ar.getString("A1287");
            }
        }
        return this.ar.getString("A1288");
    }

    private int runPause(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        String input = null;
        String yes = this.ar.getString("A5016");
        String yesShort = this.ar.getString("A5015");
        String no = this.ar.getString("A5018");
        String noShort = this.ar.getString("A5017");
        BrokerAdmin broker = this.init();
        boolean force = brokerCmdProps.forceModeSet();
        String commandArg = brokerCmdProps.getCommandArg();
        if ("bkr".equals(commandArg)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1209")).append("\n");
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            sb.append(this.ar.getString("A1207")).append("\n");
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1209")).append("\n");
                return 1;
            }
            if (!force) {
                input = this.getUserInput(this.ar.getString("A5005"), noShort);
                sb.append("").append("\n");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendPauseMessage(null);
                    broker.receivePauseReplyMessage();
                    sb.append(this.ar.getString("A1208")).append("\n");
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    sb.append(this.ar.getString("A1209")).append("\n");
                    return 1;
                }
            }
            if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                sb.append(this.ar.getString("A1210")).append("\n");
                return 0;
            }
            sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
            sb.append("").append("\n");
            sb.append(this.ar.getString("A1210")).append("\n");
            return 1;
        }
        if ("svc".equals(commandArg)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1213")).append("\n");
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String svcName = brokerCmdProps.getTargetName();
            sb.append(this.ar.getString("A1211")).append("\n");
            this.printServiceInfo();
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1213")).append("\n");
                return 1;
            }
            try {
                this.isAdminService(broker, svcName);
            }
            catch (BrokerAdminException bae) {
                if (7 == bae.getType()) {
                    bae.setBrokerErrorStr(this.ar.getString("A1001") + this.ar.getKString("A3109", (Object)svcName));
                }
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1213")).append("\n");
                return 1;
            }
            if (!force) {
                input = this.getUserInput(this.ar.getString("A5006"), noShort);
                sb.append("").append("\n");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendPauseMessage(svcName);
                    broker.receivePauseReplyMessage();
                    sb.append(this.ar.getString("A1212")).append("\n");
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    sb.append(this.ar.getString("A1213")).append("\n");
                    return 1;
                }
            }
            if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                sb.append(this.ar.getString("A1214")).append("\n");
                return 0;
            }
            sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
            sb.append("").append("\n");
            sb.append(this.ar.getString("A1214")).append("\n");
            return 1;
        }
        if ("dst".equals(commandArg)) {
            BrokerCmdPrinter bcp = new BrokerCmdPrinter(2, 4);
            Object[] row = new String[2];
            boolean pauseAll = true;
            String destName = brokerCmdProps.getTargetName();
            int destTypeMask = this.getDestTypeMask(brokerCmdProps);
            String pauseTypeStr = brokerCmdProps.getPauseType();
            if (destName != null) {
                pauseAll = false;
            }
            if (broker == null) {
                if (pauseAll) {
                    sb.append(this.ar.getString("A1311")).append("\n");
                } else {
                    sb.append(this.ar.getString("A1275")).append("\n");
                }
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            if (pauseAll) {
                sb.append(this.ar.getString("A1309")).append("\n");
            } else {
                sb.append(this.ar.getString("A1273")).append("\n");
                this.printDestinationInfo();
            }
            if (pauseTypeStr != null) {
                sb.append(this.ar.getString("A1317")).append("\n");
                row[0] = this.ar.getString("A1442");
                row[1] = pauseTypeStr;
                bcp.add(row);
                bcp.println();
            }
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                if (pauseAll) {
                    sb.append(this.ar.getString("A1311")).append("\n");
                } else {
                    sb.append(this.ar.getString("A1275")).append("\n");
                }
                return 1;
            }
            if (!force) {
                input = pauseAll ? this.getUserInput(this.ar.getString("A5025"), noShort) : this.getUserInput(this.ar.getString("A5021"), noShort);
                sb.append("").append("\n");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    int pauseType = this.getPauseTypeVal(pauseTypeStr);
                    broker.sendPauseMessage(destName, destTypeMask, pauseType);
                    broker.receivePauseReplyMessage();
                    if (pauseAll) {
                        sb.append(this.ar.getString("A1310")).append("\n");
                    }
                    sb.append(this.ar.getString("A1274")).append("\n");
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    if (pauseAll) {
                        sb.append(this.ar.getString("A1311")).append("\n");
                    } else {
                        sb.append(this.ar.getString("A1275")).append("\n");
                    }
                    return 1;
                }
            } else {
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    if (pauseAll) {
                        sb.append(this.ar.getString("A1312")).append("\n");
                    } else {
                        sb.append(this.ar.getString("A1276")).append("\n");
                    }
                    return 0;
                }
                sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
                sb.append("").append("\n");
                if (pauseAll) {
                    sb.append(this.ar.getString("A1312")).append("\n");
                } else {
                    sb.append(this.ar.getString("A1276")).append("\n");
                }
                return 1;
            }
        }
        broker.close();
        return 0;
    }

    private int runReset(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        String input = null;
        String yes = this.ar.getString("A5016");
        String yesShort = this.ar.getString("A5015");
        String no = this.ar.getString("A5018");
        String noShort = this.ar.getString("A5017");
        BrokerAdmin broker = this.init();
        boolean force = brokerCmdProps.forceModeSet();
        String commandArg = brokerCmdProps.getCommandArg();
        if ("bkr".equals(commandArg)) {
            BrokerCmdPrinter bcp = new BrokerCmdPrinter(2, 4);
            Object[] row = new String[2];
            String resetType = brokerCmdProps.getResetType();
            if (broker == null) {
                sb.append(this.ar.getString("A1766")).append("\n");
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            sb.append(this.ar.getString("A1764")).append("\n");
            if (resetType != null) {
                sb.append(this.ar.getString("A1317")).append("\n");
                row[0] = this.ar.getString("A1768");
                row[1] = resetType;
                bcp.add(row);
                bcp.println();
            }
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1766")).append("\n");
                return 1;
            }
            if (!force) {
                input = this.getUserInput(this.ar.getString("A5031"), noShort);
                sb.append("").append("\n");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    String resetTypeVal = this.getResetTypeVal(resetType);
                    broker.sendResetBrokerMessage(resetTypeVal);
                    broker.receiveResetBrokerReplyMessage();
                    sb.append(this.ar.getString("A1765")).append("\n");
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    sb.append(this.ar.getString("A1766")).append("\n");
                    return 1;
                }
            } else {
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    sb.append(this.ar.getString("A1767")).append("\n");
                    return 0;
                }
                sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
                sb.append("").append("\n");
                sb.append(this.ar.getString("A1767")).append("\n");
                return 1;
            }
        }
        broker.close();
        return 0;
    }

    private int runResume(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        String input = null;
        String yes = this.ar.getString("A5016");
        String yesShort = this.ar.getString("A5015");
        String no = this.ar.getString("A5018");
        String noShort = this.ar.getString("A5017");
        BrokerAdmin broker = this.init();
        boolean force = brokerCmdProps.forceModeSet();
        String commandArg = brokerCmdProps.getCommandArg();
        if ("bkr".equals(commandArg)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1217")).append("\n");
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            sb.append(this.ar.getString("A1215")).append("\n");
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1217")).append("\n");
                return 1;
            }
            if (!force) {
                input = this.getUserInput(this.ar.getString("A5007"), noShort);
                sb.append("").append("\n");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendResumeMessage(null);
                    broker.receiveResumeReplyMessage();
                    sb.append(this.ar.getString("A1216")).append("\n");
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    sb.append(this.ar.getString("A1217")).append("\n");
                    return 1;
                }
            }
            if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                sb.append(this.ar.getString("A1218")).append("\n");
                return 0;
            }
            sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
            sb.append("").append("\n");
            sb.append(this.ar.getString("A1218")).append("\n");
            return 1;
        }
        if ("svc".equals(commandArg)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1221")).append("\n");
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String svcName = brokerCmdProps.getTargetName();
            sb.append(this.ar.getString("A1219")).append("\n");
            this.printServiceInfo();
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1221")).append("\n");
                return 1;
            }
            try {
                this.isAdminService(broker, svcName);
            }
            catch (BrokerAdminException bae) {
                if (7 == bae.getType()) {
                    bae.setBrokerErrorStr(this.ar.getString("A1001") + this.ar.getKString("A3110", (Object)svcName));
                }
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1221")).append("\n");
                return 1;
            }
            if (!force) {
                input = this.getUserInput(this.ar.getString("A5008"), noShort);
                sb.append("").append("\n");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendResumeMessage(svcName);
                    broker.receiveResumeReplyMessage();
                    sb.append(this.ar.getString("A1220")).append("\n");
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    sb.append(this.ar.getString("A1221")).append("\n");
                    return 1;
                }
            }
            if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                sb.append(this.ar.getString("A1222")).append("\n");
                return 0;
            }
            sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
            sb.append("").append("\n");
            sb.append(this.ar.getString("A1222")).append("\n");
            return 1;
        }
        if ("dst".equals(commandArg)) {
            boolean resumeAll = true;
            String destName = brokerCmdProps.getTargetName();
            int destTypeMask = this.getDestTypeMask(brokerCmdProps);
            if (destName != null) {
                resumeAll = false;
            }
            if (broker == null) {
                if (resumeAll) {
                    sb.append(this.ar.getString("A1315")).append("\n");
                } else {
                    sb.append(this.ar.getString("A1294")).append("\n");
                }
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            if (resumeAll) {
                sb.append(this.ar.getString("A1313")).append("\n");
            } else {
                sb.append(this.ar.getString("A1292")).append("\n");
                this.printDestinationInfo();
                sb.append(this.ar.getString("A1200")).append("\n");
            }
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                if (resumeAll) {
                    sb.append(this.ar.getString("A1315")).append("\n");
                } else {
                    sb.append(this.ar.getString("A1294")).append("\n");
                }
                return 1;
            }
            if (!force) {
                input = resumeAll ? this.getUserInput(this.ar.getString("A5026"), noShort) : this.getUserInput(this.ar.getString("A5022"), noShort);
                sb.append("").append("\n");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendResumeMessage(destName, destTypeMask);
                    broker.receiveResumeReplyMessage();
                    if (resumeAll) {
                        sb.append(this.ar.getString("A1314")).append("\n");
                    }
                    sb.append(this.ar.getString("A1293")).append("\n");
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    if (resumeAll) {
                        sb.append(this.ar.getString("A1315")).append("\n");
                    } else {
                        sb.append(this.ar.getString("A1294")).append("\n");
                    }
                    return 1;
                }
            } else {
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    if (resumeAll) {
                        sb.append(this.ar.getString("A1316")).append("\n");
                    } else {
                        sb.append(this.ar.getString("A1295")).append("\n");
                    }
                    return 0;
                }
                sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
                sb.append("").append("\n");
                if (resumeAll) {
                    sb.append(this.ar.getString("A1316")).append("\n");
                } else {
                    sb.append(this.ar.getString("A1295")).append("\n");
                }
                return 1;
            }
        }
        broker.close();
        return 0;
    }

    private int runShutdown(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        String sessionID;
        String input = null;
        String yes = this.ar.getString("A5016");
        String yesShort = this.ar.getString("A5015");
        String no = this.ar.getString("A5018");
        String noShort = this.ar.getString("A5017");
        BrokerAdmin broker = this.init();
        if (broker == null) {
            sb.append(this.ar.getString("A1225")).append("\n");
            return 1;
        }
        boolean force = brokerCmdProps.forceModeSet();
        if (!force) {
            broker = this.promptForAuthentication(broker);
        }
        boolean noFailover = brokerCmdProps.noFailoverSet();
        int time = brokerCmdProps.getTime();
        sb.append(this.ar.getString("A1223")).append("\n");
        this.printBrokerInfo(broker);
        try {
            this.connectToBroker(broker);
            sessionID = this.getPortMapperSessionID(brokerCmdProps, broker);
        }
        catch (BrokerAdminException bae) {
            this.handleBrokerAdminException(bae);
            sb.append(this.ar.getString("A1225")).append("\n");
            return 1;
        }
        if (!force) {
            input = this.getUserInput(this.ar.getString("A5009"), noShort);
            sb.append("").append("\n");
        }
        if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
            try {
                broker.sendShutdownMessage(false, false, noFailover, time);
                broker.receiveShutdownReplyMessage();
                if (this.waitForShutdown(broker, sessionID, brokerCmdProps)) {
                    sb.append(this.ar.getString("A1224")).append("\n");
                }
                sb.append(this.ar.getString("A1760")).append("\n");
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1225")).append("\n");
                return 1;
            }
        } else {
            if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                sb.append(this.ar.getString("A1226")).append("\n");
                return 0;
            }
            sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
            sb.append("").append("\n");
            sb.append(this.ar.getString("A1226")).append("\n");
            return 1;
        }
        return 0;
    }

    private boolean waitForShutdown(BrokerAdmin broker, String waitSessionID, BrokerCmdProperties brokerCmdProps) {
        int port;
        GenericPortMapperClient pmc = null;
        String hostName = broker.getBrokerHost();
        String portString = broker.getBrokerPort();
        String sessionID = null;
        if (brokerCmdProps == null) {
            return false;
        }
        long sleepTime = brokerCmdProps.getShutdownWaitInterval();
        int shutdownDelaySecs = brokerCmdProps.getTime();
        if (shutdownDelaySecs > 0) {
            return false;
        }
        if (waitSessionID == null) {
            return false;
        }
        try {
            port = Integer.parseInt(portString);
        }
        catch (Exception e) {
            port = 7676;
        }
        boolean brokerDown = false;
        boolean count = false;
        Globals.stdOutPrintln((String)this.ar.getString("A1761", (Object)(hostName + ":" + portString)));
        while (!brokerDown) {
            try {
                Thread.sleep(sleepTime);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                pmc = new GenericPortMapperClient(hostName, port);
            }
            catch (Exception e) {
                brokerDown = true;
            }
            if (pmc == null) continue;
            sessionID = pmc.getProperty("sessionid", null, "PORTMAPPER", "portmapper");
            if (sessionID == null) {
                brokerDown = true;
                continue;
            }
            if (sessionID.equals(waitSessionID)) continue;
            brokerDown = true;
        }
        return true;
    }

    private String getPortMapperSessionID(BrokerCmdProperties brokerCmdProps, BrokerAdmin broker) {
        int port;
        String hostName = broker.getBrokerHost();
        String portString = broker.getBrokerPort();
        String sessionID = null;
        try {
            port = Integer.parseInt(portString);
        }
        catch (Exception e) {
            port = 7676;
        }
        try {
            GenericPortMapperClient pmc = new GenericPortMapperClient(hostName, port);
            sessionID = pmc.getProperty("sessionid", null, "PORTMAPPER", "portmapper");
        }
        catch (Exception e) {
            // empty catch block
        }
        return sessionID;
    }

    private int runRestart(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        String input = null;
        String yes = this.ar.getString("A5016");
        String yesShort = this.ar.getString("A5015");
        String no = this.ar.getString("A5018");
        String noShort = this.ar.getString("A5017");
        BrokerAdmin broker = this.init();
        if (broker == null) {
            sb.append(this.ar.getString("A1229")).append("\n");
            return 1;
        }
        boolean force = brokerCmdProps.forceModeSet();
        if (!force) {
            broker = this.promptForAuthentication(broker);
        }
        sb.append(this.ar.getString("A1227")).append("\n");
        this.printBrokerInfo(broker);
        try {
            this.connectToBroker(broker);
        }
        catch (BrokerAdminException bae) {
            this.handleBrokerAdminException(bae);
            sb.append(this.ar.getString("A1229")).append("\n");
            return 1;
        }
        if (!force) {
            input = this.getUserInput(this.ar.getString("A5010"), noShort);
            sb.append("").append("\n");
        }
        if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
            try {
                broker.sendShutdownMessage(true);
                broker.receiveShutdownReplyMessage();
                if (!this.reconnectToBroker(broker)) {
                    sb.append(this.ar.getString("A1229")).append("\n");
                    return 1;
                }
                sb.append(this.ar.getString("A1228")).append("\n");
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1229")).append("\n");
                return 1;
            }
        } else {
            if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                sb.append(this.ar.getString("A1230")).append("\n");
                return 0;
            }
            sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
            sb.append("").append("\n");
            sb.append(this.ar.getString("A1230")).append("\n");
            return 1;
        }
        broker.close();
        return 0;
    }

    private int runCreate(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        BrokerAdmin broker = this.init();
        if (broker == null) {
            sb.append(this.ar.getString("A1233")).append("\n");
            return 1;
        }
        boolean force = brokerCmdProps.forceModeSet();
        if (!force) {
            broker = this.promptForAuthentication(broker);
        }
        String destName = brokerCmdProps.getTargetName();
        int destTypeMask = this.getDestTypeMask(brokerCmdProps);
        Properties destAttrs = brokerCmdProps.getTargetAttrs();
        sb.append(this.ar.getString("A1231")).append("\n");
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(2, 4);
        Object[] row = new String[2];
        bcp.setSortNeeded(false);
        row[0] = this.ar.getString("A1400");
        row[1] = destName;
        bcp.add(row);
        row[0] = this.ar.getString("A1401");
        row[1] = BrokerAdminUtil.getDestinationType((int)destTypeMask);
        bcp.add(row);
        String prop = null;
        prop = destAttrs.getProperty("maxNumMsgs");
        if (prop != null) {
            row[0] = this.ar.getString("A1407");
            row[1] = prop;
            bcp.add(row);
        }
        if ((prop = destAttrs.getProperty("maxTotalMsgBytes")) != null) {
            row[0] = this.ar.getString("A1406");
            row[1] = prop;
            bcp.add(row);
        }
        if ((prop = destAttrs.getProperty("maxBytesPerMsg")) != null) {
            row[0] = this.ar.getString("A1408");
            row[1] = prop;
            bcp.add(row);
        }
        if ((prop = destAttrs.getProperty("maxNumProducers")) != null) {
            row[0] = this.ar.getString("A1415");
            row[1] = prop;
            bcp.add(row);
        }
        if ((prop = destAttrs.getProperty("maxNumActiveConsumers")) != null) {
            row[0] = this.ar.getString("A1410");
            row[1] = prop;
            bcp.add(row);
        }
        if ((prop = destAttrs.getProperty("maxNumBackupConsumers")) != null) {
            row[0] = this.ar.getString("A1409");
            row[1] = prop;
            bcp.add(row);
        }
        if ((prop = destAttrs.getProperty("limitBehavior")) != null) {
            row[0] = this.ar.getString("A1412");
            row[1] = prop;
            bcp.add(row);
        }
        if ((prop = destAttrs.getProperty("consumerFlowLimit")) != null) {
            row[0] = this.ar.getString("A1414");
            row[1] = prop;
            bcp.add(row);
        }
        if ((prop = destAttrs.getProperty("isLocalOnly")) != null) {
            row[0] = this.ar.getString("A1411");
            row[1] = prop;
            bcp.add(row);
        }
        if ((prop = destAttrs.getProperty("localDeliveryPreferred")) != null) {
            row[0] = this.ar.getString("A1413");
            row[1] = prop;
            bcp.add(row);
        }
        if ((prop = destAttrs.getProperty("useDMQ")) != null) {
            row[0] = this.ar.getString("A1446");
            row[1] = prop;
            bcp.add(row);
        }
        if ((prop = destAttrs.getProperty("validateXMLSchemaEnabled")) != null) {
            row[0] = this.ar.getString("A1447");
            row[1] = prop;
            bcp.add(row);
        }
        if ((prop = destAttrs.getProperty("XMLSchemaURIList")) != null) {
            row[0] = this.ar.getString("A1448");
            row[1] = prop;
            bcp.add(row);
        }
        bcp.println();
        sb.append(this.ar.getString("A1200")).append("\n");
        this.printBrokerInfo(broker);
        try {
            long byteValue;
            SizeString ss;
            DestinationInfo destInfo = new DestinationInfo();
            destInfo.setType(destTypeMask);
            destInfo.setName(destName);
            prop = destAttrs.getProperty("maxTotalMsgBytes");
            if (prop != null) {
                try {
                    ss = new SizeString(prop);
                    byteValue = ss.getBytes();
                    destInfo.setMaxMessageBytes(byteValue);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if ((prop = destAttrs.getProperty("maxNumMsgs")) != null) {
                destInfo.setMaxMessages(Integer.parseInt(prop));
            }
            if ((prop = destAttrs.getProperty("maxBytesPerMsg")) != null) {
                try {
                    ss = new SizeString(prop);
                    byteValue = ss.getBytes();
                    destInfo.setMaxMessageSize(byteValue);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if ((prop = destAttrs.getProperty("maxNumBackupConsumers")) != null) {
                destInfo.setMaxFailoverConsumers(Integer.parseInt(prop));
            }
            if ((prop = destAttrs.getProperty("maxNumActiveConsumers")) != null) {
                destInfo.setMaxActiveConsumers(Integer.parseInt(prop));
            }
            if ((prop = destAttrs.getProperty("isLocalOnly")) != null) {
                destInfo.setScope(Boolean.valueOf(prop).booleanValue());
            }
            if ((prop = destAttrs.getProperty("limitBehavior")) != null) {
                destInfo.setLimitBehavior(this.getLimitBehavValue(prop));
            }
            if ((prop = destAttrs.getProperty("localDeliveryPreferred")) != null) {
                destInfo.setClusterDeliveryPolicy(this.getClusterDeliveryPolicy(prop));
            }
            if ((prop = destAttrs.getProperty("consumerFlowLimit")) != null) {
                destInfo.setPrefetch(Integer.parseInt(prop));
            }
            if ((prop = destAttrs.getProperty("maxNumProducers")) != null) {
                destInfo.setMaxProducers(Integer.parseInt(prop));
            }
            if ((prop = destAttrs.getProperty("useDMQ")) != null) {
                destInfo.setUseDMQ(Boolean.valueOf(prop).booleanValue());
            }
            if ((prop = destAttrs.getProperty("validateXMLSchemaEnabled")) != null) {
                destInfo.setValidateXMLSchemaEnabled(Boolean.valueOf(prop).booleanValue());
            }
            if ((prop = destAttrs.getProperty("XMLSchemaURIList")) != null) {
                destInfo.setXMLSchemaUriList(prop);
            }
            if ((prop = destAttrs.getProperty("reloadXMLSchemaOnFailure")) != null) {
                destInfo.setReloadXMLSchemaOnFailure(Boolean.valueOf(prop).booleanValue());
            }
            this.connectToBroker(broker);
            broker.sendCreateDestinationMessage(destInfo);
            broker.receiveCreateDestinationReplyMessage();
            sb.append(this.ar.getString("A1232")).append("\n");
        }
        catch (BrokerAdminException bae) {
            this.handleBrokerAdminException(bae);
            sb.append(this.ar.getString("A1233")).append("\n");
            return 1;
        }
        broker.close();
        return 0;
    }

    private int runDestroy(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        String input = null;
        String yes = this.ar.getString("A5016");
        String yesShort = this.ar.getString("A5015");
        String no = this.ar.getString("A5018");
        String noShort = this.ar.getString("A5017");
        String commandArg = brokerCmdProps.getCommandArg();
        boolean force = brokerCmdProps.forceModeSet();
        BrokerAdmin broker = this.init();
        if ("dst".equals(commandArg)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1236")).append("\n");
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String destName = brokerCmdProps.getTargetName();
            int destTypeMask = this.getDestTypeMask(brokerCmdProps);
            sb.append(this.ar.getString("A1234")).append("\n");
            this.printDestinationInfo();
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1236")).append("\n");
                return 1;
            }
            if (!force) {
                input = this.getUserInput(this.ar.getString("A5003"), noShort);
                sb.append("").append("\n");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendDestroyDestinationMessage(destName, destTypeMask);
                    broker.receiveDestroyDestinationReplyMessage();
                    sb.append(this.ar.getString("A1235")).append("\n");
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    sb.append(this.ar.getString("A1236")).append("\n");
                    return 1;
                }
            }
            if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                sb.append(this.ar.getString("A1237")).append("\n");
                return 0;
            }
            sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
            sb.append("").append("\n");
            sb.append(this.ar.getString("A1237")).append("\n");
            return 1;
        }
        if ("dur".equals(commandArg)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1556")).append("\n");
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String subName = brokerCmdProps.getTargetName();
            String clientID = brokerCmdProps.getClientID();
            sb.append(this.ar.getString("A1554")).append("\n");
            this.printDurableSubscriptionInfo();
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1556")).append("\n");
                return 1;
            }
            if (!force) {
                input = this.getUserInput(this.ar.getString("A5014"), noShort);
                sb.append("").append("\n");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendDestroyDurableMessage(subName, clientID);
                    broker.receiveDestroyDurableReplyMessage();
                    sb.append(this.ar.getString("A1555")).append("\n");
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    sb.append(this.ar.getString("A1556")).append("\n");
                    return 1;
                }
            }
            if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                sb.append(this.ar.getString("A1557")).append("\n");
                return 0;
            }
            sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
            sb.append("").append("\n");
            sb.append(this.ar.getString("A1557")).append("\n");
            return 1;
        }
        if ("cxn".equals(commandArg)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1730")).append("\n");
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String cxnIdStr = brokerCmdProps.getTargetName();
            Long cxnId = null;
            try {
                cxnId = Long.valueOf(cxnIdStr);
            }
            catch (NumberFormatException nfe) {
                sb.append(this.ar.getString("A3159", (Object)cxnIdStr)).append("\n");
                sb.append(this.ar.getString("A1730")).append("\n");
                return 1;
            }
            sb.append(this.ar.getString("A1729")).append("\n");
            this.printConnectionInfo();
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1730")).append("\n");
                return 1;
            }
            if (!force) {
                input = this.getUserInput(this.ar.getString("A5029"), noShort);
                sb.append("").append("\n");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendDestroyConnectionMessage(cxnId);
                    broker.receiveDestroyConnectionReplyMessage();
                    sb.append(this.ar.getString("A1731")).append("\n");
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    sb.append(this.ar.getString("A1730")).append("\n");
                    return 1;
                }
            }
            if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                sb.append(this.ar.getString("A1732")).append("\n");
                return 0;
            }
            sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
            sb.append("").append("\n");
            sb.append(this.ar.getString("A1732")).append("\n");
            return 1;
        }
        if ("msg".equals(commandArg)) {
            if (broker == null) {
                sb.append("Destroying message failed.").append("\n");
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String destName = brokerCmdProps.getTargetName();
            int destTypeMask = this.getDestTypeMask(brokerCmdProps);
            String msgID = brokerCmdProps.getMsgID();
            sb.append("Destroying message:").append("\n");
            this.printMessageInfo();
            sb.append("In the destination").append("\n");
            this.printDestinationInfo();
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append("Destroying message failed.").append("\n");
                return 1;
            }
            if (!force) {
                input = this.getUserInput("Are you sure you want to destroy this message? (y/n)[n] ", noShort);
                sb.append("").append("\n");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendDestroyMessagesMessage(destName, destTypeMask, msgID);
                    broker.receiveDestroyMessagesReplyMessage();
                    sb.append("Successfully destroyed message.").append("\n");
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    sb.append("Destroying message failed.").append("\n");
                    return 1;
                }
            } else {
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    sb.append("The message was not destroyed.\n").append("\n");
                    return 0;
                }
                sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
                sb.append("").append("\n");
                sb.append("The message was not destroyed.\n").append("\n");
                return 1;
            }
        }
        broker.close();
        return 0;
    }

    private int runPurge(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        String input = null;
        String yes = this.ar.getString("A5016");
        String yesShort = this.ar.getString("A5015");
        String no = this.ar.getString("A5018");
        String noShort = this.ar.getString("A5017");
        String commandArg = brokerCmdProps.getCommandArg();
        boolean force = brokerCmdProps.forceModeSet();
        BrokerAdmin broker = this.init();
        if ("dst".equals(commandArg)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1240")).append("\n");
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String destName = brokerCmdProps.getTargetName();
            int destTypeMask = this.getDestTypeMask(brokerCmdProps);
            sb.append(this.ar.getString("A1238")).append("\n");
            this.printDestinationInfo();
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1240")).append("\n");
                return 1;
            }
            if (!force) {
                input = this.getUserInput(this.ar.getString("A5004"), noShort);
                sb.append("").append("\n");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendPurgeDestinationMessage(destName, destTypeMask);
                    broker.receivePurgeDestinationReplyMessage();
                    sb.append(this.ar.getString("A1239")).append("\n");
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    sb.append(this.ar.getString("A1240")).append("\n");
                    return 1;
                }
            }
            if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                sb.append(this.ar.getString("A1241")).append("\n");
                return 0;
            }
            sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
            sb.append("").append("\n");
            sb.append(this.ar.getString("A1241")).append("\n");
            return 1;
        }
        if ("dur".equals(commandArg)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1634")).append("\n");
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String subName = brokerCmdProps.getTargetName();
            String clientID = brokerCmdProps.getClientID();
            sb.append(this.ar.getString("A1635")).append("\n");
            this.printDurableSubscriptionInfo();
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1634")).append("\n");
                return 1;
            }
            if (!force) {
                input = this.getUserInput(this.ar.getString("A5020"), noShort);
                sb.append("").append("\n");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendPurgeDurableMessage(subName, clientID);
                    broker.receivePurgeDurableReplyMessage();
                    sb.append(this.ar.getString("A1636")).append("\n");
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    sb.append(this.ar.getString("A1634")).append("\n");
                    return 1;
                }
            } else {
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    sb.append(this.ar.getString("A1637")).append("\n");
                    return 0;
                }
                sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
                sb.append("").append("\n");
                sb.append(this.ar.getString("A1637")).append("\n");
                return 1;
            }
        }
        broker.close();
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    private int runPurgeAll(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        input = null;
        ret_code = 0;
        yes = this.ar.getString("A5016");
        yesShort = this.ar.getString("A5015");
        no = this.ar.getString("A5018");
        noShort = this.ar.getString("A5017");
        commandArg = brokerCmdProps.getCommandArg();
        force = brokerCmdProps.forceModeSet();
        broker = this.init();
        if ("dst".equals(commandArg)) {
            if (broker == null) {
                sb.append("Purging all the destinations failed").append("\n");
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            sb.append("Purging all the destinations").append("\n");
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append("Purging all the destinations failed").append("\n");
                return 1;
            }
            if (!force) {
                input = this.getUserInput("Are you sure you want to purge all the destinations? (y/n)[n] ", noShort);
                sb.append("").append("\n");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    dstsPurged = false;
                    broker.sendGetDestinationsMessage(null, -1);
                    dests = broker.receiveGetDestinationsReplyMessage();
                    if (dests != null) {
                        thisEnum = dests.elements();
                        while (thisEnum.hasMoreElements()) {
                            dInfo = (DestinationInfo)thisEnum.nextElement();
                            destName = dInfo.name;
                            destTypeMask = dInfo.type;
                            if ("__JMQAdmin".equals(destName) || DestType.isInternal((int)dInfo.fulltype) || DestType.isTemporary((int)dInfo.type)) {
                                sb.append("Skipping destination: " + destName).append("\n");
                                continue;
                            }
                            try {
                                broker.sendPurgeDestinationMessage(destName, destTypeMask);
                                broker.receivePurgeDestinationReplyMessage();
                                if (DestType.isQueue((int)destTypeMask)) {
                                    sb.append("Successfully purged queue " + destName).append("\n");
                                } else {
                                    sb.append("Successfully purged topic " + destName).append("\n");
                                }
                                dstsPurged = true;
                            }
                            catch (BrokerAdminException purgeEx) {
                                this.handleBrokerAdminException(purgeEx);
                                if (DestType.isQueue((int)destTypeMask)) {
                                    sb.append("Purging failed for queue " + destName).append("\n");
                                } else {
                                    sb.append("Purging failed for topic " + destName).append("\n");
                                }
                                ret_code = 1;
                            }
                        }
                    }
                    if (dstsPurged) ** GOTO lbl95
                    sb.append("No destinations purged.").append("\n");
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    sb.append("Purging all the destinations failed").append("\n");
                    return 1;
                }
            } else {
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    sb.append("The destinations were not purged.").append("\n");
                    return 0;
                }
                sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
                sb.append("").append("\n");
                sb.append("The destinations were not purged.").append("\n");
                return 1;
            }
        }
lbl95:
        // 4 sources

        broker.close();
        return ret_code;
    }

    /*
     * Unable to fully structure code
     */
    private int runDestroyAll(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        input = null;
        ret_code = 0;
        yes = this.ar.getString("A5016");
        yesShort = this.ar.getString("A5015");
        no = this.ar.getString("A5018");
        noShort = this.ar.getString("A5017");
        commandArg = brokerCmdProps.getCommandArg();
        force = brokerCmdProps.forceModeSet();
        broker = this.init();
        if ("dst".equals(commandArg)) {
            if (broker == null) {
                sb.append("Destroying all the destinations failed").append("\n");
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            sb.append("Destroying all the destinations").append("\n");
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append("Destroying all the destinations failed").append("\n");
                return 1;
            }
            if (!force) {
                input = this.getUserInput("Are you sure you want to destroy all the destinations? (y/n)[n] ", noShort);
                sb.append("").append("\n");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    dstsDestroyed = false;
                    broker.sendGetDestinationsMessage(null, -1);
                    dests = broker.receiveGetDestinationsReplyMessage();
                    if (dests != null) {
                        thisEnum = dests.elements();
                        while (thisEnum.hasMoreElements()) {
                            dInfo = (DestinationInfo)thisEnum.nextElement();
                            destName = dInfo.name;
                            destTypeMask = dInfo.type;
                            if ("__JMQAdmin".equals(destName) || DestType.isInternal((int)dInfo.fulltype) || DestType.isTemporary((int)dInfo.type) || DestType.isDMQ((int)dInfo.type)) {
                                sb.append("Skipping destination: " + destName).append("\n");
                                continue;
                            }
                            try {
                                broker.sendDestroyDestinationMessage(destName, destTypeMask);
                                broker.receiveDestroyDestinationReplyMessage();
                                if (DestType.isQueue((int)destTypeMask)) {
                                    Globals.stdOutPrintln((String)("Successfully destroyed queue " + destName));
                                } else {
                                    Globals.stdOutPrintln((String)("Successfully destroyed topic " + destName));
                                }
                                dstsDestroyed = true;
                            }
                            catch (BrokerAdminException destroyEx) {
                                this.handleBrokerAdminException(destroyEx);
                                if (DestType.isQueue((int)destTypeMask)) {
                                    sb.append("Destroy failed for queue " + destName).append("\n");
                                } else {
                                    sb.append("Destroy failed for topic " + destName).append("\n");
                                }
                                ret_code = 1;
                            }
                        }
                    }
                    if (dstsDestroyed) ** GOTO lbl93
                    sb.append("No destinations destroyed.").append("\n");
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    sb.append("Destroying all the destinations failed").append("\n");
                    return 1;
                }
            } else {
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    sb.append("The destinations were not destroyed.").append("\n");
                    return 0;
                }
                sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
                sb.append("").append("\n");
                sb.append("The destinations were not destroyed.").append("\n");
                return 1;
            }
        }
lbl93:
        // 4 sources

        broker.close();
        return ret_code;
    }

    private int runUpdate(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        String input = null;
        String yes = this.ar.getString("A5016");
        String yesShort = this.ar.getString("A5015");
        String no = this.ar.getString("A5018");
        String noShort = this.ar.getString("A5017");
        BrokerAdmin broker = this.init();
        String commandArg = brokerCmdProps.getCommandArg();
        boolean force = brokerCmdProps.forceModeSet();
        if ("bkr".equals(commandArg)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1538")).append("\n");
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            Properties targetAttrs = brokerCmdProps.getTargetAttrs();
            sb.append(this.ar.getString("A1539")).append("\n");
            sb.append("").append("\n");
            this.printAttrs(targetAttrs);
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            if (!force) {
                input = this.getUserInput(this.ar.getString("A5011"), noShort);
                sb.append("").append("\n");
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    sb.append(this.ar.getString("A1540")).append("\n");
                    return 0;
                }
                if (!yesShort.equalsIgnoreCase(input) && !yes.equalsIgnoreCase(input)) {
                    sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
                    sb.append("").append("\n");
                    sb.append(this.ar.getString("A1540")).append("\n");
                    return 1;
                }
            }
            try {
                this.connectToBroker(broker);
                broker.sendUpdateBrokerPropsMessage(targetAttrs);
                broker.receiveUpdateBrokerPropsReplyMessage();
                sb.append(this.ar.getString("A1541")).append("\n");
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1538")).append("\n");
                return 1;
            }
        }
        if ("svc".equals(commandArg)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1542")).append("\n");
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            Properties targetAttrs = brokerCmdProps.getTargetAttrs();
            String svcName = brokerCmdProps.getTargetName();
            sb.append(this.ar.getString("A1543", (Object)svcName)).append("\n");
            sb.append("").append("\n");
            this.printAttrs(targetAttrs);
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            ServiceInfo si = this.getServiceInfoFromAttrs(targetAttrs);
            si.setName(svcName);
            int svcType = -1;
            int svcPort = -1;
            Vector svc = null;
            try {
                this.connectToBroker(broker);
                broker.sendGetServicesMessage(svcName);
                svc = broker.receiveGetServicesReplyMessage();
                if (svc != null && svc.size() == 1) {
                    Enumeration thisEnum = svc.elements();
                    ServiceInfo sInfo = (ServiceInfo)thisEnum.nextElement();
                    svcType = sInfo.type;
                    svcPort = sInfo.port;
                }
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1542")).append("\n");
                return 1;
            }
            if (!force) {
                input = this.getUserInput(this.ar.getString("A5012"), noShort);
                sb.append("").append("\n");
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    sb.append(this.ar.getString("A1544")).append("\n");
                    return 0;
                }
                if (!yesShort.equalsIgnoreCase(input) && !yes.equalsIgnoreCase(input)) {
                    sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
                    sb.append("").append("\n");
                    sb.append(this.ar.getString("A1544")).append("\n");
                    return 1;
                }
            }
            if (si.isModified(1) && svcPort == -1) {
                Globals.stdErrPrintln((String)this.ar.getString("A3149", (Object)svcName));
                sb.append(this.ar.getString("A1542")).append("\n");
                return 1;
            }
            try {
                broker.sendUpdateServiceMessage(si);
                broker.receiveUpdateServiceReplyMessage();
                sb.append(this.ar.getString("A1545")).append("\n");
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1542")).append("\n");
                return 1;
            }
        }
        if ("dst".equals(commandArg)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1546")).append("\n");
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            Properties targetAttrs = brokerCmdProps.getTargetAttrs();
            int destTypeMask = this.getDestTypeMask(brokerCmdProps);
            String destName = brokerCmdProps.getTargetName();
            if (DestType.isQueue((int)destTypeMask)) {
                Globals.stdOutPrintln((String)this.ar.getString("A1547", (Object)destName));
            } else {
                Globals.stdOutPrintln((String)this.ar.getString("A1548", (Object)destName));
            }
            sb.append("").append("\n");
            this.printAttrs(targetAttrs);
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            if (!force) {
                if (this.updatingDestXMLSchema(targetAttrs)) {
                    Object[] args = new Object[]{"validateXMLSchemaEnabled", "XMLSchemaURIList", "reloadXMLSchemaOnFailure"};
                    input = this.getUserInput(this.ar.getString("A5034", args), noShort);
                } else {
                    input = this.getUserInput(this.ar.getString("A5013"), noShort);
                }
                sb.append("").append("\n");
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    sb.append(this.ar.getString("A1549")).append("\n");
                    return 0;
                }
                if (!yesShort.equalsIgnoreCase(input) && !yes.equalsIgnoreCase(input)) {
                    sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
                    sb.append("").append("\n");
                    sb.append(this.ar.getString("A1549")).append("\n");
                    return 1;
                }
            }
            try {
                DestinationInfo di = this.getDestinationInfoFromAttrs(targetAttrs);
                di.setType(destTypeMask);
                di.setName(destName);
                this.connectToBroker(broker);
                broker.sendUpdateDestinationMessage(di);
                broker.receiveUpdateDestinationReplyMessage();
                sb.append(this.ar.getString("A1550")).append("\n");
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1546")).append("\n");
                return 1;
            }
        }
        broker.close();
        return 0;
    }

    private void printAttrs(Properties targetAttrs) {
        this.printAttrs(targetAttrs, false);
    }

    private void printAttrs(Properties targetAttrs, boolean printTitle) {
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(2, 4);
        Object[] row = new String[2];
        if (printTitle) {
            bcp = new BrokerCmdPrinter(2, 4, "-");
            row[0] = "Property Name";
            row[1] = "Property Value";
            bcp.addTitle((String[])row);
        } else {
            bcp = new BrokerCmdPrinter(2, 4);
        }
        Enumeration<?> e = targetAttrs.propertyNames();
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            String value = targetAttrs.getProperty(propName);
            row[0] = propName;
            row[1] = value;
            bcp.add(row);
        }
        bcp.println();
    }

    private ServiceInfo getServiceInfoFromAttrs(Properties svcAttrs) {
        ServiceInfo si = new ServiceInfo();
        Enumeration<?> e = svcAttrs.propertyNames();
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            String value = svcAttrs.getProperty(propName);
            int intValue = 0;
            boolean valueOK = true;
            if (propName.equals("port")) {
                try {
                    intValue = Integer.parseInt(value);
                }
                catch (NumberFormatException nfe) {
                    valueOK = false;
                }
                if (!valueOK) continue;
                si.setPort(intValue);
                continue;
            }
            if (propName.equals("minThreads")) {
                try {
                    intValue = Integer.parseInt(value);
                }
                catch (NumberFormatException nfe) {
                    valueOK = false;
                }
                if (!valueOK) continue;
                si.setMinThreads(intValue);
                continue;
            }
            if (!propName.equals("maxThreads")) continue;
            try {
                intValue = Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                valueOK = false;
            }
            if (!valueOK) continue;
            si.setMaxThreads(intValue);
        }
        return si;
    }

    private boolean updatingDestXMLSchema(Properties dstAttrs) {
        if (dstAttrs == null) {
            return false;
        }
        String value = dstAttrs.getProperty("validateXMLSchemaEnabled");
        if (value != null && !value.equals("")) {
            return true;
        }
        value = dstAttrs.getProperty("XMLSchemaURIList");
        if (value != null && !value.equals("")) {
            return true;
        }
        value = dstAttrs.getProperty("reloadXMLSchemaOnFailure");
        return value != null && !value.equals("");
    }

    public DestinationInfo getDestinationInfoFromAttrs(Properties destAttrs) {
        DestinationInfo di = new DestinationInfo();
        Enumeration<?> e = destAttrs.propertyNames();
        while (e.hasMoreElements()) {
            SizeString ss;
            String propName = (String)e.nextElement();
            String value = destAttrs.getProperty(propName);
            int intValue = 0;
            long longValue = 0L;
            boolean valueOK = true;
            if (propName.equals("maxTotalMsgBytes")) {
                try {
                    ss = new SizeString(value);
                    longValue = ss.getBytes();
                }
                catch (NumberFormatException nfe) {
                    valueOK = false;
                }
                if (!valueOK) continue;
                di.setMaxMessageBytes(longValue);
                continue;
            }
            if (propName.equals("maxNumMsgs")) {
                try {
                    intValue = Integer.parseInt(value);
                }
                catch (NumberFormatException nfe) {
                    valueOK = false;
                }
                if (!valueOK) continue;
                di.setMaxMessages(intValue);
                continue;
            }
            if (propName.equals("maxBytesPerMsg")) {
                try {
                    ss = new SizeString(value);
                    longValue = ss.getBytes();
                }
                catch (NumberFormatException nfe) {
                    valueOK = false;
                }
                if (!valueOK) continue;
                di.setMaxMessageSize(longValue);
                continue;
            }
            if (propName.equals("maxNumBackupConsumers")) {
                try {
                    di.setMaxFailoverConsumers(Integer.parseInt(value));
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if (propName.equals("maxNumActiveConsumers")) {
                try {
                    di.setMaxActiveConsumers(Integer.parseInt(value));
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if (propName.equals("isLocalOnly")) {
                di.setScope(Boolean.valueOf(value).booleanValue());
            }
            if (propName.equals("limitBehavior")) {
                di.setLimitBehavior(this.getLimitBehavValue(value));
            }
            if (propName.equals("localDeliveryPreferred")) {
                di.setClusterDeliveryPolicy(this.getClusterDeliveryPolicy(value));
            }
            if (propName.equals("consumerFlowLimit")) {
                try {
                    di.setPrefetch(Integer.parseInt(value));
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if (propName.equals("maxNumProducers")) {
                try {
                    di.setMaxProducers(Integer.parseInt(value));
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if (propName.equals("useDMQ")) {
                di.setUseDMQ(Boolean.valueOf(value).booleanValue());
            }
            if (propName.equals("validateXMLSchemaEnabled")) {
                di.setValidateXMLSchemaEnabled(Boolean.valueOf(value).booleanValue());
            }
            if (propName.equals("XMLSchemaURIList")) {
                di.setXMLSchemaUriList(value);
            }
            if (!propName.equals("reloadXMLSchemaOnFailure")) continue;
            di.setReloadXMLSchemaOnFailure(Boolean.valueOf(value).booleanValue());
        }
        return di;
    }

    private int runQuery(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        BrokerAdmin broker = this.init();
        String commandArg = brokerCmdProps.getCommandArg();
        if ("dst".equals(commandArg)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1245")).append("\n");
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String destName = brokerCmdProps.getTargetName();
            int destTypeMask = this.getDestTypeMask(brokerCmdProps);
            sb.append(this.ar.getString("A1242")).append("\n");
            this.printDestinationInfo();
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            try {
                Object[] row;
                BrokerCmdPrinter bcp;
                DestinationInfo dInfo;
                this.connectToBroker(broker);
                broker.sendGetDestinationsMessage(destName, destTypeMask);
                Vector dest = broker.receiveGetDestinationsReplyMessage();
                if (dest != null && dest.size() == 1) {
                    Enumeration thisEnum = dest.elements();
                    dInfo = (DestinationInfo)thisEnum.nextElement();
                    bcp = new BrokerCmdPrinter(2, 4);
                    row = new String[2];
                    bcp.setSortNeeded(false);
                    row[0] = this.ar.getString("A1400");
                    row[1] = dInfo.name;
                    bcp.add(row);
                    row[0] = this.ar.getString("A1401");
                    row[1] = BrokerAdminUtil.getDestinationType((int)dInfo.type);
                    if (DestType.isTemporary((int)dInfo.type)) {
                        row[1] = (String)row[1] + " (" + this.ar.getString("A1631") + ")";
                    }
                    bcp.add(row);
                    row[0] = this.ar.getString("A1429");
                    row[1] = DestState.toString((int)dInfo.destState);
                    bcp.add(row);
                    row[0] = this.ar.getString("A1427");
                    row[1] = dInfo.autocreated ? Boolean.FALSE.toString() : Boolean.TRUE.toString();
                    bcp.add(row);
                    row[0] = "";
                    row[1] = "";
                    bcp.add(row);
                    row[0] = this.ar.getString("A1404");
                    row[1] = "";
                    bcp.add(row);
                    String indent = "    ";
                    row[0] = indent + this.ar.getString("A1735");
                    row[1] = new Integer(dInfo.nMessages - dInfo.nTxnMessages).toString();
                    bcp.add(row);
                    row[0] = indent + this.ar.getString("A1738");
                    row[1] = new Integer(dInfo.nRemoteMessages).toString();
                    bcp.add(row);
                    row[0] = indent + this.ar.getString("A1734");
                    row[1] = new Integer(dInfo.nTxnMessages).toString();
                    bcp.add(row);
                    row[0] = this.ar.getString("A1405");
                    row[1] = "";
                    bcp.add(row);
                    row[0] = indent + this.ar.getString("A1735");
                    row[1] = new Long(dInfo.nMessageBytes - dInfo.nTxnMessageBytes).toString();
                    bcp.add(row);
                    row[0] = indent + this.ar.getString("A1738");
                    row[1] = new Long(dInfo.nRemoteMessageBytes).toString();
                    bcp.add(row);
                    row[0] = indent + this.ar.getString("A1734");
                    row[1] = new Long(dInfo.nTxnMessageBytes).toString();
                    bcp.add(row);
                    row[0] = this.ar.getString("A1428");
                    row[1] = new Integer(dInfo.nProducers).toString();
                    bcp.add(row);
                    if (DestType.isQueue((int)destTypeMask)) {
                        row[0] = this.ar.getString("A1416");
                        row[1] = new Integer(dInfo.naConsumers).toString();
                        bcp.add(row);
                        row[0] = this.ar.getString("A1417");
                        row[1] = new Integer(dInfo.nfConsumers).toString();
                        bcp.add(row);
                    } else {
                        Integer val;
                        String wildcard;
                        Enumeration keys;
                        Hashtable h = dInfo.producerWildcards;
                        row[0] = this.ar.getString("A1692");
                        row[1] = Integer.toString(this.getWildcardCount(h));
                        bcp.add(row);
                        if (h != null) {
                            keys = h.keys();
                            while (keys.hasMoreElements()) {
                                wildcard = (String)keys.nextElement();
                                val = (Integer)h.get(wildcard);
                                row[0] = indent + wildcard + "  (" + val + ")";
                                row[1] = "";
                                bcp.add(row);
                            }
                        }
                        row[0] = this.ar.getString("A1688");
                        row[1] = new Integer(dInfo.nConsumers).toString();
                        bcp.add(row);
                        h = dInfo.consumerWildcards;
                        row[0] = this.ar.getString("A1693");
                        row[1] = Integer.toString(this.getWildcardCount(h));
                        bcp.add(row);
                        if (h != null) {
                            keys = h.keys();
                            while (keys.hasMoreElements()) {
                                wildcard = (String)keys.nextElement();
                                val = (Integer)h.get(wildcard);
                                row[0] = indent + wildcard + "  (" + val + ")";
                                row[1] = "";
                                bcp.add(row);
                            }
                        }
                    }
                    row[0] = "";
                    row[1] = "";
                    bcp.add(row);
                    row[0] = this.ar.getString("A1407");
                    row[1] = this.checkAndPrintUnlimitedInt(dInfo.maxMessages, this.zeroNegOneInt);
                    bcp.add(row);
                    row[0] = this.ar.getString("A1406");
                    row[1] = this.checkAndPrintUnlimitedLong(dInfo.maxMessageBytes, this.zeroNegOneLong);
                    bcp.add(row);
                    row[0] = this.ar.getString("A1408");
                    row[1] = new Long(dInfo.maxMessageSize).toString();
                    row[1] = this.checkAndPrintUnlimitedLong(dInfo.maxMessageSize, this.zeroNegOneLong);
                    bcp.add(row);
                    row[0] = this.ar.getString("A1415");
                    row[1] = this.checkAndPrintUnlimitedInt(dInfo.maxProducers, -1);
                    bcp.add(row);
                    if (DestType.isQueue((int)destTypeMask)) {
                        row[0] = this.ar.getString("A1410");
                        row[1] = this.checkAndPrintUnlimitedInt(dInfo.maxActiveConsumers, -1);
                        bcp.add(row);
                        row[0] = this.ar.getString("A1409");
                        row[1] = this.checkAndPrintUnlimitedInt(dInfo.maxFailoverConsumers, -1);
                        bcp.add(row);
                    }
                    row[0] = "";
                    row[1] = "";
                    bcp.add(row);
                    row[0] = this.ar.getString("A1412");
                    row[1] = DestLimitBehavior.getString((int)dInfo.destLimitBehavior);
                    bcp.add(row);
                    row[0] = this.ar.getString("A1414");
                    row[1] = this.checkAndPrintUnlimitedInt(dInfo.maxPrefetch, -1);
                    bcp.add(row);
                    row[0] = this.ar.getString("A1411");
                    row[1] = dInfo.isDestinationLocal() ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
                    bcp.add(row);
                    if (DestType.isQueue((int)destTypeMask)) {
                        row[0] = this.ar.getString("A1413");
                        row[1] = dInfo.destCDP == 1 ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
                        bcp.add(row);
                    }
                } else {
                    sb.append(this.ar.getString("A1335")).append("\n");
                    sb.append(this.ar.getString("A1245")).append("\n");
                    return 1;
                }
                row[0] = this.ar.getString("A1446");
                row[1] = dInfo.useDMQ() ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
                bcp.add(row);
                row[0] = this.ar.getString("A1447");
                row[1] = dInfo.validateXMLSchemaEnabled() ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
                bcp.add(row);
                row[0] = this.ar.getString("A1448");
                row[1] = dInfo.XMLSchemaUriList;
                bcp.add(row);
                row[0] = this.ar.getString("A1449");
                row[1] = dInfo.reloadXMLSchemaOnFailure() ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
                bcp.add(row);
                bcp.println();
                sb.append(this.ar.getString("A1243")).append("\n");
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1245")).append("\n");
                return 1;
            }
        }
        if ("svc".equals(commandArg)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1249")).append("\n");
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String svcName = brokerCmdProps.getTargetName();
            sb.append(this.ar.getString("A1246")).append("\n");
            this.printServiceInfo();
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            try {
                Object[] row;
                BrokerCmdPrinter bcp;
                ServiceInfo sInfo;
                this.connectToBroker(broker);
                broker.sendGetServicesMessage(svcName);
                Vector svc = broker.receiveGetServicesReplyMessage();
                if (svc != null && svc.size() == 1) {
                    Enumeration thisEnum = svc.elements();
                    sInfo = (ServiceInfo)thisEnum.nextElement();
                    bcp = new BrokerCmdPrinter(2, 4);
                    row = new String[2];
                    bcp.setSortNeeded(false);
                    row[0] = this.ar.getString("A1420");
                    row[1] = sInfo.name;
                    bcp.add(row);
                    row[0] = this.ar.getString("A1422");
                    row[1] = ServiceState.getString((int)sInfo.state);
                    bcp.add(row);
                    if (sInfo.port != -1) {
                        row[0] = this.ar.getString("A1421");
                        if (sInfo.dynamicPort) {
                            switch (sInfo.state) {
                                case -1: {
                                    row[1] = this.ar.getString("A1520");
                                    break;
                                }
                                default: {
                                    row[1] = new Integer(sInfo.port).toString() + " (" + this.ar.getString("A1520") + ")";
                                    break;
                                }
                            }
                        } else {
                            row[1] = new Integer(sInfo.port).toString() + " (" + this.ar.getString("A1521") + ")";
                        }
                        bcp.add(row);
                    }
                } else {
                    sb.append(this.ar.getString("A1335")).append("\n");
                    sb.append(this.ar.getString("A1249")).append("\n");
                    return 1;
                }
                row[0] = "";
                row[1] = "";
                bcp.add(row);
                row[0] = this.ar.getString("A1425");
                row[1] = new Integer(sInfo.currentThreads).toString();
                bcp.add(row);
                row[0] = this.ar.getString("A1426");
                row[1] = new Integer(sInfo.nConnections).toString();
                bcp.add(row);
                row[0] = "";
                row[1] = "";
                bcp.add(row);
                row[0] = this.ar.getString("A1423");
                row[1] = new Integer(sInfo.minThreads).toString();
                bcp.add(row);
                row[0] = this.ar.getString("A1424");
                row[1] = new Integer(sInfo.maxThreads).toString();
                bcp.add(row);
                bcp.println();
                sb.append(this.ar.getString("A1247")).append("\n");
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1249")).append("\n");
                return 1;
            }
        }
        if ("bkr".equals(commandArg)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1523")).append("\n");
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            sb.append(this.ar.getString("A1522")).append("\n");
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
                broker.sendGetBrokerPropsMessage();
                Properties bkrProps = broker.receiveGetBrokerPropsReplyMessage();
                if (bkrProps == null) {
                    sb.append(this.ar.getString("A1523")).append("\n");
                    return 1;
                }
                if (brokerCmdProps.adminDebugModeSet()) {
                    this.printAllBrokerAttrs(bkrProps);
                } else {
                    this.printDisplayableBrokerAttrs(bkrProps);
                }
                sb.append(this.ar.getString("A1524")).append("\n");
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1523")).append("\n");
                return 1;
            }
        }
        if ("txn".equals(commandArg)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1256")).append("\n");
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String tidStr = brokerCmdProps.getTargetName();
            Long tid = null;
            try {
                tid = Long.valueOf(tidStr);
            }
            catch (NumberFormatException nfe) {
                sb.append(this.ar.getString("A3150", (Object)tidStr)).append("\n");
                sb.append(this.ar.getString("A1256")).append("\n");
                return 1;
            }
            sb.append(this.ar.getString("A1254")).append("\n");
            this.printTransactionInfo();
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
                broker.sendGetTxnsMessage(tid);
                Vector txns = broker.receiveGetTxnsReplyMessage();
                if (txns != null && txns.size() == 1) {
                    Enumeration thisEnum = txns.elements();
                    Hashtable txnInfo = (Hashtable)thisEnum.nextElement();
                    if (brokerCmdProps.debugModeSet()) {
                        this.printAllTxnAttrs(txnInfo);
                    } else {
                        this.printDisplayableTxnAttrs(txnInfo);
                    }
                } else {
                    sb.append(this.ar.getString("A1335")).append("\n");
                    sb.append(this.ar.getString("A1256")).append("\n");
                    return 1;
                }
                sb.append(this.ar.getString("A1255")).append("\n");
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1256")).append("\n");
                return 1;
            }
        }
        if ("cxn".equals(commandArg)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1334")).append("\n");
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String cxnIdStr = brokerCmdProps.getTargetName();
            Long cxnId = null;
            try {
                cxnId = Long.valueOf(cxnIdStr);
            }
            catch (NumberFormatException nfe) {
                sb.append(this.ar.getString("A3159", (Object)cxnIdStr)).append("\n");
                sb.append(this.ar.getString("A1334")).append("\n");
                return 1;
            }
            sb.append(this.ar.getString("A1332")).append("\n");
            this.printConnectionInfo();
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
                broker.sendGetConnectionsMessage(null, cxnId);
                Vector cxnList = broker.receiveGetConnectionsReplyMessage();
                if (cxnList != null && cxnList.size() == 1) {
                    Enumeration thisEnum = cxnList.elements();
                    Hashtable cxnInfo = (Hashtable)thisEnum.nextElement();
                    if (brokerCmdProps.debugModeSet()) {
                        this.printAllCxnAttrs(cxnInfo);
                    } else {
                        this.printDisplayableCxnAttrs(cxnInfo);
                    }
                } else {
                    sb.append(this.ar.getString("A1335")).append("\n");
                    sb.append(this.ar.getString("A1334")).append("\n");
                    return 1;
                }
                sb.append(this.ar.getString("A1333")).append("\n");
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1334")).append("\n");
                return 1;
            }
        }
        if ("msg".equals(commandArg)) {
            if (broker == null) {
                sb.append("Querying message failed.").append("\n");
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String destName = brokerCmdProps.getTargetName();
            int destTypeMask = this.getDestTypeMask(brokerCmdProps);
            String msgID = brokerCmdProps.getMsgID();
            sb.append("Querying message:").append("\n");
            this.printMessageInfo();
            sb.append("In the destination").append("\n");
            this.printDestinationInfo();
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
                broker.sendGetMessagesMessage(destName, destTypeMask, true, msgID, null, null);
                Vector msgList = broker.receiveGetMessagesReplyMessage();
                if (msgList != null && msgList.size() == 1) {
                    HashMap oneMsg = (HashMap)msgList.get(0);
                    this.printDisplayableMsgAttrs(oneMsg);
                    sb.append("Successfully queried message.").append("\n");
                } else {
                    sb.append("There are no messages.").append("\n");
                    sb.append("").append("\n");
                    sb.append("Successfully queried message.").append("\n");
                }
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append("Querying message failed.").append("\n");
                return 1;
            }
        }
        if (broker.isConnected()) {
            broker.close();
        }
        return 0;
    }

    private int runMetrics(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        BrokerAdmin broker = this.init();
        String commandArg = brokerCmdProps.getCommandArg();
        long sleepTime = brokerCmdProps.getMetricInterval();
        int metricType = this.getMetricType(brokerCmdProps);
        int metricSamples = brokerCmdProps.getMetricSamples();
        if ("svc".equals(commandArg)) {
            BrokerCmdPrinter bcp = this.setupMetricTitle(commandArg, metricType);
            if (broker == null) {
                sb.append(this.ar.getString("A1559")).append("\n");
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String svcName = brokerCmdProps.getTargetName();
            sb.append(this.ar.getString("A1560")).append("\n");
            this.printServiceInfo();
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            try {
                MetricCounters previousMetrics = null;
                int rowsPrinted = 0;
                this.connectToBroker(broker);
                while (true) {
                    broker.sendGetMetricsMessage(svcName);
                    MetricCounters mc = (MetricCounters)broker.receiveGetMetricsReplyMessage();
                    if (mc == null) {
                        sb.append(this.ar.getString("A1559")).append("\n");
                        return 1;
                    }
                    this.addOneMetricRow(metricType, bcp, mc, previousMetrics);
                    if (rowsPrinted % 20 == 0) {
                        bcp.print();
                    } else {
                        bcp.print(false);
                    }
                    bcp.clear();
                    previousMetrics = mc;
                    if (metricSamples > 0 && metricSamples == ++rowsPrinted) break;
                    try {
                        Thread.sleep(sleepTime * 1000L);
                    }
                    catch (InterruptedException ie) {
                        sb.append(ie.toString()).append("\n");
                    }
                }
                sb.append("").append("\n");
                sb.append(this.ar.getString("A1298")).append("\n");
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1559")).append("\n");
                return 1;
            }
        }
        if ("bkr".equals(commandArg)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1561")).append("\n");
                return 1;
            }
            BrokerCmdPrinter bcp = this.setupMetricTitle(commandArg, metricType);
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            sb.append(this.ar.getString("A1562")).append("\n");
            this.printBrokerInfo(broker);
            try {
                MetricCounters previousMetrics = null;
                int rowsPrinted = 0;
                this.connectToBroker(broker);
                while (true) {
                    broker.sendGetMetricsMessage(null);
                    MetricCounters mc = (MetricCounters)broker.receiveGetMetricsReplyMessage();
                    if (mc == null) {
                        sb.append(this.ar.getString("A1561")).append("\n");
                        return 1;
                    }
                    this.addOneMetricRow(metricType, bcp, mc, previousMetrics);
                    if (rowsPrinted % 20 == 0) {
                        bcp.print();
                    } else {
                        bcp.print(false);
                    }
                    bcp.clear();
                    previousMetrics = mc;
                    if (metricSamples > 0 && metricSamples == ++rowsPrinted) break;
                    try {
                        Thread.sleep(sleepTime * 1000L);
                    }
                    catch (InterruptedException ie) {
                        sb.append(ie.toString()).append("\n");
                    }
                }
                sb.append("").append("\n");
                sb.append(this.ar.getString("A1299")).append("\n");
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1561")).append("\n");
                return 1;
            }
        }
        if ("dst".equals(commandArg)) {
            String destName = brokerCmdProps.getTargetName();
            int destTypeMask = this.getDestTypeMask(brokerCmdProps);
            BrokerCmdPrinter bcp = this.setupDestMetricTitle(commandArg, metricType, destTypeMask);
            if (broker == null) {
                sb.append(this.ar.getString("A1296")).append("\n");
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            sb.append(this.ar.getString("A1297")).append("\n");
            this.printDestinationInfo();
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            try {
                DestMetricsCounters previousMetrics = null;
                int rowsPrinted = 0;
                this.connectToBroker(broker);
                while (true) {
                    broker.sendGetMetricsMessage(destName, destTypeMask);
                    DestMetricsCounters mc = (DestMetricsCounters)broker.receiveGetMetricsReplyMessage();
                    if (mc == null) {
                        sb.append(this.ar.getString("A1296")).append("\n");
                        return 1;
                    }
                    this.addOneDestMetricRow(metricType, destTypeMask, bcp, mc, previousMetrics);
                    if (rowsPrinted % 20 == 0) {
                        bcp.print();
                    } else {
                        bcp.print(false);
                    }
                    bcp.clear();
                    previousMetrics = mc;
                    if (metricSamples > 0 && metricSamples == ++rowsPrinted) break;
                    try {
                        Thread.sleep(sleepTime * 1000L);
                    }
                    catch (InterruptedException ie) {
                        sb.append(ie.toString()).append("\n");
                    }
                }
                sb.append("").append("\n");
                sb.append(this.ar.getString("A1300")).append("\n");
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1296")).append("\n");
                return 1;
            }
        }
        if (broker.isConnected()) {
            broker.close();
        }
        return 0;
    }

    private BrokerCmdPrinter setupListDestTitle(int listType) {
        BrokerCmdPrinter bcp = null;
        if (listType != 2) {
            bcp = new BrokerCmdPrinter(11, 2, "-");
            String[] row = new String[11];
            int i = 0;
            bcp.setTitleAlign(1);
            int[] span = new int[11];
            span[i++] = 1;
            span[i++] = 1;
            span[i++] = 1;
            span[i++] = 2;
            span[i++] = 0;
            span[i++] = 2;
            span[i++] = 0;
            span[i++] = 4;
            span[i++] = 0;
            span[i++] = 0;
            span[i++] = 0;
            i = 0;
            int n = i++;
            row[n] = this.ar.getString("A1443");
            int n2 = i++;
            row[n2] = this.ar.getString("A1444");
            int n3 = i++;
            row[n3] = this.ar.getString("A1445");
            int n4 = i++;
            row[n4] = this.ar.getString("A1675");
            row[i++] = "";
            int n5 = i++;
            row[n5] = this.ar.getString("A1676");
            row[i++] = "";
            int n6 = i++;
            row[n6] = this.ar.getString("A1677");
            row[i++] = "";
            row[i++] = "";
            row[i++] = "";
            bcp.addTitle(row, span);
            i = 0;
            row[i++] = "";
            row[i++] = "";
            row[i++] = "";
            int n7 = i++;
            row[n7] = this.ar.getString("A1690");
            int n8 = i++;
            row[n8] = this.ar.getString("A1691");
            int n9 = i++;
            row[n9] = this.ar.getString("A1689");
            int n10 = i++;
            row[n10] = this.ar.getString("A1691");
            int n11 = i++;
            row[n11] = this.ar.getString("A1680");
            int n12 = i++;
            row[n12] = this.ar.getString("A1738");
            int n13 = i++;
            row[n13] = this.ar.getString("A1681");
            int n14 = i++;
            row[n14] = this.ar.getString("A1682");
            bcp.addTitle(row);
        } else {
            bcp = new BrokerCmdPrinter(10, 2, "-");
            String[] row = new String[10];
            int i = 0;
            bcp.setTitleAlign(1);
            int[] span = new int[10];
            span[i++] = 1;
            span[i++] = 1;
            span[i++] = 1;
            span[i++] = 1;
            span[i++] = 2;
            span[i++] = 0;
            span[i++] = 4;
            span[i++] = 0;
            span[i++] = 0;
            span[i++] = 0;
            i = 0;
            int n = i++;
            row[n] = this.ar.getString("A1443");
            int n15 = i++;
            row[n15] = this.ar.getString("A1444");
            int n16 = i++;
            row[n16] = this.ar.getString("A1445");
            int n17 = i++;
            row[n17] = this.ar.getString("A1675");
            int n18 = i++;
            row[n18] = this.ar.getString("A1676");
            row[i++] = "";
            int n19 = i++;
            row[n19] = this.ar.getString("A1677");
            row[i++] = "";
            row[i++] = "";
            bcp.addTitle(row, span);
            i = 0;
            row[i++] = "";
            row[i++] = "";
            row[i++] = "";
            row[i++] = "";
            int n20 = i++;
            row[n20] = this.ar.getString("A1678");
            int n21 = i++;
            row[n21] = this.ar.getString("A1679");
            int n22 = i++;
            row[n22] = this.ar.getString("A1680");
            int n23 = i++;
            row[n23] = this.ar.getString("A1738");
            int n24 = i++;
            row[n24] = this.ar.getString("A1681");
            int n25 = i++;
            row[n25] = this.ar.getString("A1682");
            bcp.addTitle(row);
        }
        return bcp;
    }

    private BrokerCmdPrinter setupMetricTitle(String commandArg, int metricType) {
        BrokerCmdPrinter bcp = null;
        if (metricType == 0) {
            int i = 0;
            int[] span = new int[8];
            bcp = new BrokerCmdPrinter(8, 2, "-", 1);
            bcp.setTitleAlign(1);
            String[] titleRow = new String[8];
            span[i++] = 2;
            span[i++] = 0;
            span[i++] = 2;
            span[i++] = 0;
            span[i++] = 2;
            span[i++] = 0;
            span[i++] = 2;
            span[i++] = 0;
            i = 0;
            int n = i++;
            titleRow[n] = this.ar.getString("A1659");
            titleRow[i++] = "";
            int n2 = i++;
            titleRow[n2] = this.ar.getString("A1660");
            titleRow[i++] = "";
            int n3 = i++;
            titleRow[n3] = this.ar.getString("A1661");
            titleRow[i++] = "";
            int n4 = i++;
            titleRow[n4] = this.ar.getString("A1662");
            titleRow[i++] = "";
            bcp.addTitle(titleRow, span);
            i = 0;
            int n5 = i++;
            titleRow[n5] = this.ar.getString("A1667");
            int n6 = i++;
            titleRow[n6] = this.ar.getString("A1668");
            int n7 = i++;
            titleRow[n7] = this.ar.getString("A1667");
            int n8 = i++;
            titleRow[n8] = this.ar.getString("A1668");
            int n9 = i++;
            titleRow[n9] = this.ar.getString("A1667");
            int n10 = i++;
            titleRow[n10] = this.ar.getString("A1668");
            int n11 = i++;
            titleRow[n11] = this.ar.getString("A1667");
            int n12 = i++;
            titleRow[n12] = this.ar.getString("A1668");
            bcp.addTitle(titleRow);
        } else if (metricType == 1) {
            int i = 0;
            int[] span = new int[8];
            bcp = new BrokerCmdPrinter(8, 2, "-", 1);
            bcp.setTitleAlign(1);
            String[] titleRow = new String[8];
            span[i++] = 2;
            span[i++] = 0;
            span[i++] = 2;
            span[i++] = 0;
            span[i++] = 2;
            span[i++] = 0;
            span[i++] = 2;
            span[i++] = 0;
            i = 0;
            int n = i++;
            titleRow[n] = this.ar.getString("A1663");
            titleRow[i++] = "";
            int n13 = i++;
            titleRow[n13] = this.ar.getString("A1664");
            titleRow[i++] = "";
            int n14 = i++;
            titleRow[n14] = this.ar.getString("A1665");
            titleRow[i++] = "";
            int n15 = i++;
            titleRow[n15] = this.ar.getString("A1666");
            titleRow[i++] = "";
            bcp.addTitle(titleRow, span);
            i = 0;
            int n16 = i++;
            titleRow[n16] = this.ar.getString("A1667");
            int n17 = i++;
            titleRow[n17] = this.ar.getString("A1668");
            int n18 = i++;
            titleRow[n18] = this.ar.getString("A1667");
            int n19 = i++;
            titleRow[n19] = this.ar.getString("A1668");
            int n20 = i++;
            titleRow[n20] = this.ar.getString("A1667");
            int n21 = i++;
            titleRow[n21] = this.ar.getString("A1668");
            int n22 = i++;
            titleRow[n22] = this.ar.getString("A1667");
            int n23 = i++;
            titleRow[n23] = this.ar.getString("A1668");
            bcp.addTitle(titleRow);
        } else if (metricType == 2) {
            int i = 0;
            String[] titleRow = new String[6];
            int[] span = new int[6];
            bcp = new BrokerCmdPrinter(6, 2, "-", 1);
            bcp.setTitleAlign(1);
            span[i++] = 1;
            span[i++] = 2;
            span[i++] = 0;
            span[i++] = 3;
            span[i++] = 0;
            span[i++] = 0;
            i = 0;
            int n = i++;
            titleRow[n] = this.ar.getString("A1608");
            int n24 = i++;
            titleRow[n24] = this.ar.getString("A1669");
            titleRow[i++] = "";
            int n25 = i++;
            titleRow[n25] = this.ar.getString("A1670");
            titleRow[i++] = "";
            titleRow[i++] = "";
            bcp.addTitle(titleRow, span);
            i = 0;
            int n26 = i++;
            titleRow[n26] = this.ar.getString("A1609");
            int n27 = i++;
            titleRow[n27] = this.ar.getString("A1647");
            int n28 = i++;
            titleRow[n28] = this.ar.getString("A1671");
            int n29 = i++;
            titleRow[n29] = this.ar.getString("A1672");
            int n30 = i++;
            titleRow[n30] = this.ar.getString("A1673");
            int n31 = i++;
            titleRow[n31] = this.ar.getString("A1674");
            bcp.addTitle(titleRow);
        }
        return bcp;
    }

    private BrokerCmdPrinter setupDestMetricTitle(String commandArg, int metricType, int destTypeMask) {
        BrokerCmdPrinter bcp = null;
        if (metricType == 0) {
            bcp = new BrokerCmdPrinter(11, 2, "-", 1);
            bcp.setTitleAlign(1);
            String[] titleRow = new String[11];
            int[] span = new int[11];
            int i = 0;
            span[i++] = 2;
            span[i++] = 0;
            span[i++] = 2;
            span[i++] = 0;
            span[i++] = 3;
            span[i++] = 0;
            span[i++] = 0;
            span[i++] = 3;
            span[i++] = 0;
            span[i++] = 0;
            span[i++] = 1;
            i = 0;
            int n = i++;
            titleRow[n] = this.ar.getString("A1659");
            titleRow[i++] = "";
            int n2 = i++;
            titleRow[n2] = this.ar.getString("A1660");
            titleRow[i++] = "";
            int n3 = i++;
            titleRow[n3] = this.ar.getString("A1643");
            titleRow[i++] = "";
            titleRow[i++] = "";
            int n4 = i++;
            titleRow[n4] = this.ar.getString("A1644");
            titleRow[i++] = "";
            titleRow[i++] = "";
            int n5 = i++;
            titleRow[n5] = this.ar.getString("A1645");
            bcp.addTitle(titleRow, span);
            i = 0;
            int n6 = i++;
            titleRow[n6] = this.ar.getString("A1667");
            int n7 = i++;
            titleRow[n7] = this.ar.getString("A1668");
            int n8 = i++;
            titleRow[n8] = this.ar.getString("A1667");
            int n9 = i++;
            titleRow[n9] = this.ar.getString("A1668");
            int n10 = i++;
            titleRow[n10] = this.ar.getString("A1649");
            int n11 = i++;
            titleRow[n11] = this.ar.getString("A1650");
            int n12 = i++;
            titleRow[n12] = this.ar.getString("A1651");
            int n13 = i++;
            titleRow[n13] = this.ar.getString("A1649");
            int n14 = i++;
            titleRow[n14] = this.ar.getString("A1650");
            int n15 = i++;
            titleRow[n15] = this.ar.getString("A1651");
            int n16 = i++;
            titleRow[n16] = this.ar.getString("A1646");
            bcp.addTitle(titleRow);
        } else if (metricType == 1) {
            bcp = new BrokerCmdPrinter(11, 2, "-", 1);
            bcp.setTitleAlign(1);
            String[] titleRow = new String[11];
            int[] span = new int[11];
            int i = 0;
            span[i++] = 2;
            span[i++] = 0;
            span[i++] = 2;
            span[i++] = 0;
            span[i++] = 3;
            span[i++] = 0;
            span[i++] = 0;
            span[i++] = 3;
            span[i++] = 0;
            span[i++] = 0;
            span[i++] = 1;
            i = 0;
            int n = i++;
            titleRow[n] = this.ar.getString("A1663");
            titleRow[i++] = "";
            int n17 = i++;
            titleRow[n17] = this.ar.getString("A1664");
            titleRow[i++] = "";
            int n18 = i++;
            titleRow[n18] = this.ar.getString("A1643");
            titleRow[i++] = "";
            titleRow[i++] = "";
            int n19 = i++;
            titleRow[n19] = this.ar.getString("A1644");
            titleRow[i++] = "";
            titleRow[i++] = "";
            int n20 = i++;
            titleRow[n20] = this.ar.getString("A1645");
            bcp.addTitle(titleRow, span);
            i = 0;
            int n21 = i++;
            titleRow[n21] = this.ar.getString("A1667");
            int n22 = i++;
            titleRow[n22] = this.ar.getString("A1668");
            int n23 = i++;
            titleRow[n23] = this.ar.getString("A1667");
            int n24 = i++;
            titleRow[n24] = this.ar.getString("A1668");
            int n25 = i++;
            titleRow[n25] = this.ar.getString("A1649");
            int n26 = i++;
            titleRow[n26] = this.ar.getString("A1650");
            int n27 = i++;
            titleRow[n27] = this.ar.getString("A1651");
            int n28 = i++;
            titleRow[n28] = this.ar.getString("A1649");
            int n29 = i++;
            titleRow[n29] = this.ar.getString("A1650");
            int n30 = i++;
            titleRow[n30] = this.ar.getString("A1651");
            int n31 = i++;
            titleRow[n31] = this.ar.getString("A1646");
            bcp.addTitle(titleRow);
        } else if (metricType == 3) {
            if (DestType.isQueue((int)destTypeMask)) {
                bcp = new BrokerCmdPrinter(9, 2, "-", 1);
                bcp.setTitleAlign(1);
                String[] titleRow = new String[9];
                int[] span = new int[9];
                int i = 0;
                span[i++] = 3;
                span[i++] = 0;
                span[i++] = 0;
                span[i++] = 3;
                span[i++] = 0;
                span[i++] = 0;
                span[i++] = 3;
                span[i++] = 0;
                span[i++] = 0;
                i = 0;
                int n = i++;
                titleRow[n] = this.ar.getString("A1652");
                titleRow[i++] = "";
                titleRow[i++] = "";
                int n32 = i++;
                titleRow[n32] = this.ar.getString("A1653");
                titleRow[i++] = "";
                titleRow[i++] = "";
                int n33 = i++;
                titleRow[n33] = this.ar.getString("A1643");
                titleRow[i++] = "";
                titleRow[i++] = "";
                bcp.addTitle(titleRow, span);
                i = 0;
                int n34 = i++;
                titleRow[n34] = this.ar.getString("A1649");
                int n35 = i++;
                titleRow[n35] = this.ar.getString("A1650");
                int n36 = i++;
                titleRow[n36] = this.ar.getString("A1651");
                int n37 = i++;
                titleRow[n37] = this.ar.getString("A1649");
                int n38 = i++;
                titleRow[n38] = this.ar.getString("A1650");
                int n39 = i++;
                titleRow[n39] = this.ar.getString("A1651");
                int n40 = i++;
                titleRow[n40] = this.ar.getString("A1649");
                int n41 = i++;
                titleRow[n41] = this.ar.getString("A1650");
                int n42 = i++;
                titleRow[n42] = this.ar.getString("A1651");
                bcp.addTitle(titleRow);
            } else {
                bcp = new BrokerCmdPrinter(6, 2, "-", 1);
                bcp.setTitleAlign(1);
                String[] titleRow = new String[6];
                int[] span = new int[6];
                int i = 0;
                span[i++] = 3;
                span[i++] = 0;
                span[i++] = 0;
                span[i++] = 3;
                span[i++] = 0;
                span[i++] = 0;
                i = 0;
                int n = i++;
                titleRow[n] = this.ar.getString("A1687");
                titleRow[i++] = "";
                titleRow[i++] = "";
                int n43 = i++;
                titleRow[n43] = this.ar.getString("A1643");
                titleRow[i++] = "";
                titleRow[i++] = "";
                bcp.addTitle(titleRow, span);
                i = 0;
                int n44 = i++;
                titleRow[n44] = this.ar.getString("A1649");
                int n45 = i++;
                titleRow[n45] = this.ar.getString("A1650");
                int n46 = i++;
                titleRow[n46] = this.ar.getString("A1651");
                int n47 = i++;
                titleRow[n47] = this.ar.getString("A1649");
                int n48 = i++;
                titleRow[n48] = this.ar.getString("A1650");
                int n49 = i++;
                titleRow[n49] = this.ar.getString("A1651");
                bcp.addTitle(titleRow);
            }
        } else if (metricType == 4) {
            bcp = new BrokerCmdPrinter(3, 2, "-", 1);
            String[] titleRow = new String[3];
            titleRow[0] = this.ar.getString("A1656");
            titleRow[1] = this.ar.getString("A1657");
            titleRow[2] = this.ar.getString("A1658");
            bcp.addTitle(titleRow);
        } else if (metricType == 5) {
            bcp = new BrokerCmdPrinter(3, 2, "-", 1);
            bcp.setTitleAlign(1);
            String[] titleRow = new String[3];
            int[] span = new int[3];
            int i = 0;
            span[i++] = 3;
            span[i++] = 0;
            span[i++] = 0;
            i = 0;
            titleRow[i++] = "Msgs Removed";
            titleRow[i++] = "";
            titleRow[i++] = "";
            bcp.addTitle(titleRow, span);
            i = 0;
            titleRow[i++] = "Expired";
            titleRow[i++] = "Discarded";
            titleRow[i++] = "Purged";
            bcp.addTitle(titleRow);
        }
        return bcp;
    }

    private void addOneMetricRow(int metricType, BrokerCmdPrinter bcp, MetricCounters latest, MetricCounters previous) {
        if (metricType == 0) {
            Object[] metricRow = new String[]{Long.toString(latest.messagesIn), Long.toString(latest.messagesOut), Long.toString(latest.messageBytesIn), Long.toString(latest.messageBytesOut), Long.toString(latest.packetsIn), Long.toString(latest.packetsOut), Long.toString(latest.packetBytesIn), Long.toString(latest.packetBytesOut)};
            bcp.add(metricRow);
        } else if (metricType == 1) {
            Object[] metricRow = new String[8];
            if (previous == null) {
                metricRow[0] = "0";
                metricRow[1] = "0";
                metricRow[2] = "0";
                metricRow[3] = "0";
                metricRow[4] = "0";
                metricRow[5] = "0";
                metricRow[6] = "0";
                metricRow[7] = "0";
            } else {
                float secs = (float)(latest.timeStamp - previous.timeStamp) / 1000.0f;
                metricRow[0] = this.getRateString(latest.messagesIn, previous.messagesIn, secs);
                metricRow[1] = this.getRateString(latest.messagesOut, previous.messagesOut, secs);
                metricRow[2] = this.getRateString(latest.messageBytesIn, previous.messageBytesIn, secs);
                metricRow[3] = this.getRateString(latest.messageBytesOut, previous.messageBytesOut, secs);
                metricRow[4] = this.getRateString(latest.packetsIn, previous.packetsIn, secs);
                metricRow[5] = this.getRateString(latest.packetsOut, previous.packetsOut, secs);
                metricRow[6] = this.getRateString(latest.packetBytesIn, previous.packetBytesIn, secs);
                metricRow[7] = this.getRateString(latest.packetBytesOut, previous.packetBytesOut, secs);
            }
            bcp.add(metricRow);
        } else if (metricType == 2) {
            Object[] metricRow = new String[]{Integer.toString(latest.nConnections), Long.toString(latest.totalMemory), Long.toString(latest.freeMemory), Integer.toString(latest.threadsActive), Integer.toString(latest.threadsLowWater), Integer.toString(latest.threadsHighWater)};
            bcp.add(metricRow);
        }
    }

    private String getRateString(long latest, long previous, float secs) {
        String rateString = "";
        long diff = latest - previous;
        long rate = (long)((float)diff / secs);
        rateString = rate == 0L ? (diff != 0L ? "< 1" : "0") : Long.toString(rate);
        return rateString;
    }

    private String displayInKBytes(long l) {
        if (l == 0L) {
            return "0";
        }
        if (l < 1024L) {
            return "< 1";
        }
        return Long.toString(l / 1024L);
    }

    private void addOneDestMetricRow(int metricType, int destTypeMask, BrokerCmdPrinter bcp, DestMetricsCounters latestDest, DestMetricsCounters previousDest) {
        if (metricType == 0) {
            Object[] metricRow = new String[]{Integer.toString(latestDest.getMessagesIn()), Integer.toString(latestDest.getMessagesOut()), Long.toString(latestDest.getMessageBytesIn()), Long.toString(latestDest.getMessageBytesOut()), Integer.toString(latestDest.getCurrentMessages()), Integer.toString(latestDest.getHighWaterMessages()), Integer.toString(latestDest.getAverageMessages()), this.displayInKBytes(latestDest.getCurrentMessageBytes()), this.displayInKBytes(latestDest.getHighWaterMessageBytes()), this.displayInKBytes(latestDest.getAverageMessageBytes()), this.displayInKBytes(latestDest.getHighWaterLargestMsgBytes())};
            bcp.add(metricRow);
        } else if (metricType == 1) {
            Object[] metricRow = new String[11];
            if (previousDest == null) {
                metricRow[0] = "0";
                metricRow[1] = "0";
                metricRow[2] = "0";
                metricRow[3] = "0";
            } else {
                float secs = (float)(latestDest.timeStamp - previousDest.timeStamp) / 1000.0f;
                metricRow[0] = this.getRateString(latestDest.getMessagesIn(), previousDest.getMessagesIn(), secs);
                metricRow[1] = this.getRateString(latestDest.getMessagesOut(), previousDest.getMessagesOut(), secs);
                metricRow[2] = this.getRateString(latestDest.getMessageBytesIn(), previousDest.getMessageBytesIn(), secs);
                metricRow[3] = this.getRateString(latestDest.getMessageBytesOut(), previousDest.getMessageBytesOut(), secs);
            }
            metricRow[4] = Integer.toString(latestDest.getCurrentMessages());
            metricRow[5] = Integer.toString(latestDest.getHighWaterMessages());
            metricRow[6] = Integer.toString(latestDest.getAverageMessages());
            metricRow[7] = this.displayInKBytes(latestDest.getCurrentMessageBytes());
            metricRow[8] = this.displayInKBytes(latestDest.getHighWaterMessageBytes());
            metricRow[9] = this.displayInKBytes(latestDest.getAverageMessageBytes());
            metricRow[10] = this.displayInKBytes(latestDest.getHighWaterLargestMsgBytes());
            bcp.add(metricRow);
        } else if (metricType == 3) {
            if (DestType.isQueue((int)destTypeMask)) {
                Object[] metricRow = new String[]{Integer.toString(latestDest.getActiveConsumers()), Integer.toString(latestDest.getHWActiveConsumers()), Integer.toString(latestDest.getAvgActiveConsumers()), Integer.toString(latestDest.getFailoverConsumers()), Integer.toString(latestDest.getHWFailoverConsumers()), Integer.toString(latestDest.getAvgFailoverConsumers()), Integer.toString(latestDest.getCurrentMessages()), Integer.toString(latestDest.getHighWaterMessages()), Integer.toString(latestDest.getAverageMessages())};
                bcp.add(metricRow);
            } else {
                Object[] metricRow = new String[]{Integer.toString(latestDest.getActiveConsumers()), Integer.toString(latestDest.getHWActiveConsumers()), Integer.toString(latestDest.getAvgActiveConsumers()), Integer.toString(latestDest.getCurrentMessages()), Integer.toString(latestDest.getHighWaterMessages()), Integer.toString(latestDest.getAverageMessages())};
                bcp.add(metricRow);
            }
        } else if (metricType == 4) {
            Object[] metricRow = new String[]{Long.toString(latestDest.getDiskReserved()), Long.toString(latestDest.getDiskUsed()), Integer.toString(latestDest.getDiskUtilizationRatio())};
            bcp.add(metricRow);
        } else if (metricType == 5) {
            Object[] metricRow = new String[]{"0", "0", "0"};
            bcp.add(metricRow);
        }
    }

    private int runReload(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        BrokerAdmin broker = this.init();
        if (broker == null) {
            sb.append(this.ar.getString("A1229")).append("\n");
            return 1;
        }
        boolean force = brokerCmdProps.forceModeSet();
        if (!force) {
            broker = this.promptForAuthentication(broker);
        }
        sb.append(this.ar.getString("A1569")).append("\n");
        this.printBrokerInfo(broker);
        try {
            this.connectToBroker(broker);
            broker.sendReloadClusterMessage();
            broker.receiveReloadClusterReplyMessage();
            sb.append(this.ar.getString("A1571")).append("\n");
        }
        catch (BrokerAdminException bae) {
            this.handleBrokerAdminException(bae);
            sb.append(this.ar.getString("A1570")).append("\n");
            return 1;
        }
        return 0;
    }

    private int runCommit(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        block11: {
            Long tid = null;
            String yes = this.ar.getString("A5016");
            String yesShort = this.ar.getString("A5015");
            String no = this.ar.getString("A5018");
            String noShort = this.ar.getString("A5017");
            BrokerAdmin broker = this.init();
            if (broker == null) {
                sb.append(this.ar.getString("A1259")).append("\n");
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            sb.append(this.ar.getString("A1257")).append("\n");
            this.printTransactionInfo();
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            String tidStr = brokerCmdProps.getTargetName();
            try {
                tid = Long.valueOf(tidStr);
            }
            catch (NumberFormatException nfe) {
                sb.append(this.ar.getString("A3150", (Object)tidStr)).append("\n");
                sb.append(this.ar.getString("A1259")).append("\n");
                return 1;
            }
            try {
                this.connectToBroker(broker);
                String input = null;
                if (!force) {
                    input = this.getUserInput(this.ar.getString("A5033"), noShort);
                    sb.append("").append("\n");
                }
                if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                    try {
                        broker.sendCommitTxnMessage(tid);
                        broker.receiveCommitTxnReplyMessage();
                        sb.append(this.ar.getString("A1258")).append("\n");
                        break block11;
                    }
                    catch (BrokerAdminException bae) {
                        this.handleBrokerAdminException(bae);
                        sb.append(this.ar.getString("A1259")).append("\n");
                        return 1;
                    }
                }
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    sb.append(this.ar.getString("A1279")).append("\n");
                    return 0;
                }
                sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
                sb.append("").append("\n");
                sb.append(this.ar.getString("A1279")).append("\n");
                return 1;
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1259")).append("\n");
                return 1;
            }
        }
        return 0;
    }

    private int runRollback(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        block14: {
            Long tid = null;
            String yes = this.ar.getString("A5016");
            String yesShort = this.ar.getString("A5015");
            String no = this.ar.getString("A5018");
            String noShort = this.ar.getString("A5017");
            BrokerAdmin broker = this.init();
            if (broker == null) {
                sb.append(this.ar.getString("A1262")).append("\n");
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            sb.append(this.ar.getString("A1260")).append("\n");
            this.printTransactionInfo();
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            String tidStr = brokerCmdProps.getTargetName();
            try {
                tid = Long.valueOf(tidStr);
            }
            catch (NumberFormatException nfe) {
                sb.append(this.ar.getString("A3150", (Object)tidStr)).append("\n");
                sb.append(this.ar.getString("A1262")).append("\n");
                return 1;
            }
            try {
                Hashtable txnInfo = null;
                this.connectToBroker(broker);
                broker.sendGetTxnsMessage(tid);
                Vector txns = broker.receiveGetTxnsReplyMessage();
                if (txns != null && txns.size() == 1) {
                    Enumeration thisEnum = txns.elements();
                    txnInfo = (Hashtable)thisEnum.nextElement();
                    if (brokerCmdProps.debugModeSet()) {
                        this.printAllTxnAttrs(txnInfo);
                    }
                } else {
                    sb.append(this.ar.getString("A1335")).append("\n");
                    sb.append(this.ar.getString("A1262")).append("\n");
                    return 1;
                }
                Integer tmpInt = (Integer)txnInfo.get("state");
                String txnState = this.getTxnStateString(tmpInt);
                String input = null;
                if (!force) {
                    input = this.getUserInput(this.ar.getString("A5032", (Object)txnState), noShort);
                    sb.append("").append("\n");
                }
                if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                    try {
                        broker.sendRollbackTxnMessage(tid);
                        broker.receiveRollbackTxnReplyMessage();
                        sb.append(this.ar.getString("A1261")).append("\n");
                        break block14;
                    }
                    catch (BrokerAdminException bae) {
                        this.handleBrokerAdminException(bae);
                        sb.append(this.ar.getString("A1262")).append("\n");
                        return 1;
                    }
                }
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    sb.append(this.ar.getString("A1278")).append("\n");
                    return 0;
                }
                sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
                sb.append("").append("\n");
                sb.append(this.ar.getString("A1278")).append("\n");
                return 1;
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1262")).append("\n");
                return 1;
            }
        }
        return 0;
    }

    private int runCompact(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        String input = null;
        boolean compactAll = true;
        String yes = this.ar.getString("A5016");
        String yesShort = this.ar.getString("A5015");
        String no = this.ar.getString("A5018");
        String noShort = this.ar.getString("A5017");
        String commandArg = brokerCmdProps.getCommandArg();
        boolean force = brokerCmdProps.forceModeSet();
        BrokerAdmin broker = this.init();
        if ("dst".equals(commandArg)) {
            String destName = brokerCmdProps.getTargetName();
            int destTypeMask = this.getDestTypeMask(brokerCmdProps);
            if (destName != null) {
                compactAll = false;
            }
            if (broker == null) {
                if (compactAll) {
                    sb.append(this.ar.getString("A1306")).append("\n");
                } else {
                    sb.append(this.ar.getString("A1305")).append("\n");
                }
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            if (compactAll) {
                sb.append(this.ar.getString("A1302")).append("\n");
                this.printBrokerInfo(broker);
            } else {
                sb.append(this.ar.getString("A1301")).append("\n");
                this.printDestinationInfo();
                sb.append(this.ar.getString("A1200")).append("\n");
                this.printBrokerInfo(broker);
            }
            try {
                this.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                if (compactAll) {
                    sb.append(this.ar.getString("A1306")).append("\n");
                } else {
                    sb.append(this.ar.getString("A1305")).append("\n");
                }
                return 1;
            }
            if (!force) {
                input = compactAll ? this.getUserInput(this.ar.getString("A5024"), noShort) : this.getUserInput(this.ar.getString("A5023"), noShort);
                sb.append("").append("\n");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendCompactDestinationMessage(destName, destTypeMask);
                    broker.receiveCompactDestinationReplyMessage();
                    if (compactAll) {
                        sb.append(this.ar.getString("A1304")).append("\n");
                    }
                    sb.append(this.ar.getString("A1303")).append("\n");
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    if (compactAll) {
                        sb.append(this.ar.getString("A1306")).append("\n");
                    } else {
                        sb.append(this.ar.getString("A1305")).append("\n");
                    }
                    return 1;
                }
            } else {
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    if (compactAll) {
                        sb.append(this.ar.getString("A1308")).append("\n");
                    } else {
                        sb.append(this.ar.getString("A1307")).append("\n");
                    }
                    return 0;
                }
                sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
                sb.append("").append("\n");
                if (compactAll) {
                    sb.append(this.ar.getString("A1308")).append("\n");
                } else {
                    sb.append(this.ar.getString("A1307")).append("\n");
                }
                return 1;
            }
        }
        broker.close();
        return 0;
    }

    private int runQuiesce(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        String input = null;
        String yes = this.ar.getString("A5016");
        String yesShort = this.ar.getString("A5015");
        String no = this.ar.getString("A5018");
        String noShort = this.ar.getString("A5017");
        BrokerAdmin broker = this.init();
        boolean force = brokerCmdProps.forceModeSet();
        String commandArg = brokerCmdProps.getCommandArg();
        if ("bkr".equals(commandArg)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1701")).append("\n");
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            sb.append(this.ar.getString("A1700")).append("\n");
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1701")).append("\n");
                return 1;
            }
            if (!force) {
                input = this.getUserInput(this.ar.getString("A5027"), noShort);
                sb.append("").append("\n");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendQuiesceMessage();
                    broker.receiveQuiesceReplyMessage();
                    sb.append(this.ar.getString("A1702")).append("\n");
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    sb.append(this.ar.getString("A1701")).append("\n");
                    return 1;
                }
            } else {
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    sb.append(this.ar.getString("A1703")).append("\n");
                    return 0;
                }
                sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
                sb.append("").append("\n");
                sb.append(this.ar.getString("A1703")).append("\n");
                return 1;
            }
        }
        broker.close();
        return 0;
    }

    private int runUnquiesce(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        String input = null;
        String yes = this.ar.getString("A5016");
        String yesShort = this.ar.getString("A5015");
        String no = this.ar.getString("A5018");
        String noShort = this.ar.getString("A5017");
        BrokerAdmin broker = this.init();
        boolean force = brokerCmdProps.forceModeSet();
        String commandArg = brokerCmdProps.getCommandArg();
        if ("bkr".equals(commandArg)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1751")).append("\n");
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            sb.append(this.ar.getString("A1750")).append("\n");
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1751")).append("\n");
                return 1;
            }
            if (!force) {
                input = this.getUserInput(this.ar.getString("A5030"), noShort);
                sb.append("").append("\n");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendUnquiesceMessage();
                    broker.receiveUnquiesceReplyMessage();
                    sb.append(this.ar.getString("A1752")).append("\n");
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    sb.append(this.ar.getString("A1751")).append("\n");
                    return 1;
                }
            } else {
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    sb.append(this.ar.getString("A1753")).append("\n");
                    return 0;
                }
                sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
                sb.append("").append("\n");
                sb.append(this.ar.getString("A1753")).append("\n");
                return 1;
            }
        }
        broker.close();
        return 0;
    }

    private int runTakeover(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        String input = null;
        String yes = this.ar.getString("A5016");
        String yesShort = this.ar.getString("A5015");
        String no = this.ar.getString("A5018");
        String noShort = this.ar.getString("A5017");
        BrokerAdmin broker = this.init();
        boolean force = brokerCmdProps.forceModeSet();
        String commandArg = brokerCmdProps.getCommandArg();
        if ("bkr".equals(commandArg)) {
            String brokerID = brokerCmdProps.getTargetName();
            if (broker == null) {
                sb.append(this.ar.getString("A1705")).append("\n");
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            sb.append(this.ar.getString("A1704")).append("\n");
            sb.append(this.ar.getString("A1708")).append("\n");
            this.printBrokerInfo(broker);
            try {
                this.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1705")).append("\n");
                return 1;
            }
            try {
                broker.sendGetBrokerPropsMessage();
                Properties bkrProps = broker.receiveGetBrokerPropsReplyMessage();
                String value = bkrProps.getProperty("imq.cluster.ha");
                if (!Boolean.valueOf(value).booleanValue()) {
                    sb.append(this.ar.getString("A3171")).append("\n");
                    sb.append(this.ar.getString("A1705")).append("\n");
                    return 1;
                }
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1523")).append("\n");
                sb.append(this.ar.getString("A1705")).append("\n");
                return 1;
            }
            sb.append(this.ar.getString("A1769")).append("\n");
            BrokerCmdPrinter bcp = new BrokerCmdPrinter(5, 3, "-");
            Object[] row = new String[5];
            bcp.setSortNeeded(false);
            bcp.setTitleAlign(1);
            int i = 0;
            row[i++] = "";
            row[i++] = "";
            row[i++] = "";
            row[i++] = "";
            int n = i++;
            row[n] = this.ar.getString("A1721");
            bcp.addTitle((String[])row);
            i = 0;
            int n2 = i++;
            row[n2] = this.ar.getString("A1716");
            int n3 = i++;
            row[n3] = this.ar.getString("A1717");
            int n4 = i++;
            row[n4] = this.ar.getString("A1718");
            int n5 = i++;
            row[n5] = this.ar.getString("A1719");
            int n6 = i++;
            row[n6] = this.ar.getString("A1737");
            bcp.addTitle((String[])row);
            Vector bkrList = null;
            try {
                broker.sendGetClusterMessage(true);
                bkrList = broker.receiveGetClusterReplyMessage();
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A3169")).append("\n");
                sb.append(this.ar.getString("A1705")).append("\n");
                return 1;
            }
            String brokerIDFromList = null;
            boolean found = false;
            Enumeration thisEnum = bkrList.elements();
            while (thisEnum.hasMoreElements()) {
                Hashtable bkrClsInfo = (Hashtable)thisEnum.nextElement();
                brokerIDFromList = (String)bkrClsInfo.get("ID");
                if (brokerIDFromList == null || !brokerIDFromList.equals(brokerID)) continue;
                found = true;
                i = 0;
                row[i++] = this.checkNullAndPrint(brokerIDFromList);
                row[i++] = this.checkNullAndPrint(bkrClsInfo.get("Address"));
                Integer tmpInt = (Integer)bkrClsInfo.get("State");
                row[i++] = tmpInt != null ? BrokerState.toString((int)tmpInt) : "";
                Long tmpLong = (Long)bkrClsInfo.get("NumMsgs");
                row[i++] = this.checkNullAndPrint(tmpLong);
                tmpLong = (Long)bkrClsInfo.get("StatusTimestamp");
                if (tmpLong != null) {
                    long idle = System.currentTimeMillis() - tmpLong;
                    row[i++] = this.getTimeString(idle);
                } else {
                    row[i++] = "";
                }
                bcp.add(row);
                break;
            }
            if (!found) {
                sb.append(this.ar.getString("A3170", (Object)brokerID)).append("\n");
                sb.append(this.ar.getString("A1705")).append("\n");
                return 1;
            }
            bcp.println();
            if (!force) {
                input = this.getUserInput(this.ar.getString("A5028"), noShort);
                sb.append("").append("\n");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendTakeoverMessage(brokerID);
                    broker.receiveTakeoverReplyMessage();
                    sb.append(this.ar.getString("A1706")).append("\n");
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    sb.append(this.ar.getString("A1705")).append("\n");
                    return 1;
                }
            } else {
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    sb.append(this.ar.getString("A1707")).append("\n");
                    return 0;
                }
                sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
                sb.append("").append("\n");
                sb.append(this.ar.getString("A1707")).append("\n");
                return 1;
            }
        }
        broker.close();
        return 0;
    }

    private int runExists(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        int retValue = 1;
        BrokerAdmin broker = this.init();
        String commandArg = brokerCmdProps.getCommandArg();
        if ("dst".equals(commandArg)) {
            if (broker == null) {
                sb.append("Problems connecting to the broker.").append("\n");
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String destName = brokerCmdProps.getTargetName();
            int destTypeMask = this.getDestTypeMask(brokerCmdProps);
            try {
                this.connectToBroker(broker);
                broker.sendGetDestinationsMessage(destName, destTypeMask);
                Vector dest = broker.receiveGetDestinationsReplyMessage();
                if (dest == null || dest.size() != 1) {
                    sb.append("Problems retrieving the destination info.").append("\n");
                    return 1;
                }
                sb.append(Boolean.TRUE.toString()).append("\n");
                retValue = 0;
            }
            catch (BrokerAdminException bae) {
                if (bae.getReplyStatus() == 404) {
                    sb.append(Boolean.FALSE.toString()).append("\n");
                    retValue = 0;
                }
                this.handleBrokerAdminException(bae);
                return 1;
            }
        }
        return retValue;
    }

    private int runGetAttr(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        int retValue = 1;
        BrokerAdmin broker = this.init();
        String commandArg = brokerCmdProps.getCommandArg();
        if ("dst".equals(commandArg)) {
            block46: {
                if (broker == null) {
                    sb.append("Problems connecting to the broker.").append("\n");
                    return 1;
                }
                boolean force = brokerCmdProps.forceModeSet();
                if (!force) {
                    broker = this.promptForAuthentication(broker);
                }
                String destName = brokerCmdProps.getTargetName();
                int destTypeMask = this.getDestTypeMask(brokerCmdProps);
                String attrName = brokerCmdProps.getSingleTargetAttr();
                try {
                    this.connectToBroker(broker);
                    broker.sendGetDestinationsMessage(destName, destTypeMask);
                    Vector dest = broker.receiveGetDestinationsReplyMessage();
                    if (dest != null && dest.size() == 1) {
                        Enumeration thisEnum = dest.elements();
                        DestinationInfo dInfo = (DestinationInfo)thisEnum.nextElement();
                        if ("maxTotalMsgBytes".equals(attrName)) {
                            sb.append(Long.toString(dInfo.maxMessageBytes)).append("\n");
                            retValue = 0;
                            break block46;
                        }
                        if ("maxNumMsgs".equals(attrName)) {
                            sb.append(Integer.toString(dInfo.maxMessages)).append("\n");
                            retValue = 0;
                            break block46;
                        }
                        if ("maxBytesPerMsg".equals(attrName)) {
                            sb.append(Long.toString(dInfo.maxMessageSize)).append("\n");
                            retValue = 0;
                            break block46;
                        }
                        if ("curTotalMsgBytes".equals(attrName)) {
                            sb.append(Long.toString(dInfo.nMessageBytes)).append("\n");
                            retValue = 0;
                            break block46;
                        }
                        if ("curNumMsgs".equals(attrName)) {
                            sb.append(Integer.toString(dInfo.nMessages)).append("\n");
                            retValue = 0;
                            break block46;
                        }
                        if ("curNumProducers".equals(attrName)) {
                            sb.append(Integer.toString(dInfo.nProducers)).append("\n");
                            retValue = 0;
                            break block46;
                        }
                        if ("maxNumBackupConsumers".equals(attrName)) {
                            sb.append(Integer.toString(dInfo.maxFailoverConsumers)).append("\n");
                            retValue = 0;
                            break block46;
                        }
                        if ("maxNumActiveConsumers".equals(attrName)) {
                            sb.append(Integer.toString(dInfo.maxActiveConsumers)).append("\n");
                            retValue = 0;
                            break block46;
                        }
                        if ("isLocalOnly".equals(attrName)) {
                            if (dInfo.isDestinationLocal()) {
                                sb.append(Boolean.TRUE.toString()).append("\n");
                            } else {
                                sb.append(Boolean.FALSE.toString()).append("\n");
                            }
                            retValue = 0;
                            break block46;
                        }
                        if ("limitBehavior".equals(attrName)) {
                            sb.append(DestLimitBehavior.getString((int)dInfo.destLimitBehavior)).append("\n");
                            retValue = 0;
                            break block46;
                        }
                        if ("localDeliveryPreferred".equals(attrName)) {
                            int cdp = dInfo.destCDP;
                            if (cdp == 1) {
                                sb.append(Boolean.TRUE.toString()).append("\n");
                            } else {
                                sb.append(Boolean.FALSE.toString()).append("\n");
                            }
                            retValue = 0;
                            break block46;
                        }
                        if ("consumerFlowLimit".equals(attrName)) {
                            sb.append(Integer.toString(dInfo.maxPrefetch)).append("\n");
                            retValue = 0;
                            break block46;
                        }
                        if ("maxNumProducers".equals(attrName)) {
                            sb.append(Integer.toString(dInfo.maxProducers)).append("\n");
                            retValue = 0;
                            break block46;
                        }
                        if ("curNumActiveConsumers".equals(attrName)) {
                            if (DestType.isQueue((int)destTypeMask)) {
                                sb.append(Integer.toString(dInfo.naConsumers)).append("\n");
                            } else {
                                sb.append(Integer.toString(dInfo.nConsumers)).append("\n");
                            }
                            retValue = 0;
                            break block46;
                        }
                        if ("curNumBackupConsumers".equals(attrName)) {
                            sb.append(Integer.toString(dInfo.nfConsumers)).append("\n");
                            retValue = 0;
                            break block46;
                        }
                        if ("useDMQ".equals(attrName)) {
                            sb.append(Boolean.toString(dInfo.useDMQ())).append("\n");
                            retValue = 0;
                            break block46;
                        }
                        if ("validateXMLSchemaEnabled".equals(attrName)) {
                            sb.append(Boolean.toString(dInfo.validateXMLSchemaEnabled())).append("\n");
                            retValue = 0;
                            break block46;
                        }
                        if ("XMLSchemaURIList".equals(attrName)) {
                            sb.append(dInfo.XMLSchemaUriList).append("\n");
                            retValue = 0;
                            break block46;
                        }
                        if ("reloadXMLSchemaOnFailure".equals(attrName)) {
                            sb.append(Boolean.toString(dInfo.reloadXMLSchemaOnFailure())).append("\n");
                            retValue = 0;
                            break block46;
                        }
                        sb.append(attrName + " is not recognized.").append("\n");
                        return 1;
                    }
                    sb.append("Problems retrieving the destination info.").append("\n");
                    return 1;
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    return 1;
                }
            }
            return retValue;
        }
        if ("svc".equals(commandArg)) {
            block47: {
                if (broker == null) {
                    sb.append("Problems connecting to the broker.").append("\n");
                    return 1;
                }
                boolean force = brokerCmdProps.forceModeSet();
                if (!force) {
                    broker = this.promptForAuthentication(broker);
                }
                String svcName = brokerCmdProps.getTargetName();
                String attrName = brokerCmdProps.getSingleTargetAttr();
                try {
                    this.connectToBroker(broker);
                    broker.sendGetServicesMessage(svcName);
                    Vector svc = broker.receiveGetServicesReplyMessage();
                    if (svc != null && svc.size() == 1) {
                        Enumeration thisEnum = svc.elements();
                        ServiceInfo sInfo = (ServiceInfo)thisEnum.nextElement();
                        if ("port".equals(attrName)) {
                            sb.append(Integer.toString(sInfo.port)).append("\n");
                            retValue = 0;
                            break block47;
                        }
                        if ("minThreads".equals(attrName)) {
                            sb.append(Integer.toString(sInfo.minThreads)).append("\n");
                            retValue = 0;
                            break block47;
                        }
                        if ("maxThreads".equals(attrName)) {
                            sb.append(Integer.toString(sInfo.maxThreads)).append("\n");
                            retValue = 0;
                            break block47;
                        }
                        sb.append(attrName + " is not recognized.").append("\n");
                        return 1;
                    }
                    sb.append("Problems retrieving the service info.").append("\n");
                    return 1;
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    return 1;
                }
            }
            return retValue;
        }
        if ("bkr".equals(commandArg)) {
            if (broker == null) {
                sb.append("Problems connecting to the broker.").append("\n");
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String attrName = brokerCmdProps.getSingleTargetAttr();
            try {
                this.connectToBroker(broker);
                broker.sendGetBrokerPropsMessage();
                Properties bkrProps = broker.receiveGetBrokerPropsReplyMessage();
                if (bkrProps == null) {
                    sb.append("Problems retrieving the broker info.").append("\n");
                    return 1;
                }
                String value = bkrProps.getProperty(attrName, "");
                sb.append(value).append("\n");
                retValue = 0;
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                return 1;
            }
        }
        return retValue;
    }

    private int runUngracefulKill(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        BrokerAdmin broker = this.init();
        if (broker == null) {
            sb.append("Problems connecting to the broker.").append("\n");
            return 1;
        }
        boolean force = brokerCmdProps.forceModeSet();
        if (!force) {
            broker = this.promptForAuthentication(broker);
        }
        try {
            this.connectToBroker(broker);
            broker.sendShutdownMessage(false, true);
            sb.append("Ungracefully shutdown the broker.").append("\n");
            return 0;
        }
        catch (BrokerAdminException bae) {
            this.handleBrokerAdminException(bae);
            return 1;
        }
    }

    private int runDebug(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        Hashtable debugHash = null;
        Properties optionalProps = null;
        BrokerAdmin broker = this.init();
        if (broker == null) {
            sb.append("Problems connecting to the broker.").append("\n");
            return 1;
        }
        boolean force = brokerCmdProps.forceModeSet();
        if (!force) {
            broker = this.promptForAuthentication(broker);
        }
        String cmd = brokerCmdProps.getCommand();
        String cmdarg = brokerCmdProps.getCommandArg();
        String target = brokerCmdProps.getTargetName();
        String targetType = brokerCmdProps.getDestType();
        optionalProps = brokerCmdProps.getTargetAttrs();
        sb.append("Sending the following DEBUG message:").append("\n");
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(2, 4, "-", 0, false);
        Object[] row = new String[]{"Header Property Name", "Value"};
        bcp.addTitle((String[])row);
        row[0] = "JMQCommand";
        row[1] = cmd;
        bcp.add(row);
        row[0] = "JMQCommandArg";
        row[1] = cmdarg;
        bcp.add(row);
        if (target != null) {
            row[0] = "JMQTarget";
            row[1] = target;
            bcp.add(row);
        }
        if (targetType != null) {
            row[0] = "JMQTargetType";
            row[1] = targetType;
            bcp.add(row);
        }
        bcp.println();
        if (optionalProps != null && optionalProps.size() > 0) {
            sb.append("Optional properties:").append("\n");
            this.printAttrs(optionalProps, true);
        }
        sb.append("To the broker specified by:").append("\n");
        this.printBrokerInfo(broker);
        try {
            this.connectToBroker(broker);
            broker.sendDebugMessage(cmd, cmdarg, target, targetType, optionalProps);
            debugHash = broker.receiveDebugReplyMessage();
            if (debugHash != null && debugHash.size() > 0) {
                sb.append("Data received back from broker:").append("\n");
                this.printDebugHash(debugHash);
            } else {
                sb.append("No additional data received back from broker.\n").append("\n");
            }
            sb.append("DEBUG message sent successfully.").append("\n");
            return 0;
        }
        catch (BrokerAdminException bae) {
            this.handleBrokerAdminException(bae);
            return 1;
        }
    }

    private void printDebugHash(Hashtable hash) {
        DebugPrinter dbp = new DebugPrinter(hash, 4);
        dbp.println();
    }

    private void printAllBrokerAttrs(Properties bkrProps) {
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(2, 4);
        Object[] row = new String[2];
        Enumeration<?> e = bkrProps.propertyNames();
        while (e.hasMoreElements()) {
            String curPropName;
            row[0] = curPropName = (String)e.nextElement();
            row[1] = bkrProps.getProperty(curPropName, "");
            bcp.add(row);
        }
        bcp.println();
    }

    private void printDisplayableBrokerAttrs(Properties bkrProps) {
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(2, 4);
        Object[] row = new String[2];
        bcp.setSortNeeded(false);
        row[0] = this.ar.getString("A1626");
        String value = bkrProps.getProperty("imq.product.version", "");
        if (value.equals("")) {
            value = this.ar.getString("A1627");
        }
        row[1] = value;
        bcp.add(row);
        row[0] = this.ar.getString("A1525");
        value = bkrProps.getProperty("imq.instancename", "");
        row[1] = value;
        bcp.add(row);
        row[0] = this.ar.getString("A1711");
        value = bkrProps.getProperty("imq.brokerid", "");
        row[1] = value;
        bcp.add(row);
        row[0] = this.ar.getString("A1441");
        value = bkrProps.getProperty("imq.portmapper.port", "");
        row[1] = value;
        bcp.add(row);
        row[0] = this.ar.getString("A1733");
        value = bkrProps.getProperty("imq.embedded", "");
        row[1] = value;
        bcp.add(row);
        row[0] = this.ar.getString("A1763");
        value = bkrProps.getProperty("imq.varhome", "");
        row[1] = value;
        bcp.add(row);
        row[0] = "";
        row[1] = "";
        bcp.add(row);
        row[0] = this.ar.getString("A1628");
        value = bkrProps.getProperty("imq.system.current_count", "");
        row[1] = value;
        bcp.add(row);
        row[0] = this.ar.getString("A1629");
        value = bkrProps.getProperty("imq.system.current_size", "");
        row[1] = value;
        bcp.add(row);
        row[0] = "";
        row[1] = "";
        bcp.add(row);
        row[0] = this.ar.getString("A1684");
        value = bkrProps.getProperty("imq.dmq.current_count", "");
        row[1] = value;
        bcp.add(row);
        row[0] = this.ar.getString("A1685");
        value = bkrProps.getProperty("imq.dmq.current_size", "");
        row[1] = value;
        bcp.add(row);
        row[0] = "";
        row[1] = "";
        bcp.add(row);
        row[0] = this.ar.getString("A1683");
        value = bkrProps.getProperty("imq.destination.logDeadMsgs", "");
        row[1] = value;
        bcp.add(row);
        row[0] = this.ar.getString("A1686");
        value = bkrProps.getProperty("imq.destination.DMQ.truncateBody", "");
        row[1] = value;
        bcp.add(row);
        row[0] = "";
        row[1] = "";
        bcp.add(row);
        row[0] = this.ar.getString("A1534");
        value = bkrProps.getProperty("imq.system.max_count", "");
        row[1] = this.checkAndPrintUnlimited(value, this.zeroNegOneString);
        bcp.add(row);
        row[0] = this.ar.getString("A1535");
        value = bkrProps.getProperty("imq.system.max_size", "");
        row[1] = this.checkAndPrintUnlimitedBytes(value, this.zeroNegOneLong);
        bcp.add(row);
        row[0] = this.ar.getString("A1536");
        value = bkrProps.getProperty("imq.message.max_size", "");
        row[1] = this.checkAndPrintUnlimitedBytes(value, this.zeroNegOneLong);
        bcp.add(row);
        row[0] = "";
        row[1] = "";
        bcp.add(row);
        row[0] = this.ar.getString("A1527");
        value = bkrProps.getProperty("imq.autocreate.queue", "");
        row[1] = value;
        bcp.add(row);
        row[0] = this.ar.getString("A1526");
        value = bkrProps.getProperty("imq.autocreate.topic", "");
        row[1] = value;
        bcp.add(row);
        row[0] = this.ar.getString("A1654");
        value = bkrProps.getProperty("imq.autocreate.queue.maxNumActiveConsumers", "");
        row[1] = this.checkAndPrintUnlimited(value, this.negOneString);
        bcp.add(row);
        row[0] = this.ar.getString("A1655");
        value = bkrProps.getProperty("imq.autocreate.queue.maxNumBackupConsumers", "");
        row[1] = this.checkAndPrintUnlimited(value, this.negOneString);
        bcp.add(row);
        row[0] = "";
        row[1] = "";
        bcp.add(row);
        row[0] = this.ar.getString("A1709");
        value = bkrProps.getProperty("imq.cluster.clusterid", "");
        row[1] = value;
        bcp.add(row);
        row[0] = this.ar.getString("A1710");
        value = bkrProps.getProperty("imq.cluster.ha");
        row[1] = Boolean.valueOf(value).toString();
        bcp.add(row);
        row[0] = this.ar.getString("A1573");
        value = bkrProps.getProperty("imq.cluster.brokerlist.active", "");
        row[1] = value;
        bcp.add(row);
        row[0] = this.ar.getString("A1572");
        value = bkrProps.getProperty("imq.cluster.brokerlist", "");
        row[1] = value;
        bcp.add(row);
        row[0] = this.ar.getString("A1574");
        value = bkrProps.getProperty("imq.cluster.masterbroker", "");
        row[1] = value;
        bcp.add(row);
        row[0] = this.ar.getString("A1575");
        value = bkrProps.getProperty("imq.cluster.url", "");
        row[1] = value;
        bcp.add(row);
        row[0] = "";
        row[1] = "";
        bcp.add(row);
        row[0] = this.ar.getString("A1528");
        value = bkrProps.getProperty("imq.log.level", "");
        row[1] = value;
        bcp.add(row);
        row[0] = this.ar.getString("A1530");
        value = bkrProps.getProperty("imq.log.file.rolloversecs", "");
        row[1] = this.checkAndPrintUnlimited(value, this.zeroNegOneString);
        bcp.add(row);
        row[0] = this.ar.getString("A1529");
        value = bkrProps.getProperty("imq.log.file.rolloverbytes", "");
        row[1] = this.checkAndPrintUnlimitedBytes(value, this.zeroNegOneLong);
        bcp.add(row);
        bcp.println();
    }

    private void printAllTxnAttrs(Hashtable txnInfo) {
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(2, 4);
        Object[] row = new String[2];
        Enumeration e = txnInfo.keys();
        while (e.hasMoreElements()) {
            String curPropName;
            row[0] = curPropName = (String)e.nextElement();
            Object tmpObj = txnInfo.get(curPropName);
            row[1] = tmpObj.toString();
            bcp.add(row);
        }
        bcp.println();
    }

    private void printDisplayableTxnAttrs(Hashtable txnInfo) {
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(2, 4);
        Object[] row = new String[2];
        row[0] = this.ar.getString("A1263");
        Long tmpLong = (Long)txnInfo.get("txnid");
        row[1] = this.checkNullAndPrint(tmpLong);
        bcp.add(row);
        row[0] = this.ar.getString("A1269");
        Integer tmpInt = (Integer)txnInfo.get("state");
        row[1] = this.getTxnStateString(tmpInt);
        bcp.add(row);
        row[0] = this.ar.getString("A1268");
        tmpInt = (Integer)txnInfo.get("nmsgs");
        row[1] = this.checkNullAndPrint(tmpInt);
        bcp.add(row);
        row[0] = this.ar.getString("A1267");
        tmpInt = (Integer)txnInfo.get("nacks");
        row[1] = this.checkNullAndPrint(tmpInt);
        bcp.add(row);
        row[0] = this.ar.getString("A1264");
        String tmpStr = (String)txnInfo.get("clientid");
        row[1] = this.checkNullAndPrint(tmpStr);
        bcp.add(row);
        row[0] = this.ar.getString("A1266");
        tmpLong = (Long)txnInfo.get("timestamp");
        row[1] = this.checkNullAndPrintTimestamp(tmpLong);
        bcp.add(row);
        row[0] = this.ar.getString("A1265");
        tmpStr = (String)txnInfo.get("connection");
        row[1] = this.checkNullAndPrint(tmpStr);
        bcp.add(row);
        row[0] = this.ar.getString("A1277");
        tmpLong = (Long)txnInfo.get("connectionid");
        row[1] = this.checkNullAndPrint(tmpLong);
        bcp.add(row);
        row[0] = this.ar.getString("A1270");
        tmpStr = (String)txnInfo.get("user");
        row[1] = this.checkNullAndPrint(tmpStr);
        bcp.add(row);
        row[0] = this.ar.getString("A1271");
        tmpStr = (String)txnInfo.get("xid");
        row[1] = this.checkNullAndPrint(tmpStr);
        bcp.add(row);
        bcp.println();
    }

    private void printAllCxnAttrs(Hashtable cxnInfo) {
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(2, 4);
        Object[] row = new String[2];
        Enumeration e = cxnInfo.keys();
        while (e.hasMoreElements()) {
            String curPropName;
            row[0] = curPropName = (String)e.nextElement();
            Object tmpObj = cxnInfo.get(curPropName);
            row[1] = tmpObj.toString();
            bcp.add(row);
        }
        bcp.println();
    }

    private void printDisplayableCxnAttrs(Hashtable cxnInfo) {
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(2, 4);
        Object[] row = new String[2];
        bcp.setSortNeeded(false);
        row[0] = this.ar.getString("A1323");
        Long tmpLong = (Long)cxnInfo.get("cxnid");
        row[1] = this.checkNullAndPrint(tmpLong);
        bcp.add(row);
        row[0] = this.ar.getString("A1327");
        String tmpStr = (String)cxnInfo.get("user");
        row[1] = this.checkNullAndPrint(tmpStr);
        bcp.add(row);
        row[0] = this.ar.getString("A1331");
        tmpStr = (String)cxnInfo.get("service");
        row[1] = this.checkNullAndPrint(tmpStr);
        bcp.add(row);
        row[0] = this.ar.getString("A1328");
        Integer tmpInt = (Integer)cxnInfo.get("nproducers");
        row[1] = this.checkNullAndPrint(tmpInt);
        bcp.add(row);
        row[0] = this.ar.getString("A1329");
        tmpInt = (Integer)cxnInfo.get("nconsumers");
        row[1] = this.checkNullAndPrint(tmpInt);
        bcp.add(row);
        row[0] = this.ar.getString("A1325");
        tmpStr = (String)cxnInfo.get("host");
        row[1] = this.checkNullAndPrint(tmpStr);
        bcp.add(row);
        row[0] = this.ar.getString("A1326");
        tmpInt = (Integer)cxnInfo.get("port");
        row[1] = this.checkNullAndPrint(tmpInt);
        bcp.add(row);
        row[0] = this.ar.getString("A1324");
        tmpStr = (String)cxnInfo.get("clientid");
        row[1] = this.checkNullAndPrint(tmpStr);
        bcp.add(row);
        row[0] = this.ar.getString("A1330");
        tmpStr = (String)cxnInfo.get("clientplatform");
        row[1] = this.checkNullAndPrint(tmpStr);
        bcp.add(row);
        bcp.println();
    }

    private void printDisplayableMsgAttrs(HashMap oneMsg) {
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(2, 4);
        BrokerCmdPrinter titleBcp = new BrokerCmdPrinter(1, 0, "-");
        Object[] row = new String[2];
        String[] titleRow = new String[1];
        bcp.setSortNeeded(false);
        titleRow[0] = "Message Header Information";
        titleBcp.addTitle(titleRow);
        titleBcp.print();
        row[0] = "Message ID";
        row[1] = this.checkNullAndPrint(oneMsg.get("MessageID"));
        bcp.add(row);
        row[0] = "Correlation ID";
        row[1] = this.checkNullAndPrint(oneMsg.get("CorrelationID"));
        bcp.add(row);
        row[0] = "Destination Name";
        row[1] = this.checkNullAndPrint(oneMsg.get("DestinationName"));
        bcp.add(row);
        row[0] = "Destination Type";
        Integer tmpInt = (Integer)oneMsg.get("DestinationType");
        row[1] = BrokerAdminUtil.getDestinationType((int)tmpInt);
        bcp.add(row);
        row[0] = "Delivery Mode";
        tmpInt = (Integer)oneMsg.get("DeliveryMode");
        row[1] = this.checkNullAndPrintDeliveryMode(tmpInt);
        bcp.add(row);
        row[0] = "Priority";
        row[1] = this.checkNullAndPrint(oneMsg.get("Priority"));
        bcp.add(row);
        row[0] = "Redelivered";
        row[1] = this.checkNullAndPrint(oneMsg.get("Redelivered"));
        bcp.add(row);
        row[0] = "Timestamp";
        row[1] = this.checkNullAndPrintTimestamp((Long)oneMsg.get("Timestamp"));
        bcp.add(row);
        row[0] = "Type";
        row[1] = this.checkNullAndPrint((String)oneMsg.get("Type"));
        bcp.add(row);
        row[0] = "Expiration";
        row[1] = this.checkNullAndPrintTimestamp((Long)oneMsg.get("Expiration"));
        bcp.add(row);
        row[0] = "ReplyTo Destination Name";
        row[1] = this.checkNullAndPrint(oneMsg.get("ReplyToDestinationName"));
        bcp.add(row);
        row[0] = "ReplyTo Destination Type";
        tmpInt = (Integer)oneMsg.get("ReplyToDestinationType");
        row[1] = tmpInt != null ? BrokerAdminUtil.getDestinationType((int)tmpInt) : "";
        bcp.add(row);
        bcp.println();
        titleBcp.clear();
        titleBcp.clearTitle();
        titleRow[0] = "Message Properties Information";
        titleBcp.addTitle(titleRow);
        titleBcp.print();
        Hashtable props = (Hashtable)oneMsg.get("MessageProperties");
        if (props != null) {
            Enumeration keys = props.keys();
            bcp.clear();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                Object val = props.get(key);
                row[0] = key;
                row[1] = val.toString();
                bcp.add(row);
            }
            bcp.println();
        } else {
            Globals.stdOutPrintln((String)"");
        }
        titleBcp.clear();
        titleBcp.clearTitle();
        titleRow[0] = "Message Body Information";
        titleBcp.addTitle(titleRow);
        titleBcp.print();
        bcp.clear();
        row[0] = "Body Type";
        row[1] = this.checkNullAndPrintMsgBodyType((Integer)oneMsg.get("MessageBodyType"), true);
        bcp.add(row);
        bcp.println();
    }

    private int getDestTypeMask(BrokerCmdProperties brokerCmdProps) {
        Properties props = brokerCmdProps.getTargetAttrs();
        String destType = brokerCmdProps.getDestType();
        int mask = 0;
        if (destType == null || destType.equals("")) {
            return -1;
        }
        if (destType.equals("t")) {
            mask = 2;
        } else if (destType.equals("q")) {
            mask = 1;
        }
        if (props == null || props.isEmpty()) {
            return mask;
        }
        String flavour = props.getProperty("queueDeliveryPolicy");
        if (flavour == null) {
            return mask;
        }
        if (flavour.equals("s")) {
            mask |= 0x100;
        } else if (flavour.equals("f")) {
            mask |= 0x400;
        } else if (flavour.equals("r")) {
            mask |= 0x200;
        }
        return mask;
    }

    private BrokerAdmin init() {
        BrokerAdmin broker;
        String brokerHostPort = this.brokerCmdProps.getBrokerHostPort();
        String brokerHostName = this.getBrokerHost(brokerHostPort);
        String adminUser = this.brokerCmdProps.getAdminUserId();
        int brokerPort = -1;
        int numRetries = this.brokerCmdProps.getNumRetries();
        int receiveTimeout = this.brokerCmdProps.getReceiveTimeout();
        boolean adminKeyUsed = this.brokerCmdProps.isAdminKeyUsed();
        boolean useSSL = this.brokerCmdProps.useSSLTransportSet();
        if (this.brokerCmdProps.adminDebugModeSet()) {
            BrokerAdmin.setDebug((boolean)true);
        }
        try {
            String adminPasswd = this.getPasswordFromFileOrCmdLine(this.brokerCmdProps);
            broker = new BrokerAdmin(brokerHostPort, adminUser, adminPasswd, receiveTimeout * 1000, useSSL);
            if (adminKeyUsed) {
                broker.setAdminKeyUsed(true);
            }
            if (useSSL) {
                broker.setSSLTransportUsed(true);
            }
            if (numRetries > 0) {
                broker.setNumRetries(numRetries);
            }
        }
        catch (BrokerCmdException bce) {
            this.handleBrokerCmdException(bce);
            return null;
        }
        catch (BrokerAdminException bae) {
            this.handleBrokerAdminException(bae);
            return null;
        }
        broker.addAdminEventListener((AdminEventListener)this);
        return broker;
    }

    private String getBrokerHost(String brokerHostPort) {
        String host = brokerHostPort;
        if (brokerHostPort == null) {
            return null;
        }
        int i = brokerHostPort.indexOf(58);
        if (i >= 0) {
            host = brokerHostPort.substring(0, i);
        }
        if (host == null || host.equals("")) {
            return null;
        }
        return host;
    }

    private int getBrokerPort(String brokerHostPort) throws BrokerAdminException {
        int port = -1;
        if (brokerHostPort == null) {
            return port;
        }
        int i = brokerHostPort.indexOf(58);
        if (i >= 0) {
            try {
                port = Integer.parseInt(brokerHostPort.substring(i + 1));
            }
            catch (Exception e) {
                throw new BrokerAdminException(8);
            }
        }
        return port;
    }

    private void connectToBroker(BrokerAdmin broker) throws BrokerAdminException {
        if (!broker.isConnected()) {
            broker.connect();
            broker.sendHelloMessage();
            broker.receiveHelloReplyMessage();
        }
    }

    private void handleBrokerAdminException(BrokerAdminException bae) {
        Exception e = bae.getLinkedException();
        int type = bae.getType();
        switch (type) {
            case 0: {
                Globals.stdErrPrintln((String)this.ar.getString("A3120", (Object)bae.getBrokerHost(), (Object)bae.getBrokerPort()));
                this.printBrokerAdminExceptionDetails(bae);
                Globals.stdErrPrintln((String)this.ar.getString("A3139", (Object)"-b"));
                break;
            }
            case 1: {
                Globals.stdErrPrintln((String)this.ar.getString("A3121"));
                this.printBrokerAdminExceptionDetails(bae);
                break;
            }
            case 2: {
                Globals.stdErrPrintln((String)this.ar.getString("A3122"));
                this.printBrokerAdminExceptionDetails(bae);
                break;
            }
            case 3: {
                Globals.stdErrPrintln((String)this.ar.getString("A3123"));
                this.printBrokerAdminExceptionDetails(bae);
                break;
            }
            case 4: {
                Globals.stdErrPrintln((String)this.ar.getString("A3124"));
                this.printBrokerAdminExceptionDetails(bae);
                break;
            }
            case 5: {
                Globals.stdErrPrintln((String)this.ar.getString("A3125"));
                this.printBrokerAdminExceptionDetails(bae);
                break;
            }
            case 6: {
                Globals.stdErrPrintln((String)this.ar.getString("A3126"));
                this.printBrokerAdminExceptionDetails(bae);
                break;
            }
            case 7: {
                Globals.stdErrPrintln((String)this.ar.getString("A3127"));
                this.printBrokerAdminExceptionDetails(bae);
                break;
            }
            case 8: {
                Globals.stdErrPrintln((String)this.ar.getString("A1001"), (String)this.ar.getKString("A3128"));
                break;
            }
            case 11: {
                Globals.stdErrPrintln((String)this.ar.getString("A3120", (Object)bae.getBrokerHost(), (Object)bae.getBrokerPort()));
                this.printBrokerAdminExceptionDetails(bae);
                Globals.stdErrPrintln((String)this.ar.getString("A3140"));
                break;
            }
            case 12: {
                Globals.stdErrPrintln((String)this.ar.getString("A3120", (Object)bae.getBrokerHost(), (Object)bae.getBrokerPort()));
                this.printBrokerAdminExceptionDetails(bae);
                Globals.stdErrPrintln((String)this.ar.getString("A3141"));
                break;
            }
            case 15: {
                Globals.stdErrPrintln((String)this.ar.getString("A3120", (Object)bae.getBrokerHost(), (Object)bae.getBrokerPort()));
                this.printBrokerAdminExceptionDetails(bae);
                Globals.stdErrPrintln((String)this.ar.getString("A3154"));
                break;
            }
            case 16: {
                Globals.stdErrPrintln((String)this.ar.getString("A1001"), (String)this.ar.getKString("A3167", (Object)bae.getBrokerAddress()));
            }
        }
    }

    private void printBrokerAdminExceptionDetails(BrokerAdminException bae) {
        Exception e = bae.getLinkedException();
        String s = bae.getBrokerErrorStr();
        if (s != null) {
            Globals.stdErrPrintln((String)s);
        }
        if (e != null) {
            String msg = e.getMessage();
            String s2 = e.toString();
            if (s2 != null) {
                Globals.stdErrPrintln((String)s2);
            } else if (msg != null) {
                Globals.stdErrPrintln((String)msg);
            }
            if (this.brokerCmdProps.debugModeSet()) {
                e.printStackTrace(System.err);
            }
        }
    }

    private void handleBrokerCmdException(BrokerCmdException bce) {
        Exception ex = bce.getLinkedException();
        BrokerCmdProperties brokerCmdProps = bce.getProperties();
        int type = bce.getType();
        switch (type) {
            case 34: {
                Globals.stdErrPrintln((String)this.ar.getString("A1001"), (String)this.ar.getKString("A3161", (Object)ex));
                break;
            }
            default: {
                Globals.stdErrPrintln((String)("Unknown exception caught: " + type));
            }
        }
    }

    private String getUserInput(String question) {
        return this.getUserInput(question, null);
    }

    private String getUserInput(String question, String defaultResponse) {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            Globals.stdOutPrint((String)question);
            String s = in.readLine();
            if (s.equals("") && defaultResponse != null) {
                s = defaultResponse;
            }
            return s;
        }
        catch (IOException ex) {
            Globals.stdErrPrintln((String)this.ar.getString("A1001"), (String)this.ar.getKString("A3081"));
            return null;
        }
    }

    private String getPassword() {
        Password pw = new Password();
        Globals.stdOutPrint((String)this.ar.getString("A1621"));
        return pw.getPassword();
    }

    private void printBrokerInfo(BrokerAdmin broker) {
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(2, 4, "-");
        Object[] row = new String[2];
        row[0] = this.ar.getString("A1440");
        row[1] = this.ar.getString("A1441");
        bcp.addTitle((String[])row);
        row[0] = broker.getBrokerHost();
        row[1] = broker.getBrokerPort();
        bcp.add(row);
        bcp.println();
    }

    private void printServiceInfo() {
        this.printServiceInfo(null);
    }

    private void printServiceInfo(String svcName) {
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(1, 4, "-");
        Object[] row = new String[1];
        row[0] = this.ar.getString("A1420");
        bcp.addTitle((String[])row);
        row[0] = svcName == null ? this.brokerCmdProps.getTargetName() : svcName;
        bcp.add(row);
        bcp.println();
    }

    private void printMessageInfo() {
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(1, 4, "-");
        Object[] row = new String[]{"Message ID"};
        bcp.addTitle((String[])row);
        row[0] = this.brokerCmdProps.getMsgID();
        bcp.add(row);
        bcp.println();
    }

    private void printDestinationInfo() {
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(2, 4, "-");
        Object[] row = new String[2];
        row[0] = this.ar.getString("A1400");
        row[1] = this.ar.getString("A1401");
        bcp.addTitle((String[])row);
        row[0] = this.brokerCmdProps.getTargetName();
        row[1] = BrokerAdminUtil.getDestinationType((int)this.getDestTypeMask(this.brokerCmdProps));
        bcp.add(row);
        bcp.println();
    }

    private void printDurableSubscriptionInfo() {
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(2, 4, "-");
        Object[] row = new String[2];
        row[0] = this.ar.getString("A1430");
        row[1] = this.ar.getString("A1431");
        bcp.addTitle((String[])row);
        row[0] = this.brokerCmdProps.getTargetName();
        row[1] = this.brokerCmdProps.getClientID();
        bcp.add(row);
        bcp.println();
    }

    private void printTransactionInfo() {
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(1, 4, "-");
        Object[] row = new String[1];
        row[0] = this.ar.getString("A1263");
        bcp.addTitle((String[])row);
        row[0] = this.brokerCmdProps.getTargetName();
        bcp.add(row);
        bcp.println();
    }

    private void printConnectionInfo() {
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(1, 4, "-");
        Object[] row = new String[1];
        row[0] = this.ar.getString("A1323");
        bcp.addTitle((String[])row);
        row[0] = this.brokerCmdProps.getTargetName();
        bcp.add(row);
        bcp.println();
    }

    private void isAdminService(BrokerAdmin broker, String svcName) throws BrokerAdminException {
        broker.sendGetServicesMessage(svcName);
        Vector svc = broker.receiveGetServicesReplyMessage();
        if (svc != null && svc.size() == 1) {
            Enumeration thisEnum = svc.elements();
            ServiceInfo sInfo = (ServiceInfo)thisEnum.nextElement();
            if (sInfo.type == 1) {
                throw new BrokerAdminException(7);
            }
        }
    }

    private void isDestTypeTopic(BrokerAdmin broker, String destName) throws BrokerAdminException {
        broker.sendGetDestinationsMessage(null, -1);
        Vector dests = broker.receiveGetDestinationsReplyMessage();
        boolean found = false;
        for (int i = 0; !found && i < dests.size(); ++i) {
            DestinationInfo dInfo = (DestinationInfo)dests.elementAt(i);
            if (!destName.equals(dInfo.name) || !DestType.isTopic((int)dInfo.type)) continue;
            found = true;
        }
        if (!found) {
            throw new BrokerAdminException(7);
        }
    }

    private String checkAndPrintUnlimitedInt(int value, int[] unlimitedValues) {
        String ret = null;
        for (int i = 0; i < unlimitedValues.length; ++i) {
            if (value != unlimitedValues[i]) continue;
            ret = this.ar.getString("A1537") + " (-1)";
            break;
        }
        if (ret == null) {
            ret = new Integer(value).toString();
        }
        return ret;
    }

    private String checkAndPrintUnlimitedInt(int value, int unlimitedValue) {
        String ret = value == unlimitedValue ? this.ar.getString("A1537") + " (-1)" : new Integer(value).toString();
        return ret;
    }

    private String checkAndPrintUnlimitedLong(long value, long[] unlimitedValues) {
        String ret = null;
        for (int i = 0; i < unlimitedValues.length; ++i) {
            if (value != unlimitedValues[i]) continue;
            ret = this.ar.getString("A1537") + " (-1)";
            break;
        }
        if (ret == null) {
            ret = new Long(value).toString();
        }
        return ret;
    }

    private String checkAndPrintUnlimitedBytes(String s, long[] unlimitedValues) {
        SizeString ss;
        String ret = null;
        String value = s.trim();
        try {
            ss = new SizeString(value);
        }
        catch (Exception e) {
            return value;
        }
        for (int i = 0; i < unlimitedValues.length; ++i) {
            if (ss.getBytes() != unlimitedValues[i]) continue;
            ret = this.ar.getString("A1537") + " (-1)";
            break;
        }
        if (ret == null) {
            ret = value;
        }
        return ret;
    }

    private String checkAndPrintUnlimited(String s, String[] unlimitedValues) {
        String ret = null;
        String value = s.trim();
        for (int i = 0; i < unlimitedValues.length; ++i) {
            if (!value.equals(unlimitedValues[i])) continue;
            ret = this.ar.getString("A1537") + " (-1)";
            break;
        }
        if (ret == null) {
            ret = value;
        }
        return ret;
    }

    private String checkNullAndPrint(Object obj) {
        if (obj != null) {
            return obj.toString();
        }
        return "";
    }

    private String checkNullAndPrintTimestamp(Long timestamp) {
        if (timestamp != null) {
            Date d = new Date(timestamp);
            DateFormat df = DateFormat.getDateTimeInstance(3, 2);
            String ts = df.format(d);
            return ts;
        }
        return "";
    }

    private int getMetricType(BrokerCmdProperties brokerCmdProps) {
        String s = brokerCmdProps.getMetricType();
        String commandArg = brokerCmdProps.getCommandArg();
        if (s == null) {
            return 0;
        }
        if (s.equals("ttl")) {
            return 0;
        }
        if (s.equals("rts")) {
            return 1;
        }
        if (s.equals("cxn")) {
            return 2;
        }
        if (s.equals("con")) {
            return 3;
        }
        if (s.equals("dsk")) {
            return 4;
        }
        if (s.equals("rem")) {
            return 5;
        }
        return 0;
    }

    private BrokerAdmin promptForAuthentication(BrokerAdmin broker) {
        String usernameValue = broker.getUserName();
        String passwordValue = broker.getPassword();
        boolean carriageReturnNeeded = false;
        if (usernameValue == null) {
            broker.setUserName(this.getUserInput(this.ar.getString("A1620")));
            carriageReturnNeeded = true;
        }
        if (passwordValue == null) {
            String passwd = this.getPassword();
            broker.setPassword(passwd);
            carriageReturnNeeded = false;
        }
        if (carriageReturnNeeded) {
            Globals.stdOutPrintln((String)"");
        }
        return broker;
    }

    private boolean reconnectToBroker(BrokerAdmin broker) {
        boolean connected = false;
        int count = 0;
        while (!connected && count < 5) {
            try {
                broker.connect();
                broker.sendHelloMessage();
                broker.receiveHelloReplyMessage();
                connected = true;
            }
            catch (BrokerAdminException baex) {
                if (baex.getType() == 0) {
                    try {
                        Thread.sleep(5000L);
                        ++count;
                    }
                    catch (InterruptedException ie) {
                        connected = false;
                    }
                } else {
                    connected = false;
                }
            }
            catch (Exception ex) {
                connected = false;
            }
            if (count < 5) continue;
            connected = false;
            Globals.stdErrPrintln((String)this.ar.getString("A3120", (Object)broker.getBrokerHost(), (Object)broker.getBrokerPort()));
            Globals.stdErrPrintln((String)this.ar.getString("A3116", (Object)new Long(25L)));
        }
        return connected;
    }

    private static Properties convertQueueDeliveryPolicy(Properties targetAttrs) {
        String deliveryValue = targetAttrs.getProperty("imq.queue.deliverypolicy");
        if ("s".equals(deliveryValue)) {
            targetAttrs.setProperty("imq.queue.deliverypolicy", "single");
        } else if ("f".equals(deliveryValue)) {
            targetAttrs.setProperty("imq.queue.deliverypolicy", "failover");
        } else if ("r".equals(deliveryValue)) {
            targetAttrs.setProperty("imq.queue.deliverypolicy", "round-robin");
        }
        return targetAttrs;
    }

    private String getDisplayableQueueDeliveryPolicy(String deliveryValue) {
        if ("single".equals(deliveryValue)) {
            return this.ar.getString("A1503");
        }
        if ("failover".equals(deliveryValue)) {
            return this.ar.getString("A1505");
        }
        if ("round-robin".equals(deliveryValue)) {
            return this.ar.getString("A1504");
        }
        return this.ar.getString("A1502");
    }

    private int getPauseTypeVal(String destStateStr) {
        int ret = -1;
        if (destStateStr == null) {
            return ret;
        }
        if (destStateStr.equals("ALL")) {
            ret = 3;
        } else if (destStateStr.equals("PRODUCERS")) {
            ret = 2;
        } else if (destStateStr.equals("CONSUMERS")) {
            ret = 1;
        }
        return ret;
    }

    private String getResetTypeVal(String resetType) {
        if (resetType == null || resetType.equals("")) {
            return null;
        }
        if (resetType.equals("METRICS")) {
            return "JMQMetrics";
        }
        return null;
    }

    private int getLimitBehavValue(String limitBehavStr) {
        int ret = -1;
        if (limitBehavStr == null) {
            return ret;
        }
        if (limitBehavStr.equals(LIMIT_BEHAV_FLOW_CONTROL)) {
            ret = 0;
        } else if (limitBehavStr.equals(LIMIT_BEHAV_RM_OLDEST)) {
            ret = 1;
        } else if (limitBehavStr.equals(LIMIT_BEHAV_REJECT_NEWEST)) {
            ret = 2;
        } else if (limitBehavStr.equals(LIMIT_BEHAV_RM_LOW_PRIORITY)) {
            ret = 3;
        }
        return ret;
    }

    private int getClusterDeliveryPolicy(String cdp) {
        int ret = -1;
        if (cdp == null) {
            return ret;
        }
        boolean b = Boolean.valueOf(cdp);
        ret = b ? 1 : 2;
        return ret;
    }

    private String getPasswordFromFileOrCmdLine(BrokerCmdProperties brokerCmdProps) throws BrokerCmdException {
        String passwd = brokerCmdProps.getAdminPasswd();
        String passfile = brokerCmdProps.getAdminPassfile();
        if (passwd != null) {
            return passwd;
        }
        if (passfile != null) {
            String ret = null;
            InputStream fis = null;
            try {
                Properties props = new Properties();
                fis = FileUtil.retrieveObfuscatedFile((String)passfile);
                props.load(fis);
                ret = props.getProperty("imq.imqcmd.password");
                if (ret == null) {
                    throw new RuntimeException(this.ar.getString("A3162", (Object)"imq.imqcmd.password", (Object)passfile));
                }
            }
            catch (Exception e) {
                BrokerCmdException bce = new BrokerCmdException(34);
                bce.setProperties(brokerCmdProps);
                bce.setLinkedException(e);
                throw bce;
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ioe) {}
                    fis = null;
                }
            }
            return ret;
        }
        return null;
    }

    private String checkNullAndPrintDeliveryMode(Integer deliveryMode) {
        if (deliveryMode != null) {
            String val;
            switch (deliveryMode) {
                case 1: {
                    val = "NON_PERSISTENT";
                    break;
                }
                case 2: {
                    val = "PERSISTENT";
                    break;
                }
                default: {
                    val = "Unknown";
                }
            }
            return val + " (" + deliveryMode + ")";
        }
        return "";
    }

    private String checkNullAndPrintMsgBodyType(Integer bodyType, boolean includeValue) {
        if (bodyType != null) {
            String label = null;
            switch (bodyType) {
                case 1: {
                    label = "TextMessage";
                    break;
                }
                case 2: {
                    label = "BytesMessage";
                    break;
                }
                case 3: {
                    label = "MapMessage";
                    break;
                }
                case 4: {
                    label = "StreamMessage";
                    break;
                }
                case 5: {
                    label = "ObjectMessage";
                    break;
                }
                default: {
                    label = "Unknown";
                }
            }
            if (includeValue) {
                return label + " (" + bodyType + ")";
            }
            return label;
        }
        return "";
    }
}

