/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dialog;

import com.jidesoft.dialog.ButtonListener;
import com.jidesoft.dialog.ButtonPanelLayout;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.ArrowKeyNavigationSupport;
import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.JPanel;

public final class ButtonPanel
extends JPanel
implements ButtonListener {
    private String _defaultOrder = UIDefaultsLookup.getString("ButtonPanel.order");
    private String _defaultOppositeOrder = UIDefaultsLookup.getString("ButtonPanel.oppositeOrder");
    private int _defaultButtonGap = UIDefaultsLookup.getInt("ButtonPanel.buttonGap");
    private int _defaultGroupGap = UIDefaultsLookup.getInt("ButtonPanel.groupGap");
    private int _defaultButtonWidth = UIDefaultsLookup.getInt("ButtonPanel.minButtonWidth");
    private int _alignment;
    private ButtonPanelLayout _layout;
    private boolean _addNotify = false;

    public ButtonPanel() {
        this(11);
    }

    public ButtonPanel(int n) {
        this(n, 0);
    }

    private ButtonPanel(int n, int n2) {
        this._alignment = n;
        if (n != 2 && n != 4 && n != 10 && n != 11 && n != 1 && n != 3 && n != 0) {
            throw new IllegalArgumentException("Invalid alignment");
        }
        n = this._alignment == 0 || this._alignment == 2 || this._alignment == 4 || this._alignment == 11 || this._alignment == 10 ? 0 : 1;
        this._layout = new ButtonPanelLayout(this, n, this._alignment, 0, this._defaultOrder, this._defaultOppositeOrder, this._defaultButtonGap, this._defaultGroupGap);
        this.setLayout(this._layout);
        new ArrowKeyNavigationSupport(new Class[]{AbstractButton.class}).install(this);
    }

    public final void updateUI() {
        if (UIDefaultsLookup.get("ButtonPanel.buttonGap") == null && UIDefaultsLookup.get("ButtonPanel.order") == null && UIDefaultsLookup.get("ButtonPanel.groupGap") == null) {
            LookAndFeelFactory.installJideExtension();
        }
        super.updateUI();
        ButtonPanel buttonPanel = this;
        if (buttonPanel._layout != null) {
            ButtonPanelLayout buttonPanelLayout = buttonPanel._layout;
            if (buttonPanel._defaultButtonGap == buttonPanelLayout._buttonGap) {
                buttonPanel._defaultButtonGap = UIDefaultsLookup.getInt("ButtonPanel.buttonGap");
                buttonPanel._layout.setButtonGap(buttonPanel._defaultButtonGap);
            }
            buttonPanelLayout = buttonPanel._layout;
            if (buttonPanel._defaultGroupGap == buttonPanelLayout._groupGap) {
                buttonPanel._defaultGroupGap = UIDefaultsLookup.getInt("ButtonPanel.groupGap");
                buttonPanel._layout.setGroupGap(buttonPanel._defaultGroupGap);
            }
            if (buttonPanel._defaultOrder.equals(buttonPanel._layout.getButtonOrder())) {
                buttonPanel._defaultOrder = UIDefaultsLookup.getString("ButtonPanel.order");
                buttonPanel._layout.setButtonOrder(buttonPanel._defaultOrder);
            }
            if (buttonPanel._defaultOppositeOrder.equals(buttonPanel._layout.getOppositeButtonOrder())) {
                buttonPanel._defaultOppositeOrder = UIDefaultsLookup.getString("ButtonPanel.oppositeOrder");
                buttonPanel._layout.setOppositeButtonOrder(buttonPanel._defaultOppositeOrder);
            }
            if (buttonPanel._defaultButtonWidth == buttonPanel._layout.getMinButtonWidth()) {
                buttonPanel._defaultButtonWidth = UIDefaultsLookup.getInt("ButtonPanel.minButtonWidth");
                buttonPanel._layout.setMinButtonWidth(buttonPanel._defaultButtonWidth);
            }
        }
    }

    public final void addButton(AbstractButton abstractButton, Object object) {
        int n = -1;
        Object object2 = object;
        object = abstractButton;
        ButtonPanel buttonPanel = this;
        buttonPanel.add((Component)object, object2, -1);
    }

    protected final void addImpl(Component component, Object object, int n) {
        if (object == null) {
            object = "AFFIRMATIVE";
        }
        super.addImpl(component, object, n);
    }

    public final void setSizeConstraint(int n) {
        this._layout.setSizeConstraint(n);
    }

    public final void setButtonGap(int n) {
        this._layout.setButtonGap(n);
    }

    public final void addNotify() {
        super.addNotify();
    }
}

