/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.GripperUI;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.Painter;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.Gripper;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.SecurityUtils;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class BasicGripperUI
extends GripperUI {
    private int _size;
    private ThemePainter _painter;
    protected Painter _gripperPainter;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicGripperUI();
    }

    public void installUI(JComponent object) {
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        this._gripperPainter = (Painter)UIDefaultsLookup.get("Gripper.painter");
        this.installDefaults((Gripper)object);
        Gripper gripper = (Gripper)object;
        Object object2 = object = this;
        object2 = new GripperMouseListener((BasicGripperUI)object2);
        if (object2 != null) {
            gripper.putClientProperty(object, object2);
            gripper.addMouseListener((MouseListener)object2);
        }
    }

    public void uninstallUI(JComponent object) {
        this._painter = null;
        this._gripperPainter = null;
        Gripper gripper = (Gripper)object;
        object = this;
        MouseListener mouseListener = (MouseListener)gripper.getClientProperty(object);
        gripper.putClientProperty(object, null);
        if (mouseListener != null) {
            gripper.removeMouseListener(mouseListener);
        }
    }

    protected void installDefaults(Gripper gripper) {
        this._size = UIDefaultsLookup.getInt("Gripper.size");
    }

    protected final void paintBackground(Graphics graphics, Gripper gripper) {
        Rectangle rectangle = new Rectangle(0, 0, gripper.getWidth(), gripper.getHeight());
        if (gripper.isRollover()) {
            BasicGripperUI basicGripperUI = this;
            basicGripperUI._painter.paintButtonBackground(gripper, graphics, rectangle, 0, 2);
            return;
        }
        if (gripper.isOpaque()) {
            BasicGripperUI basicGripperUI = this;
            Object object = basicGripperUI;
            object = gripper;
            basicGripperUI._painter.paintButtonBackground(gripper, graphics, rectangle, 0, 0, false);
            if ("true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
                JideSwingUtilities.fillGradient(graphics, rectangle, 0);
            }
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Gripper gripper = (Gripper)jComponent;
        this.paintBackground(graphics, gripper);
        Object object = gripper;
        int n = 0;
        if (this._gripperPainter == null) {
            object = this;
            ((BasicGripperUI)object)._painter.paintGripper$6e95d9b1(graphics, new Rectangle(0, 0, jComponent.getWidth(), jComponent.getHeight()), gripper.getOrientation(), n);
            return;
        }
        this._gripperPainter.paint(jComponent, graphics, new Rectangle(0, 0, jComponent.getWidth(), jComponent.getHeight()), gripper.getOrientation(), n);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return new Dimension(this._size, this._size);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Gripper gripper = (Gripper)jComponent;
        if (gripper.getOrientation() == 0) {
            return new Dimension(this._size, jComponent.getParent().getHeight());
        }
        return new Dimension(jComponent.getParent().getWidth(), this._size);
    }

    public final ThemePainter getPainter() {
        return this._painter;
    }

    final class GripperMouseListener
    extends MouseAdapter {
        GripperMouseListener(BasicGripperUI basicGripperUI) {
        }

        public final void mouseEntered(MouseEvent mouseEvent) {
            super.mouseEntered(mouseEvent);
            if (mouseEvent.getSource() instanceof Gripper && ((Gripper)mouseEvent.getSource()).isRolloverEnabled()) {
                ((Gripper)mouseEvent.getSource()).setRollover(true);
            }
        }

        public final void mouseExited(MouseEvent mouseEvent) {
            super.mouseExited(mouseEvent);
            if (mouseEvent.getSource() instanceof Gripper && ((Gripper)mouseEvent.getSource()).isRolloverEnabled()) {
                ((Gripper)mouseEvent.getSource()).setRollover(false);
            }
        }
    }
}

