/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.ComponentStateSupport;
import com.jidesoft.swing.JideSplitPaneDivider;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideTabbedPane;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class BasicPainter
implements ThemePainter,
SwingConstants {
    private static BasicPainter _instance;
    private Color _bk0;
    private Color _bk1;
    private Color _bk2;
    private Color _bk3;
    private Color _borderColor;

    public static ThemePainter getInstance() {
        if (_instance == null) {
            _instance = new BasicPainter();
        }
        return _instance;
    }

    public void installDefaults() {
        if (this._bk0 == null) {
            this._bk0 = UIDefaultsLookup.getColor("JideButton.background");
        }
        if (this._bk1 == null) {
            this._bk1 = UIDefaultsLookup.getColor("JideButton.focusedBackground");
        }
        if (this._bk2 == null) {
            this._bk2 = UIDefaultsLookup.getColor("JideButton.selectedBackground");
        }
        if (this._bk3 == null) {
            this._bk3 = UIDefaultsLookup.getColor("JideButton.selectedAndFocusedBackground");
        }
        if (this._borderColor == null) {
            this._borderColor = UIDefaultsLookup.getColor("JideButton.borderColor");
        }
    }

    public Color getGripperForeground() {
        return UIDefaultsLookup.getColor("Gripper.foreground");
    }

    public Color getGripperForegroundLt() {
        return UIDefaultsLookup.getColor("JideButton.highlight");
    }

    public Color getSeparatorForeground() {
        return UIDefaultsLookup.getColor("JideButton.shadow");
    }

    public Color getBackgroundDk() {
        return UIDefaultsLookup.getColor("JideButton.background");
    }

    public Color getBackgroundLt() {
        return UIDefaultsLookup.getColor("JideButton.background");
    }

    public Color getSelectionSelectedDk() {
        return this._bk2;
    }

    public Color getSelectionSelectedLt() {
        return this._bk2;
    }

    public Color getMenuItemBorderColor() {
        return UIDefaultsLookup.getColor("MenuItem.selectionBorderColor");
    }

    public Color getMenuItemBackground() {
        return UIDefaultsLookup.getColor("MenuItem.background");
    }

    public Color getControlDk() {
        return this.getControlShadow();
    }

    public Color getControlShadow() {
        return UIDefaultsLookup.getColor("JideButton.shadow");
    }

    public Color getOptionPaneBannerForeground() {
        return new ColorUIResource(255, 255, 255);
    }

    public Color getTabbedPaneSelectDk() {
        return new ColorUIResource(230, 139, 44);
    }

    public Color getTabbedPaneSelectLt() {
        return new ColorUIResource(255, 199, 60);
    }

    public Color getOptionPaneBannerDk() {
        return new ColorUIResource(45, 96, 249);
    }

    public Color getOptionPaneBannerLt() {
        return new ColorUIResource(0, 52, 206);
    }

    public void paintSelectedMenu$6e95d9b1(Graphics graphics, Rectangle rectangle, int n) {
        Color color = graphics.getColor();
        graphics.setColor(UIDefaultsLookup.getColor("JideButton.darkShadow"));
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height, rectangle.x, rectangle.y + 1);
        graphics.drawLine(rectangle.x + rectangle.width - 2, rectangle.y, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height);
        if (n == 0) {
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 3, rectangle.y);
        } else {
            graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 3, rectangle.y + rectangle.height - 1);
        }
        graphics.setColor(color);
    }

    public final void paintMenuItemBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        this.paintMenuItemBackground(jComponent, graphics, rectangle, n, n2, true);
    }

    public void paintMenuItemBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2, boolean bl) {
        this.paintButtonBackground(jComponent, graphics, rectangle, n, n2, bl);
    }

    public void paintButtonBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        this.paintButtonBackground(jComponent, graphics, rectangle, n, n2, true);
    }

    public void paintButtonBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2, boolean bl) {
        this.installDefaults();
        Color color = null;
        switch (n2) {
            case 0: {
                color = jComponent.getBackground();
                if (color == null || color instanceof UIResource) {
                    color = this._bk0;
                }
                BasicPainter.paintBackground(jComponent, graphics, rectangle, bl ? this._borderColor : null, color, n);
                return;
            }
            case 2: {
                if (jComponent instanceof ComponentStateSupport) {
                    color = ((ComponentStateSupport)((Object)jComponent)).getBackgroundOfState(2);
                }
                if (color == null || color instanceof UIResource) {
                    color = this._bk1;
                }
                BasicPainter.paintBackground(jComponent, graphics, rectangle, bl ? this._borderColor : null, color, n);
                return;
            }
            case 3: {
                if (jComponent instanceof ComponentStateSupport) {
                    color = ((ComponentStateSupport)((Object)jComponent)).getBackgroundOfState(3);
                }
                if (color == null || color instanceof UIResource) {
                    color = this._bk2;
                }
                BasicPainter.paintBackground(jComponent, graphics, rectangle, bl ? this._borderColor : null, color, n);
                return;
            }
            case 1: {
                if (jComponent instanceof ComponentStateSupport) {
                    color = ((ComponentStateSupport)((Object)jComponent)).getBackgroundOfState(1);
                }
                if (color == null || color instanceof UIResource) {
                    color = this._bk3;
                }
                BasicPainter.paintBackground(jComponent, graphics, rectangle, bl ? this._borderColor : null, color, n);
            }
        }
    }

    private static void paintBackground(JComponent object, Graphics graphics, Rectangle rectangle, Color color, Color color2, int n) {
        Color color3 = graphics.getColor();
        if (color != null) {
            boolean bl = true;
            Object object2 = ((JComponent)object).getClientProperty("JideButton.paintDefaultBorder");
            if (object2 instanceof Boolean) {
                bl = (Boolean)object2;
            }
            if (bl) {
                graphics.setColor(color);
                object = ((JComponent)object).getClientProperty("JButton.segmentPosition");
                if (object == null || "only".equals(object)) {
                    graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
                } else if ("first".equals(object)) {
                    if (n == 0) {
                        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height - 1);
                    } else {
                        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height);
                    }
                } else if ("middle".equals(object)) {
                    if (n == 0) {
                        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height - 1);
                    } else {
                        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height);
                    }
                } else if ("last".equals(object)) {
                    graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
                }
            }
            graphics.setColor(color2);
            graphics.fillRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
        } else {
            graphics.setColor(color2);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        graphics.setColor(color3);
    }

    public void paintMenuShadow$6e95d9b1(Graphics graphics, Rectangle rectangle, int n) {
        Color color = graphics.getColor();
        graphics.setColor(UIDefaultsLookup.getColor("MenuItem.shadowColor"));
        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        graphics.setColor(color);
    }

    public void paintGripper$6e95d9b1(Graphics graphics, Rectangle rectangle, int n, int n2) {
        graphics.setColor(this.getGripperForeground());
        if (rectangle.width > rectangle.height) {
            rectangle.x = rectangle.x + rectangle.width / 2 - 10;
            rectangle.width = 22;
        } else {
            rectangle.y = rectangle.y + rectangle.height / 2 - 10;
            rectangle.height = 22;
        }
        if (n == 0) {
            if (rectangle.width <= 30) {
                for (n = 0; n < (rectangle.height - 6) / 2; ++n) {
                    graphics.drawLine(rectangle.x + 3, rectangle.y + 3 + (n << 1), rectangle.x + rectangle.width - 3, rectangle.y + 3 + (n << 1));
                }
                return;
            }
            for (n = 0; n < (rectangle.height - 4) / 2; ++n) {
                graphics.drawLine((rectangle.width - rectangle.width) / 2, rectangle.y + 2 + (n << 1), (rectangle.width + rectangle.width) / 2, rectangle.y + 2 + (n << 1));
            }
            return;
        }
        n = (rectangle.width - 6) / 2;
        for (n2 = 0; n2 < n; ++n2) {
            int n3 = rectangle.x + rectangle.width / 2 - n + (n2 << 1);
            graphics.drawLine(n3, rectangle.y + 3, n3, rectangle.y + rectangle.height - 3);
        }
    }

    public void paintTabAreaBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        if (jComponent.isOpaque() && jComponent instanceof JideTabbedPane) {
            jComponent = (JideTabbedPane)jComponent;
            n = ((JideTabbedPane)jComponent).getTabShape();
            int n3 = ((JideTabbedPane)jComponent).getColorTheme();
            if (n != 3 && n3 != 1 && n3 == 3) {
                graphics.setColor(UIDefaultsLookup.getColor("JideTabbedPane.tabAreaBackground"));
            } else {
                graphics.setColor(UIDefaultsLookup.getColor("control"));
            }
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public final void paintTabBackground$99cae22(JComponent jComponent, Graphics graphics, Shape shape, Color[] object, int n) {
        graphics = (Graphics2D)graphics.create();
        Color color = object[0];
        if ((object = object[1]) != null && color != null) {
            int n2 = 1;
            if (jComponent instanceof JideTabbedPane) {
                n2 = ((JideTabbedPane)jComponent).getTabPlacement();
            }
            switch (n2) {
                case 2: {
                    JideSwingUtilities.fillGradient((Graphics2D)graphics, shape, color, (Color)object, false);
                    break;
                }
                case 4: {
                    JideSwingUtilities.fillGradient((Graphics2D)graphics, shape, (Color)object, color, false);
                    break;
                }
                case 3: {
                    JideSwingUtilities.fillGradient((Graphics2D)graphics, shape, (Color)object, color, true);
                    break;
                }
                default: {
                    JideSwingUtilities.fillGradient((Graphics2D)graphics, shape, color, (Color)object, true);
                }
            }
        }
        graphics.dispose();
    }

    public void paintHeaderBoxBackground(JComponent serializable, Graphics graphics, Rectangle rectangle, int n, int n2) {
        n = Boolean.TRUE.equals(serializable.getClientProperty("HeaderBox.isTableCellEditor")) ? 1 : 0;
        if ((serializable = serializable.getBackground()) instanceof UIResource && (serializable = UIDefaultsLookup.getColor("HeaderBox.background")) == null) {
            serializable = UIDefaultsLookup.getColor("control");
        }
        if (n2 == 1 || n2 == 3 || n2 == 2) {
            Color color = JideSplitPaneDivider.DragController.getDerivedColor((Color)serializable, 0.48f);
            if (n != 0) {
                graphics.setColor(color);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            } else {
                graphics.setColor(color);
                graphics.fillRoundRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, 4, 4);
                graphics.setColor(JideSplitPaneDivider.DragController.getDerivedColor((Color)serializable, 0.4f));
                graphics.drawRoundRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, 6, 6);
            }
            graphics.setColor(JideSplitPaneDivider.DragController.getDerivedColor((Color)serializable, 0.45f));
            graphics.drawLine(rectangle.x + 1, rectangle.y + rectangle.height - 3, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 3);
            graphics.setColor(JideSplitPaneDivider.DragController.getDerivedColor((Color)serializable, 0.43f));
            graphics.drawLine(rectangle.x + 2, rectangle.y + rectangle.height - 2, rectangle.x + rectangle.width - 3, rectangle.y + rectangle.height - 2);
            graphics.setColor(JideSplitPaneDivider.DragController.getDerivedColor((Color)serializable, 0.4f));
            graphics.drawLine(rectangle.x + 3, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 4, rectangle.y + rectangle.height - 1);
            return;
        }
        if (n != 0) {
            graphics.setColor((Color)serializable);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        } else {
            graphics.setColor((Color)serializable);
            graphics.fillRoundRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, 2, 2);
            graphics.setColor(JideSplitPaneDivider.DragController.getDerivedColor((Color)serializable, 0.42f));
            graphics.drawRoundRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, 2, 4);
        }
        graphics.setColor(JideSplitPaneDivider.DragController.getDerivedColor((Color)serializable, 0.48f));
        graphics.drawLine(rectangle.x + 1, rectangle.y + rectangle.height - 3, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 3);
        graphics.setColor(JideSplitPaneDivider.DragController.getDerivedColor((Color)serializable, 0.47f));
        graphics.drawLine(rectangle.x + 1, rectangle.y + rectangle.height - 2, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
        if (n != 0) {
            graphics.setColor(new Color(198, 197, 178));
            graphics.drawLine(rectangle.x + rectangle.width - 3, rectangle.y + 4, rectangle.x + rectangle.width - 3, rectangle.y + rectangle.height - 7);
            graphics.setColor(Color.WHITE);
            graphics.drawLine(rectangle.x + rectangle.width - 2, rectangle.y + 4, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 7);
        }
    }
}

