/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.StyleRange;
import com.jidesoft.swing.StyledLabel;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.text.View;

public class BasicStyledLabelUI
extends BasicLabelUI
implements SwingConstants {
    private static Comparator<StyleRange> _comparator;
    private static BasicStyledLabelUI styledLabelUI;
    private List<StyledText> _styledTexts;

    public static ComponentUI createUI(JComponent jComponent) {
        return styledLabelUI;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        if ("styleRange".equals(propertyChangeEvent.getPropertyName())) {
            this._styledTexts = null;
            if (propertyChangeEvent.getSource() instanceof StyledLabel) {
                ((StyledLabel)propertyChangeEvent.getSource()).revalidate();
                ((StyledLabel)propertyChangeEvent.getSource()).repaint();
                return;
            }
        } else if ("ignoreColorSettings".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getSource() instanceof StyledLabel) {
            ((StyledLabel)propertyChangeEvent.getSource()).repaint();
        }
    }

    protected void paintEnabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
        View view = jLabel != null ? (View)jLabel.getClientProperty("html") : null;
        if (view != null) {
            super.paintEnabledText(jLabel, graphics, string, n, n2);
            return;
        }
        this.paintStyledText((StyledLabel)jLabel, graphics, n, n2);
    }

    protected void paintDisabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
        View view = jLabel != null ? (View)jLabel.getClientProperty("html") : null;
        if (view != null) {
            super.paintDisabledText(jLabel, graphics, string, n, n2);
            return;
        }
        this.paintStyledText((StyledLabel)jLabel, graphics, n, n2);
    }

    private void buildStyledText(StyledLabel object) {
        if (this._styledTexts == null) {
            this._styledTexts = new ArrayList<StyledText>();
        } else {
            this._styledTexts.clear();
        }
        StyleRange[] styleRangeArray = ((StyledLabel)object).getStyleRanges();
        if (_comparator == null) {
            _comparator = new Comparator<StyleRange>(this){};
        }
        Arrays.sort(styleRangeArray, _comparator);
        object = ((JLabel)object).getText();
        if (object != null && ((String)object).length() > 0) {
            int n = 0;
            for (StyleRange styleRange : styleRangeArray) {
                if (styleRange.getStart() > n) {
                    this._styledTexts.add(new StyledText(this, ((String)object).substring(n, styleRange.getStart())));
                    n = styleRange.getStart();
                }
                if (styleRange.getStart() != n) continue;
                if (styleRange.getLength() == -1) {
                    this._styledTexts.add(new StyledText(this, ((String)object).substring(n), styleRange));
                    n = ((String)object).length();
                    continue;
                }
                this._styledTexts.add(new StyledText(this, ((String)object).substring(n, n + styleRange.getLength()), styleRange));
                n += styleRange.getLength();
            }
            if (n < ((String)object).length()) {
                this._styledTexts.add(new StyledText(this, ((String)object).substring(n, ((String)object).length())));
            }
        }
    }

    protected String layoutCL(JLabel serializable, FontMetrics object, String object2, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        int n;
        Cloneable cloneable = this.getPreferredSize((StyledLabel)serializable);
        rectangle3.width = cloneable.width;
        rectangle3.height = cloneable.height;
        JLabel jLabel = serializable;
        FontMetrics fontMetrics = object;
        String string = object2;
        int n2 = ((JLabel)serializable).getIconTextGap();
        Rectangle rectangle4 = rectangle3;
        Rectangle rectangle5 = rectangle2;
        cloneable = rectangle;
        int n3 = ((JLabel)serializable).getHorizontalTextPosition();
        int n4 = ((JLabel)serializable).getVerticalTextPosition();
        int n5 = ((JLabel)serializable).getHorizontalAlignment();
        int n6 = ((JLabel)serializable).getVerticalAlignment();
        object2 = icon;
        object = string;
        serializable = fontMetrics;
        serializable = jLabel;
        boolean bl = true;
        int n7 = n5;
        int n8 = n3;
        if (serializable != null && !((Component)serializable).getComponentOrientation().isLeftToRight()) {
            bl = false;
        }
        switch (n5) {
            case 10: {
                n7 = bl ? 2 : 4;
                break;
            }
            case 11: {
                n7 = bl ? 4 : 2;
            }
        }
        switch (n3) {
            case 10: {
                n8 = bl ? 2 : 4;
                break;
            }
            case 11: {
                n8 = bl ? 4 : 2;
            }
        }
        n3 = n8;
        n5 = n7;
        if (object2 != null) {
            rectangle5.width = object2.getIconWidth();
            rectangle5.height = object2.getIconHeight();
        } else {
            rectangle5.height = 0;
            rectangle5.width = 0;
        }
        bl = object == null || ((String)object).equals("");
        View view = null;
        if (bl) {
            rectangle4.height = 0;
            rectangle4.width = 0;
            object = "";
            n = 0;
        } else {
            n = object2 == null ? 0 : n2;
            n2 = n3 == 0 ? ((Rectangle)cloneable).width : ((Rectangle)cloneable).width - (rectangle5.width + n);
            view = serializable != null ? (View)((JComponent)serializable).getClientProperty("html") : null;
            if (view != null) {
                rectangle4.width = Math.min(n2, (int)view.getPreferredSpan(0));
                rectangle4.height = (int)view.getPreferredSpan(1);
            }
        }
        rectangle4.y = n4 == 1 ? (n3 != 0 ? 0 : -(rectangle4.height + n)) : (n4 == 0 ? rectangle5.height / 2 - rectangle4.height / 2 : (n3 != 0 ? rectangle5.height - rectangle4.height : rectangle5.height + n));
        rectangle4.x = n3 == 2 ? -(rectangle4.width + n) : (n3 == 0 ? rectangle5.width / 2 - rectangle4.width / 2 : rectangle5.width + n);
        n2 = Math.min(rectangle5.x, rectangle4.x);
        int n9 = Math.max(rectangle5.x + rectangle5.width, rectangle4.x + rectangle4.width) - n2;
        n = Math.min(rectangle5.y, rectangle4.y);
        n4 = Math.max(rectangle5.y + rectangle5.height, rectangle4.y + rectangle4.height) - n;
        n = n6 == 1 ? ((Rectangle)cloneable).y - n : (n6 == 0 ? ((Rectangle)cloneable).y + ((Rectangle)cloneable).height / 2 - (n + n4 / 2) : ((Rectangle)cloneable).y + ((Rectangle)cloneable).height - (n + n4));
        n9 = n5 == 2 ? ((Rectangle)cloneable).x - n2 : (n5 == 4 ? ((Rectangle)cloneable).x + ((Rectangle)cloneable).width - (n2 + n9) : ((Rectangle)cloneable).x + ((Rectangle)cloneable).width / 2 - (n2 + n9 / 2));
        rectangle4.x += n9;
        rectangle4.y += n;
        rectangle5.x += n9;
        rectangle5.y += n;
        return object;
    }

    private Dimension getPreferredSize(StyledLabel styledLabel) {
        this.buildStyledText(styledLabel);
        int n = 0;
        Object object = BasicStyledLabelUI.getFont(styledLabel);
        FontMetrics fontMetrics = styledLabel.getFontMetrics((Font)object);
        int n2 = 0;
        int n3 = ((Font)object).getSize();
        List<StyledText> list = this._styledTexts;
        synchronized (list) {
            StyledText[] styledTextArray = this._styledTexts.toArray(new StyledText[this._styledTexts.size()]);
            for (int i = styledTextArray.length - 1; i >= 0; --i) {
                float f;
                StyledText styledText = styledTextArray[i];
                StyleRange styleRange = styledText.styleRange;
                if (styleRange != null && (styleRange.isSuperscript() || styleRange.isSubscript())) {
                    object = styleRange;
                    f = Math.round((float)n3 / 0.0f);
                } else {
                    f = n3;
                }
                float f2 = f;
                object = BasicStyledLabelUI.getFont(styledLabel);
                if (styleRange != null && (styleRange.getFontStyle() != -1 && ((Font)object).getStyle() != styleRange.getFontStyle() || (float)((Font)object).getSize() != f2)) {
                    object = ((Font)object).deriveFont(styleRange.getFontStyle() == -1 ? ((Font)object).getStyle() : styleRange.getFontStyle(), f2);
                    object = styledLabel.getFontMetrics((Font)object);
                    n += ((FontMetrics)object).stringWidth(styledText.text);
                } else {
                    object = null;
                    n += fontMetrics.stringWidth(styledText.text);
                }
                if (styleRange == null) continue;
                if (styleRange.isUnderlined() && n2 < 2) {
                    n2 = 2;
                }
                if (styleRange.isDotted() && n2 < 3) {
                    n2 = 3;
                }
                if (!styleRange.isWaved() || n2 >= 4) continue;
                n2 = 4;
            }
        }
        int n4 = fontMetrics.getHeight();
        return new Dimension(n, n4 + n2);
    }

    private static Font getFont(StyledLabel serializable) {
        if ((serializable = serializable.getFont()) == null) {
            serializable = UIDefaultsLookup.getFont("Label.font");
        }
        return serializable;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void paintStyledText(StyledLabel var1_1, Graphics var2_2, int var3_3, int var4_4) {
        var3_3 = var3_3 < var1_1.getInsets().left ? var1_1.getInsets().left : var3_3;
        var6_5 = var1_1.getDisplayedMnemonicIndex();
        if (UIManager.getLookAndFeel() instanceof WindowsLookAndFeel && WindowsLookAndFeel.isMnemonicHidden()) {
            var6_5 = -1;
        }
        this.buildStyledText(var1_1);
        var7_6 = var2_2.getColor();
        var8_7 = 0;
        var9_8 = false;
        var10_9 = 0;
        var11_10 = BasicStyledLabelUI.getFont(var1_1);
        var12_11 = var1_1.getFontMetrics((Font)var11_10);
        var14_12 = var11_10.getSize();
        for (StyledText var16_20 : this._styledTexts) {
            var17_21 = var16_20.styleRange;
            if (var16_20.text.length() > var6_5 - var8_7) {
                var9_8 = true;
                var10_9 = var6_5 - var8_7;
            }
            var8_7 += var16_20.text.length();
            var5_14 = var4_4;
            if (var17_21 != null && (var17_21.isSuperscript() || var17_21.isSubscript())) {
                var19_23 = var17_21;
                v0 = Math.round((float)var14_12 / 0.0f);
            } else {
                v0 = var14_12;
            }
            var13_15 = v0;
            var11_10 = BasicStyledLabelUI.getFont(var1_1);
            if (var17_21 != null && (var17_21.getFontStyle() != -1 && var11_10.getStyle() != var17_21.getFontStyle() || (float)var11_10.getSize() != var13_15)) {
                var11_10 = var11_10.deriveFont(var17_21.getFontStyle() == -1 ? var11_10.getStyle() : var17_21.getFontStyle(), var13_15);
                var13_16 = var1_1.getFontMetrics((Font)var11_10);
            } else {
                var13_16 = var12_11;
            }
            var2_2.setFont((Font)var11_10);
            var11_10 = var16_20.text;
            var16_19 = var13_16.stringWidth((String)var11_10);
            var18_22 = false;
            var19_24 = var1_1.getWidth() - var3_3;
            if (var19_24 < var16_19) {
                var11_10 = SwingUtilities.layoutCompoundLabel(var1_1, var13_16, (String)var11_10, null, var1_1.getVerticalAlignment(), var1_1.getHorizontalAlignment(), var1_1.getVerticalTextPosition(), var1_1.getHorizontalTextPosition(), new Rectangle(var3_3, var4_4, var19_24, var1_1.getHeight()), new Rectangle(), new Rectangle(), 0);
                var16_19 = var13_16.stringWidth((String)var11_10);
                var18_22 = true;
            }
            if (var17_21 != null && var17_21.isSuperscript()) {
                var5_14 = var4_4 - (var12_11.getHeight() - var13_16.getHeight());
            }
            if (var17_21 != null && var17_21.getBackgroundColor() != null) {
                var2_2.setColor(var17_21.getBackgroundColor());
                var2_2.fillRect(var3_3, var5_14 - var13_16.getHeight(), var16_19, var13_16.getHeight() + 4);
            }
            if (var17_21 == null) ** GOTO lbl-1000
            var19_25 /* !! */  = var1_1;
            if (var17_21.getFontColor() != null) {
                v1 /* !! */  = var17_21.getFontColor();
            } else lbl-1000:
            // 2 sources

            {
                v1 /* !! */  = var19_25 /* !! */  = var1_1.getForeground();
            }
            if (!var1_1.isEnabled()) {
                var19_25 /* !! */  = UIDefaultsLookup.getColor("Label.disabledForeground");
            }
            var2_2.setColor((Color)var19_25 /* !! */ );
            if (var9_8) {
                JideSwingUtilities.drawStringUnderlineCharAt(var1_1, var2_2, (String)var11_10, var10_9, var3_3, var5_14);
            } else {
                JideSwingUtilities.drawString(var1_1, var2_2, (String)var11_10, var3_3, var5_14);
            }
            if (var17_21 != null) {
                var11_10 = ((Graphics2D)var2_2).getStroke();
                if (var17_21.getLineStroke() != null) {
                    ((Graphics2D)var2_2).setStroke(var17_21.getLineStroke());
                }
                var19_25 /* !! */  = var1_1;
                if (var17_21.getLineColor() != null) {
                    var2_2.setColor(var17_21.getLineColor());
                }
                if (var17_21.isStrikethrough()) {
                    var19_26 = var5_14 + (var13_16.getDescent() - var13_16.getAscent()) / 2;
                    var2_2.drawLine(var3_3, var19_26, var3_3 + var16_19 - 1, var19_26);
                }
                if (var17_21.isDoublestrikethrough()) {
                    var19_27 = var5_14 + (var13_16.getDescent() - var13_16.getAscent()) / 2;
                    var2_2.drawLine(var3_3, var19_27 - 1, var3_3 + var16_19 - 1, var19_27 - 1);
                    var2_2.drawLine(var3_3, var19_27 + 1, var3_3 + var16_19 - 1, var19_27 + 1);
                }
                if (var17_21.isUnderlined()) {
                    var19_28 = var5_14 + 1;
                    var2_2.drawLine(var3_3, var19_28, var3_3 + var16_19 - 1, var19_28);
                }
                if (var17_21.isDotted()) {
                    var19_29 = var5_14 + 1;
                    for (var13_17 = var3_3; var13_17 < var3_3 + var16_19; var13_17 += 4) {
                        var2_2.drawRect(var13_17, var19_29, 1, 1);
                    }
                }
                if (var17_21.isWaved()) {
                    var19_30 = var5_14 + 1;
                    for (var13_18 = var3_3; var13_18 < var3_3 + var16_19; var13_18 += 4) {
                        if (var13_18 + 2 <= var3_3 + var16_19 - 1) {
                            var2_2.drawLine(var13_18, var19_30 + 2, var13_18 + 2, var19_30);
                        }
                        if (var13_18 + 4 > var3_3 + var16_19 - 1) continue;
                        var2_2.drawLine(var13_18 + 3, var19_30 + 1, var13_18 + 4, var19_30 + 2);
                    }
                }
                if (var17_21.getLineStroke() != null) {
                    ((Graphics2D)var2_2).setStroke((Stroke)var11_10);
                }
            }
            if (var18_22) break;
            var3_3 += var16_19;
        }
        var2_2.setColor(var7_6);
    }

    static {
        styledLabelUI = new BasicStyledLabelUI();
    }

    final class StyledText {
        StyleRange styleRange;
        String text;

        public StyledText(BasicStyledLabelUI basicStyledLabelUI, String string) {
            this.text = string;
        }

        public StyledText(BasicStyledLabelUI basicStyledLabelUI, String string, StyleRange styleRange) {
            this.text = string;
            this.styleRange = styleRange;
        }
    }
}

