/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.popup.JidePopup;
import com.jidesoft.popup.JidePopupFactory;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.Resource;
import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.SearchableBarIconsFactory;
import com.jidesoft.swing.SearchableProvider;
import com.jidesoft.swing.event.SearchableEvent;
import com.jidesoft.swing.event.SearchableListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public final class SearchableBar
extends JToolBar
implements SearchableProvider {
    private Searchable _searchable;
    private JLabel _statusLabel;
    private JTextField _textField;
    private AbstractButton _closeButton;
    private AbstractButton _findPrevButton;
    private AbstractButton _findNextButton;
    protected AbstractButton _highlightsButton;
    private AbstractButton _matchCaseCheckBox;
    private AbstractButton _repeatCheckBox;
    private int _visibleButtons = -17;
    private boolean _compact;
    private JidePopup _messagePopup;
    private MouseMotionListener _mouseMotionListener;
    private KeyListener _keyListener;
    private static final Color DEFAULT_MISMATCH_BACKGROUND = new Color(255, 85, 85);
    private Installer _installer;

    private SearchableBar(Searchable searchable) {
        this(searchable, "", false);
    }

    private SearchableBar(Searchable object, String string, boolean bl) {
        this.setFloatable(false);
        this.setRollover(true);
        this._searchable = object;
        this._searchable.addSearchableListener(new SearchableListener(this){
            private /* synthetic */ SearchableBar this$0;
            {
                this.this$0 = searchableBar;
            }

            public final void searchableEventFired(SearchableEvent searchableEvent) {
                if (searchableEvent.getID() == 3005) {
                    SearchableBar.access$000(this.this$0);
                }
            }
        });
        this._searchable.setSearchableProvider(this);
        this._compact = false;
        object = this;
        AbstractAction abstractAction = new AbstractAction((SearchableBar)object){
            private /* synthetic */ SearchableBar this$0;
            {
                this.this$0 = searchableBar;
            }

            public final void actionPerformed(ActionEvent actionEvent) {
                if (this.this$0.getInstaller() != null) {
                    this.this$0.getInstaller().closeSearchBar(this.this$0);
                }
            }
        };
        AbstractAction abstractAction2 = new AbstractAction((SearchableBar)object){
            private /* synthetic */ SearchableBar this$0;
            {
                this.this$0 = searchableBar;
            }

            public final void actionPerformed(ActionEvent object) {
                this.this$0._highlightsButton.setSelected(false);
                object = this.this$0.getSearchingText();
                int n = this.this$0._searchable.getSelectedIndex();
                this.this$0._searchable.setCursor(n);
                int n2 = this.this$0._searchable.findNext((String)object);
                if (n2 != -1 && this.this$0._searchable.isRepeats() && n2 <= n) {
                    this.this$0.select(n2, (String)object, false);
                    this.this$0.setStatus(SearchableBar.getResourceString("SearchableBar.reachedBottomRepeat"), SearchableBar.getImageIcon("icons/repeat.png"));
                    return;
                }
                if (!this.this$0._searchable.isRepeats() && n2 == -1) {
                    this.this$0.setStatus(SearchableBar.getResourceString("SearchableBar.reachedBottom"), SearchableBar.getImageIcon("icons/error.png"));
                    return;
                }
                if (n2 != -1) {
                    this.this$0.select(n2, (String)object, false);
                    this.this$0.clearStatus();
                }
            }
        };
        AbstractAction abstractAction3 = new AbstractAction((SearchableBar)object){
            private /* synthetic */ SearchableBar this$0;
            {
                this.this$0 = searchableBar;
            }

            public final void actionPerformed(ActionEvent object) {
                this.this$0._highlightsButton.setSelected(false);
                object = this.this$0.getSearchingText();
                int n = this.this$0._searchable.getSelectedIndex();
                this.this$0._searchable.setCursor(n);
                int n2 = this.this$0._searchable.findPrevious((String)object);
                if (n2 != -1 && this.this$0._searchable.isRepeats() && n2 >= n) {
                    this.this$0.select(n2, (String)object, false);
                    this.this$0.setStatus(SearchableBar.getResourceString("SearchableBar.reachedTopRepeat"), SearchableBar.getImageIcon("icons/repeat.png"));
                    return;
                }
                if (!this.this$0._searchable.isRepeats() && n2 == -1) {
                    this.this$0.setStatus(SearchableBar.getResourceString("SearchableBar.reachedTop"), SearchableBar.getImageIcon("icons/error.png"));
                    return;
                }
                if (n2 != -1) {
                    this.this$0.select(n2, (String)object, false);
                    this.this$0.clearStatus();
                }
            }
        };
        ((SearchableBar)object)._mouseMotionListener = new MouseMotionListener((SearchableBar)object){
            private /* synthetic */ SearchableBar this$0;
            {
                this.this$0 = searchableBar;
            }

            public final void mouseMoved(MouseEvent mouseEvent) {
                this.this$0.hideMessage();
            }

            public final void mouseDragged(MouseEvent mouseEvent) {
            }
        };
        ((SearchableBar)object)._keyListener = new KeyListener((SearchableBar)object){
            private /* synthetic */ SearchableBar this$0;
            {
                this.this$0 = searchableBar;
            }

            public final void keyTyped(KeyEvent keyEvent) {
                this.this$0.hideMessage();
            }

            public final void keyPressed(KeyEvent keyEvent) {
            }

            public final void keyReleased(KeyEvent keyEvent) {
            }
        };
        Serializable serializable = abstractAction;
        Object object2 = object;
        object2 = new JButton(SearchableBar.getImageIcon("icons/close.png"));
        ((AbstractButton)object2).addActionListener((ActionListener)((Object)serializable));
        ((AbstractButton)object2).setRolloverEnabled(true);
        ((JComponent)object2).setBorder(BorderFactory.createEmptyBorder());
        ((JComponent)object2).setOpaque(false);
        ((JComponent)object2).setRequestFocusEnabled(false);
        ((Component)object2).setFocusable(false);
        ((AbstractButton)object2).setRolloverIcon(SearchableBar.getImageIcon("icons/closeR.png"));
        ((SearchableBar)object)._closeButton = object2;
        serializable = abstractAction2;
        object2 = object;
        object2 = new JButton(((SearchableBar)object2)._compact ? "" : SearchableBar.getResourceString("SearchableBar.findNext"), SearchableBar.getImageIcon("icons/next.png"));
        ((JComponent)object2).setToolTipText(SearchableBar.getResourceString("SearchableBar.findNext.tooltip"));
        ((AbstractButton)object2).setMnemonic(SearchableBar.getResourceString("SearchableBar.findNext.mnemonic").charAt(0));
        ((AbstractButton)object2).setRolloverIcon(SearchableBar.getImageIcon("icons/nextR.png"));
        ((AbstractButton)object2).setDisabledIcon(SearchableBar.getImageIcon("icons/nextD.png"));
        ((JComponent)object2).setRequestFocusEnabled(false);
        ((Component)object2).setFocusable(false);
        ((AbstractButton)object2).addActionListener((ActionListener)((Object)serializable));
        ((AbstractButton)object2).setEnabled(false);
        ((SearchableBar)object)._findNextButton = object2;
        serializable = abstractAction3;
        object2 = object;
        object2 = new JButton(((SearchableBar)object2)._compact ? "" : SearchableBar.getResourceString("SearchableBar.findPrevious"), SearchableBar.getImageIcon("icons/previous.png"));
        ((JComponent)object2).setToolTipText(SearchableBar.getResourceString("SearchableBar.findPrevious.tooltip"));
        ((AbstractButton)object2).setMnemonic(SearchableBar.getResourceString("SearchableBar.findPrevious.mnemonic").charAt(0));
        ((AbstractButton)object2).setRolloverIcon(SearchableBar.getImageIcon("icons/previousR.png"));
        ((AbstractButton)object2).setDisabledIcon(SearchableBar.getImageIcon("icons/previousD.png"));
        ((JComponent)object2).setRequestFocusEnabled(false);
        ((Component)object2).setFocusable(false);
        ((AbstractButton)object2).addActionListener((ActionListener)((Object)serializable));
        ((AbstractButton)object2).setEnabled(false);
        ((SearchableBar)object)._findPrevButton = object2;
        object2 = object;
        serializable = new JToggleButton(((SearchableBar)object2)._compact ? "" : SearchableBar.getResourceString("SearchableBar.highlights"), SearchableBar.getImageIcon("icons/highlights.png"));
        ((JComponent)serializable).setToolTipText(SearchableBar.getResourceString("SearchableBar.highlights.tooltip"));
        ((AbstractButton)serializable).setMnemonic(SearchableBar.getResourceString("SearchableBar.highlights.mnemonic").charAt(0));
        ((AbstractButton)serializable).setSelectedIcon(SearchableBar.getImageIcon("icons/highlightsS.png"));
        ((AbstractButton)serializable).setDisabledIcon(SearchableBar.getImageIcon("icons/highlightsD.png"));
        ((AbstractButton)serializable).setRolloverIcon(SearchableBar.getImageIcon("icons/highlightsR.png"));
        ((AbstractButton)serializable).setRolloverSelectedIcon(SearchableBar.getImageIcon("icons/highlightsRS.png"));
        ((JComponent)serializable).setRequestFocusEnabled(false);
        ((Component)serializable).setFocusable(false);
        object2 = new AbstractAction((SearchableBar)object2){
            private /* synthetic */ SearchableBar this$0;
            {
                this.this$0 = searchableBar;
            }

            public final void actionPerformed(ActionEvent actionEvent) {
                SearchableBar.access$000(this.this$0);
            }
        };
        ((AbstractButton)serializable).addActionListener((ActionListener)object2);
        ((AbstractButton)serializable).setEnabled(false);
        ((SearchableBar)object)._highlightsButton = serializable;
        object2 = object;
        serializable = new JCheckBox(SearchableBar.getResourceString("SearchableBar.matchCase"));
        ((AbstractButton)serializable).setMnemonic(SearchableBar.getResourceString("SearchableBar.matchCase.mnemonic").charAt(0));
        ((JComponent)serializable).setRequestFocusEnabled(false);
        ((Component)serializable).setFocusable(false);
        Object object3 = object2;
        ((AbstractButton)serializable).setSelected(((SearchableBar)object3)._searchable.isCaseSensitive());
        ((AbstractButton)serializable).addItemListener(new ItemListener((SearchableBar)object2){
            private /* synthetic */ SearchableBar this$0;
            {
                this.this$0 = searchableBar;
            }

            public final void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getSource() instanceof AbstractButton) {
                    this.this$0.getSearchable().setCaseSensitive(((AbstractButton)itemEvent.getSource()).isSelected());
                    SearchableBar.access$000(this.this$0);
                }
            }
        });
        ((SearchableBar)object)._matchCaseCheckBox = serializable;
        object2 = object;
        serializable = new JCheckBox(SearchableBar.getResourceString("SearchableBar.repeats"));
        ((AbstractButton)serializable).setMnemonic(SearchableBar.getResourceString("SearchableBar.repeats.mnemonic").charAt(0));
        ((JComponent)serializable).setRequestFocusEnabled(false);
        ((Component)serializable).setFocusable(false);
        object3 = object2;
        ((AbstractButton)serializable).setSelected(((SearchableBar)object3)._searchable.isRepeats());
        ((AbstractButton)serializable).addItemListener(new ItemListener((SearchableBar)object2){
            private /* synthetic */ SearchableBar this$0;
            {
                this.this$0 = searchableBar;
            }

            public final void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getSource() instanceof AbstractButton) {
                    this.this$0.getSearchable().setRepeats(((AbstractButton)itemEvent.getSource()).isSelected());
                }
            }
        });
        ((SearchableBar)object)._repeatCheckBox = serializable;
        ((SearchableBar)object)._statusLabel = new JLabel();
        ((SearchableBar)object)._textField = new JTextField();
        ((SearchableBar)object)._textField.addFocusListener(new FocusAdapter((SearchableBar)object){
            private /* synthetic */ SearchableBar this$0;
            {
                this.this$0 = searchableBar;
            }

            public final void focusGained(FocusEvent focusEvent) {
                this.this$0._textField.selectAll();
            }
        });
        ((SearchableBar)object)._textField.setColumns(13);
        ((SearchableBar)object)._textField.getDocument().addDocumentListener(new DocumentListener(){
            private Timer timer;
            {
                SearchableBar.this = SearchableBar.this._searchable;
                this.timer = new Timer(0, new ActionListener(this){
                    private /* synthetic */ 8 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public final void actionPerformed(ActionEvent actionEvent) {
                        SearchableBar.access$000(this.this$1.SearchableBar.this);
                    }
                });
            }

            public final void insertUpdate(DocumentEvent documentEvent) {
                this.startTimer();
            }

            public final void removeUpdate(DocumentEvent documentEvent) {
                this.startTimer();
            }

            public final void changedUpdate(DocumentEvent documentEvent) {
                this.startTimer();
            }

            private void startTimer() {
                Searchable searchable = SearchableBar.this._searchable;
                SearchableBar.access$000(SearchableBar.this);
            }
        });
        ((SearchableBar)object)._textField.setText(string);
        ((SearchableBar)object)._textField.registerKeyboardAction(abstractAction2, KeyStroke.getKeyStroke(40, 0), 0);
        ((SearchableBar)object)._textField.registerKeyboardAction(abstractAction2, KeyStroke.getKeyStroke(10, 0), 0);
        ((SearchableBar)object)._textField.registerKeyboardAction(abstractAction3, KeyStroke.getKeyStroke(38, 0), 0);
        ((SearchableBar)object)._textField.registerKeyboardAction(abstractAction, KeyStroke.getKeyStroke(27, 0), 0);
        object2 = object;
        ((JComponent)object2).setBorder(BorderFactory.createEtchedBorder());
        ((JToolBar)object2).setLayout(new JideBoxLayout((Container)object2, 0));
        ((Container)object2).add(Box.createHorizontalStrut(4), "fix");
        if ((((SearchableBar)object2)._visibleButtons & 1) != 0) {
            ((Container)object2).add(((SearchableBar)object2)._closeButton);
            ((Container)object2).add(Box.createHorizontalStrut(10));
        }
        serializable = new JLabel(SearchableBar.getResourceString("SearchableBar.find"));
        ((JLabel)serializable).setDisplayedMnemonic(SearchableBar.getResourceString("SearchableBar.find.mnemonic").charAt(0));
        ((JLabel)serializable).setLabelFor(((SearchableBar)object2)._textField);
        ((Container)object2).add((Component)serializable);
        ((Container)object2).add(Box.createHorizontalStrut(2), "fix");
        ((Container)object2).add((Component)JideSwingUtilities.createCenterPanel(((SearchableBar)object2)._textField), "fix");
        ((Container)object2).add(Box.createHorizontalStrut(2), "fix");
        if ((((SearchableBar)object2)._visibleButtons & 2) != 0) {
            ((Container)object2).add(((SearchableBar)object2)._findNextButton);
            ((Container)object2).add(((SearchableBar)object2)._findPrevButton);
        }
        if ((((SearchableBar)object2)._visibleButtons & 4) != 0) {
            ((Container)object2).add(((SearchableBar)object2)._highlightsButton);
        }
        if ((((SearchableBar)object2)._visibleButtons & 8) != 0) {
            ((Container)object2).add(((SearchableBar)object2)._matchCaseCheckBox);
        }
        if ((((SearchableBar)object2)._visibleButtons & 0x10) != 0) {
            ((Container)object2).add(((SearchableBar)object2)._repeatCheckBox);
        }
        if ((((SearchableBar)object2)._visibleButtons & 0x20) != 0) {
            ((Container)object2).add(Box.createHorizontalStrut(24));
            ((Container)object2).add((Component)((SearchableBar)object2)._statusLabel, "vary");
        }
        ((Container)object2).add(Box.createHorizontalStrut(6), "fix");
        int n = ((SearchableBar)object)._searchable.findFromCursor(((SearchableBar)object).getSearchingText());
        if (string.length() != 0 && n == -1) {
            ((SearchableBar)object).select(n, string, false);
        }
    }

    public final Searchable getSearchable() {
        return this._searchable;
    }

    private void clearStatus() {
        this._statusLabel.setIcon(null);
        this._statusLabel.setText("");
        this._textField.setBackground(UIDefaultsLookup.getColor("TextField.background"));
        this.hideMessage();
    }

    private void setStatus(String object, Icon object2) {
        this._statusLabel.setIcon((Icon)object2);
        this._statusLabel.setText((String)object);
        this._statusLabel.setToolTipText((String)object);
        if (!this._statusLabel.isShowing() || this._statusLabel.getWidth() < 25) {
            object2 = object;
            object = this;
            ((SearchableBar)object).hideMessage();
            JidePopupFactory.getSharedInstance();
            ((SearchableBar)object)._messagePopup = JidePopupFactory.createPopup();
            object2 = new JLabel((String)object2);
            ((JComponent)object2).setOpaque(true);
            ((JComponent)object2).setFont(UIDefaultsLookup.getFont("Label.font").deriveFont(1, 11.0f));
            ((JComponent)object2).setBackground(new Color(253, 254, 226));
            ((JComponent)object2).setBorder(BorderFactory.createEmptyBorder(2, 6, 2, 6));
            ((JComponent)object2).setForeground(UIDefaultsLookup.getColor("ToolTip.foreground"));
            JidePopup jidePopup = ((SearchableBar)object)._messagePopup;
            jidePopup.getRootPane().getContentPane().setLayout(new BorderLayout());
            jidePopup = ((SearchableBar)object)._messagePopup;
            jidePopup.getRootPane().getContentPane().add((Component)object2);
            ((SearchableBar)object)._messagePopup.setOwner(((SearchableBar)object)._textField);
            ((SearchableBar)object)._messagePopup.setDefaultMoveOperation(0);
            ((SearchableBar)object)._messagePopup.setTransient(true);
            ((SearchableBar)object)._messagePopup.showPopup();
            ((Component)object).addMouseMotionListener(((SearchableBar)object)._mouseMotionListener);
            ((SearchableBar)object)._textField.addKeyListener(((SearchableBar)object)._keyListener);
        }
    }

    public final void focusSearchField() {
        if (this._textField != null) {
            this._textField.requestFocus();
        }
    }

    protected final void select(int n, String string, boolean bl) {
        if (n != -1) {
            this._searchable.setSelectedIndex(n, bl);
            this._searchable.setCursor(n, bl);
            this._textField.setBackground(UIDefaultsLookup.getColor("TextField.background"));
        } else {
            this._searchable.setSelectedIndex(-1, false);
            SearchableBar searchableBar = this;
            this._textField.setBackground(DEFAULT_MISMATCH_BACKGROUND);
        }
        this._searchable.firePropertyChangeEvent(string);
        if (n != -1) {
            Object object = this._searchable.getElementAt(n);
            this._searchable.fireSearchableEvent(new SearchableEvent(this._searchable, 3002, string, object, this._searchable.convertElementToString(object)));
            return;
        }
        this._searchable.fireSearchableEvent(new SearchableEvent(this._searchable, 3003, string));
    }

    public final String getSearchingText() {
        if (this._textField != null) {
            return this._textField.getText();
        }
        return "";
    }

    public final boolean isPassive() {
        return false;
    }

    public final Installer getInstaller() {
        return this._installer;
    }

    public static SearchableBar install(Searchable searchable, KeyStroke keyStroke, Installer object) {
        SearchableBar searchableBar = new SearchableBar(searchable);
        Installer installer = object;
        object = searchableBar;
        searchableBar._installer = installer;
        ((JComponent)searchable.getComponent()).registerKeyboardAction(new AbstractAction(searchableBar){
            private /* synthetic */ SearchableBar val$searchableBar;
            {
                this.val$searchableBar = searchableBar;
            }

            public final void actionPerformed(ActionEvent actionEvent) {
                this.val$searchableBar.getInstaller().openSearchBar(this.val$searchableBar);
                this.val$searchableBar.focusSearchField();
            }
        }, keyStroke, 1);
        return searchableBar;
    }

    public final void processKeyEvent(KeyEvent keyEvent) {
    }

    protected static ImageIcon getImageIcon(String string) {
        if (string != null) {
            return IconsFactory.getImageIcon(SearchableBarIconsFactory.class, string);
        }
        return null;
    }

    protected static String getResourceString(String string) {
        return Resource.getResourceBundle(Locale.getDefault()).getString(string);
    }

    private void hideMessage() {
        if (this._messagePopup != null) {
            this._messagePopup.hidePopupImmediately();
            this._messagePopup = null;
        }
        if (this._mouseMotionListener != null) {
            this.removeMouseMotionListener(this._mouseMotionListener);
        }
        if (this._keyListener != null) {
            this._textField.removeKeyListener(this._keyListener);
        }
    }

    static /* synthetic */ void access$000(SearchableBar searchableBar) {
        if (searchableBar._highlightsButton.isSelected()) {
            String string = searchableBar.getSearchingText();
            if (string != null && string.length() != 0) {
                boolean bl = searchableBar._searchable.isRepeats();
                searchableBar._searchable.setRepeats(false);
                int n = searchableBar._searchable.findFirst(string);
                if (n != -1) {
                    searchableBar._searchable.setSelectedIndex(n, false);
                    searchableBar._searchable.setCursor(n);
                    searchableBar._findNextButton.setEnabled(true);
                    searchableBar._findPrevButton.setEnabled(true);
                    searchableBar._highlightsButton.setEnabled(true);
                    searchableBar.clearStatus();
                } else {
                    searchableBar.select(-1, string, false);
                    searchableBar._findNextButton.setEnabled(false);
                    searchableBar._findPrevButton.setEnabled(false);
                    searchableBar._highlightsButton.setEnabled(false);
                    searchableBar.setStatus(SearchableBar.getResourceString("SearchableBar.notFound"), SearchableBar.getImageIcon("icons/error.png"));
                }
                int n2 = -1;
                while (n != -1) {
                    int n3 = searchableBar._searchable.findNext(string);
                    if ((n = n == n3 ? -1 : n3) == -1) continue;
                    if (n2 == -1) {
                        n2 = n;
                    }
                    searchableBar.select(n, string, true);
                }
                if (n2 != -1) {
                    searchableBar.select(n2, string, true);
                }
                searchableBar._searchable.setRepeats(bl);
                searchableBar._searchable.setCursor(0);
                return;
            }
        } else {
            String string = searchableBar.getSearchingText();
            if (string == null || string.length() == 0) {
                searchableBar._findNextButton.setEnabled(false);
                searchableBar._findPrevButton.setEnabled(false);
                searchableBar._highlightsButton.setEnabled(false);
                searchableBar.clearStatus();
                return;
            }
            int n = searchableBar._searchable.findFromCursor(string);
            if (n == -1) {
                searchableBar.select(-1, "", false);
                searchableBar._findNextButton.setEnabled(false);
                searchableBar._findPrevButton.setEnabled(false);
                searchableBar._highlightsButton.setEnabled(false);
                searchableBar.setStatus(SearchableBar.getResourceString("SearchableBar.notFound"), SearchableBar.getImageIcon("icons/error.png"));
                return;
            }
            searchableBar.select(n, string, false);
            searchableBar._findNextButton.setEnabled(true);
            searchableBar._findPrevButton.setEnabled(true);
            searchableBar._highlightsButton.setEnabled(true);
            searchableBar.clearStatus();
        }
    }

    public static interface Installer {
        public void openSearchBar(SearchableBar var1);

        public void closeSearchBar(SearchableBar var1);
    }
}

