/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.event.SearchableEvent;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public final class TextComponentSearchable
extends Searchable
implements PropertyChangeListener,
DocumentListener {
    private Highlighter.HighlightPainter _highlightPainter;
    private static final Color DEFAULT_HIGHLIGHT_COLOR = new Color(204, 204, 255);
    private Color _highlightColor = null;
    private int _selectedIndex = -1;
    private HighlighCache _highlighCache = new HighlighCache(this);
    private String _text = null;

    public TextComponentSearchable(JTextComponent object) {
        super((JComponent)object);
        object = this;
        Serializable serializable = new AbstractAction((TextComponentSearchable)object){
            private /* synthetic */ TextComponentSearchable this$0;
            {
                this.this$0 = textComponentSearchable;
            }

            public final void actionPerformed(ActionEvent actionEvent) {
                this.this$0.removeAllHighlights();
            }
        };
        ((TextComponentSearchable)object)._component.registerKeyboardAction((ActionListener)((Object)serializable), KeyStroke.getKeyStroke(27, 0), 0);
        serializable = DEFAULT_HIGHLIGHT_COLOR;
        object = this;
        this._highlightColor = serializable;
        ((TextComponentSearchable)object)._highlightPainter = new DefaultHighlighter.DefaultHighlightPainter(((TextComponentSearchable)object)._highlightColor);
    }

    public final void installListeners() {
        super.installListeners();
        if (this._component instanceof JTextComponent) {
            ((JTextComponent)this._component).getDocument().addDocumentListener(this);
            this._component.addPropertyChangeListener("document", this);
        }
    }

    public final void uninstallListeners() {
        super.uninstallListeners();
        if (this._component instanceof JTextComponent) {
            ((JTextComponent)this._component).getDocument().removeDocumentListener(this);
            this._component.removePropertyChangeListener("document", this);
        }
    }

    protected final void setSelectedIndex(int n, boolean bl) {
        if (this._component instanceof JTextComponent) {
            if (n == -1) {
                this.removeAllHighlights();
                this._selectedIndex = -1;
                return;
            }
            if (!bl) {
                this.removeAllHighlights();
            }
            String string = this.getSearchingText();
            try {
                boolean bl2 = bl;
                int n2 = n;
                TextComponentSearchable textComponentSearchable = this;
                if (textComponentSearchable._component instanceof JTextComponent) {
                    Object object;
                    JTextComponent jTextComponent = (JTextComponent)textComponentSearchable._component;
                    Object object2 = object = jTextComponent.getHighlighter().addHighlight(n2, n2 + string.length(), textComponentSearchable._highlightPainter);
                    object = textComponentSearchable._highlighCache;
                    ((HashMap)object).put(object2, null);
                    textComponentSearchable._selectedIndex = n2;
                    if (!bl2) {
                        textComponentSearchable.scrollTextVisible(jTextComponent, n2, string.length());
                    }
                }
                return;
            }
            catch (BadLocationException badLocationException) {
                BadLocationException badLocationException2 = badLocationException;
                badLocationException.printStackTrace();
            }
        }
    }

    private void scrollTextVisible(JTextComponent jTextComponent, int n, int n2) {
        if (n != -1) {
            try {
                Rectangle rectangle = jTextComponent.modelToView(n);
                if (rectangle == null) {
                    return;
                }
                Rectangle rectangle2 = jTextComponent.modelToView(n + n2);
                if (rectangle2 == null) {
                    return;
                }
                Rectangle rectangle3 = this._component.getVisibleRect();
                if (rectangle.x <= rectangle3.width) {
                    rectangle.width = rectangle2.x;
                    rectangle.x = 0;
                } else {
                    rectangle.width = rectangle2.x - rectangle.x;
                }
                jTextComponent.scrollRectToVisible(rectangle);
                return;
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    protected final void removeAllHighlights() {
        if (this._component instanceof JTextComponent) {
            Object object = this._highlighCache;
            for (Object e : ((HashMap)object).keySet()) {
                ((JTextComponent)this._component).getHighlighter().removeHighlight(e);
            }
            object = this._highlighCache;
            ((HashMap)object).clear();
        }
    }

    protected final int getSelectedIndex() {
        if (this._component instanceof JTextComponent) {
            return this._selectedIndex;
        }
        return 0;
    }

    protected final Object getElementAt(int n) {
        String string = this.getSearchingText();
        if (string != null && this._component instanceof JTextComponent) {
            int n2;
            int n3 = n + string.length();
            if (n3 > (n2 = this.getElementCount())) {
                n3 = this.getElementCount();
            }
            try {
                return ((JTextComponent)this._component).getDocument().getText(n, n3 - n + 1);
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        return "";
    }

    protected final int getElementCount() {
        if (this._component instanceof JTextComponent) {
            return ((JTextComponent)this._component).getDocument().getLength();
        }
        return 0;
    }

    protected final String convertElementToString(Object object) {
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.hidePopup();
        this._text = null;
        if (propertyChangeEvent.getOldValue() instanceof Document) {
            ((Document)propertyChangeEvent.getNewValue()).removeDocumentListener(this);
        }
        if (propertyChangeEvent.getNewValue() instanceof Document) {
            ((Document)propertyChangeEvent.getNewValue()).addDocumentListener(this);
        }
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }

    public final void insertUpdate(DocumentEvent documentEvent) {
        this.hidePopup();
        this._text = null;
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }

    public final void removeUpdate(DocumentEvent documentEvent) {
        this.hidePopup();
        this._text = null;
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }

    public final void changedUpdate(DocumentEvent documentEvent) {
        this.hidePopup();
        this._text = null;
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }

    protected final boolean isActivateKey(KeyEvent keyEvent) {
        if (this._component instanceof JTextComponent && ((JTextComponent)this._component).isEditable()) {
            return keyEvent.getID() == 401 && keyEvent.getKeyCode() == 70 && (2 & keyEvent.getModifiers()) != 0;
        }
        return super.isActivateKey(keyEvent);
    }

    public final int findLast(String string) {
        if (this._component instanceof JTextComponent) {
            String string2 = this.getDocumentText();
            if (this.isCaseSensitive()) {
                return string2.lastIndexOf(string);
            }
            return string2.toLowerCase().lastIndexOf(string.toLowerCase());
        }
        return super.findLast(string);
    }

    private String getDocumentText() {
        if (this._text == null) {
            Object object = ((JTextComponent)this._component).getDocument();
            try {
                this._text = object = object.getText(0, object.getLength());
            }
            catch (BadLocationException badLocationException) {
                return "";
            }
        }
        return this._text;
    }

    public final int findFirst(String string) {
        if (this._component instanceof JTextComponent) {
            String string2 = this.getDocumentText();
            if (this.isCaseSensitive()) {
                return string2.indexOf(string);
            }
            return string2.toLowerCase().indexOf(string.toLowerCase());
        }
        return super.findFirst(string);
    }

    public final int findFromCursor(String string) {
        if (this.isReverseOrder()) {
            return this.reverseFindFromCursor(string);
        }
        if (this._component instanceof JTextComponent) {
            int n;
            String string2 = this.getDocumentText();
            if (!this.isCaseSensitive()) {
                string2 = string2.toLowerCase();
            }
            String string3 = this.isCaseSensitive() ? string : string.toLowerCase();
            int n2 = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
            if (n2 < 0) {
                n2 = 0;
            }
            if ((n = this.getElementCount()) == 0) {
                if (string.length() > 0) {
                    return -1;
                }
                return 0;
            }
            int n3 = string2.indexOf(string3, n2);
            if (n3 == -1 && (n3 = string2.indexOf(string3, 0)) >= n2) {
                n3 = -1;
            }
            return n3;
        }
        return super.findFromCursor(string);
    }

    public final int reverseFindFromCursor(String string) {
        if (!this.isReverseOrder()) {
            return this.findFromCursor(string);
        }
        if (this._component instanceof JTextComponent) {
            int n;
            String string2 = this.getDocumentText();
            if (!this.isCaseSensitive()) {
                string2 = string2.toLowerCase();
            }
            String string3 = this.isCaseSensitive() ? string : string.toLowerCase();
            int n2 = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
            if (n2 < 0) {
                n2 = 0;
            }
            if ((n = this.getElementCount()) == 0) {
                if (string.length() > 0) {
                    return -1;
                }
                return 0;
            }
            int n3 = string2.lastIndexOf(string3, n2);
            if (n3 == -1 && (n3 = string2.lastIndexOf(string3, string2.length() - 1)) <= n2) {
                n3 = -1;
            }
            return n3;
        }
        return super.findFromCursor(string);
    }

    public final int findNext(String string) {
        if (this._component instanceof JTextComponent) {
            int n;
            String string2 = this.getDocumentText();
            if (!this.isCaseSensitive()) {
                string2 = string2.toLowerCase();
            }
            String string3 = this.isCaseSensitive() ? string : string.toLowerCase();
            int n2 = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
            if (n2 < 0) {
                n2 = 0;
            }
            if ((n = this.getElementCount()) == 0) {
                if (string.length() > 0) {
                    return -1;
                }
                return 0;
            }
            int n3 = string2.indexOf(string3, n2 + 1);
            if (n3 == -1 && this.isRepeats() && (n3 = string2.indexOf(string3, 0)) >= n2) {
                n3 = -1;
            }
            return n3;
        }
        return super.findNext(string);
    }

    public final int findPrevious(String string) {
        if (this._component instanceof JTextComponent) {
            int n;
            String string2 = this.getDocumentText();
            if (!this.isCaseSensitive()) {
                string2 = string2.toLowerCase();
            }
            String string3 = this.isCaseSensitive() ? string : string.toLowerCase();
            int n2 = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
            if (n2 < 0) {
                n2 = 0;
            }
            if ((n = this.getElementCount()) == 0) {
                if (string.length() > 0) {
                    return -1;
                }
                return 0;
            }
            int n3 = string2.lastIndexOf(string3, n2 - 1);
            if (n3 == -1 && this.isRepeats() && (n3 = string2.lastIndexOf(string3, n - 1)) <= n2) {
                n3 = -1;
            }
            return n3;
        }
        return super.findPrevious(string);
    }

    public final void hidePopup() {
        super.hidePopup();
        this._selectedIndex = -1;
    }

    final class HighlighCache
    extends HashMap {
        private HighlighCache(TextComponentSearchable textComponentSearchable, byte by) {
        }

        /* synthetic */ HighlighCache(TextComponentSearchable textComponentSearchable) {
            this(textComponentSearchable, 0);
        }
    }
}

