/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

public class JideFocusTracker {
    private Component compHeighest;
    private FocusListener listenerFocus = null;
    private ContainerListener listenerContainer = null;
    protected transient FocusListener listenerMultiCast;
    private boolean repeat;
    protected transient Component lastFocus = null;

    public JideFocusTracker() {
        boolean bl = true;
        JideFocusTracker jideFocusTracker = this;
        this.repeat = true;
        this.listenerFocus = new MainFocusListener(this);
        this.listenerContainer = new MainContainerListener(this);
    }

    public void setHeighestComponent(Component component) {
        Object object;
        Component component2 = this.compHeighest;
        if (component2 != null) {
            object = component2.getTreeLock();
            synchronized (object) {
                this.removeInternalListeners(component2);
            }
        }
        if (component != null) {
            object = component.getTreeLock();
            synchronized (object) {
                this.addInternalListeners(component);
            }
        }
        this.compHeighest = component;
    }

    public final boolean isRepeating() {
        return this.repeat;
    }

    public final synchronized void addFocusListener(FocusListener focusListener) {
        this.listenerMultiCast = AWTEventMulticaster.add(this.listenerMultiCast, focusListener);
    }

    public final synchronized void removeFocusListener(FocusListener focusListener) {
        this.listenerMultiCast = AWTEventMulticaster.remove(this.listenerMultiCast, focusListener);
    }

    protected final void addInternalListeners(Component component) {
        component.addFocusListener(this.listenerFocus);
        if (component instanceof Container) {
            component = (Container)component;
            ((Container)component).addContainerListener(this.listenerContainer);
            for (int i = 0; i < ((Container)component).getComponentCount(); ++i) {
                this.addInternalListeners(((Container)component).getComponent(i));
            }
        }
    }

    protected final void removeInternalListeners(Component component) {
        component.removeFocusListener(this.listenerFocus);
        if (component instanceof Container) {
            component = (Container)component;
            ((Container)component).removeContainerListener(this.listenerContainer);
            for (int i = 0; i < ((Container)component).getComponentCount(); ++i) {
                this.removeInternalListeners(((Container)component).getComponent(i));
            }
        }
    }

    final class MainFocusListener
    implements FocusListener {
        private /* synthetic */ JideFocusTracker this$0;

        MainFocusListener(JideFocusTracker jideFocusTracker) {
            this.this$0 = jideFocusTracker;
        }

        public final void focusGained(FocusEvent focusEvent) {
            if (this.this$0.listenerMultiCast != null && (focusEvent.getSource() != null || this.this$0.isRepeating())) {
                this.this$0.listenerMultiCast.focusGained(focusEvent);
            }
        }

        public final void focusLost(FocusEvent focusEvent) {
            if (this.this$0.listenerMultiCast != null && (focusEvent.getSource() != null || this.this$0.isRepeating())) {
                this.this$0.listenerMultiCast.focusLost(focusEvent);
            }
        }
    }

    final class MainContainerListener
    implements ContainerListener {
        private /* synthetic */ JideFocusTracker this$0;

        MainContainerListener(JideFocusTracker jideFocusTracker) {
            this.this$0 = jideFocusTracker;
        }

        public final void componentAdded(ContainerEvent containerEvent) {
            Object object = containerEvent.getChild().getTreeLock();
            synchronized (object) {
                this.this$0.addInternalListeners(containerEvent.getChild());
                return;
            }
        }

        public final void componentRemoved(ContainerEvent containerEvent) {
            Object object = containerEvent.getChild().getTreeLock();
            synchronized (object) {
                this.this$0.removeInternalListeners(containerEvent.getChild());
                return;
            }
        }
    }
}

