/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.transport.httptunnel.client;

import com.sun.messaging.jmq.transport.httptunnel.HttpTunnelConnection;
import com.sun.messaging.jmq.transport.httptunnel.HttpTunnelDefaults;
import com.sun.messaging.jmq.transport.httptunnel.HttpTunnelDriver;
import com.sun.messaging.jmq.transport.httptunnel.HttpTunnelPacket;
import com.sun.messaging.jmq.transport.httptunnel.client.HttpTunnelPush;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpTunnelClientDriver
extends Thread
implements HttpTunnelDefaults,
HttpTunnelDriver {
    private static boolean DEBUG = Boolean.getBoolean("httptunnel.debug");
    private boolean stopThread = false;
    private String urlString = null;
    private String urlParam = null;
    private URL pushUrl = null;
    private URL pullUrl = null;
    private URLConnection uc = null;
    private HttpTunnelPush pushWorker = null;
    private int connId;
    private HttpTunnelConnection conn = null;
    private long lastConnectTime = 0L;
    private Logger logger = Logger.getLogger("Http Tunneling");

    public HttpTunnelClientDriver(String string) {
        int n = string.lastIndexOf(63);
        if (n >= 0) {
            this.urlString = string.substring(0, n);
            this.urlParam = "&" + string.substring(n + 1);
        } else {
            this.urlString = string;
            this.urlParam = "";
        }
        this.setName("HttpTunnelClientDriver");
        this.setDaemon(true);
        this.pushWorker = new HttpTunnelPush();
    }

    private void handleConnInitAck(HttpTunnelPacket httpTunnelPacket) {
        if (this.conn != null) {
            return;
        }
        this.conn = new HttpTunnelConnection(this.connId, this);
    }

    private void handleConnClose(HttpTunnelPacket httpTunnelPacket) {
        if (this.conn == null) {
            return;
        }
        this.conn.handleClose(httpTunnelPacket);
    }

    private void handleConnAbort(HttpTunnelPacket httpTunnelPacket) {
        if (this.conn == null) {
            return;
        }
        this.conn.handleAbort(httpTunnelPacket);
    }

    private void handleConnOption(HttpTunnelPacket httpTunnelPacket) {
        if (this.conn == null) {
            return;
        }
        this.conn.handleConnOption(httpTunnelPacket);
    }

    private void handlePacket(HttpTunnelPacket httpTunnelPacket, boolean bl) {
        if (this.conn == null) {
            return;
        }
        this.conn.receivePacket(httpTunnelPacket, bl);
    }

    private void handleDummyPacket(HttpTunnelPacket httpTunnelPacket) {
        if (DEBUG) {
            this.log("#### Received dummy packet :");
            this.log(httpTunnelPacket + "\n");
        }
    }

    public HttpTunnelConnection doConnect() throws IOException {
        URL uRL = new URL(this.urlString + "?Type=connect" + this.urlParam);
        HttpTunnelPacket httpTunnelPacket = new HttpTunnelPacket();
        httpTunnelPacket.setPacketType(1);
        httpTunnelPacket.setPacketBody(null);
        httpTunnelPacket.setConnId(0);
        httpTunnelPacket.setSequence(0);
        httpTunnelPacket.setWinsize(0);
        httpTunnelPacket.setChecksum(0);
        try {
            HttpTunnelPacket httpTunnelPacket2 = this.pushWorker.sendPacketDirect(uRL, httpTunnelPacket, true);
            this.connId = httpTunnelPacket2.getConnId();
            String string = new String(httpTunnelPacket2.getPacketBody(), "UTF8");
            String string2 = "&" + string;
            if (!this.urlParam.equals("") && !string2.equals(this.urlParam)) {
                throw new IOException("Unexpected new ServerName: " + string);
            }
            if (this.urlParam.equals("")) {
                this.urlParam = string2;
            }
            this.pushUrl = new URL(this.urlString + "?Type=push" + this.urlParam);
            this.pullUrl = new URL(this.urlString + "?Type=pull&ConnId=" + this.connId + this.urlParam);
            while (this.conn == null) {
                HttpTunnelPacket httpTunnelPacket3;
                Vector vector = this.pullPackets();
                if (vector == null || vector.size() == 0 || (httpTunnelPacket3 = (HttpTunnelPacket)vector.elementAt(0)) == null) continue;
                switch (httpTunnelPacket3.getPacketType()) {
                    case 7: {
                        throw new IOException("Connection refused");
                    }
                    case 2: {
                        this.handleConnInitAck(httpTunnelPacket3);
                        break;
                    }
                    case 5: {
                        this.handleConnClose(httpTunnelPacket);
                    }
                }
            }
        }
        catch (Exception exception) {
            String string = "Connection refused : ";
            if (exception instanceof EOFException) {
                string = "Connection refused : Make sure that the broker is running and its HTTP service is active...";
            }
            if (exception.getMessage() != null) {
                string = string + exception.getMessage();
            }
            ConnectException connectException = new ConnectException(string);
            try {
                connectException.initCause(exception);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw connectException;
        }
        this.pushWorker.startPushThread(this.pushUrl);
        this.start();
        return this.conn;
    }

    public void sendPacket(HttpTunnelPacket httpTunnelPacket) {
        this.pushWorker.sendPacket(httpTunnelPacket);
        if (DEBUG) {
            this.log("Sending packet" + httpTunnelPacket);
        }
    }

    public void shutdown(int n) {
        this.pushWorker.shutdown();
        this.stopThread = true;
        if (this.uc != null && this.uc instanceof HttpURLConnection) {
            try {
                ((HttpURLConnection)this.uc).disconnect();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.conn = null;
    }

    private Vector pullPackets() throws Exception {
        Vector<HttpTunnelPacket> vector = null;
        int n = 200;
        try {
            this.uc = this.pullUrl.openConnection();
            this.uc.setDoInput(true);
            this.uc.setDoOutput(false);
            this.uc.setUseCaches(false);
            this.uc.connect();
            if (this.uc instanceof HttpURLConnection) {
                n = ((HttpURLConnection)this.uc).getResponseCode();
            } else {
                this.uc.getContentType();
            }
        }
        catch (IOException iOException) {
            this.handleHTTPConnectError();
            throw iOException;
        }
        if (n != 200) {
            this.handleHTTPConnectError();
        } else {
            this.lastConnectTime = System.currentTimeMillis();
            vector = new Vector<HttpTunnelPacket>();
            InputStream inputStream = this.uc.getInputStream();
            try {
                while (true) {
                    HttpTunnelPacket httpTunnelPacket = new HttpTunnelPacket();
                    httpTunnelPacket.readPacket(inputStream);
                    vector.addElement(httpTunnelPacket);
                }
            }
            catch (Exception exception) {
                HttpTunnelPacket httpTunnelPacket;
                if (vector.size() <= 1 && (vector.size() != 1 || (httpTunnelPacket = (HttpTunnelPacket)vector.elementAt(0)).getPacketType() == 12)) {
                    int n2 = this.conn.getPullPeriod();
                    if (n2 > 0) {
                        try {
                            Thread.sleep(n2 * 1000);
                        }
                        catch (Exception exception2) {}
                    } else {
                        throw exception;
                    }
                }
                inputStream.close();
            }
        }
        this.uc = null;
        return vector;
    }

    private void handleHTTPConnectError() {
        if (this.conn.getConnectionTimeout() <= 0) {
            return;
        }
        if (this.lastConnectTime == 0L) {
            return;
        }
        if (System.currentTimeMillis() - this.lastConnectTime > (long)(this.conn.getConnectionTimeout() * 1000)) {
            HttpTunnelPacket httpTunnelPacket = new HttpTunnelPacket();
            httpTunnelPacket.setPacketType(9);
            httpTunnelPacket.setConnId(this.connId);
            httpTunnelPacket.setSequence(0);
            httpTunnelPacket.setWinsize(0);
            httpTunnelPacket.setChecksum(0);
            httpTunnelPacket.setPacketBody(null);
            this.handleConnAbort(httpTunnelPacket);
        }
    }

    private void handleHttpPullError() {
    }

    public void run() {
        while (!this.stopThread) {
            try {
                HttpTunnelPacket httpTunnelPacket;
                int n;
                Vector vector = this.pullPackets();
                if (vector == null || vector.size() == 0) {
                    this.handleHttpPullError();
                    continue;
                }
                for (n = vector.size() - 1; n >= 0 && (httpTunnelPacket = (HttpTunnelPacket)vector.elementAt(n)).getPacketType() != 4; --n) {
                }
                block13: for (int i = 0; i < vector.size(); ++i) {
                    httpTunnelPacket = (HttpTunnelPacket)vector.elementAt(i);
                    if (httpTunnelPacket.getPacketType() == 7) {
                        // empty if block
                    }
                    if (DEBUG) {
                        this.log("Received packet:" + httpTunnelPacket);
                    }
                    switch (httpTunnelPacket.getPacketType()) {
                        case 5: {
                            this.handleConnClose(httpTunnelPacket);
                            continue block13;
                        }
                        case 9: {
                            this.handleConnAbort(httpTunnelPacket);
                            continue block13;
                        }
                        case 10: {
                            this.handleConnOption(httpTunnelPacket);
                            continue block13;
                        }
                        case 4: 
                        case 6: {
                            this.handlePacket(httpTunnelPacket, i != n);
                            continue block13;
                        }
                        case 100: {
                            this.handleDummyPacket(httpTunnelPacket);
                            continue block13;
                        }
                    }
                }
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                this.handleHttpPullError();
            }
        }
    }

    public Hashtable getDebugState() {
        return new Hashtable();
    }

    private void log(String string) {
        this.logger.log(Level.INFO, string);
    }
}

