/*
 * Decompiled with CFR 0.152.
 */
package com.qbrowser.property;

import com.qbrowser.QBrowserV2;
import com.qbrowser.container.MessageContainer;
import com.qbrowser.property.InputProperty;
import com.qbrowser.property.Property;
import com.qbrowser.property.PropertyUtil;
import java.awt.event.ItemListener;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.ResourceBundle;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.swing.JComboBox;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyInputTable
extends DefaultTableModel {
    private static ResourceBundle resources = QBrowserV2.resources;
    private String[] columnNames = new String[]{resources.getString("qkey.proptable.header.key"), resources.getString("qkey.proptable.header.prop_type"), resources.getString("qkey.proptable.header.prop_value")};
    private LinkedList list = null;

    public PropertyInputTable() {
        this.init();
    }

    public PropertyInputTable(int number_of_initial_rows) {
        this.init();
    }

    public final int findRowNumberFromJComboBox(JComboBox src) {
        if (this.list == null) {
            return -1;
        }
        for (int i = 0; i < this.list.size(); ++i) {
            InputProperty ip = (InputProperty)this.list.get(i);
            if (!src.equals(ip.getType_combo_box())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final int getRowCount() {
        if (this.list == null) {
            return 0;
        }
        return this.list.size();
    }

    @Override
    public final int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public final String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public final Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Object.class;
            }
            case 2: {
                return Object.class;
            }
        }
        return Object.class;
    }

    @Override
    public final boolean isCellEditable(int row, int column) {
        return true;
    }

    @Override
    public final void setValueAt(Object value, int row, int column) {
        if (this.list == null) {
            return;
        }
        if (this.list.size() < row) {
            return;
        }
        Object p = (InputProperty)this.list.get(row);
        if (p == null) {
            return;
        }
        try {
            switch (column) {
                case 0: {
                    if (value instanceof String) {
                        Object object = p;
                        p = (String)value;
                        value = object;
                        ((Property)object).key = p;
                    }
                    return;
                }
                case 1: {
                    if (value instanceof JComboBox) {
                        Object object = p;
                        p = (String)((JComboBox)value).getSelectedItem();
                        value = object;
                        ((Property)object).property_type = p;
                        return;
                    }
                    if (value instanceof String) {
                        Object object = p;
                        p = (String)value;
                        value = object;
                        ((Property)object).property_type = p;
                    }
                    return;
                }
                case 2: {
                    InputProperty inputProperty = p;
                    p = value;
                    value = inputProperty;
                    inputProperty.property_value = p;
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return;
        }
    }

    public final int findRowNumberFromJTextArea(JTextArea src) {
        if (this.list == null) {
            return -1;
        }
        for (int i = 0; i < this.list.size(); ++i) {
            InputProperty ip = (InputProperty)this.list.get(i);
            if (!src.equals(ip.property_value)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final Object getValueAt(int row, int column) {
        if (this.list == null) {
            return null;
        }
        if (this.list.size() < row) {
            return null;
        }
        InputProperty p = (InputProperty)this.list.get(row);
        if (p == null) {
            return "";
        }
        try {
            switch (column) {
                case 0: {
                    return p.key;
                }
                case 1: {
                    return p.getType_combo_box();
                }
                case 2: {
                    return p.property_value;
                }
            }
            return "Bad column value: " + column;
        }
        catch (Exception e) {
            return "Error: " + e;
        }
    }

    public final int load(MessageContainer mc) {
        if (mc == null) {
            return 0;
        }
        Message message = mc.getMessage();
        if (message == null) {
            return 0;
        }
        this.list = new LinkedList();
        try {
            Enumeration enu = message.getPropertyNames();
            while (enu.hasMoreElements()) {
                JComboBox<String> jcbt;
                InputProperty prop;
                String name = enu.nextElement().toString();
                JComboBox<String> propvalueobj = message.getObjectProperty(name);
                InputProperty inputProperty = prop = new InputProperty();
                prop.key = name;
                if (propvalueobj instanceof String) {
                    JTextArea jobj = new JTextArea(1, 10);
                    jobj.setText((String)((Object)propvalueobj));
                    jobj.setToolTipText(resources.getString("qkey.msg.msg230"));
                    inputProperty = prop;
                    prop.property_value = jobj;
                } else if (propvalueobj instanceof Boolean) {
                    jcbt = new JComboBox<String>();
                    jcbt.addItem("true");
                    jcbt.addItem("false");
                    if (((Boolean)((Object)propvalueobj)).booleanValue()) {
                        jcbt.setSelectedIndex(0);
                    } else {
                        jcbt.setSelectedIndex(1);
                    }
                    inputProperty = prop;
                    prop.property_value = jcbt;
                } else {
                    jcbt = propvalueobj;
                    inputProperty = prop;
                    prop.property_value = jcbt;
                }
                prop.autoComplementTypeNme();
                JComboBox jcb = PropertyUtil.getUserPropTypeComboBox();
                inputProperty = prop;
                jcb.setSelectedItem(inputProperty.property_type);
                prop.setType_combo_box(jcb);
                this.list.add(prop);
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        this.fireTableDataChanged();
        return this.list.size();
    }

    private void init() {
        this.list = new LinkedList();
    }

    public final void setMouseListenerInTextAreaAt(int row2, MouseListener lsnr) {
        int n = row2;
        Object row2 = this;
        InputProperty inputProperty = ((PropertyInputTable)row2).getPropertyAtRow(n);
        row2 = inputProperty;
        row2 = inputProperty;
        row2 = inputProperty.property_value;
        JTextArea jta = row2 instanceof JTextArea ? (JTextArea)row2 : null;
        if (jta != null) {
            jta.addMouseListener(lsnr);
        }
    }

    public final void add_one_empty_row() {
        InputProperty ip = new InputProperty();
        JComboBox jcb = PropertyUtil.getUserPropTypeComboBox();
        ip.setType_combo_box(jcb);
        this.list.add(ip);
        this.fireTableDataChanged();
    }

    public final void setItemListenerInComboBoxAt(int row2, ItemListener lsnr) {
        int n = row2;
        Object row2 = this;
        JComboBox jcb = (JComboBox)((InputProperty)(row2 = ((PropertyInputTable)row2).getPropertyAtRow(n))).getType_combo_box();
        if (jcb != null) {
            jcb.addItemListener(lsnr);
        }
    }

    public final void deletePropertyAtRow(int row) {
        if (this.list == null) {
            return;
        }
        this.list.remove(row);
        this.fireTableDataChanged();
    }

    public final InputProperty getPropertyAtRow(int row) {
        if (this.list == null) {
            return null;
        }
        if (this.list.size() < row) {
            return null;
        }
        return (InputProperty)this.list.get(row);
    }
}

