/*
 * Decompiled with CFR 0.152.
 */
package jp.sun.util;

import com.sun.messaging.jmq.admin.apps.broker.BrokerCmdException;
import com.sun.messaging.jmq.admin.apps.broker.BrokerCmdOptions;
import com.sun.messaging.jmq.admin.apps.broker.BrokerCmdProperties;
import com.sun.messaging.jmq.admin.apps.console.event.AdminEvent;
import com.sun.messaging.jmq.admin.apps.console.event.AdminEventListener;
import com.sun.messaging.jmq.admin.apps.console.event.BrokerCmdStatusEvent;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdmin;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdminException;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdminUtil;
import com.sun.messaging.jmq.admin.bkrutil.BrokerConstants;
import com.sun.messaging.jmq.admin.resources.AdminResources;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.io.DestMetricsCounters;
import com.sun.messaging.jmq.io.MetricCounters;
import com.sun.messaging.jmq.jmsclient.GenericPortMapperClient;
import com.sun.messaging.jmq.util.DebugPrinter;
import com.sun.messaging.jmq.util.DestLimitBehavior;
import com.sun.messaging.jmq.util.DestState;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.FileUtil;
import com.sun.messaging.jmq.util.Password;
import com.sun.messaging.jmq.util.ServiceState;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.admin.DestinationInfo;
import com.sun.messaging.jmq.util.admin.DurableInfo;
import com.sun.messaging.jmq.util.admin.ServiceInfo;
import com.sun.messaging.jms.management.server.BrokerState;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import jp.sun.util.BrokerCmdPrinter;

public final class CmdRunner
implements BrokerCmdOptions,
AdminEventListener,
BrokerConstants {
    private int[] zeroNegOneInt = new int[]{0, -1};
    private long[] zeroNegOneLong = new long[]{0L, -1L};
    private String[] zeroNegOneString = new String[]{"0", "-1"};
    private String[] negOneString = new String[]{"-1"};
    private AdminResources ar = Globals.getAdminResources();
    private BrokerCmdProperties brokerCmdProps;
    private int filter_transactionstate = -1;

    public CmdRunner(BrokerCmdProperties props) {
        this.brokerCmdProps = props;
    }

    public final void setFilter_transactionstate(int value) {
        this.filter_transactionstate = value;
    }

    public final String runCommands(StringBuffer result) {
        int exitcode = 0;
        if (this.brokerCmdProps.debugModeSet()) {
            exitcode = this.runDebug(this.brokerCmdProps, result);
            return String.valueOf(exitcode);
        }
        String cmd = this.brokerCmdProps.getCommand();
        if (cmd.equals("list")) {
            exitcode = this.runList(this.brokerCmdProps, result);
        } else if (cmd.equals("pause")) {
            exitcode = this.runPause(this.brokerCmdProps, result);
        } else if (cmd.equals("resume")) {
            exitcode = this.runResume(this.brokerCmdProps, result);
        } else if (cmd.equals("shutdown")) {
            exitcode = this.runShutdown(this.brokerCmdProps, result);
        } else if (cmd.equals("restart")) {
            exitcode = this.runRestart(this.brokerCmdProps, result);
        } else if (cmd.equals("create")) {
            exitcode = this.runCreate(this.brokerCmdProps, result);
        } else if (cmd.equals("destroy")) {
            exitcode = this.runDestroy(this.brokerCmdProps, result);
        } else if (cmd.equals("purge")) {
            exitcode = this.runPurge(this.brokerCmdProps, result);
        } else if (cmd.equals("update")) {
            exitcode = this.runUpdate(this.brokerCmdProps, result);
        } else if (cmd.equals("query")) {
            exitcode = this.runQuery(this.brokerCmdProps, result);
        } else if (cmd.equals("metrics")) {
            exitcode = this.runMetrics(this.brokerCmdProps, result);
        } else if (cmd.equals("reload")) {
            exitcode = this.runReload(this.brokerCmdProps, result);
        } else if (cmd.equals("commit")) {
            exitcode = this.runCommit(this.brokerCmdProps, result);
        } else if (cmd.equals("rollback")) {
            exitcode = this.runRollback(this.brokerCmdProps, result);
        } else if (cmd.equals("compact")) {
            exitcode = this.runCompact(this.brokerCmdProps, result);
        } else if (cmd.equals("quiesce")) {
            exitcode = this.runQuiesce(this.brokerCmdProps, result);
        } else if (cmd.equals("takeover")) {
            exitcode = this.runTakeover(this.brokerCmdProps, result);
        } else if (cmd.equals("unquiesce")) {
            exitcode = this.runUnquiesce(this.brokerCmdProps, result);
        } else if (cmd.equals("reset")) {
            exitcode = this.runReset(this.brokerCmdProps, result);
        } else if (cmd.equals(".exists")) {
            exitcode = this.runExists(this.brokerCmdProps, result);
        } else if (cmd.equals(".getattr")) {
            exitcode = this.runGetAttr(this.brokerCmdProps, result);
        } else if (cmd.equals("._kill")) {
            exitcode = this.runUngracefulKill(this.brokerCmdProps, result);
        } else if (cmd.equals(".purgeall")) {
            exitcode = this.runPurgeAll(this.brokerCmdProps, result);
        } else if (cmd.equals(".destroyall")) {
            exitcode = this.runDestroyAll(this.brokerCmdProps, result);
        }
        return String.valueOf(exitcode);
    }

    public final void adminEventDispatched(AdminEvent e) {
        BrokerCmdStatusEvent be;
        int type;
        if (e instanceof BrokerCmdStatusEvent && (type = (be = (BrokerCmdStatusEvent)e).getType()) == 31) {
            int numRetriesAttempted = be.getNumRetriesAttempted();
            int maxNumRetries = be.getMaxNumRetries();
            long retryTimeount = be.getRetryTimeount();
            Object[] objectArray = new Object[3];
            Object[] args = objectArray;
            objectArray[0] = Integer.toString(numRetriesAttempted);
            args[1] = Integer.toString(maxNumRetries);
            args[2] = Long.toString(retryTimeount);
            String s = this.ar.getString("A1350", args);
            Globals.stdOutPrintln((String)s);
        }
    }

    public final ArrayList retrieveDestinations(boolean isQueue) {
        BrokerAdmin broker = this.init();
        if (broker == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        try {
            CmdRunner.connectToBroker(broker);
            broker.sendGetDestinationsMessage(null, -1);
            Vector dests = broker.receiveGetDestinationsReplyMessage();
            Enumeration thisEnum = dests.elements();
            while (thisEnum.hasMoreElements()) {
                DestinationInfo dInfo = (DestinationInfo)thisEnum.nextElement();
                if ("__JMQAdmin".equals(dInfo.name) || DestType.isInternal((int)dInfo.fulltype) || DestType.isTemporary((int)dInfo.type)) continue;
                if (DestType.isTopic((int)dInfo.type) && !isQueue) {
                    result.add(dInfo.name);
                }
                if (!DestType.isQueue((int)dInfo.type) || !isQueue) continue;
                result.add(dInfo.name);
            }
        }
        catch (Exception exception) {
            Exception e = exception;
            exception.printStackTrace();
        }
        finally {
            if (broker != null) {
                broker.close();
            }
        }
        return result;
    }

    public final DestinationInfo getSpecifiedDestinationInfo() {
        BrokerAdmin broker = this.init();
        if (broker == null) {
            return null;
        }
        DestinationInfo retval = null;
        String destName = this.brokerCmdProps.getTargetName();
        int destTypeMask = CmdRunner.getDestTypeMask(this.brokerCmdProps);
        try {
            CmdRunner.connectToBroker(broker);
            broker.sendGetDestinationsMessage(destName, destTypeMask);
            Vector dest = broker.receiveGetDestinationsReplyMessage();
            if (dest != null && dest.size() == 1) {
                DestinationInfo dInfo;
                Enumeration thisEnum = dest.elements();
                retval = dInfo = (DestinationInfo)thisEnum.nextElement();
            }
        }
        catch (Exception exception) {
            Exception e = exception;
            exception.printStackTrace();
        }
        finally {
            if (broker != null) {
                broker.close();
            }
        }
        return retval;
    }

    public final String retrieveInstanceName() {
        BrokerAdmin broker = this.init();
        if (broker == null) {
            return null;
        }
        String retval = null;
        try {
            CmdRunner.connectToBroker(broker);
            broker.sendGetBrokerPropsMessage();
            Properties bkrProps = broker.receiveGetBrokerPropsReplyMessage();
            retval = bkrProps.getProperty("imq.instancename", "");
        }
        catch (Exception exception) {
            Exception e = exception;
            exception.printStackTrace();
        }
        finally {
            if (broker != null) {
                broker.close();
            }
        }
        return retval;
    }

    /*
     * WARNING - void declaration
     */
    private int runList(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        BrokerCmdPrinter brokercmdprinter4;
        BrokerCmdPrinter brokercmdprinter2;
        void bkrClsInfo2;
        Enumeration thisEnum;
        BrokerCmdPrinter bcp_local;
        void bae6;
        BrokerCmdPrinter bcp;
        void bcp22;
        Object[] row;
        void force2;
        boolean listAll;
        BrokerAdmin broker = this.init();
        String commandArg = brokerCmdProps.getCommandArg();
        String destTypeStr = brokerCmdProps.getDestType();
        int destTypeMask = CmdRunner.getDestTypeMask(brokerCmdProps);
        boolean bl = listAll = destTypeStr == null;
        if ("dst".equals(commandArg)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1203")).append("\n");
                return 1;
            }
            boolean force2 = brokerCmdProps.forceModeSet();
            if (!force2) {
                broker = this.promptForAuthentication(broker);
            }
            if (listAll) {
                sb.append(this.ar.getString("A1201")).append("\n");
            } else if (DestType.isQueue((int)destTypeMask)) {
                sb.append(this.ar.getString("A1291")).append("\n");
            } else if (DestType.isTopic((int)destTypeMask)) {
                sb.append(this.ar.getString("A1290")).append("\n");
            }
            this.printBrokerInfo(broker);
            try {
                CmdRunner.connectToBroker(broker);
                broker.sendGetDestinationsMessage(null, -1);
                Vector dests = broker.receiveGetDestinationsReplyMessage();
                if (dests != null) {
                    if (listAll) {
                        this.listDests(brokerCmdProps, dests, 0);
                    } else if (DestType.isTopic((int)destTypeMask)) {
                        this.listDests(brokerCmdProps, dests, 1);
                    } else if (DestType.isQueue((int)destTypeMask)) {
                        this.listDests(brokerCmdProps, dests, 2);
                    }
                } else {
                    sb.append(this.ar.getString("A1203")).append("\n");
                    return 1;
                }
                sb.append(this.ar.getString("A1202")).append("\n");
            }
            catch (BrokerAdminException bae2) {
                this.handleBrokerAdminException(bae2);
                sb.append(this.ar.getString("A1203")).append("\n");
                return 1;
            }
        }
        if ("svc".equals(force2)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1206")).append("\n");
                return 1;
            }
            boolean force3 = brokerCmdProps.forceModeSet();
            if (!force3) {
                broker = this.promptForAuthentication(broker);
            }
            sb.append(this.ar.getString("A1204")).append("\n");
            this.printBrokerInfo(broker);
            try {
                BrokerCmdPrinter bcp22;
                CmdRunner.connectToBroker(broker);
                broker.sendGetServicesMessage(null);
                Vector svcs = broker.receiveGetServicesReplyMessage();
                if (svcs != null) {
                    bcp22 = new BrokerCmdPrinter(3, 4, "-");
                    Object[] objectArray = new String[3];
                    row = objectArray;
                    objectArray[0] = this.ar.getString("A1420");
                    row[1] = this.ar.getString("A1421");
                    row[2] = this.ar.getString("A1422");
                    bcp22.addTitle((String[])row);
                    Enumeration thisEnum2 = svcs.elements();
                    while (thisEnum2.hasMoreElements()) {
                        ServiceInfo sInfo = (ServiceInfo)thisEnum2.nextElement();
                        row[0] = sInfo.name;
                        if (sInfo.port == -1) {
                            row[1] = "-";
                        } else if (sInfo.dynamicPort) {
                            switch (sInfo.state) {
                                case -1: {
                                    row[1] = this.ar.getString("A1520");
                                    break;
                                }
                                default: {
                                    row[1] = new Integer(sInfo.port).toString() + " (" + this.ar.getString("A1520") + ")";
                                    break;
                                }
                            }
                        } else {
                            row[1] = new Integer(sInfo.port).toString() + " (" + this.ar.getString("A1521") + ")";
                        }
                        row[2] = ServiceState.getString((int)sInfo.state);
                        bcp22.add(row);
                    }
                } else {
                    sb.append(this.ar.getString("A1206")).append("\n");
                    return 1;
                }
                bcp22.println();
                sb.append(this.ar.getString("A1205")).append("\n");
            }
            catch (BrokerAdminException bae3) {
                this.handleBrokerAdminException(bae3);
                sb.append(this.ar.getString("A1206")).append("\n");
                return 1;
            }
        }
        if ("dur".equals(bcp22)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1553")).append("\n");
                return 1;
            }
            boolean force4 = row.forceModeSet();
            if (!force4) {
                broker = this.promptForAuthentication(broker);
            }
            String destName = row.getDestName();
            sb.append(this.ar.getString("A1551", (Object)destName)).append("\n");
            this.printBrokerInfo(broker);
            try {
                CmdRunner.connectToBroker(broker);
            }
            catch (BrokerAdminException bae4) {
                this.handleBrokerAdminException(bae4);
                sb.append(this.ar.getString("A1553")).append("\n");
                return 1;
            }
            try {
                CmdRunner.isDestTypeTopic(broker, destName);
            }
            catch (BrokerAdminException bae5) {
                if (7 == bae5.getType()) {
                    bae5.setBrokerErrorStr(this.ar.getString("A1001") + this.ar.getKString("A3111", (Object)destName));
                }
                this.handleBrokerAdminException(bae5);
                sb.append(this.ar.getString("A1553")).append("\n");
                return 1;
            }
            try {
                broker.sendGetDurablesMessage(destName, null);
                Vector durs = broker.receiveGetDurablesReplyMessage();
                if (durs != null) {
                    bcp = new BrokerCmdPrinter(4, 3, "-");
                    Object[] objectArray = new String[4];
                    Object[] row2 = objectArray;
                    objectArray[0] = this.ar.getString("A1430");
                    row2[1] = this.ar.getString("A1431");
                    row2[2] = this.ar.getString("A1432");
                    row2[3] = this.ar.getString("A1433");
                    bcp.addTitle((String[])row2);
                    Enumeration thisEnum3 = durs.elements();
                    while (thisEnum3.hasMoreElements()) {
                        DurableInfo dInfo = (DurableInfo)thisEnum3.nextElement();
                        row2[0] = dInfo.name == null ? "" : dInfo.name;
                        row2[1] = dInfo.clientID == null ? "" : dInfo.clientID;
                        row2[2] = new Integer(dInfo.nMessages).toString();
                        row2[3] = dInfo.isActive ? this.ar.getString("A1510") : this.ar.getString("A1511");
                        bcp.add(row2);
                    }
                } else {
                    sb.append(this.ar.getString("A1553")).append("\n");
                    return 1;
                }
                bcp.setKeyCriteria(new int[]{0, 1});
                bcp.println();
                sb.append(this.ar.getString("A1552")).append("\n");
            }
            catch (BrokerAdminException bae6) {
                this.handleBrokerAdminException(bae6);
                sb.append(this.ar.getString("A1553")).append("\n");
                return 1;
            }
        }
        if ("txn".equals(bae6)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1253")).append("\n");
                return 1;
            }
            boolean force5 = bcp.forceModeSet();
            if (!force5) {
                broker = this.promptForAuthentication(broker);
            }
            sb.append(this.ar.getString("A1250")).append("\n");
            this.printBrokerInfo(broker);
            try {
                CmdRunner.connectToBroker(broker);
                broker.sendGetTxnsMessage();
                Vector txns = broker.receiveGetTxnsReplyMessage();
                if (txns != null && txns.size() > 0) {
                    BrokerCmdPrinter bcp3 = new BrokerCmdPrinter(5, 3, "-");
                    bcp_local = new BrokerCmdPrinter(4, 3, "-");
                    BrokerCmdPrinter bcp_remote = new BrokerCmdPrinter(4, 3, "-");
                    Object[] objectArray = new String[5];
                    Object[] row3 = objectArray;
                    objectArray[0] = this.ar.getString("A1263");
                    row3[1] = this.ar.getString("A1269");
                    row3[2] = this.ar.getString("A1270");
                    row3[3] = this.ar.getString("A1272");
                    row3[4] = this.ar.getString("A1266");
                    bcp3.addTitle((String[])row3);
                    row3[0] = this.ar.getString("A1263");
                    row3[1] = this.ar.getString("A1269");
                    row3[2] = this.ar.getString("A1270");
                    row3[3] = this.ar.getString("A1266");
                    bcp_local.addTitle((String[])row3);
                    row3[0] = this.ar.getString("A1263");
                    row3[1] = this.ar.getString("A1269");
                    row3[2] = "# Acks";
                    row3[3] = "Remote broker";
                    bcp_remote.addTitle((String[])row3);
                    Enumeration thisEnum4 = txns.elements();
                    while (thisEnum4.hasMoreElements()) {
                        String tmpStr2;
                        String tmpStr;
                        Integer tmpInt;
                        Long tmpLong;
                        Hashtable txnInfo = (Hashtable)thisEnum4.nextElement();
                        Integer type = (Integer)txnInfo.get("type");
                        if (type == 0) {
                            tmpLong = (Long)txnInfo.get("txnid");
                            row3[0] = CmdRunner.checkNullAndPrint(tmpLong);
                            tmpInt = (Integer)txnInfo.get("state");
                            row3[1] = this.getTxnStateString(tmpInt);
                            tmpStr = (String)txnInfo.get("user");
                            row3[2] = CmdRunner.checkNullAndPrint(tmpStr);
                            tmpInt = (Integer)txnInfo.get("nmsgs");
                            tmpStr = CmdRunner.checkNullAndPrint(tmpInt);
                            tmpInt = (Integer)txnInfo.get("nacks");
                            tmpStr2 = CmdRunner.checkNullAndPrint(tmpInt);
                            row3[3] = tmpStr + "/" + tmpStr2;
                            tmpLong = (Long)txnInfo.get("timestamp");
                            row3[4] = CmdRunner.checkNullAndPrintTimestamp(tmpLong);
                            bcp3.add(row3);
                            continue;
                        }
                        if ((Integer)((Object)tmpStr2) == 1) {
                            tmpLong = (Long)txnInfo.get("txnid");
                            row3[0] = CmdRunner.checkNullAndPrint(tmpLong);
                            tmpInt = (Integer)txnInfo.get("state");
                            row3[1] = this.getTxnStateString(tmpInt);
                            tmpStr = (String)txnInfo.get("user");
                            row3[2] = CmdRunner.checkNullAndPrint(tmpStr);
                            tmpLong = (Long)txnInfo.get("timestamp");
                            row3[3] = CmdRunner.checkNullAndPrintTimestamp(tmpLong);
                            bcp_local.add(row3);
                            continue;
                        }
                        if ((Integer)((Object)tmpStr2) != 2) continue;
                        tmpLong = (Long)txnInfo.get("txnid");
                        row3[0] = CmdRunner.checkNullAndPrint(tmpLong);
                        tmpInt = (Integer)txnInfo.get("state");
                        row3[1] = this.getTxnStateString(tmpInt);
                        tmpInt = (Integer)txnInfo.get("nacks");
                        row3[2] = tmpStr2 = CmdRunner.checkNullAndPrint(tmpInt);
                        tmpStr = (String)txnInfo.get("homebroker");
                        row3[3] = CmdRunner.checkNullAndPrint(tmpStr);
                        bcp_remote.add(row3);
                    }
                    sb.append("Transactions that are owned by this broker\n");
                    bcp3.println();
                    sb.append("   Transactions that involve remote brokers\n");
                    bcp_local.setIndent(3);
                    bcp_local.println();
                    sb.append("Transactions that are owned by a remote broker\n");
                    bcp_remote.println();
                    sb.append(this.ar.getString("A1251")).append("\n");
                }
                sb.append(this.ar.getString("A1252")).append("\n");
            }
            catch (BrokerAdminException bae7) {
                this.handleBrokerAdminException(bae7);
                sb.append(this.ar.getString("A1253")).append("\n");
                return 1;
            }
        } else if ("cxn".equals(bcp22)) {
            String svcName = bcp_local.getService();
            if (broker == null) {
                sb.append(this.ar.getString("A1321")).append("\n");
                return 1;
            }
            boolean force6 = bcp_local.forceModeSet();
            if (!force6) {
                broker = this.promptForAuthentication(broker);
            }
            if (svcName == null) {
                sb.append(this.ar.getString("A1318")).append("\n");
                this.printBrokerInfo(broker);
            } else {
                sb.append(this.ar.getString("A1319")).append("\n");
                this.printServiceInfo(svcName);
                sb.append(this.ar.getString("A1200")).append("\n");
                this.printBrokerInfo(broker);
            }
            try {
                CmdRunner.connectToBroker(broker);
                broker.sendGetConnectionsMessage(svcName, null);
                Vector cxnList = broker.receiveGetConnectionsReplyMessage();
                if (cxnList != null && cxnList.size() > 0) {
                    bcp = new BrokerCmdPrinter(6, 2, "-");
                    Object[] objectArray = new String[6];
                    Object[] row4 = objectArray;
                    objectArray[0] = this.ar.getString("A1323");
                    row4[1] = this.ar.getString("A1327");
                    row4[2] = this.ar.getString("A1331");
                    row4[3] = this.ar.getString("A1328");
                    row4[4] = this.ar.getString("A1329");
                    row4[5] = this.ar.getString("A1325");
                    bcp.addTitle((String[])row4);
                    Enumeration thisEnum5 = cxnList.elements();
                    while (thisEnum5.hasMoreElements()) {
                        Hashtable cxnInfo = (Hashtable)thisEnum5.nextElement();
                        Long tmpLong = (Long)cxnInfo.get("cxnid");
                        row4[0] = CmdRunner.checkNullAndPrint(tmpLong);
                        String tmpStr = (String)cxnInfo.get("user");
                        row4[1] = CmdRunner.checkNullAndPrint(tmpStr);
                        tmpStr = (String)cxnInfo.get("service");
                        row4[2] = CmdRunner.checkNullAndPrint(tmpStr);
                        Integer tmpInt = (Integer)cxnInfo.get("nproducers");
                        row4[3] = CmdRunner.checkNullAndPrint(tmpInt);
                        tmpInt = (Integer)cxnInfo.get("nconsumers");
                        row4[4] = CmdRunner.checkNullAndPrint(tmpInt);
                        tmpStr = (String)cxnInfo.get("host");
                        row4[5] = CmdRunner.checkNullAndPrint(tmpStr);
                        bcp.add(row4);
                    }
                    bcp.println();
                    sb.append(this.ar.getString("A1320")).append("\n");
                }
                sb.append(this.ar.getString("A1322")).append("\n");
            }
            catch (BrokerAdminException bae8) {
                this.handleBrokerAdminException(bae8);
                sb.append(this.ar.getString("A1321")).append("\n");
                return 1;
            }
        } else if ("bkr".equals(bae6)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1713")).append("\n");
                return 1;
            }
            boolean force7 = bcp.forceModeSet();
            if (!force7) {
                broker = this.promptForAuthentication(broker);
            }
            sb.append(this.ar.getString("A1712")).append("\n");
            this.printBrokerInfo(broker);
            try {
                CmdRunner.connectToBroker(broker);
                broker.sendGetBrokerPropsMessage();
                Properties bkrProps = broker.receiveGetBrokerPropsReplyMessage();
                BrokerCmdPrinter haBcp = new BrokerCmdPrinter(2, 3, null);
                Object[] haInfoRow = new String[2];
                String value = bkrProps.getProperty("imq.cluster.ha");
                boolean isHA = Boolean.valueOf(value);
                if (isHA) {
                    haInfoRow[0] = this.ar.getString("A1709");
                    haInfoRow[1] = value = bkrProps.getProperty("imq.cluster.clusterid", "");
                    haBcp.add(haInfoRow);
                }
                haInfoRow[0] = this.ar.getString("A1710");
                haInfoRow[1] = !isHA ? Boolean.FALSE.toString() : Boolean.TRUE.toString();
                haBcp.add(haInfoRow);
                haBcp.println();
                broker.sendGetClusterMessage(true);
                Vector bkrList = broker.receiveGetClusterReplyMessage();
                if (bkrList != null && bkrList.size() > 0) {
                    Hashtable bkrClsInfo2;
                    BrokerCmdPrinter bcp4;
                    if (isHA) {
                        bcp4 = new BrokerCmdPrinter(6, 3, "-");
                        Object[] row5 = new String[6];
                        bcp4.setSortNeeded(false);
                        bcp4.setTitleAlign(1);
                        row5[0] = "";
                        row5[1] = "";
                        row5[2] = "";
                        row5[3] = "";
                        row5[4] = this.ar.getString("A1720");
                        row5[5] = this.ar.getString("A1721");
                        bcp4.addTitle((String[])row5);
                        row5[0] = this.ar.getString("A1716");
                        row5[1] = this.ar.getString("A1717");
                        row5[2] = this.ar.getString("A1718");
                        row5[3] = this.ar.getString("A1719");
                        row5[4] = this.ar.getString("A1736");
                        row5[5] = this.ar.getString("A1737");
                        bcp4.addTitle((String[])row5);
                        thisEnum = bkrList.elements();
                        while (thisEnum.hasMoreElements()) {
                            bkrClsInfo2 = (Hashtable)thisEnum.nextElement();
                            row5[0] = CmdRunner.checkNullAndPrint(bkrClsInfo2.get("ID"));
                            row5[1] = CmdRunner.checkNullAndPrint(bkrClsInfo2.get("Address"));
                            Integer tmpInt = (Integer)bkrClsInfo2.get("State");
                            row5[2] = tmpInt != null ? BrokerState.toString((int)tmpInt) : "";
                            Long tmpLong = (Long)bkrClsInfo2.get("NumMsgs");
                            row5[3] = CmdRunner.checkNullAndPrint(tmpLong);
                            row5[4] = CmdRunner.checkNullAndPrint(bkrClsInfo2.get("TakeoverBrokerID"));
                            tmpLong = (Long)bkrClsInfo2.get("StatusTimestamp");
                            if (tmpLong != null) {
                                long idle = System.currentTimeMillis() - tmpLong;
                                row5[5] = CmdRunner.getTimeString(idle);
                            } else {
                                row5[5] = "";
                            }
                            bcp4.add(row5);
                        }
                    } else {
                        bcp4 = new BrokerCmdPrinter(2, 3, "-");
                        Object[] row6 = new String[2];
                        bcp4.setSortNeeded(false);
                        bcp4.setTitleAlign(1);
                        row6[0] = this.ar.getString("A1717");
                        row6[1] = this.ar.getString("A1718");
                        bcp4.addTitle((String[])row6);
                        thisEnum = bkrList.elements();
                        while (thisEnum.hasMoreElements()) {
                            bkrClsInfo2 = (Hashtable)thisEnum.nextElement();
                            row6[0] = CmdRunner.checkNullAndPrint(bkrClsInfo2.get("Address"));
                            Integer tmpInt = (Integer)bkrClsInfo2.get("State");
                            row6[1] = tmpInt != null ? BrokerState.toString((int)tmpInt) : "";
                            bcp4.add(row6);
                        }
                    }
                    bcp4.println();
                    sb.append(this.ar.getString("A1714")).append("\n");
                }
                sb.append("ar.getString(ar.I_JMQCMD_LIST_BKR_NONE)").append("\n");
            }
            catch (BrokerAdminException bae9) {
                this.handleBrokerAdminException(bae9);
                sb.append(this.ar.getString("A1713")).append("\n");
                return 1;
            }
        } else if ("abtxn".equals(bkrClsInfo2)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1253")).append("\n");
                return 1;
            }
            thisEnum.forceModeSet();
            sb.append(this.ar.getString("A1250")).append("\n");
            this.printBrokerInfo(broker);
            try {
                CmdRunner.connectToBroker(broker);
                broker.sendGetTxnsMessage();
                Vector vector3 = broker.receiveGetTxnsReplyMessage();
                if (vector3 != null && vector3.size() > 0) {
                    brokercmdprinter2 = new BrokerCmdPrinter(5, 3, "-");
                    brokercmdprinter4 = new BrokerCmdPrinter(4, 3, "-");
                    BrokerCmdPrinter brokercmdprinter5 = new BrokerCmdPrinter(4, 3, "-");
                    Object[] objectArray = new String[5];
                    Object[] as3 = objectArray;
                    objectArray[0] = this.ar.getString("A1263");
                    as3[1] = this.ar.getString("A1269");
                    as3[2] = this.ar.getString("A1270");
                    as3[3] = this.ar.getString("A1272");
                    as3[4] = this.ar.getString("A1266");
                    brokercmdprinter2.addTitle((String[])as3);
                    as3[0] = this.ar.getString("A1263");
                    as3[1] = this.ar.getString("A1269");
                    as3[2] = this.ar.getString("A1270");
                    as3[3] = this.ar.getString("A1266");
                    brokercmdprinter4.addTitle((String[])as3);
                    as3[0] = this.ar.getString("A1263");
                    as3[1] = this.ar.getString("A1269");
                    as3[2] = "# Acks";
                    as3[3] = "Remote broker";
                    brokercmdprinter5.addTitle((String[])as3);
                    Enumeration enumeration4 = vector3.elements();
                    while (enumeration4.hasMoreElements()) {
                        String s10;
                        Hashtable hashtable1 = (Hashtable)enumeration4.nextElement();
                        Integer integer4 = (Integer)hashtable1.get("type");
                        if (integer4 == 0) {
                            Long long4 = (Long)hashtable1.get("txnid");
                            as3[0] = CmdRunner.checkNullAndPrint(long4);
                            Integer integer1 = (Integer)hashtable1.get("state");
                            int current_txn_state = integer1;
                            as3[1] = this.getTxnStateString(integer1);
                            String s6 = (String)hashtable1.get("user");
                            as3[2] = CmdRunner.checkNullAndPrint(s6);
                            integer1 = (Integer)hashtable1.get("nmsgs");
                            s6 = CmdRunner.checkNullAndPrint(integer1);
                            integer1 = (Integer)hashtable1.get("nacks");
                            String s9 = CmdRunner.checkNullAndPrint(integer1);
                            as3[3] = s6 + "/" + s9;
                            long4 = (Long)hashtable1.get("timestamp");
                            as3[4] = CmdRunner.checkNullAndPrintTimestamp(long4);
                            if (this.filter_transactionstate != -1 && this.filter_transactionstate != current_txn_state && (this.filter_transactionstate != 8 || current_txn_state == 1)) continue;
                            brokercmdprinter2.add(as3);
                            continue;
                        }
                        if (integer4 == 1) {
                            Long long5 = (Long)hashtable1.get("txnid");
                            as3[0] = CmdRunner.checkNullAndPrint(long5);
                            Integer integer2 = (Integer)hashtable1.get("state");
                            as3[1] = this.getTxnStateString(integer2);
                            String s7 = (String)hashtable1.get("user");
                            as3[2] = CmdRunner.checkNullAndPrint(s7);
                            long5 = (Long)hashtable1.get("timestamp");
                            as3[3] = CmdRunner.checkNullAndPrintTimestamp(long5);
                            brokercmdprinter4.add(as3);
                            continue;
                        }
                        Long long6 = (Long)hashtable1.get("txnid");
                        as3[0] = CmdRunner.checkNullAndPrint(long6);
                        Integer integer3 = (Integer)hashtable1.get("state");
                        as3[1] = this.getTxnStateString(integer3);
                        integer3 = (Integer)hashtable1.get("nacks");
                        as3[2] = s10 = CmdRunner.checkNullAndPrint(integer3);
                        String s8 = (String)hashtable1.get("homebroker");
                        as3[3] = CmdRunner.checkNullAndPrint(s8);
                        brokercmdprinter5.add(as3);
                    }
                    brokercmdprinter2.println();
                    sb.append(this.ar.getString("A1251")).append("\n");
                }
                sb.append(this.ar.getString("A1252")).append("\n");
            }
            catch (BrokerAdminException brokeradminexception4) {
                this.handleBrokerAdminException(brokeradminexception4);
                sb.append(this.ar.getString("A1253")).append("\n");
                return 1;
            }
        } else if ("jmx".equals((Object)brokercmdprinter2)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1723")).append("\n");
                return 1;
            }
            boolean force8 = brokercmdprinter4.forceModeSet();
            if (!force8) {
                broker = this.promptForAuthentication(broker);
            }
            sb.append(this.ar.getString("A1722")).append("\n");
            this.printBrokerInfo(broker);
            try {
                CmdRunner.connectToBroker(broker);
                broker.sendGetJMXConnectorsMessage(null);
                Vector jmxList = broker.receiveGetJMXConnectorsReplyMessage();
                if (jmxList != null) {
                    BrokerCmdPrinter bcp5 = new BrokerCmdPrinter(3, 4, null);
                    String[] stringArray = new String[3];
                    row = stringArray;
                    stringArray[0] = this.ar.getString("A1726");
                    row[1] = this.ar.getString("A1727");
                    row[2] = this.ar.getString("A1728");
                    bcp5.addTitle((String[])row);
                    Enumeration thisEnum6 = jmxList.elements();
                    while (thisEnum6.hasMoreElements()) {
                        Hashtable jmxInfo = (Hashtable)thisEnum6.nextElement();
                        row[0] = CmdRunner.checkNullAndPrint(jmxInfo.get("name"));
                        row[1] = CmdRunner.checkNullAndPrint(jmxInfo.get("active"));
                        row[2] = CmdRunner.checkNullAndPrint(jmxInfo.get("url"));
                        bcp5.add(row);
                    }
                    bcp5.println();
                    sb.append(this.ar.getString("A1724")).append("\n");
                }
                sb.append(this.ar.getString("A1725")).append("\n");
                sb.append("").append("\n");
                sb.append(this.ar.getString("A1724")).append("\n");
            }
            catch (BrokerAdminException bae10) {
                this.handleBrokerAdminException(bae10);
                sb.append(this.ar.getString("A1723")).append("\n");
                return 1;
            }
        } else if ("msg".equals(bcp22)) {
            if (broker == null) {
                sb.append("Listing messages failed.").append("\n");
                return 1;
            }
            boolean force9 = row.forceModeSet();
            if (!force9) {
                broker = this.promptForAuthentication(broker);
            }
            String destName = row.getTargetName();
            int jmxInfo = CmdRunner.getDestTypeMask((BrokerCmdProperties)row);
            Long maxNumMsgsRetrieved = row.getMaxNumMsgsRetrieved();
            Long startMsgIndex = row.getStartMsgIndex();
            sb.append("Listing messages for the destination").append("\n");
            this.printDestinationInfo();
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            try {
                CmdRunner.connectToBroker(broker);
                broker.sendGetMessagesMessage(destName, jmxInfo, false, null, startMsgIndex, maxNumMsgsRetrieved);
                Vector msgList = broker.receiveGetMessagesReplyMessage();
                if (msgList != null && msgList.size() != 0) {
                    BrokerCmdPrinter bcp6 = new BrokerCmdPrinter(4, 3, "-");
                    Object[] row7 = new String[4];
                    bcp6.setSortNeeded(false);
                    row7[0] = "Message #";
                    row7[1] = "Message IDs";
                    row7[2] = "Priority";
                    row7[3] = "Body Type";
                    bcp6.addTitle((String[])row7);
                    long start = 0L;
                    if (startMsgIndex != null) {
                        start = startMsgIndex;
                    }
                    Enumeration thisEnum7 = msgList.elements();
                    while (thisEnum7.hasMoreElements()) {
                        HashMap oneMsg = (HashMap)thisEnum7.nextElement();
                        row7[0] = Long.toString(start++);
                        row7[1] = CmdRunner.checkNullAndPrint(oneMsg.get("MessageID"));
                        row7[2] = CmdRunner.checkNullAndPrint(oneMsg.get("Priority"));
                        row7[3] = CmdRunner.checkNullAndPrintMsgBodyType((Integer)oneMsg.get("MessageBodyType"), false);
                        bcp6.add(row7);
                    }
                    bcp6.println();
                    sb.append("Successfully listed messages.").append("\n");
                } else {
                    sb.append("There are no messages.").append("\n");
                    sb.append("").append("\n");
                    sb.append("Successfully listed messages.").append("\n");
                }
            }
            catch (BrokerAdminException bae11) {
                this.handleBrokerAdminException(bae11);
                sb.append("Listing messages failed.").append("\n");
                return 1;
            }
        }
        broker.close();
        return 0;
    }

    private static String getTimeString(long millis22) {
        long millis22;
        String millis22;
        if (millis22 < 1000L) {
            millis22 = millis22 + " milliseconds";
        } else if (millis22 < 60000L) {
            long seconds = millis22 / 1000L;
            millis22 = seconds + " seconds";
        } else if (millis22 < 3600000L) {
            long mins = millis22 / 60000L;
            millis22 = mins + " minutes";
        } else {
            millis22 = "> 1 hour";
        }
        return millis22;
    }

    private void listDests(BrokerCmdProperties brokerCmdProps, Vector dests, int listType) {
        int[] nArray;
        String[] stringArray;
        BrokerCmdPrinter brokerCmdPrinter;
        int n = listType;
        CmdRunner cmdRunner = this;
        if (n != 2) {
            brokerCmdPrinter = new BrokerCmdPrinter(11, 2, "-");
            stringArray = new String[11];
            brokerCmdPrinter.setTitleAlign(1);
            int[] nArray2 = new int[11];
            nArray = nArray2;
            nArray2[0] = 1;
            nArray[1] = 1;
            nArray[2] = 1;
            nArray[3] = 2;
            nArray[4] = 0;
            nArray[5] = 2;
            nArray[6] = 0;
            nArray[7] = 4;
            nArray[8] = 0;
            nArray[9] = 0;
            nArray[10] = 0;
            stringArray[0] = cmdRunner.ar.getString("A1443");
            stringArray[1] = cmdRunner.ar.getString("A1444");
            stringArray[2] = cmdRunner.ar.getString("A1445");
            stringArray[3] = cmdRunner.ar.getString("A1675");
            stringArray[4] = "";
            stringArray[5] = cmdRunner.ar.getString("A1676");
            stringArray[6] = "";
            stringArray[7] = cmdRunner.ar.getString("A1677");
            stringArray[8] = "";
            stringArray[9] = "";
            stringArray[10] = "";
            brokerCmdPrinter.addTitle(stringArray, nArray);
            stringArray[0] = "";
            stringArray[1] = "";
            stringArray[2] = "";
            stringArray[3] = cmdRunner.ar.getString("A1690");
            stringArray[4] = cmdRunner.ar.getString("A1691");
            stringArray[5] = cmdRunner.ar.getString("A1689");
            stringArray[6] = cmdRunner.ar.getString("A1691");
            stringArray[7] = cmdRunner.ar.getString("A1680");
            stringArray[8] = cmdRunner.ar.getString("A1738");
            stringArray[9] = cmdRunner.ar.getString("A1681");
            stringArray[10] = cmdRunner.ar.getString("A1682");
            brokerCmdPrinter.addTitle(stringArray);
        } else {
            brokerCmdPrinter = new BrokerCmdPrinter(10, 2, "-");
            stringArray = new String[10];
            brokerCmdPrinter.setTitleAlign(1);
            int[] nArray3 = new int[10];
            nArray = nArray3;
            nArray3[0] = 1;
            nArray[1] = 1;
            nArray[2] = 1;
            nArray[3] = 1;
            nArray[4] = 2;
            nArray[5] = 0;
            nArray[6] = 4;
            nArray[7] = 0;
            nArray[8] = 0;
            nArray[9] = 0;
            stringArray[0] = cmdRunner.ar.getString("A1443");
            stringArray[1] = cmdRunner.ar.getString("A1444");
            stringArray[2] = cmdRunner.ar.getString("A1445");
            stringArray[3] = cmdRunner.ar.getString("A1675");
            stringArray[4] = cmdRunner.ar.getString("A1676");
            stringArray[5] = "";
            stringArray[6] = cmdRunner.ar.getString("A1677");
            stringArray[7] = "";
            stringArray[8] = "";
            brokerCmdPrinter.addTitle(stringArray, nArray);
            stringArray[0] = "";
            stringArray[1] = "";
            stringArray[2] = "";
            stringArray[3] = "";
            stringArray[4] = cmdRunner.ar.getString("A1678");
            stringArray[5] = cmdRunner.ar.getString("A1679");
            stringArray[6] = cmdRunner.ar.getString("A1680");
            stringArray[7] = cmdRunner.ar.getString("A1738");
            stringArray[8] = cmdRunner.ar.getString("A1681");
            stringArray[9] = cmdRunner.ar.getString("A1682");
            brokerCmdPrinter.addTitle(stringArray);
        }
        BrokerCmdPrinter bcp = brokerCmdPrinter;
        Object[] row = new String[11];
        Enumeration thisEnum = dests.elements();
        while (thisEnum.hasMoreElements()) {
            String destType;
            DestinationInfo dInfo = (DestinationInfo)thisEnum.nextElement();
            float avgMsgSize = 0.0f;
            if ("__JMQAdmin".equals(dInfo.name) || DestType.isInternal((int)dInfo.fulltype)) continue;
            if (DestType.isTemporary((int)dInfo.type)) {
                if (!brokerCmdProps.showTempDestModeSet()) continue;
                destType = BrokerAdminUtil.getDestinationType((int)dInfo.type) + " (" + this.ar.getString("A1631") + ")";
            } else {
                destType = BrokerAdminUtil.getDestinationType((int)dInfo.type);
            }
            if (listType == 1 && !DestType.isTopic((int)dInfo.type) || listType == 2 && !DestType.isQueue((int)dInfo.type)) continue;
            int numMsgs = dInfo.nMessages - dInfo.nTxnMessages;
            long totalMsgSize = dInfo.nMessageBytes;
            if (numMsgs > 0) {
                avgMsgSize = (float)totalMsgSize / (float)numMsgs;
            }
            row[0] = dInfo.name;
            row[1] = destType;
            row[2] = DestState.toString((int)dInfo.destState);
            row[3] = new Integer(dInfo.nProducers).toString();
            if (DestType.isTopic((int)dInfo.type)) {
                Hashtable h = dInfo.producerWildcards;
                row[4] = Integer.toString(CmdRunner.getWildcardCount(h));
            } else {
                row[4] = "-";
            }
            if (DestType.isTopic((int)dInfo.type)) {
                row[5] = new Integer(dInfo.nConsumers).toString();
                Hashtable h = dInfo.consumerWildcards;
                row[6] = Integer.toString(CmdRunner.getWildcardCount(h));
            } else if (listType == 2) {
                row[5] = new Integer(dInfo.naConsumers).toString();
                row[6] = new Integer(dInfo.nfConsumers).toString();
            } else {
                row[5] = new Integer(dInfo.naConsumers + dInfo.nfConsumers).toString();
                row[6] = "-";
            }
            row[7] = new Integer(numMsgs).toString();
            row[8] = new Integer(dInfo.nRemoteMessages).toString();
            row[9] = new Integer(dInfo.nUnackMessages).toString();
            row[10] = new Float(avgMsgSize).toString();
            bcp.add(row);
        }
        bcp.setKeyCriteria(new int[]{0, 1});
        bcp.println();
    }

    private static int getWildcardCount(Hashtable h) {
        int count = 0;
        if (h == null) {
            return 0;
        }
        Enumeration keys = h.keys();
        while (keys.hasMoreElements()) {
            String wildcard = (String)keys.nextElement();
            Integer val = (Integer)h.get(wildcard);
            count += val.intValue();
        }
        return count;
    }

    private String getTxnStateString(Integer txnState) {
        if (txnState == null) {
            return "";
        }
        int tmpInt = txnState;
        switch (tmpInt) {
            case 0: {
                return this.ar.getString("A1280");
            }
            case 1: {
                return this.ar.getString("A1281");
            }
            case 2: {
                return this.ar.getString("A1282");
            }
            case 3: {
                return this.ar.getString("A1283");
            }
            case 4: {
                return this.ar.getString("A1284");
            }
            case 5: {
                return this.ar.getString("A1285");
            }
            case 6: {
                return this.ar.getString("A1286");
            }
            case 7: {
                return this.ar.getString("A1287");
            }
        }
        return this.ar.getString("A1288");
    }

    /*
     * WARNING - void declaration
     */
    private int runPause(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        String svcName;
        void bae3;
        String input2 = null;
        String yes = this.ar.getString("A5016");
        String yesShort = this.ar.getString("A5015");
        String no = this.ar.getString("A5018");
        String noShort = this.ar.getString("A5017");
        BrokerAdmin broker = this.init();
        boolean force = brokerCmdProps.forceModeSet();
        String commandArg = brokerCmdProps.getCommandArg();
        if ("bkr".equals(commandArg)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1209")).append("\n");
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            sb.append(this.ar.getString("A1207")).append("\n");
            this.printBrokerInfo(broker);
            try {
                CmdRunner.connectToBroker(broker);
            }
            catch (BrokerAdminException bae2) {
                this.handleBrokerAdminException(bae2);
                sb.append(this.ar.getString("A1209")).append("\n");
                return 1;
            }
            if (!force) {
                input2 = this.getUserInput(this.ar.getString("A5005"), noShort);
                sb.append("").append("\n");
            }
            if (yesShort.equalsIgnoreCase(input2) || yes.equalsIgnoreCase(input2) || force) {
                try {
                    broker.sendPauseMessage(null);
                    broker.receivePauseReplyMessage();
                    sb.append(this.ar.getString("A1208")).append("\n");
                }
                catch (BrokerAdminException bae3) {
                    this.handleBrokerAdminException(bae3);
                    sb.append(this.ar.getString("A1209")).append("\n");
                    return 1;
                }
            }
            if (noShort.equalsIgnoreCase(input2) || no.equalsIgnoreCase(input2)) {
                sb.append(this.ar.getString("A1210")).append("\n");
                return 0;
            }
            sb.append(this.ar.getString("A1026", (Object)input2)).append("\n");
            sb.append("").append("\n");
            sb.append(this.ar.getString("A1210")).append("\n");
            return 1;
        }
        if ("svc".equals(bae3)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1213")).append("\n");
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            svcName = brokerCmdProps.getTargetName();
            sb.append(this.ar.getString("A1211")).append("\n");
            brokerCmdProps = this;
            brokerCmdProps.printServiceInfo(null);
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            try {
                CmdRunner.connectToBroker(broker);
            }
            catch (BrokerAdminException bae4) {
                this.handleBrokerAdminException(bae4);
                sb.append(this.ar.getString("A1213")).append("\n");
                return 1;
            }
            try {
                CmdRunner.isAdminService(broker, svcName);
            }
            catch (BrokerAdminException bae5) {
                if (7 == bae5.getType()) {
                    bae5.setBrokerErrorStr(this.ar.getString("A1001") + this.ar.getKString("A3109", (Object)svcName));
                }
                this.handleBrokerAdminException(bae5);
                sb.append(this.ar.getString("A1213")).append("\n");
                return 1;
            }
            if (!force) {
                input2 = this.getUserInput(this.ar.getString("A5006"), noShort);
                sb.append("").append("\n");
            }
            if (yesShort.equalsIgnoreCase(input2) || yes.equalsIgnoreCase(input2) || force) {
                try {
                    broker.sendPauseMessage(svcName);
                    broker.receivePauseReplyMessage();
                    sb.append(this.ar.getString("A1212")).append("\n");
                }
                catch (BrokerAdminException bae6) {
                    this.handleBrokerAdminException(bae6);
                    sb.append(this.ar.getString("A1213")).append("\n");
                    return 1;
                }
            }
            if (noShort.equalsIgnoreCase(input2) || no.equalsIgnoreCase(input2)) {
                sb.append(this.ar.getString("A1214")).append("\n");
                return 0;
            }
            sb.append(this.ar.getString("A1026", (Object)input2)).append("\n");
            sb.append("").append("\n");
            sb.append(this.ar.getString("A1214")).append("\n");
            return 1;
        }
        if ("dst".equals(svcName)) {
            void bae6;
            BrokerCmdPrinter bcp = new BrokerCmdPrinter(2, 4);
            Object[] row = new String[2];
            boolean pauseAll = true;
            String destName = bae6.getTargetName();
            int destTypeMask = CmdRunner.getDestTypeMask((BrokerCmdProperties)bae6);
            String pauseTypeStr = bae6.getPauseType();
            if (destName != null) {
                pauseAll = false;
            }
            if (broker == null) {
                if (pauseAll) {
                    sb.append(this.ar.getString("A1311")).append("\n");
                } else {
                    sb.append(this.ar.getString("A1275")).append("\n");
                }
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            if (pauseAll) {
                sb.append(this.ar.getString("A1309")).append("\n");
            } else {
                sb.append(this.ar.getString("A1273")).append("\n");
                this.printDestinationInfo();
            }
            if (pauseTypeStr != null) {
                sb.append(this.ar.getString("A1317")).append("\n");
                row[0] = this.ar.getString("A1442");
                row[1] = pauseTypeStr;
                bcp.add(row);
                bcp.println();
            }
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            try {
                CmdRunner.connectToBroker(broker);
            }
            catch (BrokerAdminException bae2) {
                this.handleBrokerAdminException(bae2);
                if (pauseAll) {
                    sb.append(this.ar.getString("A1311")).append("\n");
                } else {
                    sb.append(this.ar.getString("A1275")).append("\n");
                }
                return 1;
            }
            if (!force) {
                input2 = pauseAll ? this.getUserInput(this.ar.getString("A5025"), noShort) : this.getUserInput(this.ar.getString("A5021"), noShort);
                sb.append("").append("\n");
            }
            if (yesShort.equalsIgnoreCase(input2) || yes.equalsIgnoreCase(input2) || force) {
                try {
                    int n;
                    int input2 = -1;
                    if (bae6 == null) {
                        n = -1;
                    } else {
                        if (bae6.equals("ALL")) {
                            input2 = 3;
                        } else if (bae6.equals("PRODUCERS")) {
                            input2 = 2;
                        } else if (bae6.equals("CONSUMERS")) {
                            input2 = 1;
                        }
                        n = input2;
                    }
                    int pauseType = n;
                    broker.sendPauseMessage(destName, destTypeMask, pauseType);
                    broker.receivePauseReplyMessage();
                    if (pauseAll) {
                        sb.append(this.ar.getString("A1310")).append("\n");
                    }
                    sb.append(this.ar.getString("A1274")).append("\n");
                }
                catch (BrokerAdminException bae7) {
                    this.handleBrokerAdminException(bae7);
                    if (pauseAll) {
                        sb.append(this.ar.getString("A1311")).append("\n");
                    } else {
                        sb.append(this.ar.getString("A1275")).append("\n");
                    }
                    return 1;
                }
            } else {
                if (noShort.equalsIgnoreCase(input2) || no.equalsIgnoreCase(input2)) {
                    if (pauseAll) {
                        sb.append(this.ar.getString("A1312")).append("\n");
                    } else {
                        sb.append(this.ar.getString("A1276")).append("\n");
                    }
                    return 0;
                }
                sb.append(this.ar.getString("A1026", (Object)input2)).append("\n");
                sb.append("").append("\n");
                if (pauseAll) {
                    sb.append(this.ar.getString("A1312")).append("\n");
                } else {
                    sb.append(this.ar.getString("A1276")).append("\n");
                }
                return 1;
            }
        }
        broker.close();
        return 0;
    }

    private int runReset(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        String input = null;
        String yes = this.ar.getString("A5016");
        String yesShort = this.ar.getString("A5015");
        String no = this.ar.getString("A5018");
        String noShort = this.ar.getString("A5017");
        BrokerAdmin broker = this.init();
        boolean force = brokerCmdProps.forceModeSet();
        String commandArg = brokerCmdProps.getCommandArg();
        if ("bkr".equals(commandArg)) {
            BrokerCmdPrinter bcp = new BrokerCmdPrinter(2, 4);
            Object[] row = new String[2];
            String resetType = brokerCmdProps.getResetType();
            if (broker == null) {
                sb.append(this.ar.getString("A1766")).append("\n");
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            sb.append(this.ar.getString("A1764")).append("\n");
            if (resetType != null) {
                sb.append(this.ar.getString("A1317")).append("\n");
                row[0] = this.ar.getString("A1768");
                row[1] = resetType;
                bcp.add(row);
                bcp.println();
            }
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            try {
                CmdRunner.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1766")).append("\n");
                return 1;
            }
            if (!force) {
                input = this.getUserInput(this.ar.getString("A5031"), noShort);
                sb.append("").append("\n");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    String resetTypeVal = bae == null || bae.equals("") ? null : (bae.equals("METRICS") ? "JMQMetrics" : null);
                    broker.sendResetBrokerMessage(resetTypeVal);
                    broker.receiveResetBrokerReplyMessage();
                    sb.append(this.ar.getString("A1765")).append("\n");
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    sb.append(this.ar.getString("A1766")).append("\n");
                    return 1;
                }
            } else {
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    sb.append(this.ar.getString("A1767")).append("\n");
                    return 0;
                }
                sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
                sb.append("").append("\n");
                sb.append(this.ar.getString("A1767")).append("\n");
                return 1;
            }
        }
        broker.close();
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private int runResume(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        String svcName;
        void bae3;
        String input = null;
        String yes = this.ar.getString("A5016");
        String yesShort = this.ar.getString("A5015");
        String no = this.ar.getString("A5018");
        String noShort = this.ar.getString("A5017");
        BrokerAdmin broker = this.init();
        boolean force = brokerCmdProps.forceModeSet();
        String commandArg = brokerCmdProps.getCommandArg();
        if ("bkr".equals(commandArg)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1217")).append("\n");
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            sb.append(this.ar.getString("A1215")).append("\n");
            this.printBrokerInfo(broker);
            try {
                CmdRunner.connectToBroker(broker);
            }
            catch (BrokerAdminException bae2) {
                this.handleBrokerAdminException(bae2);
                sb.append(this.ar.getString("A1217")).append("\n");
                return 1;
            }
            if (!force) {
                input = this.getUserInput(this.ar.getString("A5007"), noShort);
                sb.append("").append("\n");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendResumeMessage(null);
                    broker.receiveResumeReplyMessage();
                    sb.append(this.ar.getString("A1216")).append("\n");
                }
                catch (BrokerAdminException bae3) {
                    this.handleBrokerAdminException(bae3);
                    sb.append(this.ar.getString("A1217")).append("\n");
                    return 1;
                }
            }
            if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                sb.append(this.ar.getString("A1218")).append("\n");
                return 0;
            }
            sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
            sb.append("").append("\n");
            sb.append(this.ar.getString("A1218")).append("\n");
            return 1;
        }
        if ("svc".equals(bae3)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1221")).append("\n");
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            svcName = brokerCmdProps.getTargetName();
            sb.append(this.ar.getString("A1219")).append("\n");
            brokerCmdProps = this;
            brokerCmdProps.printServiceInfo(null);
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            try {
                CmdRunner.connectToBroker(broker);
            }
            catch (BrokerAdminException bae4) {
                this.handleBrokerAdminException(bae4);
                sb.append(this.ar.getString("A1221")).append("\n");
                return 1;
            }
            try {
                CmdRunner.isAdminService(broker, svcName);
            }
            catch (BrokerAdminException bae5) {
                if (7 == bae5.getType()) {
                    bae5.setBrokerErrorStr(this.ar.getString("A1001") + this.ar.getKString("A3110", (Object)svcName));
                }
                this.handleBrokerAdminException(bae5);
                sb.append(this.ar.getString("A1221")).append("\n");
                return 1;
            }
            if (!force) {
                input = this.getUserInput(this.ar.getString("A5008"), noShort);
                sb.append("").append("\n");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendResumeMessage(svcName);
                    broker.receiveResumeReplyMessage();
                    sb.append(this.ar.getString("A1220")).append("\n");
                }
                catch (BrokerAdminException bae6) {
                    this.handleBrokerAdminException(bae6);
                    sb.append(this.ar.getString("A1221")).append("\n");
                    return 1;
                }
            }
            if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                sb.append(this.ar.getString("A1222")).append("\n");
                return 0;
            }
            sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
            sb.append("").append("\n");
            sb.append(this.ar.getString("A1222")).append("\n");
            return 1;
        }
        if ("dst".equals(svcName)) {
            void bae6;
            boolean resumeAll = true;
            String destName = bae6.getTargetName();
            int destTypeMask = CmdRunner.getDestTypeMask((BrokerCmdProperties)bae6);
            if (destName != null) {
                resumeAll = false;
            }
            if (broker == null) {
                if (resumeAll) {
                    sb.append(this.ar.getString("A1315")).append("\n");
                } else {
                    sb.append(this.ar.getString("A1294")).append("\n");
                }
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            if (resumeAll) {
                sb.append(this.ar.getString("A1313")).append("\n");
            } else {
                sb.append(this.ar.getString("A1292")).append("\n");
                this.printDestinationInfo();
                sb.append(this.ar.getString("A1200")).append("\n");
            }
            this.printBrokerInfo(broker);
            try {
                CmdRunner.connectToBroker(broker);
            }
            catch (BrokerAdminException bae2) {
                this.handleBrokerAdminException(bae2);
                if (resumeAll) {
                    sb.append(this.ar.getString("A1315")).append("\n");
                } else {
                    sb.append(this.ar.getString("A1294")).append("\n");
                }
                return 1;
            }
            if (!force) {
                input = resumeAll ? this.getUserInput(this.ar.getString("A5026"), noShort) : this.getUserInput(this.ar.getString("A5022"), noShort);
                sb.append("").append("\n");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendResumeMessage(destName, (int)bae2);
                    broker.receiveResumeReplyMessage();
                    if (resumeAll) {
                        sb.append(this.ar.getString("A1314")).append("\n");
                    }
                    sb.append(this.ar.getString("A1293")).append("\n");
                }
                catch (BrokerAdminException bae7) {
                    this.handleBrokerAdminException(bae7);
                    if (resumeAll) {
                        sb.append(this.ar.getString("A1315")).append("\n");
                    } else {
                        sb.append(this.ar.getString("A1294")).append("\n");
                    }
                    return 1;
                }
            } else {
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    if (resumeAll) {
                        sb.append(this.ar.getString("A1316")).append("\n");
                    } else {
                        sb.append(this.ar.getString("A1295")).append("\n");
                    }
                    return 0;
                }
                sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
                sb.append("").append("\n");
                if (resumeAll) {
                    sb.append(this.ar.getString("A1316")).append("\n");
                } else {
                    sb.append(this.ar.getString("A1295")).append("\n");
                }
                return 1;
            }
        }
        broker.close();
        return 0;
    }

    private int runShutdown(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        String sessionID;
        String input = null;
        String yes = this.ar.getString("A5016");
        String yesShort = this.ar.getString("A5015");
        String no = this.ar.getString("A5018");
        String noShort = this.ar.getString("A5017");
        BrokerAdmin broker = this.init();
        if (broker == null) {
            sb.append(this.ar.getString("A1225")).append("\n");
            return 1;
        }
        boolean force = brokerCmdProps.forceModeSet();
        if (!force) {
            broker = this.promptForAuthentication(broker);
        }
        boolean noFailover = brokerCmdProps.noFailoverSet();
        int time = brokerCmdProps.getTime();
        sb.append(this.ar.getString("A1223")).append("\n");
        this.printBrokerInfo(broker);
        try {
            CmdRunner.connectToBroker(broker);
            sessionID = CmdRunner.getPortMapperSessionID$5a0d7422(broker);
        }
        catch (BrokerAdminException bae) {
            this.handleBrokerAdminException(bae);
            sb.append(this.ar.getString("A1225")).append("\n");
            return 1;
        }
        if (!force) {
            input = this.getUserInput(this.ar.getString("A5009"), noShort);
            sb.append("").append("\n");
        }
        if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
            try {
                broker.sendShutdownMessage(false, false, noFailover, time);
                broker.receiveShutdownReplyMessage();
                if (this.waitForShutdown(broker, sessionID, (BrokerCmdProperties)bae)) {
                    sb.append(this.ar.getString("A1224")).append("\n");
                }
                sb.append(this.ar.getString("A1760")).append("\n");
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1225")).append("\n");
                return 1;
            }
        } else {
            if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                sb.append(this.ar.getString("A1226")).append("\n");
                return 0;
            }
            sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
            sb.append("").append("\n");
            sb.append(this.ar.getString("A1226")).append("\n");
            return 1;
        }
        return 0;
    }

    private boolean waitForShutdown(BrokerAdmin broker, String waitSessionID, BrokerCmdProperties brokerCmdProps) {
        int port;
        GenericPortMapperClient pmc = null;
        String hostName = broker.getBrokerHost();
        String portString = broker.getBrokerPort();
        String sessionID = null;
        if (brokerCmdProps == null) {
            return false;
        }
        long sleepTime = brokerCmdProps.getShutdownWaitInterval();
        int shutdownDelaySecs = brokerCmdProps.getTime();
        if (shutdownDelaySecs > 0) {
            return false;
        }
        if (waitSessionID == null) {
            return false;
        }
        try {
            port = Integer.parseInt(portString);
        }
        catch (Exception exception) {
            port = 7676;
        }
        boolean brokerDown = false;
        Globals.stdOutPrintln((String)this.ar.getString("A1761", (Object)(hostName + ":" + portString)));
        while (!brokerDown) {
            try {
                Thread.sleep(sleepTime);
            }
            catch (Exception exception) {}
            try {
                pmc = new GenericPortMapperClient(hostName, port);
            }
            catch (Exception exception) {
                brokerDown = true;
            }
            if (pmc == null) continue;
            sessionID = pmc.getProperty("sessionid", null, "PORTMAPPER", "portmapper");
            if (sessionID == null) {
                brokerDown = true;
                continue;
            }
            if (sessionID.equals(waitSessionID)) continue;
            brokerDown = true;
        }
        return true;
    }

    private static String getPortMapperSessionID$5a0d7422(BrokerAdmin broker) {
        int port;
        String hostName = broker.getBrokerHost();
        Object portString = broker.getBrokerPort();
        String sessionID = null;
        try {
            port = Integer.parseInt((String)portString);
        }
        catch (Exception exception) {
            port = 7676;
        }
        try {
            GenericPortMapperClient pmc = new GenericPortMapperClient(hostName, port);
            sessionID = pmc.getProperty("sessionid", null, "PORTMAPPER", "portmapper");
        }
        catch (Exception exception) {}
        return sessionID;
    }

    private int runRestart(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        String input = null;
        String yes = this.ar.getString("A5016");
        String yesShort = this.ar.getString("A5015");
        String no = this.ar.getString("A5018");
        String noShort = this.ar.getString("A5017");
        BrokerAdmin broker = this.init();
        if (broker == null) {
            sb.append(this.ar.getString("A1229")).append("\n");
            return 1;
        }
        boolean force = brokerCmdProps.forceModeSet();
        if (!force) {
            broker = this.promptForAuthentication(broker);
        }
        sb.append(this.ar.getString("A1227")).append("\n");
        this.printBrokerInfo(broker);
        try {
            CmdRunner.connectToBroker(broker);
        }
        catch (BrokerAdminException bae) {
            this.handleBrokerAdminException(bae);
            sb.append(this.ar.getString("A1229")).append("\n");
            return 1;
        }
        if (bae == false) {
            input = this.getUserInput(this.ar.getString("A5010"), noShort);
            sb.append("").append("\n");
        }
        if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || bae != false) {
            try {
                broker.sendShutdownMessage(true);
                broker.receiveShutdownReplyMessage();
                if (!this.reconnectToBroker(broker)) {
                    sb.append(this.ar.getString("A1229")).append("\n");
                    return 1;
                }
                sb.append(this.ar.getString("A1228")).append("\n");
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1229")).append("\n");
                return 1;
            }
        } else {
            if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                sb.append(this.ar.getString("A1230")).append("\n");
                return 0;
            }
            sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
            sb.append("").append("\n");
            sb.append(this.ar.getString("A1230")).append("\n");
            return 1;
        }
        broker.close();
        return 0;
    }

    private int runCreate(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        BrokerAdmin broker = this.init();
        if (broker == null) {
            sb.append(this.ar.getString("A1233")).append("\n");
            return 1;
        }
        boolean force = brokerCmdProps.forceModeSet();
        if (!force) {
            broker = this.promptForAuthentication(broker);
        }
        String destName = brokerCmdProps.getTargetName();
        int destTypeMask = CmdRunner.getDestTypeMask(brokerCmdProps);
        Properties destAttrs = brokerCmdProps.getTargetAttrs();
        sb.append(this.ar.getString("A1231")).append("\n");
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(2, 4);
        Object[] row = new String[2];
        bcp.setSortNeeded(false);
        row[0] = this.ar.getString("A1400");
        row[1] = destName;
        bcp.add(row);
        row[0] = this.ar.getString("A1401");
        row[1] = BrokerAdminUtil.getDestinationType((int)destTypeMask);
        bcp.add(row);
        String prop = destAttrs.getProperty("maxNumMsgs");
        if (prop != null) {
            row[0] = this.ar.getString("A1407");
            row[1] = prop;
            bcp.add(row);
        }
        if ((prop = destAttrs.getProperty("maxTotalMsgBytes")) != null) {
            row[0] = this.ar.getString("A1406");
            row[1] = prop;
            bcp.add(row);
        }
        if ((prop = destAttrs.getProperty("maxBytesPerMsg")) != null) {
            row[0] = this.ar.getString("A1408");
            row[1] = prop;
            bcp.add(row);
        }
        if ((prop = destAttrs.getProperty("maxNumProducers")) != null) {
            row[0] = this.ar.getString("A1415");
            row[1] = prop;
            bcp.add(row);
        }
        if ((prop = destAttrs.getProperty("maxNumActiveConsumers")) != null) {
            row[0] = this.ar.getString("A1410");
            row[1] = prop;
            bcp.add(row);
        }
        if ((prop = destAttrs.getProperty("maxNumBackupConsumers")) != null) {
            row[0] = this.ar.getString("A1409");
            row[1] = prop;
            bcp.add(row);
        }
        if ((prop = destAttrs.getProperty("limitBehavior")) != null) {
            row[0] = this.ar.getString("A1412");
            row[1] = prop;
            bcp.add(row);
        }
        if ((prop = destAttrs.getProperty("consumerFlowLimit")) != null) {
            row[0] = this.ar.getString("A1414");
            row[1] = prop;
            bcp.add(row);
        }
        if ((prop = destAttrs.getProperty("isLocalOnly")) != null) {
            row[0] = this.ar.getString("A1411");
            row[1] = prop;
            bcp.add(row);
        }
        if ((prop = destAttrs.getProperty("localDeliveryPreferred")) != null) {
            row[0] = this.ar.getString("A1413");
            row[1] = prop;
            bcp.add(row);
        }
        if ((prop = destAttrs.getProperty("useDMQ")) != null) {
            row[0] = this.ar.getString("A1446");
            row[1] = prop;
            bcp.add(row);
        }
        if ((prop = destAttrs.getProperty("validateXMLSchemaEnabled")) != null) {
            row[0] = this.ar.getString("A1447");
            row[1] = prop;
            bcp.add(row);
        }
        if ((prop = destAttrs.getProperty("XMLSchemaURIList")) != null) {
            row[0] = this.ar.getString("A1448");
            row[1] = prop;
            bcp.add(row);
        }
        bcp.println();
        sb.append(this.ar.getString("A1200")).append("\n");
        this.printBrokerInfo(broker);
        try {
            long byteValue;
            SizeString ss;
            DestinationInfo destInfo = new DestinationInfo();
            destInfo.setType(destTypeMask);
            destInfo.setName(destName);
            prop = destAttrs.getProperty("maxTotalMsgBytes");
            if (prop != null) {
                try {
                    ss = new SizeString(prop);
                    byteValue = ss.getBytes();
                    destInfo.setMaxMessageBytes(byteValue);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if ((prop = destAttrs.getProperty("maxNumMsgs")) != null) {
                destInfo.setMaxMessages(Integer.parseInt(prop));
            }
            if ((prop = destAttrs.getProperty("maxBytesPerMsg")) != null) {
                try {
                    ss = new SizeString(prop);
                    byteValue = ss.getBytes();
                    destInfo.setMaxMessageSize(byteValue);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if ((prop = destAttrs.getProperty("maxNumBackupConsumers")) != null) {
                destInfo.setMaxFailoverConsumers(Integer.parseInt(prop));
            }
            if ((prop = destAttrs.getProperty("maxNumActiveConsumers")) != null) {
                destInfo.setMaxActiveConsumers(Integer.parseInt(prop));
            }
            if ((prop = destAttrs.getProperty("isLocalOnly")) != null) {
                destInfo.setScope(Boolean.valueOf(prop).booleanValue());
            }
            if ((prop = destAttrs.getProperty("limitBehavior")) != null) {
                destInfo.setLimitBehavior(CmdRunner.getLimitBehavValue(prop));
            }
            if ((prop = destAttrs.getProperty("localDeliveryPreferred")) != null) {
                destInfo.setClusterDeliveryPolicy(CmdRunner.getClusterDeliveryPolicy(prop));
            }
            if ((prop = destAttrs.getProperty("consumerFlowLimit")) != null) {
                destInfo.setPrefetch(Integer.parseInt(prop));
            }
            if ((prop = destAttrs.getProperty("maxNumProducers")) != null) {
                destInfo.setMaxProducers(Integer.parseInt(prop));
            }
            if ((prop = destAttrs.getProperty("useDMQ")) != null) {
                destInfo.setUseDMQ(Boolean.valueOf(prop).booleanValue());
            }
            if ((prop = destAttrs.getProperty("validateXMLSchemaEnabled")) != null) {
                destInfo.setValidateXMLSchemaEnabled(Boolean.valueOf(prop).booleanValue());
            }
            if ((prop = destAttrs.getProperty("XMLSchemaURIList")) != null) {
                destInfo.setXMLSchemaUriList(prop);
            }
            if ((prop = destAttrs.getProperty("reloadXMLSchemaOnFailure")) != null) {
                destInfo.setReloadXMLSchemaOnFailure(Boolean.valueOf(prop).booleanValue());
            }
            CmdRunner.connectToBroker(broker);
            broker.sendCreateDestinationMessage(destInfo);
            broker.receiveCreateDestinationReplyMessage();
            sb.append(this.ar.getString("A1232")).append("\n");
        }
        catch (BrokerAdminException bae) {
            this.handleBrokerAdminException(bae);
            sb.append(this.ar.getString("A1233")).append("\n");
            return 1;
        }
        broker.close();
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private int runDestroy(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        String cxnIdStr;
        String subName;
        void bae3;
        String destName;
        String input = null;
        String yes = this.ar.getString("A5016");
        String yesShort = this.ar.getString("A5015");
        String no = this.ar.getString("A5018");
        String noShort = this.ar.getString("A5017");
        String commandArg = brokerCmdProps.getCommandArg();
        boolean force = brokerCmdProps.forceModeSet();
        BrokerAdmin broker = this.init();
        if ("dst".equals(commandArg)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1236")).append("\n");
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            destName = brokerCmdProps.getTargetName();
            int destTypeMask = CmdRunner.getDestTypeMask(brokerCmdProps);
            sb.append(this.ar.getString("A1234")).append("\n");
            this.printDestinationInfo();
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            try {
                CmdRunner.connectToBroker(broker);
            }
            catch (BrokerAdminException bae2) {
                this.handleBrokerAdminException(bae2);
                sb.append(this.ar.getString("A1236")).append("\n");
                return 1;
            }
            if (!force) {
                input = this.getUserInput(this.ar.getString("A5003"), noShort);
                sb.append("").append("\n");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendDestroyDestinationMessage(destName, destTypeMask);
                    broker.receiveDestroyDestinationReplyMessage();
                    sb.append(this.ar.getString("A1235")).append("\n");
                }
                catch (BrokerAdminException bae3) {
                    this.handleBrokerAdminException(bae3);
                    sb.append(this.ar.getString("A1236")).append("\n");
                    return 1;
                }
            }
            if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                sb.append(this.ar.getString("A1237")).append("\n");
                return 0;
            }
            sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
            sb.append("").append("\n");
            sb.append(this.ar.getString("A1237")).append("\n");
            return 1;
        }
        if ("dur".equals(destName)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1556")).append("\n");
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            subName = bae3.getTargetName();
            String clientID = bae3.getClientID();
            sb.append(this.ar.getString("A1554")).append("\n");
            this.printDurableSubscriptionInfo();
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            try {
                CmdRunner.connectToBroker(broker);
            }
            catch (BrokerAdminException bae2) {
                this.handleBrokerAdminException(bae2);
                sb.append(this.ar.getString("A1556")).append("\n");
                return 1;
            }
            if (!force) {
                input = this.getUserInput(this.ar.getString("A5014"), noShort);
                sb.append("").append("\n");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendDestroyDurableMessage(subName, clientID);
                    broker.receiveDestroyDurableReplyMessage();
                    sb.append(this.ar.getString("A1555")).append("\n");
                }
                catch (BrokerAdminException bae4) {
                    this.handleBrokerAdminException(bae4);
                    sb.append(this.ar.getString("A1556")).append("\n");
                    return 1;
                }
            }
            if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                sb.append(this.ar.getString("A1557")).append("\n");
                return 0;
            }
            sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
            sb.append("").append("\n");
            sb.append(this.ar.getString("A1557")).append("\n");
            return 1;
        }
        if ("cxn".equals(subName)) {
            Long cxnId;
            if (broker == null) {
                sb.append(this.ar.getString("A1730")).append("\n");
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            cxnIdStr = bae3.getTargetName();
            try {
                cxnId = Long.valueOf(cxnIdStr);
            }
            catch (NumberFormatException numberFormatException) {
                sb.append(this.ar.getString("A3159", (Object)cxnIdStr)).append("\n");
                sb.append(this.ar.getString("A1730")).append("\n");
                return 1;
            }
            sb.append(this.ar.getString("A1729")).append("\n");
            this.printConnectionInfo();
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            try {
                CmdRunner.connectToBroker(broker);
            }
            catch (BrokerAdminException bae3) {
                this.handleBrokerAdminException(bae3);
                sb.append(this.ar.getString("A1730")).append("\n");
                return 1;
            }
            if (!force) {
                input = this.getUserInput(this.ar.getString("A5029"), noShort);
                sb.append("").append("\n");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendDestroyConnectionMessage(cxnId);
                    broker.receiveDestroyConnectionReplyMessage();
                    sb.append(this.ar.getString("A1731")).append("\n");
                }
                catch (BrokerAdminException bae5) {
                    this.handleBrokerAdminException(bae5);
                    sb.append(this.ar.getString("A1730")).append("\n");
                    return 1;
                }
            }
            if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                sb.append(this.ar.getString("A1732")).append("\n");
                return 0;
            }
            sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
            sb.append("").append("\n");
            sb.append(this.ar.getString("A1732")).append("\n");
            return 1;
        }
        if ("msg".equals(cxnIdStr)) {
            if (broker == null) {
                sb.append("Destroying message failed.").append("\n");
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            destName = bae3.getTargetName();
            int destTypeMask = CmdRunner.getDestTypeMask((BrokerCmdProperties)bae3);
            String msgID = bae3.getMsgID();
            sb.append("Destroying message:").append("\n");
            this.printMessageInfo();
            sb.append("In the destination").append("\n");
            this.printDestinationInfo();
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            try {
                CmdRunner.connectToBroker(broker);
            }
            catch (BrokerAdminException bae4) {
                this.handleBrokerAdminException(bae4);
                sb.append("Destroying message failed.").append("\n");
                return 1;
            }
            if (!force) {
                input = this.getUserInput("Are you sure you want to destroy this message? (y/n)[n] ", noShort);
                sb.append("").append("\n");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendDestroyMessagesMessage(destName, destTypeMask, (String)bae3);
                    broker.receiveDestroyMessagesReplyMessage();
                    sb.append("Successfully destroyed message.").append("\n");
                }
                catch (BrokerAdminException bae6) {
                    this.handleBrokerAdminException(bae6);
                    sb.append("Destroying message failed.").append("\n");
                    return 1;
                }
            } else {
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    sb.append("The message was not destroyed.\n").append("\n");
                    return 0;
                }
                sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
                sb.append("").append("\n");
                sb.append("The message was not destroyed.\n").append("\n");
                return 1;
            }
        }
        broker.close();
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private int runPurge(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        void bae3;
        String input = null;
        String yes = this.ar.getString("A5016");
        String yesShort = this.ar.getString("A5015");
        String no = this.ar.getString("A5018");
        String noShort = this.ar.getString("A5017");
        String commandArg = brokerCmdProps.getCommandArg();
        boolean force = brokerCmdProps.forceModeSet();
        BrokerAdmin broker = this.init();
        if ("dst".equals(commandArg)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1240")).append("\n");
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String destName = brokerCmdProps.getTargetName();
            int destTypeMask = CmdRunner.getDestTypeMask(brokerCmdProps);
            sb.append(this.ar.getString("A1238")).append("\n");
            this.printDestinationInfo();
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            try {
                CmdRunner.connectToBroker(broker);
            }
            catch (BrokerAdminException bae2) {
                this.handleBrokerAdminException(bae2);
                sb.append(this.ar.getString("A1240")).append("\n");
                return 1;
            }
            if (!force) {
                input = this.getUserInput(this.ar.getString("A5004"), noShort);
                sb.append("").append("\n");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendPurgeDestinationMessage((String)bae3, destTypeMask);
                    broker.receivePurgeDestinationReplyMessage();
                    sb.append(this.ar.getString("A1239")).append("\n");
                }
                catch (BrokerAdminException bae3) {
                    this.handleBrokerAdminException(bae3);
                    sb.append(this.ar.getString("A1240")).append("\n");
                    return 1;
                }
            }
            if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                sb.append(this.ar.getString("A1241")).append("\n");
                return 0;
            }
            sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
            sb.append("").append("\n");
            sb.append(this.ar.getString("A1241")).append("\n");
            return 1;
        }
        if ("dur".equals(bae3)) {
            void destTypeMask;
            if (broker == null) {
                sb.append(this.ar.getString("A1634")).append("\n");
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String subName = destTypeMask.getTargetName();
            String clientID = destTypeMask.getClientID();
            sb.append(this.ar.getString("A1635")).append("\n");
            this.printDurableSubscriptionInfo();
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            try {
                CmdRunner.connectToBroker(broker);
            }
            catch (BrokerAdminException bae4) {
                this.handleBrokerAdminException(bae4);
                sb.append(this.ar.getString("A1634")).append("\n");
                return 1;
            }
            if (!force) {
                input = this.getUserInput(this.ar.getString("A5020"), noShort);
                sb.append("").append("\n");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendPurgeDurableMessage(subName, (String)bae4);
                    broker.receivePurgeDurableReplyMessage();
                    sb.append(this.ar.getString("A1636")).append("\n");
                }
                catch (BrokerAdminException bae5) {
                    this.handleBrokerAdminException(bae5);
                    sb.append(this.ar.getString("A1634")).append("\n");
                    return 1;
                }
            } else {
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    sb.append(this.ar.getString("A1637")).append("\n");
                    return 0;
                }
                sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
                sb.append("").append("\n");
                sb.append(this.ar.getString("A1637")).append("\n");
                return 1;
            }
        }
        broker.close();
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    private int runPurgeAll(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        input = null;
        ret_code = 0;
        yes = this.ar.getString("A5016");
        yesShort = this.ar.getString("A5015");
        no = this.ar.getString("A5018");
        noShort = this.ar.getString("A5017");
        commandArg = brokerCmdProps.getCommandArg();
        force = brokerCmdProps.forceModeSet();
        broker = this.init();
        if ("dst".equals(commandArg)) {
            if (broker == null) {
                sb.append("Purging all the destinations failed").append("\n");
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            sb.append("Purging all the destinations").append("\n");
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            try {
                CmdRunner.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append("Purging all the destinations failed").append("\n");
                return 1;
            }
            if (!force) {
                bae = this.getUserInput("Are you sure you want to purge all the destinations? (y/n)[n] ", noShort);
                sb.append("").append("\n");
            }
            if (yesShort.equalsIgnoreCase(bae) || yes.equalsIgnoreCase(bae) || force) {
                try {
                    dstsPurged = false;
                    broker.sendGetDestinationsMessage(null, -1);
                    dests = broker.receiveGetDestinationsReplyMessage();
                    if (dests != null) {
                        thisEnum = dests.elements();
                        while (thisEnum.hasMoreElements()) {
                            dInfo = (DestinationInfo)thisEnum.nextElement();
                            destName = dInfo.name;
                            destTypeMask = dInfo.type;
                            if ("__JMQAdmin".equals(destName) || DestType.isInternal((int)dInfo.fulltype) || DestType.isTemporary((int)dInfo.type)) {
                                sb.append("Skipping destination: " + destName).append("\n");
                                continue;
                            }
                            try {
                                broker.sendPurgeDestinationMessage(destName, destTypeMask);
                                broker.receivePurgeDestinationReplyMessage();
                                if (DestType.isQueue((int)destTypeMask)) {
                                    sb.append("Successfully purged queue " + destName).append("\n");
                                } else {
                                    sb.append("Successfully purged topic " + destName).append("\n");
                                }
                                dstsPurged = true;
                            }
                            catch (BrokerAdminException purgeEx) {
                                this.handleBrokerAdminException(purgeEx);
                                if (DestType.isQueue((int)destTypeMask)) {
                                    sb.append("Purging failed for queue " + destName).append("\n");
                                } else {
                                    sb.append("Purging failed for topic " + destName).append("\n");
                                }
                                ret_code = 1;
                            }
                        }
                    }
                    if (dstsPurged) ** GOTO lbl90
                    sb.append("No destinations purged.").append("\n");
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    sb.append("Purging all the destinations failed").append("\n");
                    return 1;
                }
            } else {
                if (var7_12.equalsIgnoreCase((String)var3_3) || var6_11.equalsIgnoreCase((String)var3_3)) {
                    sb.append("The destinations were not purged.").append("\n");
                    return 0;
                }
                sb.append(this.ar.getString("A1026", (Object)var3_3)).append("\n");
                sb.append("").append("\n");
                sb.append("The destinations were not purged.").append("\n");
                return 1;
            }
        }
lbl90:
        // 4 sources

        broker.close();
        return ret_code;
    }

    /*
     * Unable to fully structure code
     */
    private int runDestroyAll(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        input = null;
        ret_code = 0;
        yes = this.ar.getString("A5016");
        yesShort = this.ar.getString("A5015");
        no = this.ar.getString("A5018");
        noShort = this.ar.getString("A5017");
        commandArg = brokerCmdProps.getCommandArg();
        force = brokerCmdProps.forceModeSet();
        broker = this.init();
        if ("dst".equals(commandArg)) {
            if (broker == null) {
                sb.append("Destroying all the destinations failed").append("\n");
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            sb.append("Destroying all the destinations").append("\n");
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            try {
                CmdRunner.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append("Destroying all the destinations failed").append("\n");
                return 1;
            }
            if (!force) {
                bae = this.getUserInput("Are you sure you want to destroy all the destinations? (y/n)[n] ", noShort);
                sb.append("").append("\n");
            }
            if (yesShort.equalsIgnoreCase(bae) || yes.equalsIgnoreCase(bae) || force) {
                try {
                    dstsDestroyed = false;
                    broker.sendGetDestinationsMessage(null, -1);
                    dests = broker.receiveGetDestinationsReplyMessage();
                    if (dests != null) {
                        thisEnum = dests.elements();
                        while (thisEnum.hasMoreElements()) {
                            dInfo = (DestinationInfo)thisEnum.nextElement();
                            destName = dInfo.name;
                            destTypeMask = dInfo.type;
                            if ("__JMQAdmin".equals(destName) || DestType.isInternal((int)dInfo.fulltype) || DestType.isTemporary((int)dInfo.type) || DestType.isDMQ((int)dInfo.type)) {
                                sb.append("Skipping destination: " + destName).append("\n");
                                continue;
                            }
                            try {
                                broker.sendDestroyDestinationMessage(destName, destTypeMask);
                                broker.receiveDestroyDestinationReplyMessage();
                                if (DestType.isQueue((int)destTypeMask)) {
                                    Globals.stdOutPrintln((String)("Successfully destroyed queue " + destName));
                                } else {
                                    Globals.stdOutPrintln((String)("Successfully destroyed topic " + destName));
                                }
                                dstsDestroyed = true;
                            }
                            catch (BrokerAdminException destroyEx) {
                                this.handleBrokerAdminException(destroyEx);
                                if (DestType.isQueue((int)destTypeMask)) {
                                    sb.append("Destroy failed for queue " + destName).append("\n");
                                } else {
                                    sb.append("Destroy failed for topic " + destName).append("\n");
                                }
                                ret_code = 1;
                            }
                        }
                    }
                    if (dstsDestroyed) ** GOTO lbl88
                    sb.append("No destinations destroyed.").append("\n");
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    sb.append("Destroying all the destinations failed").append("\n");
                    return 1;
                }
            } else {
                if (var7_12.equalsIgnoreCase((String)var3_3) || var6_11.equalsIgnoreCase((String)var3_3)) {
                    sb.append("The destinations were not destroyed.").append("\n");
                    return 0;
                }
                sb.append(this.ar.getString("A1026", (Object)var3_3)).append("\n");
                sb.append("").append("\n");
                sb.append("The destinations were not destroyed.").append("\n");
                return 1;
            }
        }
lbl88:
        // 4 sources

        broker.close();
        return ret_code;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private int runUpdate(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        block36: {
            block37: {
                input = null;
                yes = this.ar.getString("A5016");
                yesShort = this.ar.getString("A5015");
                no = this.ar.getString("A5018");
                noShort = this.ar.getString("A5017");
                broker = this.init();
                commandArg = brokerCmdProps /* !! */ .getCommandArg();
                force = brokerCmdProps /* !! */ .forceModeSet();
                if ("bkr".equals(commandArg)) {
                    if (broker == null) {
                        sb.append(this.ar.getString("A1538")).append("\n");
                        return 1;
                    }
                    if (!force) {
                        broker = this.promptForAuthentication(broker);
                    }
                    targetAttrs = brokerCmdProps /* !! */ .getTargetAttrs();
                    sb.append(this.ar.getString("A1539")).append("\n");
                    sb.append("").append("\n");
                    var12_18 = targetAttrs;
                    brokerCmdProps /* !! */  = this;
                    CmdRunner.printAttrs(var12_18, false);
                    sb.append(this.ar.getString("A1200")).append("\n");
                    this.printBrokerInfo(broker);
                    if (!force) {
                        force = this.getUserInput(this.ar.getString("A5011"), noShort);
                        sb.append("").append("\n");
                        if (noShort.equalsIgnoreCase(force) || no.equalsIgnoreCase(force)) {
                            sb.append(this.ar.getString("A1540")).append("\n");
                            return 0;
                        }
                        if (!yesShort.equalsIgnoreCase(force) && !yes.equalsIgnoreCase(force)) {
                            sb.append(this.ar.getString("A1026", (Object)force)).append("\n");
                            sb.append("").append("\n");
                            sb.append(this.ar.getString("A1540")).append("\n");
                            return 1;
                        }
                    }
                    try {
                        CmdRunner.connectToBroker(broker);
                        broker.sendUpdateBrokerPropsMessage(targetAttrs);
                        broker.receiveUpdateBrokerPropsReplyMessage();
                        sb.append(this.ar.getString("A1541")).append("\n");
                    }
                    catch (BrokerAdminException bae) {
                        this.handleBrokerAdminException(bae);
                        sb.append(this.ar.getString("A1538")).append("\n");
                        return 1;
                    }
                }
                if ("svc".equals(targetAttrs)) {
                    if (broker == null) {
                        sb.append(this.ar.getString("A1542")).append("\n");
                        return 1;
                    }
                    if (!force) {
                        broker = this.promptForAuthentication(broker);
                    }
                    targetAttrs = bae.getTargetAttrs();
                    svcName = bae.getTargetName();
                    sb.append(this.ar.getString("A1543", (Object)svcName)).append("\n");
                    sb.append("").append("\n");
                    var12_19 = targetAttrs;
                    bae = this;
                    CmdRunner.printAttrs(var12_19, false);
                    sb.append(this.ar.getString("A1200")).append("\n");
                    this.printBrokerInfo(broker);
                    si = CmdRunner.getServiceInfoFromAttrs(targetAttrs);
                    si.setName(svcName);
                    svcPort = -1;
                    svc = null;
                    try {
                        CmdRunner.connectToBroker(broker);
                        broker.sendGetServicesMessage(svcName);
                        svc = broker.receiveGetServicesReplyMessage();
                        if (svc != null && svc.size() == 1) {
                            thisEnum = svc.elements();
                            sInfo = (ServiceInfo)thisEnum.nextElement();
                            svcPort = sInfo.port;
                        }
                    }
                    catch (BrokerAdminException bae) {
                        this.handleBrokerAdminException(bae);
                        sb.append(this.ar.getString("A1542")).append("\n");
                        return 1;
                    }
                    if (!force) {
                        force = this.getUserInput(this.ar.getString("A5012"), noShort);
                        sb.append("").append("\n");
                        if (noShort.equalsIgnoreCase(force) || no.equalsIgnoreCase(force)) {
                            sb.append(this.ar.getString("A1544")).append("\n");
                            return 0;
                        }
                        if (!yesShort.equalsIgnoreCase(force) && !yes.equalsIgnoreCase(force)) {
                            sb.append(this.ar.getString("A1026", (Object)force)).append("\n");
                            sb.append("").append("\n");
                            sb.append(this.ar.getString("A1544")).append("\n");
                            return 1;
                        }
                    }
                    if (si.isModified(1) && svcPort == -1) {
                        Globals.stdErrPrintln((String)this.ar.getString("A3149", (Object)svcName));
                        sb.append(this.ar.getString("A1542")).append("\n");
                        return 1;
                    }
                    try {
                        broker.sendUpdateServiceMessage((ServiceInfo)si);
                        broker.receiveUpdateServiceReplyMessage();
                        sb.append(this.ar.getString("A1545")).append("\n");
                    }
                    catch (BrokerAdminException bae) {
                        this.handleBrokerAdminException(bae);
                        sb.append(this.ar.getString("A1542")).append("\n");
                        return 1;
                    }
                }
                if (!"dst".equals(bae)) break block36;
                if (broker == null) {
                    sb.append(this.ar.getString("A1546")).append("\n");
                    return 1;
                }
                if (!force) {
                    broker = this.promptForAuthentication(broker);
                }
                targetAttrs = si.getTargetAttrs();
                destTypeMask = CmdRunner.getDestTypeMask((BrokerCmdProperties)si);
                destName = si.getTargetName();
                if (DestType.isQueue((int)destTypeMask)) {
                    Globals.stdOutPrintln((String)this.ar.getString("A1547", (Object)destName));
                } else {
                    Globals.stdOutPrintln((String)this.ar.getString("A1548", (Object)destName));
                }
                sb.append("").append("\n");
                svcPort = targetAttrs;
                si = this;
                CmdRunner.printAttrs(svcPort, false);
                sb.append(this.ar.getString("A1200")).append("\n");
                this.printBrokerInfo(broker);
                if (force) break block37;
                si = targetAttrs;
                if (si == null) ** GOTO lbl-1000
                force = si.getProperty("validateXMLSchemaEnabled");
                if (force != null && !force.equals("")) {
                    v0 = true;
                } else {
                    force = si.getProperty("XMLSchemaURIList");
                    if (force != null && !force.equals("")) {
                        v0 = true;
                    } else {
                        force = si.getProperty("reloadXMLSchemaOnFailure");
                        if (force != null && !force.equals("")) {
                            v0 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v0 = false;
                        }
                    }
                }
                if (v0) {
                    v1 = new Object[3];
                    args = v1;
                    v1[0] = "validateXMLSchemaEnabled";
                    args[1] = "XMLSchemaURIList";
                    args[2] = "reloadXMLSchemaOnFailure";
                    force = this.getUserInput(this.ar.getString("A5034", args), noShort);
                } else {
                    force = this.getUserInput(this.ar.getString("A5013"), noShort);
                }
                sb.append("").append("\n");
                if (noShort.equalsIgnoreCase(force) || no.equalsIgnoreCase(force)) {
                    sb.append(this.ar.getString("A1549")).append("\n");
                    return 0;
                }
                if (!yesShort.equalsIgnoreCase(force) && !yes.equalsIgnoreCase(force)) {
                    sb.append(this.ar.getString("A1026", (Object)force)).append("\n");
                    sb.append("").append("\n");
                    sb.append(this.ar.getString("A1549")).append("\n");
                    return 1;
                }
            }
            try {
                di = this.getDestinationInfoFromAttrs(targetAttrs);
                di.setType(destTypeMask);
                di.setName(destName);
                CmdRunner.connectToBroker(broker);
                broker.sendUpdateDestinationMessage(di);
                broker.receiveUpdateDestinationReplyMessage();
                sb.append(this.ar.getString("A1550")).append("\n");
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1546")).append("\n");
                return 1;
            }
        }
        broker.close();
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private static void printAttrs(Properties targetAttrs, boolean printTitle) {
        BrokerCmdPrinter bcp2;
        void bcp2;
        new BrokerCmdPrinter(2, 4);
        Object[] row = new String[2];
        if (bcp2 != false) {
            bcp2 = new BrokerCmdPrinter(2, 4, "-");
            row[0] = "Property Name";
            row[1] = "Property Value";
            bcp2.addTitle((String[])row);
        } else {
            bcp2 = new BrokerCmdPrinter(2, 4);
        }
        Enumeration<?> e = targetAttrs.propertyNames();
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            String value = targetAttrs.getProperty(propName);
            row[0] = propName;
            row[1] = value;
            bcp2.add(row);
        }
        bcp2.println();
    }

    private static ServiceInfo getServiceInfoFromAttrs(Properties svcAttrs) {
        ServiceInfo si = new ServiceInfo();
        Enumeration<?> e = svcAttrs.propertyNames();
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            String value = svcAttrs.getProperty(propName);
            int intValue = 0;
            boolean valueOK = true;
            if (propName.equals("port")) {
                try {
                    intValue = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    valueOK = false;
                }
                if (!valueOK) continue;
                si.setPort(intValue);
                continue;
            }
            if (propName.equals("minThreads")) {
                try {
                    intValue = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    valueOK = false;
                }
                if (!valueOK) continue;
                si.setMinThreads(intValue);
                continue;
            }
            if (!propName.equals("maxThreads")) continue;
            try {
                intValue = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                valueOK = false;
            }
            if (!valueOK) continue;
            si.setMaxThreads(intValue);
        }
        return si;
    }

    private DestinationInfo getDestinationInfoFromAttrs(Properties destAttrs) {
        DestinationInfo di = new DestinationInfo();
        Enumeration<?> e = destAttrs.propertyNames();
        while (e.hasMoreElements()) {
            SizeString ss;
            String propName = (String)e.nextElement();
            String value = destAttrs.getProperty(propName);
            int intValue = 0;
            long longValue = 0L;
            boolean valueOK = true;
            if (propName.equals("maxTotalMsgBytes")) {
                try {
                    ss = new SizeString(value);
                    longValue = ss.getBytes();
                }
                catch (NumberFormatException numberFormatException) {
                    valueOK = false;
                }
                if (!valueOK) continue;
                di.setMaxMessageBytes(longValue);
                continue;
            }
            if (ss.equals("maxNumMsgs")) {
                try {
                    intValue = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    valueOK = false;
                }
                if (!valueOK) continue;
                di.setMaxMessages(intValue);
                continue;
            }
            if (ss.equals("maxBytesPerMsg")) {
                try {
                    ss = new SizeString(value);
                    longValue = ss.getBytes();
                }
                catch (NumberFormatException numberFormatException) {
                    valueOK = false;
                }
                if (!valueOK) continue;
                di.setMaxMessageSize(longValue);
                continue;
            }
            if (ss.equals("maxNumBackupConsumers")) {
                try {
                    di.setMaxFailoverConsumers(Integer.parseInt(value));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (ss.equals("maxNumActiveConsumers")) {
                try {
                    di.setMaxActiveConsumers(Integer.parseInt(value));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (ss.equals("isLocalOnly")) {
                di.setScope(Boolean.valueOf(value).booleanValue());
            }
            if (ss.equals("limitBehavior")) {
                di.setLimitBehavior(CmdRunner.getLimitBehavValue(value));
            }
            if (ss.equals("localDeliveryPreferred")) {
                di.setClusterDeliveryPolicy(CmdRunner.getClusterDeliveryPolicy(value));
            }
            if (ss.equals("consumerFlowLimit")) {
                try {
                    di.setPrefetch(Integer.parseInt(value));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (ss.equals("maxNumProducers")) {
                try {
                    di.setMaxProducers(Integer.parseInt(value));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (ss.equals("useDMQ")) {
                di.setUseDMQ(Boolean.valueOf(value).booleanValue());
            }
            if (ss.equals("validateXMLSchemaEnabled")) {
                di.setValidateXMLSchemaEnabled(Boolean.valueOf(value).booleanValue());
            }
            if (ss.equals("XMLSchemaURIList")) {
                di.setXMLSchemaUriList(value);
            }
            if (!ss.equals("reloadXMLSchemaOnFailure")) continue;
            di.setReloadXMLSchemaOnFailure(Boolean.valueOf(value).booleanValue());
        }
        return di;
    }

    /*
     * WARNING - void declaration
     */
    private int runQuery(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        void thisEnum4;
        void bae4;
        CmdRunner cmdRunner;
        void sInfo2;
        void row2;
        Object bcp;
        BrokerAdmin broker = this.init();
        String commandArg = brokerCmdProps.getCommandArg();
        if ("dst".equals(commandArg)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1245")).append("\n");
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String destName = brokerCmdProps.getTargetName();
            int destTypeMask = CmdRunner.getDestTypeMask(brokerCmdProps);
            sb.append(this.ar.getString("A1242")).append("\n");
            this.printDestinationInfo();
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            try {
                Object[] row2;
                DestinationInfo dInfo;
                CmdRunner.connectToBroker(broker);
                broker.sendGetDestinationsMessage(destName, destTypeMask);
                Vector dest = broker.receiveGetDestinationsReplyMessage();
                if (dest != null && dest.size() == 1) {
                    Enumeration thisEnum2 = dest.elements();
                    dInfo = (DestinationInfo)thisEnum2.nextElement();
                    bcp = new BrokerCmdPrinter(2, 4);
                    row2 = new String[2];
                    bcp.setSortNeeded(false);
                    row2[0] = this.ar.getString("A1400");
                    row2[1] = dInfo.name;
                    bcp.add(row2);
                    row2[0] = this.ar.getString("A1401");
                    row2[1] = BrokerAdminUtil.getDestinationType((int)dInfo.type);
                    if (DestType.isTemporary((int)dInfo.type)) {
                        row2[1] = (String)row2[1] + " (" + this.ar.getString("A1631") + ")";
                    }
                    bcp.add(row2);
                    row2[0] = this.ar.getString("A1429");
                    row2[1] = DestState.toString((int)dInfo.destState);
                    bcp.add(row2);
                    row2[0] = this.ar.getString("A1427");
                    row2[1] = dInfo.autocreated ? Boolean.FALSE.toString() : Boolean.TRUE.toString();
                    bcp.add(row2);
                    row2[0] = "";
                    row2[1] = "";
                    bcp.add(row2);
                    row2[0] = this.ar.getString("A1404");
                    row2[1] = "";
                    bcp.add(row2);
                    String indent = "    ";
                    row2[0] = indent + this.ar.getString("A1735");
                    row2[1] = new Integer(dInfo.nMessages - dInfo.nTxnMessages).toString();
                    bcp.add(row2);
                    row2[0] = indent + this.ar.getString("A1738");
                    row2[1] = new Integer(dInfo.nRemoteMessages).toString();
                    bcp.add(row2);
                    row2[0] = indent + this.ar.getString("A1734");
                    row2[1] = new Integer(dInfo.nTxnMessages).toString();
                    bcp.add(row2);
                    row2[0] = this.ar.getString("A1405");
                    row2[1] = "";
                    bcp.add(row2);
                    row2[0] = indent + this.ar.getString("A1735");
                    row2[1] = new Long(dInfo.nMessageBytes - dInfo.nTxnMessageBytes).toString();
                    bcp.add(row2);
                    row2[0] = indent + this.ar.getString("A1738");
                    row2[1] = new Long(dInfo.nRemoteMessageBytes).toString();
                    bcp.add(row2);
                    row2[0] = indent + this.ar.getString("A1734");
                    row2[1] = new Long(dInfo.nTxnMessageBytes).toString();
                    bcp.add(row2);
                    row2[0] = this.ar.getString("A1428");
                    row2[1] = new Integer(dInfo.nProducers).toString();
                    bcp.add(row2);
                    if (DestType.isQueue((int)destTypeMask)) {
                        row2[0] = this.ar.getString("A1416");
                        row2[1] = new Integer(dInfo.naConsumers).toString();
                        bcp.add(row2);
                        row2[0] = this.ar.getString("A1417");
                        row2[1] = new Integer(dInfo.nfConsumers).toString();
                        bcp.add(row2);
                    } else {
                        Integer val;
                        String wildcard;
                        Enumeration keys;
                        Hashtable h = dInfo.producerWildcards;
                        row2[0] = this.ar.getString("A1692");
                        row2[1] = Integer.toString(CmdRunner.getWildcardCount(h));
                        bcp.add(row2);
                        if (h != null) {
                            keys = h.keys();
                            while (keys.hasMoreElements()) {
                                wildcard = (String)keys.nextElement();
                                val = (Integer)h.get(wildcard);
                                row2[0] = indent + wildcard + "  (" + val + ")";
                                row2[1] = "";
                                bcp.add(row2);
                            }
                        }
                        row2[0] = this.ar.getString("A1688");
                        row2[1] = new Integer(dInfo.nConsumers).toString();
                        bcp.add(row2);
                        h = dInfo.consumerWildcards;
                        row2[0] = this.ar.getString("A1693");
                        row2[1] = Integer.toString(CmdRunner.getWildcardCount(h));
                        bcp.add(row2);
                        if (h != null) {
                            keys = h.keys();
                            while (keys.hasMoreElements()) {
                                wildcard = (String)keys.nextElement();
                                val = (Integer)h.get(wildcard);
                                row2[0] = indent + wildcard + "  (" + val + ")";
                                row2[1] = "";
                                bcp.add(row2);
                            }
                        }
                    }
                    row2[0] = "";
                    row2[1] = "";
                    bcp.add(row2);
                    row2[0] = this.ar.getString("A1407");
                    row2[1] = this.checkAndPrintUnlimitedInt(dInfo.maxMessages, this.zeroNegOneInt);
                    bcp.add(row2);
                    row2[0] = this.ar.getString("A1406");
                    row2[1] = this.checkAndPrintUnlimitedLong(dInfo.maxMessageBytes, this.zeroNegOneLong);
                    bcp.add(row2);
                    row2[0] = this.ar.getString("A1408");
                    row2[1] = new Long(dInfo.maxMessageSize).toString();
                    row2[1] = this.checkAndPrintUnlimitedLong(dInfo.maxMessageSize, this.zeroNegOneLong);
                    bcp.add(row2);
                    row2[0] = this.ar.getString("A1415");
                    row2[1] = this.checkAndPrintUnlimitedInt(dInfo.maxProducers, -1);
                    bcp.add(row2);
                    if (DestType.isQueue((int)destTypeMask)) {
                        row2[0] = this.ar.getString("A1410");
                        row2[1] = this.checkAndPrintUnlimitedInt(dInfo.maxActiveConsumers, -1);
                        bcp.add(row2);
                        row2[0] = this.ar.getString("A1409");
                        row2[1] = this.checkAndPrintUnlimitedInt(dInfo.maxFailoverConsumers, -1);
                        bcp.add(row2);
                    }
                    row2[0] = "";
                    row2[1] = "";
                    bcp.add(row2);
                    row2[0] = this.ar.getString("A1412");
                    row2[1] = DestLimitBehavior.getString((int)dInfo.destLimitBehavior);
                    bcp.add(row2);
                    row2[0] = this.ar.getString("A1414");
                    row2[1] = this.checkAndPrintUnlimitedInt(dInfo.maxPrefetch, -1);
                    bcp.add(row2);
                    row2[0] = this.ar.getString("A1411");
                    row2[1] = dInfo.isDestinationLocal() ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
                    bcp.add(row2);
                    if (DestType.isQueue((int)destTypeMask)) {
                        row2[0] = this.ar.getString("A1413");
                        row2[1] = dInfo.destCDP == 1 ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
                        bcp.add(row2);
                    }
                } else {
                    sb.append(this.ar.getString("A1335")).append("\n");
                    sb.append(this.ar.getString("A1245")).append("\n");
                    return 1;
                }
                row2[0] = this.ar.getString("A1446");
                row2[1] = dInfo.useDMQ() ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
                bcp.add(row2);
                row2[0] = this.ar.getString("A1447");
                row2[1] = dInfo.validateXMLSchemaEnabled() ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
                bcp.add(row2);
                row2[0] = this.ar.getString("A1448");
                row2[1] = dInfo.XMLSchemaUriList;
                bcp.add(row2);
                row2[0] = this.ar.getString("A1449");
                row2[1] = dInfo.reloadXMLSchemaOnFailure() ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
                bcp.add(row2);
                bcp.println();
                sb.append(this.ar.getString("A1243")).append("\n");
            }
            catch (BrokerAdminException bae2) {
                this.handleBrokerAdminException(bae2);
                sb.append(this.ar.getString("A1245")).append("\n");
                return 1;
            }
        }
        if ("svc".equals(row2)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1249")).append("\n");
                return 1;
            }
            boolean force = bcp.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String svcName = bcp.getTargetName();
            sb.append(this.ar.getString("A1246")).append("\n");
            bcp = this;
            bcp.printServiceInfo(null);
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            try {
                Object[] row3;
                BrokerCmdPrinter bcp2;
                ServiceInfo sInfo2;
                CmdRunner.connectToBroker(broker);
                broker.sendGetServicesMessage(svcName);
                Vector svc = broker.receiveGetServicesReplyMessage();
                if (svc != null && svc.size() == 1) {
                    Enumeration thisEnum3 = svc.elements();
                    sInfo2 = (ServiceInfo)thisEnum3.nextElement();
                    bcp2 = new BrokerCmdPrinter(2, 4);
                    row3 = new String[2];
                    bcp2.setSortNeeded(false);
                    row3[0] = this.ar.getString("A1420");
                    row3[1] = sInfo2.name;
                    bcp2.add(row3);
                    row3[0] = this.ar.getString("A1422");
                    row3[1] = ServiceState.getString((int)sInfo2.state);
                    bcp2.add(row3);
                    if (sInfo2.port != -1) {
                        row3[0] = this.ar.getString("A1421");
                        if (sInfo2.dynamicPort) {
                            switch (sInfo2.state) {
                                case -1: {
                                    row3[1] = this.ar.getString("A1520");
                                    break;
                                }
                                default: {
                                    row3[1] = new Integer(sInfo2.port).toString() + " (" + this.ar.getString("A1520") + ")";
                                    break;
                                }
                            }
                        } else {
                            row3[1] = new Integer(sInfo2.port).toString() + " (" + this.ar.getString("A1521") + ")";
                        }
                        bcp2.add(row3);
                    }
                } else {
                    sb.append(this.ar.getString("A1335")).append("\n");
                    sb.append(this.ar.getString("A1249")).append("\n");
                    return 1;
                }
                row3[0] = "";
                row3[1] = "";
                bcp2.add(row3);
                row3[0] = this.ar.getString("A1425");
                row3[1] = new Integer(sInfo2.currentThreads).toString();
                bcp2.add(row3);
                row3[0] = this.ar.getString("A1426");
                row3[1] = new Integer(sInfo2.nConnections).toString();
                bcp2.add(row3);
                row3[0] = "";
                row3[1] = "";
                bcp2.add(row3);
                row3[0] = this.ar.getString("A1423");
                row3[1] = new Integer(sInfo2.minThreads).toString();
                bcp2.add(row3);
                row3[0] = this.ar.getString("A1424");
                row3[1] = new Integer(sInfo2.maxThreads).toString();
                bcp2.add(row3);
                bcp2.println();
                sb.append(this.ar.getString("A1247")).append("\n");
            }
            catch (BrokerAdminException bae3) {
                this.handleBrokerAdminException(bae3);
                sb.append(this.ar.getString("A1249")).append("\n");
                return 1;
            }
        }
        if ("bkr".equals(sInfo2)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1523")).append("\n");
                return 1;
            }
            boolean force = cmdRunner.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            sb.append(this.ar.getString("A1522")).append("\n");
            this.printBrokerInfo(broker);
            try {
                CmdRunner.connectToBroker(broker);
                broker.sendGetBrokerPropsMessage();
                Properties bkrProps = broker.receiveGetBrokerPropsReplyMessage();
                if (bkrProps == null) {
                    sb.append(this.ar.getString("A1523")).append("\n");
                    return 1;
                }
                if (cmdRunner.adminDebugModeSet()) {
                    CmdRunner.printAllBrokerAttrs(bkrProps);
                } else {
                    cmdRunner = this;
                    BrokerCmdPrinter bae3 = new BrokerCmdPrinter(2, 4);
                    Object[] bcp2 = new String[2];
                    bae3.setSortNeeded(false);
                    bcp2[0] = cmdRunner.ar.getString("A1626");
                    String string = bkrProps.getProperty("imq.product.version", "");
                    if (string.equals("")) {
                        string = cmdRunner.ar.getString("A1627");
                    }
                    bcp2[1] = string;
                    bae3.add(bcp2);
                    bcp2[0] = cmdRunner.ar.getString("A1525");
                    string = bkrProps.getProperty("imq.instancename", "");
                    bcp2[1] = string;
                    bae3.add(bcp2);
                    bcp2[0] = cmdRunner.ar.getString("A1711");
                    string = bkrProps.getProperty("imq.brokerid", "");
                    bcp2[1] = string;
                    bae3.add(bcp2);
                    bcp2[0] = cmdRunner.ar.getString("A1441");
                    string = bkrProps.getProperty("imq.portmapper.port", "");
                    bcp2[1] = string;
                    bae3.add(bcp2);
                    bcp2[0] = cmdRunner.ar.getString("A1733");
                    string = bkrProps.getProperty("imq.embedded", "");
                    bcp2[1] = string;
                    bae3.add(bcp2);
                    bcp2[0] = cmdRunner.ar.getString("A1763");
                    string = bkrProps.getProperty("imq.varhome", "");
                    bcp2[1] = string;
                    bae3.add(bcp2);
                    bcp2[0] = "";
                    bcp2[1] = "";
                    bae3.add(bcp2);
                    bcp2[0] = cmdRunner.ar.getString("A1628");
                    string = bkrProps.getProperty("imq.system.current_count", "");
                    bcp2[1] = string;
                    bae3.add(bcp2);
                    bcp2[0] = cmdRunner.ar.getString("A1629");
                    string = bkrProps.getProperty("imq.system.current_size", "");
                    bcp2[1] = string;
                    bae3.add(bcp2);
                    bcp2[0] = "";
                    bcp2[1] = "";
                    bae3.add(bcp2);
                    bcp2[0] = cmdRunner.ar.getString("A1684");
                    string = bkrProps.getProperty("imq.dmq.current_count", "");
                    bcp2[1] = string;
                    bae3.add(bcp2);
                    bcp2[0] = cmdRunner.ar.getString("A1685");
                    string = bkrProps.getProperty("imq.dmq.current_size", "");
                    bcp2[1] = string;
                    bae3.add(bcp2);
                    bcp2[0] = "";
                    bcp2[1] = "";
                    bae3.add(bcp2);
                    bcp2[0] = cmdRunner.ar.getString("A1683");
                    string = bkrProps.getProperty("imq.destination.logDeadMsgs", "");
                    bcp2[1] = string;
                    bae3.add(bcp2);
                    bcp2[0] = cmdRunner.ar.getString("A1686");
                    string = bkrProps.getProperty("imq.destination.DMQ.truncateBody", "");
                    bcp2[1] = string;
                    bae3.add(bcp2);
                    bcp2[0] = "";
                    bcp2[1] = "";
                    bae3.add(bcp2);
                    bcp2[0] = cmdRunner.ar.getString("A1534");
                    string = bkrProps.getProperty("imq.system.max_count", "");
                    bcp2[1] = cmdRunner.checkAndPrintUnlimited(string, cmdRunner.zeroNegOneString);
                    bae3.add(bcp2);
                    bcp2[0] = cmdRunner.ar.getString("A1535");
                    string = bkrProps.getProperty("imq.system.max_size", "");
                    bcp2[1] = cmdRunner.checkAndPrintUnlimitedBytes(string, cmdRunner.zeroNegOneLong);
                    bae3.add(bcp2);
                    bcp2[0] = cmdRunner.ar.getString("A1536");
                    string = bkrProps.getProperty("imq.message.max_size", "");
                    bcp2[1] = cmdRunner.checkAndPrintUnlimitedBytes(string, cmdRunner.zeroNegOneLong);
                    bae3.add(bcp2);
                    bcp2[0] = "";
                    bcp2[1] = "";
                    bae3.add(bcp2);
                    bcp2[0] = cmdRunner.ar.getString("A1527");
                    string = bkrProps.getProperty("imq.autocreate.queue", "");
                    bcp2[1] = string;
                    bae3.add(bcp2);
                    bcp2[0] = cmdRunner.ar.getString("A1526");
                    string = bkrProps.getProperty("imq.autocreate.topic", "");
                    bcp2[1] = string;
                    bae3.add(bcp2);
                    bcp2[0] = cmdRunner.ar.getString("A1654");
                    string = bkrProps.getProperty("imq.autocreate.queue.maxNumActiveConsumers", "");
                    bcp2[1] = cmdRunner.checkAndPrintUnlimited(string, cmdRunner.negOneString);
                    bae3.add(bcp2);
                    bcp2[0] = cmdRunner.ar.getString("A1655");
                    string = bkrProps.getProperty("imq.autocreate.queue.maxNumBackupConsumers", "");
                    bcp2[1] = cmdRunner.checkAndPrintUnlimited(string, cmdRunner.negOneString);
                    bae3.add(bcp2);
                    bcp2[0] = "";
                    bcp2[1] = "";
                    bae3.add(bcp2);
                    bcp2[0] = cmdRunner.ar.getString("A1709");
                    string = bkrProps.getProperty("imq.cluster.clusterid", "");
                    bcp2[1] = string;
                    bae3.add(bcp2);
                    bcp2[0] = cmdRunner.ar.getString("A1710");
                    string = bkrProps.getProperty("imq.cluster.ha");
                    bcp2[1] = Boolean.valueOf(string).toString();
                    bae3.add(bcp2);
                    bcp2[0] = cmdRunner.ar.getString("A1573");
                    string = bkrProps.getProperty("imq.cluster.brokerlist.active", "");
                    bcp2[1] = string;
                    bae3.add(bcp2);
                    bcp2[0] = cmdRunner.ar.getString("A1572");
                    string = bkrProps.getProperty("imq.cluster.brokerlist", "");
                    bcp2[1] = string;
                    bae3.add(bcp2);
                    bcp2[0] = cmdRunner.ar.getString("A1574");
                    string = bkrProps.getProperty("imq.cluster.masterbroker", "");
                    bcp2[1] = string;
                    bae3.add(bcp2);
                    bcp2[0] = cmdRunner.ar.getString("A1575");
                    string = bkrProps.getProperty("imq.cluster.url", "");
                    bcp2[1] = string;
                    bae3.add(bcp2);
                    bcp2[0] = "";
                    bcp2[1] = "";
                    bae3.add(bcp2);
                    bcp2[0] = cmdRunner.ar.getString("A1528");
                    string = bkrProps.getProperty("imq.log.level", "");
                    bcp2[1] = string;
                    bae3.add(bcp2);
                    bcp2[0] = cmdRunner.ar.getString("A1530");
                    string = bkrProps.getProperty("imq.log.file.rolloversecs", "");
                    bcp2[1] = cmdRunner.checkAndPrintUnlimited(string, cmdRunner.zeroNegOneString);
                    bae3.add(bcp2);
                    bcp2[0] = cmdRunner.ar.getString("A1529");
                    string = bkrProps.getProperty("imq.log.file.rolloverbytes", "");
                    bcp2[1] = cmdRunner.checkAndPrintUnlimitedBytes(string, cmdRunner.zeroNegOneLong);
                    bae3.add(bcp2);
                    bae3.println();
                }
                sb.append(this.ar.getString("A1524")).append("\n");
            }
            catch (BrokerAdminException bae4) {
                this.handleBrokerAdminException(bae4);
                sb.append(this.ar.getString("A1523")).append("\n");
                return 1;
            }
        }
        if ("txn".equals(bae4)) {
            Object tid;
            if (broker == null) {
                sb.append(this.ar.getString("A1256")).append("\n");
                return 1;
            }
            boolean force = cmdRunner.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String tidStr = cmdRunner.getTargetName();
            try {
                tid = Long.valueOf(tidStr);
            }
            catch (NumberFormatException numberFormatException) {
                sb.append(this.ar.getString("A3150", (Object)tidStr)).append("\n");
                sb.append(this.ar.getString("A1256")).append("\n");
                return 1;
            }
            sb.append(this.ar.getString("A1254")).append("\n");
            this.printTransactionInfo();
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            try {
                CmdRunner.connectToBroker(broker);
                broker.sendGetTxnsMessage(tid);
                Vector txns = broker.receiveGetTxnsReplyMessage();
                if (txns != null && txns.size() == 1) {
                    Object thisEnum4 = txns.elements();
                    Object[] txnInfo = (Object[])thisEnum4.nextElement();
                    if (cmdRunner.debugModeSet()) {
                        CmdRunner.printAllTxnAttrs((Hashtable)txnInfo);
                    } else {
                        thisEnum4 = txnInfo;
                        cmdRunner = this;
                        tid = new BrokerCmdPrinter(2, 4);
                        Object[] objectArray = new String[2];
                        txnInfo = objectArray;
                        objectArray[0] = cmdRunner.ar.getString("A1263");
                        Object object = (Long)((Hashtable)thisEnum4).get("txnid");
                        txnInfo[1] = CmdRunner.checkNullAndPrint(object);
                        tid.add(txnInfo);
                        txnInfo[0] = cmdRunner.ar.getString("A1269");
                        object = (Integer)((Hashtable)thisEnum4).get("state");
                        txnInfo[1] = cmdRunner.getTxnStateString((Integer)object);
                        tid.add(txnInfo);
                        txnInfo[0] = cmdRunner.ar.getString("A1268");
                        object = (Integer)((Hashtable)thisEnum4).get("nmsgs");
                        txnInfo[1] = CmdRunner.checkNullAndPrint(object);
                        tid.add(txnInfo);
                        txnInfo[0] = cmdRunner.ar.getString("A1267");
                        object = (Integer)((Hashtable)thisEnum4).get("nacks");
                        txnInfo[1] = CmdRunner.checkNullAndPrint(object);
                        tid.add(txnInfo);
                        txnInfo[0] = cmdRunner.ar.getString("A1264");
                        object = (String)((Hashtable)thisEnum4).get("clientid");
                        txnInfo[1] = CmdRunner.checkNullAndPrint(object);
                        tid.add(txnInfo);
                        txnInfo[0] = cmdRunner.ar.getString("A1266");
                        object = (Long)((Hashtable)thisEnum4).get("timestamp");
                        txnInfo[1] = CmdRunner.checkNullAndPrintTimestamp((Long)object);
                        tid.add(txnInfo);
                        txnInfo[0] = cmdRunner.ar.getString("A1265");
                        object = (String)((Hashtable)thisEnum4).get("connection");
                        txnInfo[1] = CmdRunner.checkNullAndPrint(object);
                        tid.add(txnInfo);
                        txnInfo[0] = cmdRunner.ar.getString("A1277");
                        object = (Long)((Hashtable)thisEnum4).get("connectionid");
                        txnInfo[1] = CmdRunner.checkNullAndPrint(object);
                        tid.add(txnInfo);
                        txnInfo[0] = cmdRunner.ar.getString("A1270");
                        object = (String)((Hashtable)thisEnum4).get("user");
                        txnInfo[1] = CmdRunner.checkNullAndPrint(object);
                        tid.add(txnInfo);
                        txnInfo[0] = cmdRunner.ar.getString("A1271");
                        object = (String)((Hashtable)thisEnum4).get("xid");
                        txnInfo[1] = CmdRunner.checkNullAndPrint(object);
                        tid.add(txnInfo);
                        tid.println();
                    }
                } else {
                    sb.append(this.ar.getString("A1335")).append("\n");
                    sb.append(this.ar.getString("A1256")).append("\n");
                    return 1;
                }
                sb.append(this.ar.getString("A1255")).append("\n");
            }
            catch (BrokerAdminException bae5) {
                this.handleBrokerAdminException(bae5);
                sb.append(this.ar.getString("A1256")).append("\n");
                return 1;
            }
        }
        if ("cxn".equals(thisEnum4)) {
            Object cxnId;
            if (broker == null) {
                sb.append(this.ar.getString("A1334")).append("\n");
                return 1;
            }
            boolean force = cmdRunner.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String cxnIdStr = cmdRunner.getTargetName();
            try {
                cxnId = Long.valueOf(cxnIdStr);
            }
            catch (NumberFormatException numberFormatException) {
                sb.append(this.ar.getString("A3159", (Object)cxnIdStr)).append("\n");
                sb.append(this.ar.getString("A1334")).append("\n");
                return 1;
            }
            sb.append(this.ar.getString("A1332")).append("\n");
            this.printConnectionInfo();
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            try {
                CmdRunner.connectToBroker(broker);
                broker.sendGetConnectionsMessage(null, cxnId);
                Vector cxnList = broker.receiveGetConnectionsReplyMessage();
                if (cxnList != null && cxnList.size() == 1) {
                    Object thisEnum5 = cxnList.elements();
                    Object[] cxnInfo = (Object[])thisEnum5.nextElement();
                    if (cmdRunner.debugModeSet()) {
                        CmdRunner.printAllCxnAttrs((Hashtable)cxnInfo);
                    } else {
                        thisEnum5 = cxnInfo;
                        cmdRunner = this;
                        cxnId = new BrokerCmdPrinter(2, 4);
                        cxnInfo = new String[2];
                        cxnId.setSortNeeded(false);
                        cxnInfo[0] = cmdRunner.ar.getString("A1323");
                        Object object = (Long)((Hashtable)thisEnum5).get("cxnid");
                        cxnInfo[1] = CmdRunner.checkNullAndPrint(object);
                        cxnId.add(cxnInfo);
                        cxnInfo[0] = cmdRunner.ar.getString("A1327");
                        object = (String)((Hashtable)thisEnum5).get("user");
                        cxnInfo[1] = CmdRunner.checkNullAndPrint(object);
                        cxnId.add(cxnInfo);
                        cxnInfo[0] = cmdRunner.ar.getString("A1331");
                        object = (String)((Hashtable)thisEnum5).get("service");
                        cxnInfo[1] = CmdRunner.checkNullAndPrint(object);
                        cxnId.add(cxnInfo);
                        cxnInfo[0] = cmdRunner.ar.getString("A1328");
                        object = (Integer)((Hashtable)thisEnum5).get("nproducers");
                        cxnInfo[1] = CmdRunner.checkNullAndPrint(object);
                        cxnId.add(cxnInfo);
                        cxnInfo[0] = cmdRunner.ar.getString("A1329");
                        object = (Integer)((Hashtable)thisEnum5).get("nconsumers");
                        cxnInfo[1] = CmdRunner.checkNullAndPrint(object);
                        cxnId.add(cxnInfo);
                        cxnInfo[0] = cmdRunner.ar.getString("A1325");
                        object = (String)((Hashtable)thisEnum5).get("host");
                        cxnInfo[1] = CmdRunner.checkNullAndPrint(object);
                        cxnId.add(cxnInfo);
                        cxnInfo[0] = cmdRunner.ar.getString("A1326");
                        object = (Integer)((Hashtable)thisEnum5).get("port");
                        cxnInfo[1] = CmdRunner.checkNullAndPrint(object);
                        cxnId.add(cxnInfo);
                        cxnInfo[0] = cmdRunner.ar.getString("A1324");
                        object = (String)((Hashtable)thisEnum5).get("clientid");
                        cxnInfo[1] = CmdRunner.checkNullAndPrint(object);
                        cxnId.add(cxnInfo);
                        cxnInfo[0] = cmdRunner.ar.getString("A1330");
                        object = (String)((Hashtable)thisEnum5).get("clientplatform");
                        cxnInfo[1] = CmdRunner.checkNullAndPrint(object);
                        cxnId.add(cxnInfo);
                        cxnId.println();
                    }
                } else {
                    sb.append(this.ar.getString("A1335")).append("\n");
                    sb.append(this.ar.getString("A1334")).append("\n");
                    return 1;
                }
                sb.append(this.ar.getString("A1333")).append("\n");
            }
            catch (BrokerAdminException bae6) {
                this.handleBrokerAdminException(bae6);
                sb.append(this.ar.getString("A1334")).append("\n");
                return 1;
            }
        }
        if ("msg".equals(thisEnum4)) {
            if (broker == null) {
                sb.append("Querying message failed.").append("\n");
                return 1;
            }
            boolean force = cmdRunner.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String destName = cmdRunner.getTargetName();
            int destTypeMask = CmdRunner.getDestTypeMask((BrokerCmdProperties)cmdRunner);
            String msgID = cmdRunner.getMsgID();
            sb.append("Querying message:").append("\n");
            this.printMessageInfo();
            sb.append("In the destination").append("\n");
            this.printDestinationInfo();
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            try {
                CmdRunner.connectToBroker(broker);
                broker.sendGetMessagesMessage(destName, destTypeMask, true, msgID, null, null);
                Vector msgList = broker.receiveGetMessagesReplyMessage();
                if (msgList != null && msgList.size() == 1) {
                    HashMap oneMsg = (HashMap)msgList.get(0);
                    this.printDisplayableMsgAttrs(oneMsg);
                    sb.append("Successfully queried message.").append("\n");
                } else {
                    sb.append("There are no messages.").append("\n");
                    sb.append("").append("\n");
                    sb.append("Successfully queried message.").append("\n");
                }
            }
            catch (BrokerAdminException bae7) {
                this.handleBrokerAdminException(bae7);
                sb.append("Querying message failed.").append("\n");
                return 1;
            }
        }
        if (broker.isConnected()) {
            broker.close();
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private int runMetrics(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        broker = this.init();
        commandArg = brokerCmdProps /* !! */ .getCommandArg();
        sleepTime = brokerCmdProps /* !! */ .getMetricInterval();
        var11_11 = brokerCmdProps /* !! */ ;
        var15_14 = var11_11.getMetricType();
        var11_11.getCommandArg();
        if (var15_14 == null || var15_14.equals("ttl")) ** GOTO lbl-1000
        if (var15_14.equals("rts")) {
            v0 = 1;
        } else if (var15_14.equals("cxn")) {
            v0 = 2;
        } else if (var15_14.equals("con")) {
            v0 = 3;
        } else if (var15_14.equals("dsk")) {
            v0 = 4;
        } else if (var15_14.equals("rem")) {
            v0 = 5;
        } else lbl-1000:
        // 2 sources

        {
            v0 = 0;
        }
        metricType = v0;
        metricSamples = brokerCmdProps /* !! */ .getMetricSamples();
        if ("svc".equals(commandArg)) {
            bcp = this.setupMetricTitle$7ec824d9(metricType);
            if (broker == null) {
                sb.append(this.ar.getString("A1559")).append("\n");
                return 1;
            }
            force = brokerCmdProps /* !! */ .forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            svcName = brokerCmdProps /* !! */ .getTargetName();
            sb.append(this.ar.getString("A1560")).append("\n");
            brokerCmdProps /* !! */  = this;
            brokerCmdProps /* !! */ .printServiceInfo(null);
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            try {
                previousMetrics = null;
                rowsPrinted = 0;
                CmdRunner.connectToBroker(broker);
                while (true) {
                    broker.sendGetMetricsMessage(svcName);
                    mc = (MetricCounters)broker.receiveGetMetricsReplyMessage();
                    if (mc == null) {
                        sb.append(this.ar.getString("A1559")).append("\n");
                        return 1;
                    }
                    this.addOneMetricRow(metricType, bcp, mc, previousMetrics);
                    if (rowsPrinted % 20 == 0) {
                        bcp.print();
                    } else {
                        bcp.print(false);
                    }
                    bcp.clear();
                    previousMetrics = mc;
                    if (metricSamples > 0 && metricSamples == ++rowsPrinted) break;
                    try {
                        Thread.sleep(sleepTime * 1000L);
                    }
                    catch (InterruptedException ie) {
                        sb.append(ie.toString()).append("\n");
                    }
                }
                sb.append("").append("\n");
                sb.append(this.ar.getString("A1298")).append("\n");
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1559")).append("\n");
                return 1;
            }
        }
        if ("bkr".equals((Object)bcp)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1561")).append("\n");
                return 1;
            }
            bcp = this.setupMetricTitle$7ec824d9(metricType);
            force = bae.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            sb.append(this.ar.getString("A1562")).append("\n");
            this.printBrokerInfo(broker);
            try {
                previousMetrics = null;
                rowsPrinted = 0;
                CmdRunner.connectToBroker(broker);
                while (true) {
                    broker.sendGetMetricsMessage(null);
                    mc = (MetricCounters)broker.receiveGetMetricsReplyMessage();
                    if (mc == null) {
                        sb.append(this.ar.getString("A1561")).append("\n");
                        return 1;
                    }
                    this.addOneMetricRow(metricType, bcp, (MetricCounters)mc, (MetricCounters)previousMetrics);
                    if (rowsPrinted % 20 == 0) {
                        bcp.print();
                    } else {
                        bcp.print(false);
                    }
                    bcp.clear();
                    previousMetrics = mc;
                    if (metricSamples > 0 && metricSamples == ++rowsPrinted) break;
                    try {
                        Thread.sleep(sleepTime * 1000L);
                    }
                    catch (InterruptedException ie) {
                        sb.append(ie.toString()).append("\n");
                    }
                }
                sb.append("").append("\n");
                sb.append(this.ar.getString("A1299")).append("\n");
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1561")).append("\n");
                return 1;
            }
        }
        if ("dst".equals((Object)bcp)) {
            destName = rowsPrinted.getTargetName();
            var15_15 = destTypeMask = CmdRunner.getDestTypeMask((BrokerCmdProperties)rowsPrinted);
            var14_30 = metricType;
            mc = this;
            var17_38 = null;
            if (var14_30 == 0) {
                var17_38 = new BrokerCmdPrinter(11, 2, "-", 1);
                var17_38.setTitleAlign(1);
                var16_39 = new String[11];
                v1 = new int[11];
                var14_31 = v1;
                v1[0] = 2;
                var14_31[1] = 0;
                var14_31[2] = 2;
                var14_31[3] = 0;
                var14_31[4] = 3;
                var14_31[5] = 0;
                var14_31[6] = 0;
                var14_31[7] = 3;
                var14_31[8] = 0;
                var14_31[9] = 0;
                var14_31[10] = 1;
                var16_39[0] = mc.ar.getString("A1659");
                var16_39[1] = "";
                var16_39[2] = mc.ar.getString("A1660");
                var16_39[3] = "";
                var16_39[4] = mc.ar.getString("A1643");
                var16_39[5] = "";
                var16_39[6] = "";
                var16_39[7] = mc.ar.getString("A1644");
                var16_39[8] = "";
                var16_39[9] = "";
                var16_39[10] = mc.ar.getString("A1645");
                var17_38.addTitle((String[])var16_39, var14_31);
                var16_39[0] = mc.ar.getString("A1667");
                var16_39[1] = mc.ar.getString("A1668");
                var16_39[2] = mc.ar.getString("A1667");
                var16_39[3] = mc.ar.getString("A1668");
                var16_39[4] = mc.ar.getString("A1649");
                var16_39[5] = mc.ar.getString("A1650");
                var16_39[6] = mc.ar.getString("A1651");
                var16_39[7] = mc.ar.getString("A1649");
                var16_39[8] = mc.ar.getString("A1650");
                var16_39[9] = mc.ar.getString("A1651");
                var16_39[10] = mc.ar.getString("A1646");
                var17_38.addTitle((String[])var16_39);
            } else if (var14_30 == 1) {
                var17_38 = new BrokerCmdPrinter(11, 2, "-", 1);
                var17_38.setTitleAlign(1);
                var16_39 = new String[11];
                v2 = new int[11];
                var14_32 = v2;
                v2[0] = 2;
                var14_32[1] = 0;
                var14_32[2] = 2;
                var14_32[3] = 0;
                var14_32[4] = 3;
                var14_32[5] = 0;
                var14_32[6] = 0;
                var14_32[7] = 3;
                var14_32[8] = 0;
                var14_32[9] = 0;
                var14_32[10] = 1;
                var16_39[0] = mc.ar.getString("A1663");
                var16_39[1] = "";
                var16_39[2] = mc.ar.getString("A1664");
                var16_39[3] = "";
                var16_39[4] = mc.ar.getString("A1643");
                var16_39[5] = "";
                var16_39[6] = "";
                var16_39[7] = mc.ar.getString("A1644");
                var16_39[8] = "";
                var16_39[9] = "";
                var16_39[10] = mc.ar.getString("A1645");
                var17_38.addTitle((String[])var16_39, var14_32);
                var16_39[0] = mc.ar.getString("A1667");
                var16_39[1] = mc.ar.getString("A1668");
                var16_39[2] = mc.ar.getString("A1667");
                var16_39[3] = mc.ar.getString("A1668");
                var16_39[4] = mc.ar.getString("A1649");
                var16_39[5] = mc.ar.getString("A1650");
                var16_39[6] = mc.ar.getString("A1651");
                var16_39[7] = mc.ar.getString("A1649");
                var16_39[8] = mc.ar.getString("A1650");
                var16_39[9] = mc.ar.getString("A1651");
                var16_39[10] = mc.ar.getString("A1646");
                var17_38.addTitle((String[])var16_39);
            } else if (var14_30 == 3) {
                if (DestType.isQueue((int)var15_15)) {
                    var17_38 = new BrokerCmdPrinter(9, 2, "-", 1);
                    var17_38.setTitleAlign(1);
                    var16_39 = new String[9];
                    v3 = new int[9];
                    var14_33 = v3;
                    v3[0] = 3;
                    var14_33[1] = 0;
                    var14_33[2] = 0;
                    var14_33[3] = 3;
                    var14_33[4] = 0;
                    var14_33[5] = 0;
                    var14_33[6] = 3;
                    var14_33[7] = 0;
                    var14_33[8] = 0;
                    var16_39[0] = mc.ar.getString("A1652");
                    var16_39[1] = "";
                    var16_39[2] = "";
                    var16_39[3] = mc.ar.getString("A1653");
                    var16_39[4] = "";
                    var16_39[5] = "";
                    var16_39[6] = mc.ar.getString("A1643");
                    var16_39[7] = "";
                    var16_39[8] = "";
                    var17_38.addTitle((String[])var16_39, var14_33);
                    var16_39[0] = mc.ar.getString("A1649");
                    var16_39[1] = mc.ar.getString("A1650");
                    var16_39[2] = mc.ar.getString("A1651");
                    var16_39[3] = mc.ar.getString("A1649");
                    var16_39[4] = mc.ar.getString("A1650");
                    var16_39[5] = mc.ar.getString("A1651");
                    var16_39[6] = mc.ar.getString("A1649");
                    var16_39[7] = mc.ar.getString("A1650");
                    var16_39[8] = mc.ar.getString("A1651");
                    var17_38.addTitle((String[])var16_39);
                } else {
                    var17_38 = new BrokerCmdPrinter(6, 2, "-", 1);
                    var17_38.setTitleAlign(1);
                    var16_39 = new String[6];
                    v4 = new int[6];
                    var14_34 = v4;
                    v4[0] = 3;
                    var14_34[1] = 0;
                    var14_34[2] = 0;
                    var14_34[3] = 3;
                    var14_34[4] = 0;
                    var14_34[5] = 0;
                    var16_39[0] = mc.ar.getString("A1687");
                    var16_39[1] = "";
                    var16_39[2] = "";
                    var16_39[3] = mc.ar.getString("A1643");
                    var16_39[4] = "";
                    var16_39[5] = "";
                    var17_38.addTitle((String[])var16_39, var14_34);
                    var16_39[0] = mc.ar.getString("A1649");
                    var16_39[1] = mc.ar.getString("A1650");
                    var16_39[2] = mc.ar.getString("A1651");
                    var16_39[3] = mc.ar.getString("A1649");
                    var16_39[4] = mc.ar.getString("A1650");
                    var16_39[5] = mc.ar.getString("A1651");
                    var17_38.addTitle((String[])var16_39);
                }
            } else if (var14_30 == 4) {
                var17_38 = new BrokerCmdPrinter(3, 2, "-", 1);
                v5 = new String[3];
                var16_39 = v5;
                v5[0] = mc.ar.getString("A1656");
                var16_39[1] = mc.ar.getString("A1657");
                var16_39[2] = mc.ar.getString("A1658");
                var17_38.addTitle((String[])var16_39);
            } else if (var14_30 == 5) {
                var17_38 = new BrokerCmdPrinter(3, 2, "-", 1);
                var17_38.setTitleAlign(1);
                var16_39 = new String[3];
                v6 = new int[3];
                var14_35 = v6;
                v6[0] = 3;
                var14_35[1] = 0;
                var14_35[2] = 0;
                var16_39[0] = "Msgs Removed";
                var16_39[1] = "";
                var16_39[2] = "";
                var17_38.addTitle((String[])var16_39, var14_35);
                var16_39[0] = "Expired";
                var16_39[1] = "Discarded";
                var16_39[2] = "Purged";
                var17_38.addTitle((String[])var16_39);
            }
            bcp = var17_38;
            if (broker == null) {
                sb.append(this.ar.getString("A1296")).append("\n");
                return 1;
            }
            force = rowsPrinted.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            sb.append(this.ar.getString("A1297")).append("\n");
            this.printDestinationInfo();
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            try {
                previousMetrics = null;
                rowsPrinted = 0;
                CmdRunner.connectToBroker(broker);
                while (true) {
                    broker.sendGetMetricsMessage(destName, destTypeMask);
                    mc = (DestMetricsCounters)broker.receiveGetMetricsReplyMessage();
                    if (mc == null) {
                        sb.append(this.ar.getString("A1296")).append("\n");
                        return 1;
                    }
                    var17_38 = previousMetrics;
                    var16_39 = mc;
                    force = bcp;
                    var15_15 = destTypeMask;
                    var14_36 = metricType;
                    previousMetrics = this;
                    if (var14_36 == 0) {
                        v7 = new String[11];
                        previousMetrics = v7;
                        v7[0] = Integer.toString(var16_39.getMessagesIn());
                        previousMetrics[1] = Integer.toString(var16_39.getMessagesOut());
                        previousMetrics[2] = Long.toString(var16_39.getMessageBytesIn());
                        previousMetrics[3] = Long.toString(var16_39.getMessageBytesOut());
                        previousMetrics[4] = Integer.toString(var16_39.getCurrentMessages());
                        previousMetrics[5] = Integer.toString(var16_39.getHighWaterMessages());
                        previousMetrics[6] = Integer.toString(var16_39.getAverageMessages());
                        previousMetrics[7] = CmdRunner.displayInKBytes(var16_39.getCurrentMessageBytes());
                        previousMetrics[8] = CmdRunner.displayInKBytes(var16_39.getHighWaterMessageBytes());
                        previousMetrics[9] = CmdRunner.displayInKBytes(var16_39.getAverageMessageBytes());
                        previousMetrics[10] = CmdRunner.displayInKBytes(var16_39.getHighWaterLargestMsgBytes());
                        force.add((Object[])previousMetrics);
                    } else if (var14_36 == 1) {
                        previousMetrics = new String[11];
                        if (var17_38 == null) {
                            previousMetrics[0] = "0";
                            previousMetrics[1] = "0";
                            previousMetrics[2] = "0";
                            previousMetrics[3] = "0";
                        } else {
                            var14_37 = (float)(var16_39.timeStamp - var17_38.timeStamp) / 1000.0f;
                            previousMetrics[0] = CmdRunner.getRateString(var16_39.getMessagesIn(), var17_38.getMessagesIn(), var14_37);
                            previousMetrics[1] = CmdRunner.getRateString(var16_39.getMessagesOut(), var17_38.getMessagesOut(), var14_37);
                            previousMetrics[2] = CmdRunner.getRateString(var16_39.getMessageBytesIn(), var17_38.getMessageBytesIn(), var14_37);
                            previousMetrics[3] = CmdRunner.getRateString(var16_39.getMessageBytesOut(), var17_38.getMessageBytesOut(), var14_37);
                        }
                        previousMetrics[4] = Integer.toString(var16_39.getCurrentMessages());
                        previousMetrics[5] = Integer.toString(var16_39.getHighWaterMessages());
                        previousMetrics[6] = Integer.toString(var16_39.getAverageMessages());
                        previousMetrics[7] = CmdRunner.displayInKBytes(var16_39.getCurrentMessageBytes());
                        previousMetrics[8] = CmdRunner.displayInKBytes(var16_39.getHighWaterMessageBytes());
                        previousMetrics[9] = CmdRunner.displayInKBytes(var16_39.getAverageMessageBytes());
                        previousMetrics[10] = CmdRunner.displayInKBytes(var16_39.getHighWaterLargestMsgBytes());
                        force.add((Object[])previousMetrics);
                    } else if (var14_36 == 3) {
                        if (DestType.isQueue((int)var15_15)) {
                            v8 = new String[9];
                            previousMetrics = v8;
                            v8[0] = Integer.toString(var16_39.getActiveConsumers());
                            previousMetrics[1] = Integer.toString(var16_39.getHWActiveConsumers());
                            previousMetrics[2] = Integer.toString(var16_39.getAvgActiveConsumers());
                            previousMetrics[3] = Integer.toString(var16_39.getFailoverConsumers());
                            previousMetrics[4] = Integer.toString(var16_39.getHWFailoverConsumers());
                            previousMetrics[5] = Integer.toString(var16_39.getAvgFailoverConsumers());
                            previousMetrics[6] = Integer.toString(var16_39.getCurrentMessages());
                            previousMetrics[7] = Integer.toString(var16_39.getHighWaterMessages());
                            previousMetrics[8] = Integer.toString(var16_39.getAverageMessages());
                            force.add((Object[])previousMetrics);
                        } else {
                            v9 = new String[6];
                            previousMetrics = v9;
                            v9[0] = Integer.toString(var16_39.getActiveConsumers());
                            previousMetrics[1] = Integer.toString(var16_39.getHWActiveConsumers());
                            previousMetrics[2] = Integer.toString(var16_39.getAvgActiveConsumers());
                            previousMetrics[3] = Integer.toString(var16_39.getCurrentMessages());
                            previousMetrics[4] = Integer.toString(var16_39.getHighWaterMessages());
                            previousMetrics[5] = Integer.toString(var16_39.getAverageMessages());
                            force.add((Object[])previousMetrics);
                        }
                    } else if (var14_36 == 4) {
                        v10 = new String[3];
                        previousMetrics = v10;
                        v10[0] = Long.toString(var16_39.getDiskReserved());
                        previousMetrics[1] = Long.toString(var16_39.getDiskUsed());
                        previousMetrics[2] = Integer.toString(var16_39.getDiskUtilizationRatio());
                        force.add((Object[])previousMetrics);
                    } else if (var14_36 == 5) {
                        v11 = new String[3];
                        previousMetrics = v11;
                        v11[0] = "0";
                        previousMetrics[1] = "0";
                        previousMetrics[2] = "0";
                        force.add((Object[])previousMetrics);
                    }
                    if (rowsPrinted % 20 == 0) {
                        bcp.print();
                    } else {
                        bcp.print(false);
                    }
                    bcp.clear();
                    previousMetrics = mc;
                    if (metricSamples > 0 && metricSamples == ++rowsPrinted) break;
                    try {
                        Thread.sleep(sleepTime * 1000L);
                    }
                    catch (InterruptedException ie) {
                        sb.append(ie.toString()).append("\n");
                    }
                }
                sb.append("").append("\n");
                sb.append(this.ar.getString("A1300")).append("\n");
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1296")).append("\n");
                return 1;
            }
        }
        if (broker.isConnected()) {
            broker.close();
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private BrokerCmdPrinter setupMetricTitle$7ec824d9(int metricType) {
        void titleRow2;
        BrokerCmdPrinter bcp = null;
        if (metricType == 0) {
            int[] span = new int[8];
            bcp = new BrokerCmdPrinter(8, 2, "-", 1);
            bcp.setTitleAlign(1);
            String[] titleRow2 = new String[8];
            span[0] = 2;
            span[1] = 0;
            span[2] = 2;
            span[3] = 0;
            span[4] = 2;
            span[5] = 0;
            span[6] = 2;
            span[7] = 0;
            titleRow2[0] = this.ar.getString("A1659");
            titleRow2[1] = "";
            titleRow2[2] = this.ar.getString("A1660");
            titleRow2[3] = "";
            titleRow2[4] = this.ar.getString("A1661");
            titleRow2[5] = "";
            titleRow2[6] = this.ar.getString("A1662");
            titleRow2[7] = "";
            bcp.addTitle(titleRow2, span);
            titleRow2[0] = this.ar.getString("A1667");
            titleRow2[1] = this.ar.getString("A1668");
            titleRow2[2] = this.ar.getString("A1667");
            titleRow2[3] = this.ar.getString("A1668");
            titleRow2[4] = this.ar.getString("A1667");
            titleRow2[5] = this.ar.getString("A1668");
            titleRow2[6] = this.ar.getString("A1667");
            titleRow2[7] = this.ar.getString("A1668");
            bcp.addTitle(titleRow2);
        } else if (titleRow2 == true) {
            int[] span = new int[8];
            bcp = new BrokerCmdPrinter(8, 2, "-", 1);
            bcp.setTitleAlign(1);
            String[] titleRow3 = new String[8];
            span[0] = 2;
            span[1] = 0;
            span[2] = 2;
            span[3] = 0;
            span[4] = 2;
            span[5] = 0;
            span[6] = 2;
            span[7] = 0;
            titleRow3[0] = this.ar.getString("A1663");
            titleRow3[1] = "";
            titleRow3[2] = this.ar.getString("A1664");
            titleRow3[3] = "";
            titleRow3[4] = this.ar.getString("A1665");
            titleRow3[5] = "";
            titleRow3[6] = this.ar.getString("A1666");
            titleRow3[7] = "";
            bcp.addTitle(titleRow3, span);
            titleRow3[0] = this.ar.getString("A1667");
            titleRow3[1] = this.ar.getString("A1668");
            titleRow3[2] = this.ar.getString("A1667");
            titleRow3[3] = this.ar.getString("A1668");
            titleRow3[4] = this.ar.getString("A1667");
            titleRow3[5] = this.ar.getString("A1668");
            titleRow3[6] = this.ar.getString("A1667");
            titleRow3[7] = this.ar.getString("A1668");
            bcp.addTitle(titleRow3);
        } else if (titleRow2 == 2) {
            String[] titleRow4 = new String[6];
            int[] span = new int[6];
            bcp = new BrokerCmdPrinter(6, 2, "-", 1);
            bcp.setTitleAlign(1);
            span[0] = 1;
            span[1] = 2;
            span[2] = 0;
            span[3] = 3;
            span[4] = 0;
            span[5] = 0;
            titleRow4[0] = this.ar.getString("A1608");
            titleRow4[1] = this.ar.getString("A1669");
            titleRow4[2] = "";
            titleRow4[3] = this.ar.getString("A1670");
            titleRow4[4] = "";
            titleRow4[5] = "";
            bcp.addTitle(titleRow4, span);
            titleRow4[0] = this.ar.getString("A1609");
            titleRow4[1] = this.ar.getString("A1647");
            titleRow4[2] = this.ar.getString("A1671");
            titleRow4[3] = this.ar.getString("A1672");
            titleRow4[4] = this.ar.getString("A1673");
            titleRow4[5] = this.ar.getString("A1674");
            bcp.addTitle(titleRow4);
        }
        return bcp;
    }

    /*
     * WARNING - void declaration
     */
    private void addOneMetricRow(int metricType, BrokerCmdPrinter bcp, MetricCounters latest, MetricCounters previous) {
        void metricRow2;
        if (metricType == 0) {
            Object[] objectArray = new String[8];
            Object[] metricRow2 = objectArray;
            objectArray[0] = Long.toString(latest.messagesIn);
            metricRow2[1] = Long.toString(latest.messagesOut);
            metricRow2[2] = Long.toString(latest.messageBytesIn);
            metricRow2[3] = Long.toString(latest.messageBytesOut);
            metricRow2[4] = Long.toString(latest.packetsIn);
            metricRow2[5] = Long.toString(latest.packetsOut);
            metricRow2[6] = Long.toString(latest.packetBytesIn);
            metricRow2[7] = Long.toString(latest.packetBytesOut);
            bcp.add(metricRow2);
            return;
        }
        if (metricRow2 == true) {
            Object[] metricRow3 = new String[8];
            if (previous == null) {
                metricRow3[0] = "0";
                metricRow3[1] = "0";
                metricRow3[2] = "0";
                metricRow3[3] = "0";
                metricRow3[4] = "0";
                metricRow3[5] = "0";
                metricRow3[6] = "0";
                metricRow3[7] = "0";
            } else {
                float secs = (float)(latest.timeStamp - previous.timeStamp) / 1000.0f;
                metricRow3[0] = CmdRunner.getRateString(latest.messagesIn, previous.messagesIn, secs);
                metricRow3[1] = CmdRunner.getRateString(latest.messagesOut, previous.messagesOut, secs);
                metricRow3[2] = CmdRunner.getRateString(latest.messageBytesIn, previous.messageBytesIn, secs);
                metricRow3[3] = CmdRunner.getRateString(latest.messageBytesOut, previous.messageBytesOut, secs);
                metricRow3[4] = CmdRunner.getRateString(latest.packetsIn, previous.packetsIn, secs);
                metricRow3[5] = CmdRunner.getRateString(latest.packetsOut, previous.packetsOut, secs);
                metricRow3[6] = CmdRunner.getRateString(latest.packetBytesIn, previous.packetBytesIn, secs);
                metricRow3[7] = CmdRunner.getRateString(latest.packetBytesOut, previous.packetBytesOut, secs);
            }
            bcp.add(metricRow3);
            return;
        }
        if (metricRow2 == 2) {
            Object[] objectArray = new String[6];
            Object[] metricRow4 = objectArray;
            objectArray[0] = Integer.toString(latest.nConnections);
            metricRow4[1] = Long.toString(latest.totalMemory);
            metricRow4[2] = Long.toString(latest.freeMemory);
            metricRow4[3] = Integer.toString(latest.threadsActive);
            metricRow4[4] = Integer.toString(latest.threadsLowWater);
            metricRow4[5] = Integer.toString(latest.threadsHighWater);
            bcp.add(metricRow4);
        }
    }

    private static String getRateString(long latest2, long previous, float secs) {
        long diff = latest2 - previous;
        long rate = (long)((float)diff / secs);
        String latest2 = rate == 0L ? (diff != 0L ? "< 1" : "0") : Long.toString(rate);
        return latest2;
    }

    private static String displayInKBytes(long l) {
        if (l == 0L) {
            return "0";
        }
        if (l < 1024L) {
            return "< 1";
        }
        return Long.toString(l / 1024L);
    }

    private int runReload(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        BrokerAdmin broker = this.init();
        if (broker == null) {
            sb.append(this.ar.getString("A1229")).append("\n");
            return 1;
        }
        boolean force = brokerCmdProps.forceModeSet();
        if (!force) {
            broker = this.promptForAuthentication(broker);
        }
        sb.append(this.ar.getString("A1569")).append("\n");
        this.printBrokerInfo(broker);
        try {
            CmdRunner.connectToBroker(broker);
            broker.sendReloadClusterMessage();
            broker.receiveReloadClusterReplyMessage();
            sb.append(this.ar.getString("A1571")).append("\n");
        }
        catch (BrokerAdminException bae) {
            this.handleBrokerAdminException(bae);
            sb.append(this.ar.getString("A1570")).append("\n");
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private int runCommit(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        block11: {
            Long tid;
            String yes = this.ar.getString("A5016");
            String yesShort = this.ar.getString("A5015");
            String no = this.ar.getString("A5018");
            String noShort = this.ar.getString("A5017");
            BrokerAdmin broker = this.init();
            if (broker == null) {
                sb.append(this.ar.getString("A1259")).append("\n");
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            sb.append(this.ar.getString("A1257")).append("\n");
            this.printTransactionInfo();
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            String tidStr = brokerCmdProps.getTargetName();
            try {
                tid = Long.valueOf(tidStr);
            }
            catch (NumberFormatException numberFormatException) {
                void nfe;
                sb.append(this.ar.getString("A3150", (Object)nfe)).append("\n");
                sb.append(this.ar.getString("A1259")).append("\n");
                return 1;
            }
            try {
                void bae2;
                CmdRunner.connectToBroker(broker);
                String input = null;
                if (!force) {
                    input = this.getUserInput(this.ar.getString("A5033"), noShort);
                    sb.append("").append("\n");
                }
                if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                    try {
                        broker.sendCommitTxnMessage(tid);
                        broker.receiveCommitTxnReplyMessage();
                        sb.append(this.ar.getString("A1258")).append("\n");
                        break block11;
                    }
                    catch (BrokerAdminException bae2) {
                        this.handleBrokerAdminException(bae2);
                        sb.append(this.ar.getString("A1259")).append("\n");
                        return 1;
                    }
                }
                if (noShort.equalsIgnoreCase((String)bae2) || no.equalsIgnoreCase((String)bae2)) {
                    sb.append(this.ar.getString("A1279")).append("\n");
                    return 0;
                }
                sb.append(this.ar.getString("A1026", (Object)bae2)).append("\n");
                sb.append("").append("\n");
                sb.append(this.ar.getString("A1279")).append("\n");
                return 1;
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1259")).append("\n");
                return 1;
            }
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private int runRollback(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        block14: {
            Long tid;
            String yes = this.ar.getString("A5016");
            String yesShort = this.ar.getString("A5015");
            String no = this.ar.getString("A5018");
            String noShort = this.ar.getString("A5017");
            BrokerAdmin broker = this.init();
            if (broker == null) {
                sb.append(this.ar.getString("A1262")).append("\n");
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            sb.append(this.ar.getString("A1260")).append("\n");
            this.printTransactionInfo();
            sb.append(this.ar.getString("A1200")).append("\n");
            this.printBrokerInfo(broker);
            String tidStr = brokerCmdProps.getTargetName();
            try {
                tid = Long.valueOf(tidStr);
            }
            catch (NumberFormatException numberFormatException) {
                void nfe;
                sb.append(this.ar.getString("A3150", (Object)nfe)).append("\n");
                sb.append(this.ar.getString("A1262")).append("\n");
                return 1;
            }
            try {
                Object thisEnum;
                CmdRunner.connectToBroker(broker);
                broker.sendGetTxnsMessage(tid);
                Vector txns = broker.receiveGetTxnsReplyMessage();
                if (txns != null && txns.size() == 1) {
                    thisEnum = txns.elements();
                    thisEnum = (Hashtable)thisEnum.nextElement();
                    if (brokerCmdProps.debugModeSet()) {
                        CmdRunner.printAllTxnAttrs((Hashtable)thisEnum);
                    }
                } else {
                    sb.append(this.ar.getString("A1335")).append("\n");
                    sb.append(this.ar.getString("A1262")).append("\n");
                    return 1;
                }
                Integer tmpInt = (Integer)((Hashtable)thisEnum).get("state");
                String txnState = this.getTxnStateString(tmpInt);
                String input = null;
                if (!force) {
                    input = this.getUserInput(this.ar.getString("A5032", (Object)txnState), noShort);
                    sb.append("").append("\n");
                }
                if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                    try {
                        broker.sendRollbackTxnMessage(tid);
                        broker.receiveRollbackTxnReplyMessage();
                        sb.append(this.ar.getString("A1261")).append("\n");
                        break block14;
                    }
                    catch (BrokerAdminException bae) {
                        this.handleBrokerAdminException(bae);
                        sb.append(this.ar.getString("A1262")).append("\n");
                        return 1;
                    }
                }
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    sb.append(this.ar.getString("A1278")).append("\n");
                    return 0;
                }
                sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
                sb.append("").append("\n");
                sb.append(this.ar.getString("A1278")).append("\n");
                return 1;
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1262")).append("\n");
                return 1;
            }
        }
        return 0;
    }

    private int runCompact(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        String input = null;
        boolean compactAll = true;
        String yes = this.ar.getString("A5016");
        String yesShort = this.ar.getString("A5015");
        String no = this.ar.getString("A5018");
        String noShort = this.ar.getString("A5017");
        String commandArg = brokerCmdProps.getCommandArg();
        boolean force = brokerCmdProps.forceModeSet();
        BrokerAdmin broker = this.init();
        if ("dst".equals(commandArg)) {
            String destName = brokerCmdProps.getTargetName();
            int destTypeMask = CmdRunner.getDestTypeMask(brokerCmdProps);
            if (destName != null) {
                compactAll = false;
            }
            if (broker == null) {
                if (compactAll) {
                    sb.append(this.ar.getString("A1306")).append("\n");
                } else {
                    sb.append(this.ar.getString("A1305")).append("\n");
                }
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            if (compactAll) {
                sb.append(this.ar.getString("A1302")).append("\n");
                this.printBrokerInfo(broker);
            } else {
                sb.append(this.ar.getString("A1301")).append("\n");
                this.printDestinationInfo();
                sb.append(this.ar.getString("A1200")).append("\n");
                this.printBrokerInfo(broker);
            }
            try {
                CmdRunner.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                if (compactAll) {
                    sb.append(this.ar.getString("A1306")).append("\n");
                } else {
                    sb.append(this.ar.getString("A1305")).append("\n");
                }
                return 1;
            }
            if (!force) {
                input = compactAll ? this.getUserInput(this.ar.getString("A5024"), noShort) : this.getUserInput(this.ar.getString("A5023"), noShort);
                sb.append("").append("\n");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendCompactDestinationMessage(destName, (int)bae);
                    broker.receiveCompactDestinationReplyMessage();
                    if (compactAll) {
                        sb.append(this.ar.getString("A1304")).append("\n");
                    }
                    sb.append(this.ar.getString("A1303")).append("\n");
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    if (compactAll) {
                        sb.append(this.ar.getString("A1306")).append("\n");
                    } else {
                        sb.append(this.ar.getString("A1305")).append("\n");
                    }
                    return 1;
                }
            } else {
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    if (compactAll) {
                        sb.append(this.ar.getString("A1308")).append("\n");
                    } else {
                        sb.append(this.ar.getString("A1307")).append("\n");
                    }
                    return 0;
                }
                sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
                sb.append("").append("\n");
                if (compactAll) {
                    sb.append(this.ar.getString("A1308")).append("\n");
                } else {
                    sb.append(this.ar.getString("A1307")).append("\n");
                }
                return 1;
            }
        }
        broker.close();
        return 0;
    }

    private int runQuiesce(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        String input = null;
        String yes = this.ar.getString("A5016");
        String yesShort = this.ar.getString("A5015");
        String no = this.ar.getString("A5018");
        String noShort = this.ar.getString("A5017");
        BrokerAdmin broker = this.init();
        boolean force = brokerCmdProps.forceModeSet();
        String commandArg = brokerCmdProps.getCommandArg();
        if ("bkr".equals(commandArg)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1701")).append("\n");
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            sb.append(this.ar.getString("A1700")).append("\n");
            this.printBrokerInfo(broker);
            try {
                CmdRunner.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1701")).append("\n");
                return 1;
            }
            if (!force) {
                input = this.getUserInput(this.ar.getString("A5027"), noShort);
                sb.append("").append("\n");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendQuiesceMessage();
                    broker.receiveQuiesceReplyMessage();
                    sb.append(this.ar.getString("A1702")).append("\n");
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    sb.append(this.ar.getString("A1701")).append("\n");
                    return 1;
                }
            } else {
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    sb.append(this.ar.getString("A1703")).append("\n");
                    return 0;
                }
                sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
                sb.append("").append("\n");
                sb.append(this.ar.getString("A1703")).append("\n");
                return 1;
            }
        }
        broker.close();
        return 0;
    }

    private int runUnquiesce(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        String input = null;
        String yes = this.ar.getString("A5016");
        String yesShort = this.ar.getString("A5015");
        String no = this.ar.getString("A5018");
        String noShort = this.ar.getString("A5017");
        BrokerAdmin broker = this.init();
        boolean force = brokerCmdProps.forceModeSet();
        String commandArg = brokerCmdProps.getCommandArg();
        if ("bkr".equals(commandArg)) {
            if (broker == null) {
                sb.append(this.ar.getString("A1751")).append("\n");
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            sb.append(this.ar.getString("A1750")).append("\n");
            this.printBrokerInfo(broker);
            try {
                CmdRunner.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1751")).append("\n");
                return 1;
            }
            if (!force) {
                input = this.getUserInput(this.ar.getString("A5030"), noShort);
                sb.append("").append("\n");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendUnquiesceMessage();
                    broker.receiveUnquiesceReplyMessage();
                    sb.append(this.ar.getString("A1752")).append("\n");
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    sb.append(this.ar.getString("A1751")).append("\n");
                    return 1;
                }
            } else {
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    sb.append(this.ar.getString("A1753")).append("\n");
                    return 0;
                }
                sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
                sb.append("").append("\n");
                sb.append(this.ar.getString("A1753")).append("\n");
                return 1;
            }
        }
        broker.close();
        return 0;
    }

    private int runTakeover(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        String input = null;
        String yes = this.ar.getString("A5016");
        String yesShort = this.ar.getString("A5015");
        String no = this.ar.getString("A5018");
        String noShort = this.ar.getString("A5017");
        BrokerAdmin broker = this.init();
        boolean force = brokerCmdProps.forceModeSet();
        String commandArg = brokerCmdProps.getCommandArg();
        if ("bkr".equals(commandArg)) {
            Vector bkrList;
            String brokerID = brokerCmdProps.getTargetName();
            if (broker == null) {
                sb.append(this.ar.getString("A1705")).append("\n");
                return 1;
            }
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            sb.append(this.ar.getString("A1704")).append("\n");
            sb.append(this.ar.getString("A1708")).append("\n");
            this.printBrokerInfo(broker);
            try {
                CmdRunner.connectToBroker(broker);
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1705")).append("\n");
                return 1;
            }
            try {
                broker.sendGetBrokerPropsMessage();
                Properties bkrProps = broker.receiveGetBrokerPropsReplyMessage();
                String value = bkrProps.getProperty("imq.cluster.ha");
                if (!Boolean.valueOf(value).booleanValue()) {
                    sb.append(this.ar.getString("A3171")).append("\n");
                    sb.append(this.ar.getString("A1705")).append("\n");
                    return 1;
                }
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A1523")).append("\n");
                sb.append(this.ar.getString("A1705")).append("\n");
                return 1;
            }
            sb.append(this.ar.getString("A1769")).append("\n");
            BrokerCmdPrinter bcp = new BrokerCmdPrinter(5, 3, "-");
            Object[] row = new String[5];
            bcp.setSortNeeded(false);
            bcp.setTitleAlign(1);
            row[0] = "";
            row[1] = "";
            row[2] = "";
            row[3] = "";
            row[4] = this.ar.getString("A1721");
            bcp.addTitle((String[])row);
            row[0] = this.ar.getString("A1716");
            row[1] = this.ar.getString("A1717");
            row[2] = this.ar.getString("A1718");
            row[3] = this.ar.getString("A1719");
            row[4] = this.ar.getString("A1737");
            bcp.addTitle((String[])row);
            try {
                broker.sendGetClusterMessage(true);
                bkrList = broker.receiveGetClusterReplyMessage();
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                sb.append(this.ar.getString("A3169")).append("\n");
                sb.append(this.ar.getString("A1705")).append("\n");
                return 1;
            }
            String brokerIDFromList = null;
            boolean found = false;
            Enumeration thisEnum = bkrList.elements();
            while (thisEnum.hasMoreElements()) {
                Hashtable bkrClsInfo = (Hashtable)thisEnum.nextElement();
                brokerIDFromList = (String)bkrClsInfo.get("ID");
                if (brokerIDFromList == null || !brokerIDFromList.equals(brokerID)) continue;
                found = true;
                row[0] = CmdRunner.checkNullAndPrint(brokerIDFromList);
                row[1] = CmdRunner.checkNullAndPrint(bkrClsInfo.get("Address"));
                Integer tmpInt = (Integer)bkrClsInfo.get("State");
                row[2] = tmpInt != null ? BrokerState.toString((int)tmpInt) : "";
                Long tmpLong = (Long)bkrClsInfo.get("NumMsgs");
                row[3] = CmdRunner.checkNullAndPrint(tmpLong);
                tmpLong = (Long)bkrClsInfo.get("StatusTimestamp");
                if (tmpLong != null) {
                    long idle = System.currentTimeMillis() - tmpLong;
                    row[4] = CmdRunner.getTimeString(idle);
                } else {
                    row[4] = "";
                }
                bcp.add(row);
                break;
            }
            if (!found) {
                sb.append(this.ar.getString("A3170", (Object)brokerID)).append("\n");
                sb.append(this.ar.getString("A1705")).append("\n");
                return 1;
            }
            bcp.println();
            if (!force) {
                input = this.getUserInput(this.ar.getString("A5028"), noShort);
                sb.append("").append("\n");
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    broker.sendTakeoverMessage(brokerID);
                    broker.receiveTakeoverReplyMessage();
                    sb.append(this.ar.getString("A1706")).append("\n");
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    sb.append(this.ar.getString("A1705")).append("\n");
                    return 1;
                }
            } else {
                if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                    sb.append(this.ar.getString("A1707")).append("\n");
                    return 0;
                }
                sb.append(this.ar.getString("A1026", (Object)input)).append("\n");
                sb.append("").append("\n");
                sb.append(this.ar.getString("A1707")).append("\n");
                return 1;
            }
        }
        broker.close();
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private int runExists(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        void var4_6;
        boolean retValue = true;
        BrokerAdmin broker = this.init();
        String commandArg = brokerCmdProps.getCommandArg();
        if ("dst".equals(commandArg)) {
            boolean destName2;
            if (broker == null) {
                sb.append("Problems connecting to the broker.").append("\n");
                return 1;
            }
            boolean force = brokerCmdProps.forceModeSet();
            if (!force) {
                broker = this.promptForAuthentication(broker);
            }
            String destName2 = brokerCmdProps.getTargetName();
            int destTypeMask = CmdRunner.getDestTypeMask(brokerCmdProps);
            try {
                CmdRunner.connectToBroker(broker);
                broker.sendGetDestinationsMessage(destName2, destTypeMask);
                Vector dest = broker.receiveGetDestinationsReplyMessage();
                if (dest == null || dest.size() != 1) {
                    sb.append("Problems retrieving the destination info.").append("\n");
                    return 1;
                }
                sb.append(Boolean.TRUE.toString()).append("\n");
                destName2 = false;
            }
            catch (BrokerAdminException brokerAdminException) {
                BrokerAdminException bae = brokerAdminException;
                if (brokerAdminException.getReplyStatus() == 404) {
                    sb.append(Boolean.FALSE.toString()).append("\n");
                    destName2 = false;
                }
                this.handleBrokerAdminException(bae);
                return 1;
            }
        }
        return (int)var4_6;
    }

    /*
     * WARNING - void declaration
     */
    private int runGetAttr(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        void var4_5;
        String attrName;
        void destTypeMask2;
        void cdp2;
        Enumeration thisEnum;
        boolean force;
        boolean retValue = true;
        BrokerAdmin broker = this.init();
        String commandArg = brokerCmdProps.getCommandArg();
        if ("dst".equals(commandArg)) {
            block46: {
                if (broker == null) {
                    sb.append("Problems connecting to the broker.").append("\n");
                    return 1;
                }
                force = brokerCmdProps.forceModeSet();
                if (!force) {
                    broker = this.promptForAuthentication(broker);
                }
                String destName = brokerCmdProps.getTargetName();
                int destTypeMask2 = CmdRunner.getDestTypeMask(brokerCmdProps);
                String attrName2 = brokerCmdProps.getSingleTargetAttr();
                try {
                    CmdRunner.connectToBroker(broker);
                    broker.sendGetDestinationsMessage(destName, destTypeMask2);
                    Vector dest = broker.receiveGetDestinationsReplyMessage();
                    if (dest != null && dest.size() == 1) {
                        thisEnum = dest.elements();
                        DestinationInfo dInfo = (DestinationInfo)thisEnum.nextElement();
                        if ("maxTotalMsgBytes".equals(attrName2)) {
                            sb.append(Long.toString(dInfo.maxMessageBytes)).append("\n");
                            break block46;
                        }
                        if ("maxNumMsgs".equals(attrName2)) {
                            sb.append(Integer.toString(dInfo.maxMessages)).append("\n");
                            break block46;
                        }
                        if ("maxBytesPerMsg".equals(attrName2)) {
                            sb.append(Long.toString(dInfo.maxMessageSize)).append("\n");
                            break block46;
                        }
                        if ("curTotalMsgBytes".equals(attrName2)) {
                            sb.append(Long.toString(dInfo.nMessageBytes)).append("\n");
                            break block46;
                        }
                        if ("curNumMsgs".equals(attrName2)) {
                            sb.append(Integer.toString(dInfo.nMessages)).append("\n");
                            break block46;
                        }
                        if ("curNumProducers".equals(attrName2)) {
                            sb.append(Integer.toString(dInfo.nProducers)).append("\n");
                            break block46;
                        }
                        if ("maxNumBackupConsumers".equals(attrName2)) {
                            sb.append(Integer.toString(dInfo.maxFailoverConsumers)).append("\n");
                            break block46;
                        }
                        if ("maxNumActiveConsumers".equals(attrName2)) {
                            sb.append(Integer.toString(dInfo.maxActiveConsumers)).append("\n");
                            break block46;
                        }
                        if ("isLocalOnly".equals(attrName2)) {
                            if (dInfo.isDestinationLocal()) {
                                sb.append(Boolean.TRUE.toString()).append("\n");
                            } else {
                                sb.append(Boolean.FALSE.toString()).append("\n");
                            }
                            break block46;
                        }
                        if ("limitBehavior".equals(attrName2)) {
                            sb.append(DestLimitBehavior.getString((int)dInfo.destLimitBehavior)).append("\n");
                            break block46;
                        }
                        if ("localDeliveryPreferred".equals(attrName2)) {
                            int cdp2 = dInfo.destCDP;
                            if (cdp2 == 1) {
                                sb.append(Boolean.TRUE.toString()).append("\n");
                            } else {
                                sb.append(Boolean.FALSE.toString()).append("\n");
                            }
                            break block46;
                        }
                        if ("consumerFlowLimit".equals(cdp2)) {
                            sb.append(Integer.toString(dInfo.maxPrefetch)).append("\n");
                            break block46;
                        }
                        if ("maxNumProducers".equals(cdp2)) {
                            sb.append(Integer.toString(dInfo.maxProducers)).append("\n");
                            break block46;
                        }
                        if ("curNumActiveConsumers".equals(cdp2)) {
                            if (DestType.isQueue((int)destTypeMask2)) {
                                sb.append(Integer.toString(dInfo.naConsumers)).append("\n");
                            } else {
                                sb.append(Integer.toString(dInfo.nConsumers)).append("\n");
                            }
                            break block46;
                        }
                        if ("curNumBackupConsumers".equals(cdp2)) {
                            sb.append(Integer.toString(dInfo.nfConsumers)).append("\n");
                            break block46;
                        }
                        if ("useDMQ".equals(cdp2)) {
                            sb.append(Boolean.toString(dInfo.useDMQ())).append("\n");
                            break block46;
                        }
                        if ("validateXMLSchemaEnabled".equals(cdp2)) {
                            sb.append(Boolean.toString(dInfo.validateXMLSchemaEnabled())).append("\n");
                            break block46;
                        }
                        if ("XMLSchemaURIList".equals(cdp2)) {
                            sb.append(dInfo.XMLSchemaUriList).append("\n");
                            break block46;
                        }
                        if ("reloadXMLSchemaOnFailure".equals(cdp2)) {
                            sb.append(Boolean.toString(dInfo.reloadXMLSchemaOnFailure())).append("\n");
                            break block46;
                        }
                        sb.append((String)cdp2 + " is not recognized.").append("\n");
                        return 1;
                    }
                    sb.append("Problems retrieving the destination info.").append("\n");
                    return 1;
                }
                catch (BrokerAdminException bae) {
                    this.handleBrokerAdminException(bae);
                    return 1;
                }
            }
            return 0;
        }
        if ("svc".equals(destTypeMask2)) {
            block47: {
                BrokerAdmin bae;
                if (bae == null) {
                    sb.append("Problems connecting to the broker.").append("\n");
                    return 1;
                }
                force = cdp2.forceModeSet();
                if (!force) {
                    bae = this.promptForAuthentication(bae);
                }
                String svcName = cdp2.getTargetName();
                attrName = cdp2.getSingleTargetAttr();
                try {
                    CmdRunner.connectToBroker(bae);
                    bae.sendGetServicesMessage(svcName);
                    Vector svc = bae.receiveGetServicesReplyMessage();
                    if (svc != null && svc.size() == 1) {
                        thisEnum = svc.elements();
                        ServiceInfo sInfo = (ServiceInfo)thisEnum.nextElement();
                        if ("port".equals(attrName)) {
                            sb.append(Integer.toString(sInfo.port)).append("\n");
                            break block47;
                        }
                        if ("minThreads".equals(attrName)) {
                            sb.append(Integer.toString(sInfo.minThreads)).append("\n");
                            break block47;
                        }
                        if ("maxThreads".equals(attrName)) {
                            sb.append(Integer.toString(sInfo.maxThreads)).append("\n");
                            break block47;
                        }
                        sb.append(attrName + " is not recognized.").append("\n");
                        return 1;
                    }
                    sb.append("Problems retrieving the service info.").append("\n");
                    return 1;
                }
                catch (BrokerAdminException bae2) {
                    this.handleBrokerAdminException(bae2);
                    return 1;
                }
            }
            return 0;
        }
        if ("bkr".equals(attrName)) {
            void bae2;
            BrokerAdmin brokerAdmin;
            if (brokerAdmin == null) {
                sb.append("Problems connecting to the broker.").append("\n");
                return 1;
            }
            force = bae2.forceModeSet();
            if (!force) {
                brokerAdmin = this.promptForAuthentication(brokerAdmin);
            }
            String attrName32 = bae2.getSingleTargetAttr();
            try {
                CmdRunner.connectToBroker(brokerAdmin);
                brokerAdmin.sendGetBrokerPropsMessage();
                Properties bkrProps = brokerAdmin.receiveGetBrokerPropsReplyMessage();
                if (bkrProps == null) {
                    sb.append("Problems retrieving the broker info.").append("\n");
                    return 1;
                }
                String value = bkrProps.getProperty(attrName32, "");
                sb.append(value).append("\n");
                boolean attrName32 = false;
            }
            catch (BrokerAdminException bae) {
                this.handleBrokerAdminException(bae);
                return 1;
            }
        }
        return (int)var4_5;
    }

    private int runUngracefulKill(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        BrokerAdmin broker = this.init();
        if (broker == null) {
            sb.append("Problems connecting to the broker.").append("\n");
            return 1;
        }
        boolean force = brokerCmdProps.forceModeSet();
        if (!force) {
            broker = this.promptForAuthentication(broker);
        }
        try {
            CmdRunner.connectToBroker(broker);
            broker.sendShutdownMessage(false, true);
            sb.append("Ungracefully shutdown the broker.").append("\n");
            return 0;
        }
        catch (BrokerAdminException bae) {
            this.handleBrokerAdminException(bae);
            return 1;
        }
    }

    private int runDebug(BrokerCmdProperties brokerCmdProps, StringBuffer sb) {
        Object debugHash = null;
        Object broker = this.init();
        if (broker == null) {
            sb.append("Problems connecting to the broker.").append("\n");
            return 1;
        }
        boolean force = brokerCmdProps.forceModeSet();
        if (!force) {
            broker = this.promptForAuthentication((BrokerAdmin)broker);
        }
        String cmd = brokerCmdProps.getCommand();
        String cmdarg = brokerCmdProps.getCommandArg();
        String target = brokerCmdProps.getTargetName();
        String targetType = brokerCmdProps.getDestType();
        Properties optionalProps = brokerCmdProps.getTargetAttrs();
        sb.append("Sending the following DEBUG message:").append("\n");
        Object bcp = new BrokerCmdPrinter(2, 4, "-", 0, false);
        Object[] objectArray = new String[2];
        Object[] row = objectArray;
        objectArray[0] = "Header Property Name";
        row[1] = "Value";
        bcp.addTitle((String[])row);
        row[0] = "JMQCommand";
        row[1] = cmd;
        bcp.add(row);
        row[0] = "JMQCommandArg";
        row[1] = cmdarg;
        bcp.add(row);
        if (target != null) {
            row[0] = "JMQTarget";
            row[1] = target;
            bcp.add(row);
        }
        if (targetType != null) {
            row[0] = "JMQTargetType";
            row[1] = targetType;
            bcp.add(row);
        }
        bcp.println();
        if (optionalProps != null && optionalProps.size() > 0) {
            sb.append("Optional properties:").append("\n");
            CmdRunner.printAttrs(optionalProps, true);
        }
        sb.append("To the broker specified by:").append("\n");
        this.printBrokerInfo((BrokerAdmin)broker);
        try {
            CmdRunner.connectToBroker((BrokerAdmin)broker);
            broker.sendDebugMessage(cmd, cmdarg, target, targetType, optionalProps);
            broker = broker.receiveDebugReplyMessage();
            if (broker != null && ((Hashtable)broker).size() > 0) {
                sb.append("Data received back from broker:").append("\n");
                bcp = broker;
                bcp = new DebugPrinter((Hashtable)bcp, 4);
                bcp.println();
            } else {
                sb.append("No additional data received back from broker.\n").append("\n");
            }
            sb.append("DEBUG message sent successfully.").append("\n");
            return 0;
        }
        catch (BrokerAdminException bae) {
            this.handleBrokerAdminException(bae);
            return 1;
        }
    }

    private static void printAllBrokerAttrs(Properties bkrProps) {
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(2, 4);
        Object[] row = new String[2];
        Enumeration<?> e = bkrProps.propertyNames();
        while (e.hasMoreElements()) {
            String curPropName;
            row[0] = curPropName = (String)e.nextElement();
            row[1] = bkrProps.getProperty(curPropName, "");
            bcp.add(row);
        }
        bcp.println();
    }

    private static void printAllTxnAttrs(Hashtable txnInfo) {
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(2, 4);
        Object[] row = new String[2];
        Enumeration e = txnInfo.keys();
        while (e.hasMoreElements()) {
            String curPropName;
            row[0] = curPropName = (String)e.nextElement();
            Object tmpObj = txnInfo.get(curPropName);
            row[1] = tmpObj.toString();
            bcp.add(row);
        }
        bcp.println();
    }

    private static void printAllCxnAttrs(Hashtable cxnInfo) {
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(2, 4);
        Object[] row = new String[2];
        Enumeration e = cxnInfo.keys();
        while (e.hasMoreElements()) {
            String curPropName;
            row[0] = curPropName = (String)e.nextElement();
            Object tmpObj = cxnInfo.get(curPropName);
            row[1] = tmpObj.toString();
            bcp.add(row);
        }
        bcp.println();
    }

    private void printDisplayableMsgAttrs(HashMap oneMsg) {
        String string;
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(2, 4);
        BrokerCmdPrinter titleBcp = new BrokerCmdPrinter(1, 0, "-");
        Object[] row = new String[2];
        String[] titleRow = new String[1];
        bcp.setSortNeeded(false);
        titleRow[0] = "Message Header Information";
        titleBcp.addTitle(titleRow);
        titleBcp.print();
        row[0] = "Message ID";
        row[1] = CmdRunner.checkNullAndPrint(oneMsg.get("MessageID"));
        bcp.add(row);
        row[0] = "Correlation ID";
        row[1] = CmdRunner.checkNullAndPrint(oneMsg.get("CorrelationID"));
        bcp.add(row);
        row[0] = "Destination Name";
        row[1] = CmdRunner.checkNullAndPrint(oneMsg.get("DestinationName"));
        bcp.add(row);
        row[0] = "Destination Type";
        Integer tmpInt = (Integer)oneMsg.get("DestinationType");
        row[1] = BrokerAdminUtil.getDestinationType((int)tmpInt);
        bcp.add(row);
        row[0] = "Delivery Mode";
        tmpInt = (Integer)oneMsg.get("DeliveryMode");
        if (tmpInt != null) {
            String string2;
            switch (tmpInt) {
                case 1: {
                    string2 = "NON_PERSISTENT";
                    break;
                }
                case 2: {
                    string2 = "PERSISTENT";
                    break;
                }
                default: {
                    string2 = "Unknown";
                }
            }
            string = string2 + " (" + tmpInt + ")";
        } else {
            string = "";
        }
        row[1] = string;
        bcp.add(row);
        row[0] = "Priority";
        row[1] = CmdRunner.checkNullAndPrint(oneMsg.get("Priority"));
        bcp.add(row);
        row[0] = "Redelivered";
        row[1] = CmdRunner.checkNullAndPrint(oneMsg.get("Redelivered"));
        bcp.add(row);
        row[0] = "Timestamp";
        row[1] = CmdRunner.checkNullAndPrintTimestamp((Long)oneMsg.get("Timestamp"));
        bcp.add(row);
        row[0] = "Type";
        row[1] = CmdRunner.checkNullAndPrint((String)oneMsg.get("Type"));
        bcp.add(row);
        row[0] = "Expiration";
        row[1] = CmdRunner.checkNullAndPrintTimestamp((Long)oneMsg.get("Expiration"));
        bcp.add(row);
        row[0] = "ReplyTo Destination Name";
        row[1] = CmdRunner.checkNullAndPrint(oneMsg.get("ReplyToDestinationName"));
        bcp.add(row);
        row[0] = "ReplyTo Destination Type";
        tmpInt = (Integer)oneMsg.get("ReplyToDestinationType");
        row[1] = tmpInt != null ? BrokerAdminUtil.getDestinationType((int)tmpInt) : "";
        bcp.add(row);
        bcp.println();
        titleBcp.clear();
        titleBcp.clearTitle();
        titleRow[0] = "Message Properties Information";
        titleBcp.addTitle(titleRow);
        titleBcp.print();
        Hashtable props = (Hashtable)oneMsg.get("MessageProperties");
        if (props != null) {
            Enumeration keys = props.keys();
            bcp.clear();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                Object val = props.get(key);
                row[0] = key;
                row[1] = val.toString();
                bcp.add(row);
            }
            bcp.println();
        } else {
            Globals.stdOutPrintln((String)"");
        }
        titleBcp.clear();
        titleBcp.clearTitle();
        titleRow[0] = "Message Body Information";
        titleBcp.addTitle(titleRow);
        titleBcp.print();
        bcp.clear();
        row[0] = "Body Type";
        row[1] = CmdRunner.checkNullAndPrintMsgBodyType((Integer)oneMsg.get("MessageBodyType"), true);
        bcp.add(row);
        bcp.println();
    }

    private static int getDestTypeMask(BrokerCmdProperties brokerCmdProps) {
        Properties props = brokerCmdProps.getTargetAttrs();
        String destType = brokerCmdProps.getDestType();
        int mask = 0;
        if (destType == null || destType.equals("")) {
            return -1;
        }
        if (destType.equals("t")) {
            mask = 2;
        } else if (destType.equals("q")) {
            mask = 1;
        }
        if (props == null || props.isEmpty()) {
            return mask;
        }
        String flavour = props.getProperty("queueDeliveryPolicy");
        if (flavour == null) {
            return mask;
        }
        if (flavour.equals("s")) {
            mask |= 0x100;
        } else if (flavour.equals("f")) {
            mask |= 0x400;
        } else if (flavour.equals("r")) {
            mask |= 0x200;
        }
        return mask;
    }

    /*
     * WARNING - void declaration
     */
    private BrokerAdmin init() {
        void var1_1;
        String brokerHostPort = this.brokerCmdProps.getBrokerHostPort();
        Object adminUser2 = this.brokerCmdProps.getAdminUserId();
        int numRetries = this.brokerCmdProps.getNumRetries();
        int receiveTimeout = this.brokerCmdProps.getReceiveTimeout();
        boolean adminKeyUsed = this.brokerCmdProps.isAdminKeyUsed();
        boolean useSSL = this.brokerCmdProps.useSSLTransportSet();
        if (this.brokerCmdProps.adminDebugModeSet()) {
            BrokerAdmin.setDebug((boolean)true);
        }
        try {
            String adminPasswd = this.getPasswordFromFileOrCmdLine(this.brokerCmdProps);
            BrokerAdmin broker = new BrokerAdmin(brokerHostPort, adminUser2, adminPasswd, receiveTimeout * 1000, useSSL);
            if (adminKeyUsed) {
                broker.setAdminKeyUsed(true);
            }
            if (useSSL) {
                broker.setSSLTransportUsed(true);
            }
            if (numRetries > 0) {
                broker.setNumRetries(numRetries);
            }
        }
        catch (BrokerCmdException bce2) {
            adminUser2 = bce2;
            CmdRunner bce2 = this;
            Exception adminPasswd = adminUser2.getLinkedException();
            adminUser2.getProperties();
            int adminUser2 = adminUser2.getType();
            switch (adminUser2) {
                case 34: {
                    Globals.stdErrPrintln((String)bce2.ar.getString("A1001"), (String)bce2.ar.getKString("A3161", (Object)adminPasswd));
                    break;
                }
                default: {
                    Globals.stdErrPrintln((String)("Unknown exception caught: " + adminUser2));
                }
            }
            return null;
        }
        catch (BrokerAdminException bae) {
            this.handleBrokerAdminException(bae);
            return null;
        }
        var1_1.addAdminEventListener((AdminEventListener)this);
        return var1_1;
    }

    private static void connectToBroker(BrokerAdmin broker) throws BrokerAdminException {
        if (!broker.isConnected()) {
            broker.connect();
            broker.sendHelloMessage();
            broker.receiveHelloReplyMessage();
        }
    }

    private void handleBrokerAdminException(BrokerAdminException bae) {
        bae.getLinkedException();
        int type = bae.getType();
        switch (type) {
            case 0: {
                Globals.stdErrPrintln((String)this.ar.getString("A3120", (Object)bae.getBrokerHost(), (Object)bae.getBrokerPort()));
                this.printBrokerAdminExceptionDetails(bae);
                Globals.stdErrPrintln((String)this.ar.getString("A3139", (Object)"-b"));
                return;
            }
            case 1: {
                Globals.stdErrPrintln((String)this.ar.getString("A3121"));
                this.printBrokerAdminExceptionDetails(bae);
                return;
            }
            case 2: {
                Globals.stdErrPrintln((String)this.ar.getString("A3122"));
                this.printBrokerAdminExceptionDetails(bae);
                return;
            }
            case 3: {
                Globals.stdErrPrintln((String)this.ar.getString("A3123"));
                this.printBrokerAdminExceptionDetails(bae);
                return;
            }
            case 4: {
                Globals.stdErrPrintln((String)this.ar.getString("A3124"));
                this.printBrokerAdminExceptionDetails(bae);
                return;
            }
            case 5: {
                Globals.stdErrPrintln((String)this.ar.getString("A3125"));
                this.printBrokerAdminExceptionDetails(bae);
                return;
            }
            case 6: {
                Globals.stdErrPrintln((String)this.ar.getString("A3126"));
                this.printBrokerAdminExceptionDetails(bae);
                return;
            }
            case 7: {
                Globals.stdErrPrintln((String)this.ar.getString("A3127"));
                this.printBrokerAdminExceptionDetails(bae);
                return;
            }
            case 8: {
                Globals.stdErrPrintln((String)this.ar.getString("A1001"), (String)this.ar.getKString("A3128"));
                return;
            }
            case 11: {
                Globals.stdErrPrintln((String)this.ar.getString("A3120", (Object)bae.getBrokerHost(), (Object)bae.getBrokerPort()));
                this.printBrokerAdminExceptionDetails(bae);
                Globals.stdErrPrintln((String)this.ar.getString("A3140"));
                return;
            }
            case 12: {
                Globals.stdErrPrintln((String)this.ar.getString("A3120", (Object)bae.getBrokerHost(), (Object)bae.getBrokerPort()));
                this.printBrokerAdminExceptionDetails(bae);
                Globals.stdErrPrintln((String)this.ar.getString("A3141"));
                return;
            }
            case 15: {
                Globals.stdErrPrintln((String)this.ar.getString("A3120", (Object)bae.getBrokerHost(), (Object)bae.getBrokerPort()));
                this.printBrokerAdminExceptionDetails(bae);
                Globals.stdErrPrintln((String)this.ar.getString("A3154"));
                return;
            }
            case 16: {
                Globals.stdErrPrintln((String)this.ar.getString("A1001"), (String)this.ar.getKString("A3167", (Object)bae.getBrokerAddress()));
            }
        }
    }

    private void printBrokerAdminExceptionDetails(BrokerAdminException bae) {
        Exception e = bae.getLinkedException();
        String s = bae.getBrokerErrorStr();
        if (s != null) {
            Globals.stdErrPrintln((String)s);
        }
        if (e != null) {
            String msg = e.getMessage();
            String s2 = e.toString();
            if (s2 != null) {
                Globals.stdErrPrintln((String)s2);
            } else if (msg != null) {
                Globals.stdErrPrintln((String)msg);
            }
            if (this.brokerCmdProps.debugModeSet()) {
                e.printStackTrace(System.err);
            }
        }
    }

    private String getUserInput(String question, String defaultResponse) {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            Globals.stdOutPrint((String)question);
            String s = in.readLine();
            if (s.equals("") && defaultResponse != null) {
                s = defaultResponse;
            }
            return s;
        }
        catch (IOException iOException) {
            Globals.stdErrPrintln((String)this.ar.getString("A1001"), (String)this.ar.getKString("A3081"));
            return null;
        }
    }

    private void printBrokerInfo(BrokerAdmin broker) {
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(2, 4, "-");
        Object[] objectArray = new String[2];
        Object[] row = objectArray;
        objectArray[0] = this.ar.getString("A1440");
        row[1] = this.ar.getString("A1441");
        bcp.addTitle((String[])row);
        row[0] = broker.getBrokerHost();
        row[1] = broker.getBrokerPort();
        bcp.add(row);
        bcp.println();
    }

    private void printServiceInfo(String svcName) {
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(1, 4, "-");
        Object[] objectArray = new String[1];
        Object[] row = objectArray;
        objectArray[0] = this.ar.getString("A1420");
        bcp.addTitle((String[])row);
        row[0] = svcName == null ? this.brokerCmdProps.getTargetName() : svcName;
        bcp.add(row);
        bcp.println();
    }

    private void printMessageInfo() {
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(1, 4, "-");
        Object[] objectArray = new String[1];
        Object[] row = objectArray;
        objectArray[0] = "Message ID";
        bcp.addTitle((String[])row);
        row[0] = this.brokerCmdProps.getMsgID();
        bcp.add(row);
        bcp.println();
    }

    private void printDestinationInfo() {
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(2, 4, "-");
        Object[] objectArray = new String[2];
        Object[] row = objectArray;
        objectArray[0] = this.ar.getString("A1400");
        row[1] = this.ar.getString("A1401");
        bcp.addTitle((String[])row);
        row[0] = this.brokerCmdProps.getTargetName();
        row[1] = BrokerAdminUtil.getDestinationType((int)CmdRunner.getDestTypeMask(this.brokerCmdProps));
        bcp.add(row);
        bcp.println();
    }

    private void printDurableSubscriptionInfo() {
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(2, 4, "-");
        Object[] objectArray = new String[2];
        Object[] row = objectArray;
        objectArray[0] = this.ar.getString("A1430");
        row[1] = this.ar.getString("A1431");
        bcp.addTitle((String[])row);
        row[0] = this.brokerCmdProps.getTargetName();
        row[1] = this.brokerCmdProps.getClientID();
        bcp.add(row);
        bcp.println();
    }

    private void printTransactionInfo() {
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(1, 4, "-");
        Object[] objectArray = new String[1];
        Object[] row = objectArray;
        objectArray[0] = this.ar.getString("A1263");
        bcp.addTitle((String[])row);
        row[0] = this.brokerCmdProps.getTargetName();
        bcp.add(row);
        bcp.println();
    }

    private void printConnectionInfo() {
        BrokerCmdPrinter bcp = new BrokerCmdPrinter(1, 4, "-");
        Object[] objectArray = new String[1];
        Object[] row = objectArray;
        objectArray[0] = this.ar.getString("A1323");
        bcp.addTitle((String[])row);
        row[0] = this.brokerCmdProps.getTargetName();
        bcp.add(row);
        bcp.println();
    }

    private static void isAdminService(BrokerAdmin broker, String svcName) throws BrokerAdminException {
        broker.sendGetServicesMessage(svcName);
        Enumeration svc = broker.receiveGetServicesReplyMessage();
        if (svc != null && ((Vector)((Object)svc)).size() == 1) {
            Enumeration thisEnum = ((Vector)((Object)svc)).elements();
            Enumeration sInfo = (ServiceInfo)thisEnum.nextElement();
            if (((ServiceInfo)sInfo).type == 1) {
                throw new BrokerAdminException(7);
            }
        }
    }

    private static void isDestTypeTopic(BrokerAdmin broker, String destName) throws BrokerAdminException {
        broker.sendGetDestinationsMessage(null, -1);
        Vector dests = broker.receiveGetDestinationsReplyMessage();
        boolean found = false;
        for (int i = 0; !found && i < dests.size(); ++i) {
            DestinationInfo dInfo = (DestinationInfo)dests.elementAt(i);
            if (!destName.equals(dInfo.name) || !DestType.isTopic((int)dInfo.type)) continue;
            found = true;
        }
        if (!found) {
            throw new BrokerAdminException(7);
        }
    }

    private String checkAndPrintUnlimitedInt(int value, int[] unlimitedValues) {
        String ret = null;
        for (int i = 0; i < unlimitedValues.length; ++i) {
            if (value != unlimitedValues[i]) continue;
            ret = this.ar.getString("A1537") + " (-1)";
            break;
        }
        if (ret == null) {
            ret = new Integer(value).toString();
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    private String checkAndPrintUnlimitedInt(int value, int unlimitedValue) {
        void ret;
        String ret2 = value == -1 ? this.ar.getString("A1537") + " (-1)" : new Integer((int)ret).toString();
        return ret2;
    }

    private String checkAndPrintUnlimitedLong(long value, long[] unlimitedValues) {
        String ret = null;
        for (int i = 0; i < unlimitedValues.length; ++i) {
            if (value != unlimitedValues[i]) continue;
            ret = this.ar.getString("A1537") + " (-1)";
            break;
        }
        if (ret == null) {
            ret = new Long(value).toString();
        }
        return ret;
    }

    private String checkAndPrintUnlimitedBytes(String s, long[] unlimitedValues) {
        SizeString ss;
        String ret = null;
        String value = s.trim();
        try {
            ss = new SizeString(value);
        }
        catch (Exception exception) {
            return value;
        }
        for (int i = 0; i < unlimitedValues.length; ++i) {
            if (ss.getBytes() != unlimitedValues[i]) continue;
            ret = this.ar.getString("A1537") + " (-1)";
            break;
        }
        if (ret == null) {
            ret = value;
        }
        return ret;
    }

    private String checkAndPrintUnlimited(String s, String[] unlimitedValues) {
        String ret = null;
        String value = s.trim();
        for (int i = 0; i < unlimitedValues.length; ++i) {
            if (!value.equals(unlimitedValues[i])) continue;
            ret = this.ar.getString("A1537") + " (-1)";
            break;
        }
        if (ret == null) {
            ret = value;
        }
        return ret;
    }

    private static String checkNullAndPrint(Object obj) {
        if (obj != null) {
            return obj.toString();
        }
        return "";
    }

    private static String checkNullAndPrintTimestamp(Long timestamp) {
        if (timestamp != null) {
            Date d = new Date(timestamp);
            DateFormat df = DateFormat.getDateTimeInstance(3, 2);
            Date ts = df.format(d);
            return ts;
        }
        return "";
    }

    private BrokerAdmin promptForAuthentication(BrokerAdmin broker) {
        Object usernameValue = broker.getUserName();
        String passwordValue = broker.getPassword();
        boolean carriageReturnNeeded32 = false;
        if (usernameValue == null) {
            String carriageReturnNeeded32 = this.ar.getString("A1620");
            usernameValue = this;
            broker.setUserName(((CmdRunner)usernameValue).getUserInput(carriageReturnNeeded32, null));
            carriageReturnNeeded32 = true;
        }
        if (passwordValue == null) {
            usernameValue = this;
            Password carriageReturnNeeded32 = new Password();
            Globals.stdOutPrint((String)((CmdRunner)usernameValue).ar.getString("A1621"));
            String passwd = carriageReturnNeeded32.getPassword();
            broker.setPassword(passwd);
            carriageReturnNeeded32 = false;
        }
        if (carriageReturnNeeded32) {
            Globals.stdOutPrintln((String)"");
        }
        return broker;
    }

    private boolean reconnectToBroker(BrokerAdmin broker) {
        boolean connected = false;
        int count = 0;
        while (!connected && count < 5) {
            try {
                broker.connect();
                broker.sendHelloMessage();
                broker.receiveHelloReplyMessage();
                connected = true;
            }
            catch (BrokerAdminException brokerAdminException) {
                BrokerAdminException baex = brokerAdminException;
                if (brokerAdminException.getType() == 0) {
                    try {
                        Thread.sleep(5000L);
                        ++count;
                    }
                    catch (InterruptedException interruptedException) {}
                }
                connected = false;
            }
            catch (Exception exception) {
                connected = false;
            }
            if (count < 5) continue;
            connected = false;
            Globals.stdErrPrintln((String)this.ar.getString("A3120", (Object)broker.getBrokerHost(), (Object)broker.getBrokerPort()));
            Globals.stdErrPrintln((String)this.ar.getString("A3116", (Object)new Long(25L)));
        }
        return connected;
    }

    private static int getLimitBehavValue(String limitBehavStr) {
        int ret = -1;
        if (limitBehavStr == null) {
            return -1;
        }
        if (limitBehavStr.equals(LIMIT_BEHAV_FLOW_CONTROL)) {
            ret = 0;
        } else if (limitBehavStr.equals(LIMIT_BEHAV_RM_OLDEST)) {
            ret = 1;
        } else if (limitBehavStr.equals(LIMIT_BEHAV_REJECT_NEWEST)) {
            ret = 2;
        } else if (limitBehavStr.equals(LIMIT_BEHAV_RM_LOW_PRIORITY)) {
            ret = 3;
        }
        return ret;
    }

    private static int getClusterDeliveryPolicy(String cdp) {
        if (cdp == null) {
            return -1;
        }
        int b = Boolean.valueOf(cdp).booleanValue();
        b = b != 0 ? 1 : 2;
        return b;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getPasswordFromFileOrCmdLine(BrokerCmdProperties brokerCmdProps22) throws BrokerCmdException {
        void var2_3;
        String passwd = brokerCmdProps22.getAdminPasswd();
        String passfile = brokerCmdProps22.getAdminPassfile();
        if (passwd != null) {
            return passwd;
        }
        if (passfile == null) return null;
        Object ret = null;
        InputStream fis = null;
        try {
            Object props = new Properties();
            fis = FileUtil.retrieveObfuscatedFile((String)passfile);
            ((Properties)props).load(fis);
            props = ((Properties)props).getProperty("imq.imqcmd.password");
            if (props == null) {
                throw new RuntimeException(this.ar.getString("A3162", (Object)"imq.imqcmd.password", (Object)passfile));
            }
            if (fis == null) return var2_3;
        }
        catch (Exception e) {
            try {
                BrokerCmdException bce = new BrokerCmdException(34);
                bce.setProperties(brokerCmdProps22);
                bce.setLinkedException(e);
                throw bce;
            }
            catch (Throwable brokerCmdProps22) {
                if (fis == null) throw brokerCmdProps22;
                try {
                    fis.close();
                    throw brokerCmdProps22;
                }
                catch (IOException iOException) {}
                throw brokerCmdProps22;
            }
        }
        try {
            fis.close();
            return var2_3;
        }
        catch (IOException iOException) {
            return var2_3;
        }
    }

    private static String checkNullAndPrintMsgBodyType(Integer bodyType, boolean includeValue) {
        if (bodyType != null) {
            String label;
            switch (bodyType) {
                case 1: {
                    label = "TextMessage";
                    break;
                }
                case 2: {
                    label = "BytesMessage";
                    break;
                }
                case 3: {
                    label = "MapMessage";
                    break;
                }
                case 4: {
                    label = "StreamMessage";
                    break;
                }
                case 5: {
                    label = "ObjectMessage";
                    break;
                }
                default: {
                    label = "Unknown";
                }
            }
            if (includeValue) {
                return label + " (" + bodyType + ")";
            }
            return label;
        }
        return "";
    }
}

