/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.MeterProgressBar;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class MeterProgressBarUI
extends BasicProgressBarUI {
    private Color _cellBackground;
    private Color _cellForeground;
    private int _cellLength;
    private int _cellSpacing;
    private PropertyChangeListener _propertyChangeListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MeterProgressBarUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installBorder(this.progressBar, "MeterProgressBar.border");
        LookAndFeel.installColors(this.progressBar, "MeterProgressBar.background", "MeterProgressBar.foreground");
        this._cellForeground = UIDefaultsLookup.getColor("MeterProgressBar.cellForeground");
        this._cellBackground = UIDefaultsLookup.getColor("MeterProgressBar.cellBackground");
        this._cellLength = UIDefaultsLookup.getInt("MeterProgressBar.cellLength");
        this._cellSpacing = UIDefaultsLookup.getInt("MeterProgressBar.cellSpacing");
    }

    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this._cellBackground = null;
        this._cellForeground = null;
    }

    protected void installListeners() {
        super.installListeners();
        this._propertyChangeListener = new PropertyChangeHandler(this);
        this.progressBar.addPropertyChangeListener(this._propertyChangeListener);
    }

    protected void uninstallListeners() {
        this.progressBar.removePropertyChangeListener(this._propertyChangeListener);
        super.uninstallListeners();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Insets insets = this.progressBar.getInsets();
        int n = this.progressBar.getWidth() - (insets.right + insets.left);
        int n2 = this.progressBar.getHeight() - (insets.top + insets.bottom);
        int n3 = this.getAmountFull(insets, n, n2);
        int n4 = this.progressBar.getOrientation();
        float f = n4 == 0 ? (float)n2 : (float)n;
        graphics = (Graphics2D)graphics.create();
        graphics.setColor(this._cellBackground);
        ((Graphics2D)graphics).setStroke(new BasicStroke(f, 0, 2));
        if (n4 == 0) {
            graphics.drawLine(insets.left, n2 / 2 + insets.top, insets.left + n, n2 / 2 + insets.top);
        } else {
            graphics.drawLine(n / 2 + insets.left, insets.top + n2, n / 2 + insets.left, insets.top);
        }
        if (((MeterProgressBar)jComponent).getStyle() == 0) {
            graphics.setColor(this._cellForeground);
            if (n4 == 0) {
                if (jComponent.getComponentOrientation().isLeftToRight()) {
                    graphics.drawLine(insets.left, n2 / 2 + insets.top, n3 + insets.left, n2 / 2 + insets.top);
                } else {
                    graphics.drawLine(n + insets.left, n2 / 2 + insets.top, n + insets.left - n3, n2 / 2 + insets.top);
                }
            } else {
                graphics.drawLine(n / 2 + insets.left, insets.top + n2, n / 2 + insets.left, insets.top + n2 - n3);
            }
        } else {
            ((Graphics2D)graphics).setStroke(new BasicStroke(1.0f, 0, 2));
            if (n4 == 0) {
                Rectangle rectangle = new Rectangle(insets.left, insets.top, n3, n2 / 2);
                if (!jComponent.getComponentOrientation().isLeftToRight()) {
                    rectangle.x += n - n3;
                }
                JideSwingUtilities.fillGradient((Graphics2D)graphics, rectangle, this._cellForeground, this._cellBackground, true);
                rectangle.y += n2 / 2;
                JideSwingUtilities.fillGradient((Graphics2D)graphics, rectangle, this._cellBackground, this._cellForeground, true);
            } else {
                Rectangle rectangle = new Rectangle(insets.left, insets.top + n2 - n3, n / 2, n3);
                JideSwingUtilities.fillGradient((Graphics2D)graphics, rectangle, this._cellForeground, this._cellBackground, false);
                rectangle.x += n / 2;
                JideSwingUtilities.fillGradient((Graphics2D)graphics, rectangle, this._cellBackground, this._cellForeground, false);
            }
        }
        graphics.setColor(this.progressBar.getBackground());
        ((Graphics2D)graphics).setStroke(new BasicStroke(f, 0, 2, 0.0f, new float[]{this._cellLength, this._cellSpacing}, 0.0f));
        if (n4 == 0) {
            graphics.drawLine(insets.left - this._cellSpacing, n2 / 2 + insets.top, insets.left + n, n2 / 2 + insets.top);
        } else {
            graphics.drawLine(n / 2 + insets.left, insets.top + n2 + this._cellSpacing, n / 2 + insets.left, insets.top);
        }
        graphics.dispose();
    }

    final class PropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ MeterProgressBarUI this$0;

        private PropertyChangeHandler(MeterProgressBarUI meterProgressBarUI, byte by) {
            this.this$0 = meterProgressBarUI;
        }

        public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("style".equals(propertyChangeEvent.getPropertyName())) {
                this.this$0.progressBar.repaint();
            }
        }

        /* synthetic */ PropertyChangeHandler(MeterProgressBarUI meterProgressBarUI) {
            this(meterProgressBarUI, 0);
        }
    }
}

