/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.aqua;

import com.jidesoft.plaf.aqua.BinaryPListParser;
import com.jidesoft.plaf.aqua.XMLElement;
import com.jidesoft.plaf.aqua.XMLParseException;
import com.jidesoft.utils.SecurityUtils;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Logger;

class AquaPreferences {
    private static final Logger LOGGER = Logger.getLogger(AquaPreferences.class.getName());
    private static HashMap prefs;

    public static String getString(String string) {
        if (prefs == null) {
            prefs = new HashMap();
            AquaPreferences.loadGlobalPreferences();
        }
        return (String)prefs.get(string);
    }

    private static void loadGlobalPreferences() {
        prefs.put("AppleAquaColorVariant", "1");
        prefs.put("AppleHighlightColor", "0.709800 0.835300 1.000000");
        prefs.put("AppleCollationOrder", "en");
        prefs.put("AppleScrollBarVariant", "DoubleMax");
        prefs.put("AppleScrollerPagingBehavior", "false");
        Object object = new File(SecurityUtils.getProperty("user.home", "") + "/Library/Preferences/.GlobalPreferences.plist");
        try {
            object = AquaPreferences.readPList((File)object);
            object = ((XMLElement)object).iterateChildren();
            while (object.hasNext()) {
                Object object2 = (XMLElement)object.next();
                String string = null;
                object2 = ((XMLElement)object2).iterateChildren();
                while (object2.hasNext()) {
                    XMLElement xMLElement = (XMLElement)object2.next();
                    if (xMLElement.getName().equals("key")) {
                        string = xMLElement.getContent();
                        continue;
                    }
                    if (string != null) {
                        prefs.put(string, xMLElement.getContent());
                    }
                    string = null;
                }
            }
            return;
        }
        catch (IOException iOException) {
            LOGGER.warning("AquaPreferences failed to load Mac OS X global system preferences - " + iOException.getLocalizedMessage());
            return;
        }
        catch (Exception exception) {
            LOGGER.warning("AquaPreferences failed to load Mac OS X global system preferences - " + exception.getLocalizedMessage());
            return;
        }
    }

    private static XMLElement readPList(File file) throws IOException {
        FileReader fileReader = null;
        XMLElement xMLElement = null;
        try {
            fileReader = new FileReader(file);
            xMLElement = new XMLElement(new HashMap(), false, false);
            try {
                FileReader fileReader2 = fileReader;
                XMLElement xMLElement2 = xMLElement;
                xMLElement2.parseFromReader(fileReader2, 1);
            }
            catch (XMLParseException xMLParseException) {
                xMLElement = new BinaryPListParser().parse(file);
            }
        }
        catch (Throwable throwable) {
            if (fileReader != null) {
                fileReader.close();
            }
            throw throwable;
        }
        fileReader.close();
        return xMLElement;
    }
}

