/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideScrollPaneConstants;
import com.jidesoft.swing.JideScrollPaneLayout;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.plaf.UIResource;

public final class JideScrollPane
extends JScrollPane
implements JideScrollPaneConstants {
    private Component _hLeft;
    private Component _hRight;
    private Component _vTop;
    private Component _vBottom;

    private JideScrollPane(Component component, int n, int n2) {
        this.setLayout(new JideScrollPaneLayout.UIResource());
        this.setVerticalScrollBarPolicy(n);
        this.setHorizontalScrollBarPolicy(n2);
        this.setViewport(this.createViewport());
        this.setVerticalScrollBar(this.createVerticalScrollBar());
        this.setHorizontalScrollBar(this.createHorizontalScrollBar());
        if (component != null) {
            this.setViewportView(component);
        }
        this.setOpaque(true);
        this.updateUI();
        if (!this.getComponentOrientation().isLeftToRight()) {
            this.viewport.setViewPosition(new Point(Integer.MAX_VALUE, 0));
        }
    }

    public JideScrollPane(Component component) {
        this(component, 20, 30);
    }

    public JideScrollPane() {
        this(null, 20, 30);
    }

    public final void setRowHeader(JViewport jViewport) {
        super.setRowHeader(jViewport);
        JideSwingUtilities.synchronizeView(jViewport, this.getViewport(), 1);
    }

    public final void setColumnHeader(JViewport jViewport) {
        super.setColumnHeader(jViewport);
        JideSwingUtilities.synchronizeView(this.columnHeader, this.getViewport(), 0);
    }

    public final Component getScrollBarCorner(String string) {
        boolean bl = this.getComponentOrientation().isLeftToRight();
        if (string.equals("HORIZONTAL_LEADING")) {
            string = bl ? "HORIZONTAL_LEFT" : "HORIZONTAL_RIGHT";
        } else if (string.equals("HORIZONTAL_TRAILING")) {
            String string2 = string = bl ? "HORIZONTAL_RIGHT" : "HORIZONTAL_LEFT";
        }
        if (string.equals("HORIZONTAL_LEFT")) {
            return this._hLeft;
        }
        if (string.equals("HORIZONTAL_RIGHT")) {
            return this._hRight;
        }
        if (string.equals("VERTICAL_BOTTOM")) {
            return this._vBottom;
        }
        if (string.equals("VERTICAL_TOP")) {
            return this._vTop;
        }
        return null;
    }

    public final void setScrollBarCorner(String string, Component component) {
        Component component2;
        boolean bl = this.getComponentOrientation().isLeftToRight();
        if (string.equals("HORIZONTAL_LEADING")) {
            string = bl ? "HORIZONTAL_LEFT" : "HORIZONTAL_RIGHT";
        } else if (string.equals("HORIZONTAL_TRAILING")) {
            String string2 = string = bl ? "HORIZONTAL_RIGHT" : "HORIZONTAL_LEFT";
        }
        if (string.equals("HORIZONTAL_LEFT")) {
            component2 = this._hLeft;
            this._hLeft = component;
        } else if (string.equals("HORIZONTAL_RIGHT")) {
            component2 = this._hRight;
            this._hRight = component;
        } else if (string.equals("VERTICAL_TOP")) {
            component2 = this._vTop;
            this._vTop = component;
        } else if (string.equals("VERTICAL_BOTTOM")) {
            component2 = this._vBottom;
            this._vBottom = component;
        } else {
            throw new IllegalArgumentException("invalid scroll bar corner key");
        }
        if (component2 != null) {
            this.remove(component2);
        }
        if (component != null) {
            this.add(component, string);
        }
        if (component != null) {
            component.setComponentOrientation(this.getComponentOrientation());
        }
        this.firePropertyChange(string, component2, component);
        this.revalidate();
        this.repaint();
    }

    public final void updateUI() {
        super.updateUI();
        this.setLayout(new JideScrollPaneLayout.UIResource());
        if (this.getBorder() instanceof UIResource) {
            LookAndFeel.installBorder(this, "JideScrollPane.border");
        }
    }
}

