/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.ResizableMouseInputAdapter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.event.MouseInputListener;

public class Resizable {
    private int _resizableCorners = 255;
    private int _resizeCornerSize = 16;
    private JComponent _component;
    private MouseInputListener _mouseInputAdapter;

    public Resizable(JComponent object) {
        this._component = object;
        Object object2 = object = this;
        this._mouseInputAdapter = new ResizableMouseInputAdapter((Resizable)object2);
        ((Resizable)object)._component.addMouseListener(((Resizable)object)._mouseInputAdapter);
        ((Resizable)object)._component.addMouseMotionListener(((Resizable)object)._mouseInputAdapter);
    }

    public final int getResizableCorners() {
        return this._resizableCorners;
    }

    public final void setResizableCorners(int n) {
        if (this._resizableCorners != n) {
            int n2 = this._resizableCorners;
            this._resizableCorners = n;
            this._component.firePropertyChange("resizableCorner", n2, this._resizableCorners);
        }
    }

    public final int getResizeCornerSize() {
        return this._resizeCornerSize;
    }

    public final MouseInputListener getMouseInputAdapter() {
        return this._mouseInputAdapter;
    }

    public void resizing$2e715812(int n, int n2, int n3, int n4) {
        Dimension dimension = this._component.getMinimumSize();
        Dimension dimension2 = this._component.getMaximumSize();
        if (n3 < dimension.width) {
            n3 = dimension.width;
        }
        if (n4 < dimension.height) {
            n3 = dimension.height;
        }
        if (n3 > dimension2.width) {
            n3 = dimension2.width;
        }
        if (n4 > dimension2.height) {
            n4 = dimension2.height;
        }
        this._component.setPreferredSize(new Dimension(n3, n4));
        this._component.getParent().doLayout();
    }

    public boolean isTopLevel() {
        return false;
    }

    public final JComponent getComponent() {
        return this._component;
    }

    public final Insets getResizeInsets() {
        Resizable resizable = this;
        return resizable._component.getInsets();
    }

    public static final class ResizeCorner
    extends JComponent {
        private int _corner = 16;

        public ResizeCorner() {
        }

        public ResizeCorner(int n) {
            this._corner = n;
        }

        public final int getCorner() {
            return this._corner;
        }

        public final Dimension getPreferredSize() {
            return new Dimension(16, 16);
        }

        protected final void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            int n = Math.min(this.getWidth(), this.getHeight());
            int n2 = Math.min(n / 4, 4);
            Color color = graphics.getColor();
            ResizeCorner resizeCorner = this;
            int n3 = resizeCorner._corner;
            boolean bl = this.getComponentOrientation().isLeftToRight();
            switch (n3) {
                case 16: {
                    int n4;
                    graphics.setColor(UIDefaultsLookup.getColor("controlLtHighlight"));
                    n3 = 0;
                    for (n4 = 0; n4 < n2; ++n4) {
                        n3 += 4;
                        if (bl) {
                            graphics.drawLine(n, n - n3, n - n3, n);
                            continue;
                        }
                        graphics.drawLine(0, n3, n - n3, n);
                    }
                    graphics.setColor(UIDefaultsLookup.getColor("controlShadow"));
                    n3 = 0;
                    for (n4 = 0; n4 < n2; ++n4) {
                        n3 += 4;
                        if (bl) {
                            graphics.drawLine(n, n - n3 + 1, n - n3 + 1, n);
                            graphics.drawLine(n, n - n3 + 2, n - n3 + 2, n);
                            continue;
                        }
                        graphics.drawLine(0, n3 + 1, n - n3 - 1, n);
                        graphics.drawLine(0, n3 + 2, n - n3 - 2, n);
                    }
                    break;
                }
                case 4: {
                    int n5;
                    graphics.setColor(UIDefaultsLookup.getColor("controlLtHighlight"));
                    n3 = 0;
                    for (n5 = 0; n5 < n2; ++n5) {
                        n3 += 4;
                        if (bl) {
                            graphics.drawLine(n - n3, 0, n, n3);
                            continue;
                        }
                        graphics.drawLine(n3, 0, n, n - n3);
                    }
                    graphics.setColor(UIDefaultsLookup.getColor("controlShadow"));
                    n3 = 0;
                    for (n5 = 0; n5 < n2; ++n5) {
                        n3 += 4;
                        if (bl) {
                            graphics.drawLine(n - n3 + 1, 0, n, n3 - 1);
                            graphics.drawLine(n - n3 + 2, 0, n, n3 - 2);
                            continue;
                        }
                        graphics.drawLine(n3 + 1, 0, n, n - n3 - 1);
                        graphics.drawLine(n3 + 2, 0, n, n - n3 - 2);
                    }
                    break;
                }
            }
            graphics.setColor(color);
        }
    }
}

