/*
 * Decompiled with CFR 0.152.
 */
package com.qbrowser.property;

import com.qbrowser.QBrowserV2;
import com.qbrowser.property.QBrowserPropertyException;
import com.qbrowser.util.QBrowserUtil;
import java.util.ResourceBundle;
import javax.swing.JComboBox;

public class PropertyUtil {
    private static ResourceBundle resources = QBrowserV2.resources;

    public static void validateJMSHeaderValueType(String key, Object value) throws QBrowserPropertyException {
        if (key == null) {
            return;
        }
        if (key != null && value == null) {
            throw new QBrowserPropertyException("Q0005@@@HzRpWr@@" + key + "@@@HzRpWr@@" + "null");
        }
        if (key.equals("JMSExpiration")) {
            PropertyUtil.testInt(key, value);
            return;
        }
        if (key.equals("JMSPriority")) {
            PropertyUtil.testInt(key, value);
            return;
        }
        if (key.equals("JMSCorrelationID")) {
            PropertyUtil.testString(key, value);
            return;
        }
        if (key.equals("JMSType")) {
            PropertyUtil.testString(key, value);
            return;
        }
        if (key.equals("JMSReplyTo")) {
            PropertyUtil.testString(key, value);
            return;
        }
        throw new QBrowserPropertyException("Q0006@@@HzRpWr@@" + key + "@@@HzRpWr@@" + value);
    }

    static void testInt(String key, Object value) throws QBrowserPropertyException {
        if (value instanceof String) {
            return;
        }
        if (value instanceof Integer) {
            return;
        }
        if (value instanceof Long) {
            return;
        }
        throw new QBrowserPropertyException("Q0007@@@HzRpWr@@" + key + "@@@HzRpWr@@" + value);
    }

    static void testString(String key, Object value) throws QBrowserPropertyException {
        if (value instanceof String) {
            if (((String)value).length() == 0) {
                throw new QBrowserPropertyException("Q0008@@@HzRpWr@@" + key + "@@@HzRpWr@@" + value);
            }
        } else {
            throw new QBrowserPropertyException("Q0008@@@HzRpWr@@" + key + "@@@HzRpWr@@" + value);
        }
    }

    public static String selfDescribe(Object obj) {
        StringBuilder sb = new StringBuilder();
        sb.append(resources.getString("qkey.msg.msg185")).append(" = ");
        if (obj == null) {
            sb.append("NULL");
        } else if (obj instanceof String || obj instanceof Integer || obj instanceof Boolean || obj instanceof Byte || obj instanceof Character || obj instanceof Double || obj instanceof Float || obj instanceof Long || obj instanceof Short) {
            sb.append(obj.toString()).append(" (").append(obj.getClass().getName()).append(resources.getString("qkey.msg.msg183")).append(")");
        } else if (obj instanceof byte[]) {
            Object bytearray = (byte[])obj;
            boolean isOmitted = false;
            int targetlength = ((Object)bytearray).length;
            if (targetlength > 1000) {
                targetlength = 1000;
                isOmitted = true;
            }
            sb.append(" ").append(resources.getString("qkey.msg.msg186")).append(" = ").append(((Object)bytearray).length).append(resources.getString("qkey.msg.msg187")).append(" (byte[]").append(resources.getString("qkey.msg.msg183")).append(")").append("\n").append(QBrowserUtil.toHexDump((byte[])bytearray, targetlength));
            if (isOmitted) {
                sb.append("... \n").append(resources.getString("qkey.msg.msg211"));
            }
        } else {
            Object object;
            sb.append("Object (").append(object.getClass().getName()).append(resources.getString("qkey.msg.msg183")).append(")");
        }
        return sb.toString();
    }

    public static JComboBox getUserPropTypeComboBox() {
        JComboBox<String> newjcb;
        JComboBox<String> jComboBox = newjcb = new JComboBox<String>();
        newjcb.addItem("Int");
        jComboBox.addItem("String");
        jComboBox.addItem("Boolean");
        jComboBox.addItem("Byte");
        jComboBox.addItem("Double");
        jComboBox.addItem("Float");
        jComboBox.addItem("Long");
        jComboBox.addItem("Short");
        jComboBox.setSelectedIndex(0);
        return newjcb;
    }
}

