#include "byte.h"
#include "error.h"
#include "str.h"

#include "global.h"
#include "hmac_md5.h"
#include "md5.h"

extern char *crypt();
static char hextab[]="0123456789abcdef";

int auth_passwd(char *password, char *stored)
{
  char *encrypted;
 
  if (!password || !*password)
    return 0;
  if (!stored || !*stored)
    return 0;

  encrypted = crypt(password,stored);
  if (byte_diff(encrypted,str_len(stored)+1,stored))
    return 0;

  return 1;
}

int auth_plain(char *password, char *stored)
{
  if (!password || !*password)
    return 0;
  if (!stored || !*stored)
    return 0;

  if (byte_diff(password,str_len(stored)+1,stored))
    return 0;

  return 1;
}

int auth_apop(char *challenge, char *response, char *stored)
{
  int i;
  unsigned char digest[16];
  unsigned char digascii[33];
  MD5_CTX context;

  if (!challenge || !*challenge)
    return 0;
  if (!response || str_len(response) != 32)
    return 0;
  if (!stored || !*stored)
    return 0;

  MD5Init(&context);
  MD5Update(&context, challenge, str_len(challenge));
  MD5Update(&context, stored, str_len(stored));
  MD5Final(digest, &context);

  for (i = 0; i < 16; i++) {
    digascii[2 * i] = hextab[(digest[i] & 0xF0) >> 4];
    digascii[2 * i + 1] = hextab[(digest[i] & 0x0F)];
  }
  digascii[32] = '\0';

  if (byte_diff(response,33,digascii))
    return 0;

  return 1;
}

int auth_crammd5(char *challenge, char *response, char *stored)
{
  int i;
  unsigned char digest[16];
  unsigned char digascii[33];

  if (!challenge || !*challenge)
    return 0;
  if (!response || str_len(response) != 32)
    return 0;
  if (!stored || !*stored)
    return 0;

  hmac_md5(challenge, str_len(challenge), stored, str_len(stored), digest);

  for (i = 0; i < 16; i++) {
    digascii[2 * i] = hextab[digest[i] >> 4];
    digascii[2 * i + 1] = hextab[(digest[i] & 0x0F)];
  }
  digascii[32] = '\0';

  if (byte_diff(response,33,digascii))
    return 0;

  return 1;
}
