#include "alloc.h"
#include "byte.h"
#include "cdb.h"
#include "error.h"
#include "open.h"
#include "pathexec.h"
#include "str.h"
#include "stralloc.h"
#include "strerr.h"

#include "authdb.h"
#include "authpasswd.h"
#include "auto_qmailhome.h"
#include "auto_withpasswd.h"

#include <unistd.h>
#include <pwd.h>

#define DROP "checkpassword: warning: dropping connection, "

static stralloc password = {0};
struct cdb c;
char *fn;
char state;

static void drop_nomem(void)
{
  strerr_die2sys(111,DROP,"out of memory");
}

static void drop_authdb(void)
{
  strerr_die4sys(111,DROP,"unable to read ",fn,": ");
}

static void found(char *data,unsigned int datalen)
{
  unsigned int next0;
  unsigned int split;
  char *p;
  int plen;

  next0 = byte_chr(data,datalen,0);
  if (!stralloc_copys(&password,data)) drop_nomem();

  ++next0;
  p = data + next0;
  plen = datalen - next0;

  while ((next0 = byte_chr(p,plen,0)) < plen) {
    if(*p == '+') {
      p++, plen--;
      split = str_chr(p,'=');
      if (p[split]) {
	p[split] = 0;
	if (!pathexec_env(p, p + split + 1)) drop_nomem();
      }
      break;
    }
    p += next0; plen -= next0;
  }
}

static int fetchdb(char *login)
{
  char *data;
  unsigned int datalen;

  switch(cdb_find(&c,login,str_len(login))) {
    case -1: return -1;
    case 0: return 0;
  }

  datalen = cdb_datalen(&c);
  data = alloc(datalen);
  if (!data) return -1;
  if (cdb_read(&c,data,datalen,cdb_datapos(&c)) == -1) {
    alloc_free(data);
    return -1;
  }

  found(data,datalen);
  alloc_free(data);
  return 1;
}

static int authdb(char *fn, char *login, char *stored, int storedlen)
{
  int fd;

  fd = open_read(fn);
  if (fd == -1) {
    if (errno != error_noent) drop_authdb();
  }
  else {
    int r;
    int len;
    cdb_init(&c,fd);
    r = fetchdb(login);
    cdb_free(&c);
    close(fd);
    if (r == 1) {
      len = storedlen - 1 > password.len ? password.len : storedlen - 1;
      byte_copy(stored,len,password.s);
      stored[len] = 0;
      return 1;
    }
    return -1;
  }
  return 0;
}

int get_password(char *login, char *stored, int storedlen, char *owner, int realdomain)
{
  stralloc dbfn = {0};

  if (owner) {
    if (!stralloc_copys(&dbfn,auto_qmailhome)) drop_nomem();
    if (!stralloc_cats(&dbfn,"/authdb/")) drop_nomem();
    if (!stralloc_cats(&dbfn,owner)) drop_nomem();
    if (!stralloc_cats(&dbfn,"/cdb")) drop_nomem();
    if (!stralloc_0(&dbfn)) drop_nomem();
    if (authdb(dbfn.s,login,stored,storedlen) == 1)
      return 2; /* virtual mailbox */
  }
  if (realdomain && existpasswd(login)) {
    if (!stralloc_copys(&dbfn,auto_qmailhome)) drop_nomem();
    if (!stralloc_cats(&dbfn,"/authdb/pwdusers/cdb")) drop_nomem();
    if (!stralloc_0(&dbfn)) drop_nomem();
    if (authdb(dbfn.s,login,stored,storedlen) == 1)
      return 1; /* real mailbox with cdb entry */
    else if (auto_withpasswd)
      return 0; /* real mailbox without cdb entry */
  }
  return -1;
}
