#include "byte.h"
#include "error.h"
#include "str.h"
#include "hasspnam.h"
#include "hasuserpw.h"

#include "auto_uids.h"

#include <pwd.h>

static struct passwd *pw;

#ifdef HASGETSPNAM
#include <shadow.h>
static struct spwd *spw;
#endif

#ifdef HASUSERPW
#include <userpw.h>
static struct userpw *upw;
#endif

int existpasswd(char *login)
{
  pw = getpwnam(login);
  if (pw && (int)pw->pw_uid > auto_blockuid)
    return 1;
  else {
    if (errno == error_txtbsy)
      _exit(111);
  }

  return 0;
}

int getpasswd(char *login, char *stored, int storedlen)
{
  char *pwd = 0;
  int len, plen;

  pw = getpwnam(login);
  if (pw)
    pwd = pw->pw_passwd;
  else {
    if (errno == error_txtbsy)
      _exit(111);
  }

#ifdef HASUSERPW
  upw = getuserpw(login);
  if (upw)
    pwd = upw->upw_passwd;
  else {
    if (errno == error_txtbsy)
      _exit(111);
  }
#endif

#ifdef HASGETSPNAM
  spw = getspnam(login);
  if (spw)
    pwd = spw->sp_pwdp;
  else {
    if (errno == error_txtbsy)
      _exit(111);
  }
#endif

  if (!pwd || !*pwd)
    return 0;

  plen = str_len(pwd);
  len = storedlen - 1 > plen ? plen : storedlen - 1;
  byte_copy(stored,len,pwd);
  stored[len] = 0;
  return 1;
}

