#include "buffer.h"
#include "readwrite.h"
#include "exit.h"
#include "scan.h"
#include "fmt.h"

char bspace[256];
buffer b = BUFFER_INIT(write,1,bspace,sizeof bspace);

void puts(char *s)
{
  if (buffer_puts(&b,s) == -1) _exit(111);
}

void main(int argc,char **argv)
{
  char *name;
  char *value;
  unsigned long num;
  char strnum[FMT_ULONG];

  name = argv[1];
  if (!name) _exit(100);
  value = argv[2];
  if (!value) _exit(100);

  scan_ulong(value,&num);
  strnum[fmt_ulong(strnum,num)] = 0;

  puts("const int ");
  puts(name);
  puts(" = ");
  puts(strnum);
  puts(";\n");
  if (buffer_flush(&b) == -1) _exit(111);
  _exit(0);
}
