#include <sys/types.h>
#include <pwd.h>
#include "buffer.h"
#include "readwrite.h"
#include "exit.h"
#include "fmt.h"

char bspace[256];
buffer b = BUFFER_INIT(write,1,bspace,sizeof bspace);

void outs(char *s) /* was named puts, but Solaris pwd.h includes stdio.h. dorks. */
{
  if (buffer_puts(&b,s) == -1) _exit(111);
}

void main(int argc,char **argv)
{
  char *name;
  char *value;
  struct passwd *pw;
  char strnum[FMT_ULONG];

  name = argv[1];
  if (!name) _exit(100);
  value = argv[2];
  if (!value) _exit(100);

  pw = getpwnam(value);
  if (!pw) {
    buffer_puts(buffer_2,"fatal: unable to find user ");
    buffer_puts(buffer_2,value);
    buffer_puts(buffer_2,"\n");
    buffer_flush(buffer_2);
    _exit(111);
  }

  strnum[fmt_ulong(strnum,(unsigned long) pw->pw_uid)] = 0;

  outs("const int ");
  outs(name);
  outs(" = ");
  outs(strnum);
  outs(";\n");
  if (buffer_flush(&b) == -1) _exit(111);
  _exit(0);
}
