#include "byte.h"
#include "constmap.h"
#include "str.h"
#include "stralloc.h"

#include "auto_qmailhome.h"
#include "control.h"

#include <unistd.h>

static struct constmap mapvdoms;
static stralloc vdoms = {0};

static int getcontrols ()
{
  if (control_init() == -1) return 0;
  switch(control_readfile(&vdoms,"control/virtualdomains",0))
  {
    case -1: return 0;
    case 0: if (!constmap_init(&mapvdoms,"",0,1)) return 0; break;
    case 1: if (!constmap_init(&mapvdoms,vdoms.s,vdoms.len,1)) return 0; break;
  }
  return 1;
}

static int existowner (char *src)
{
  char *s;
  int len, n;

  s = vdoms.s;
  len = vdoms.len;

  while (len > 0) {
    if ((n = byte_chr (s,len,':')) == len)
      break;
    n++;
    s += n, len -= n;
    if (byte_equal (s,str_len(s)+1,src))
      return 1;
  }
  return 0;
}

char *getvdomain (char *src)
{
  char *dest;
  if (chdir (auto_qmailhome) == -1)
    _exit(1);
  if (!getcontrols ())
    _exit(1);

  dest = constmap (&mapvdoms,src,str_len(src));
  if (dest)
    return dest;
  else if (existowner(src))
    return src;
  else
    return 0;
}
