#include "error.h"
#include "stralloc.h"
#include "env.h"
#include "str.h"

static stralloc line = {0};

static void striptrailingwhitespace(sa)
stralloc *sa;
{
 while (sa->len > 0)
   switch(sa->s[sa->len - 1])
    {
     case '\n': case ' ': case '\t':
       --sa->len;
       break;
     default:
       return;
    }
}

int env2stralloc(sa,env)
stralloc *sa;
char *env;
{
 char *envstr;
 int match = 1;
 int i;

 envstr = env_get (env);
 if (!envstr)
   return 0;

 if (!stralloc_copys(sa,"")) return -1;

 for (;;)
  {
   i = str_chr(envstr,':');
   if (!envstr[i])
     match = 0;
   if (!stralloc_copyb (&line,envstr,i)) break;
   striptrailingwhitespace(&line);
   if (!stralloc_0(&line)) break;
   if (!stralloc_cat(sa,&line)) break;
   if (!match)
     return 1;
   i++; envstr += i;
  }
 return -1;
}
