#include "byte.h"
#include "case.h"
#include "constmap.h"
#include "control.h"
#include "error.h"
#include "open.h"
#include "stralloc.h"

#include "env2stralloc.h"
#include "senderhosts.h"

static int flagsh = 0;
static stralloc sh = {0};
static struct constmap mapsh;

int senderhosts_init()
{
  flagsh = env2stralloc(&sh,"SENDERHOSTS");
  if (flagsh == 1) { 
    if (!constmap_init(&mapsh,sh.s,sh.len,0)) return flagsh = -1;
    return flagsh;
  }
  else if (flagsh == -1)
    return flagsh;
  flagsh = control_readfile(&sh,"control/senderhosts",0);
  if (flagsh == -1) return flagsh;
  if (!constmap_init(&mapsh,sh.s,sh.len,0)) return flagsh = -1;
  return 0;
}

static stralloc host = {0};

int senderhosts(buf,len)
char *buf;
int len;
{
  int j;

  if (!flagsh) return 1;
  if (len == 0) return 1; /* null sender is acceptable */

  j = byte_rchr(buf,len,'@');
  if (j >= len) return 0; /* null domain is not acceptable */

  ++j; buf += j; len -= j;

  if (!stralloc_copyb(&host,buf,len)) return -1;
  buf = host.s;
  case_lowerb(buf,len);

  for (j = 0;j < len;++j)
    if (!j || (buf[j] == '.'))
      if (constmap(&mapsh,buf + j,len - j)) return 1;

  return 0;
}

