#include <sys/types.h>
#include <grp.h>
#include "buffer.h"
#include "readwrite.h"
#include "exit.h"
#include "fmt.h"

char bspace[256];
buffer b = BUFFER_INIT(write,1,bspace,sizeof bspace);

void puts(char *s)
{
  if (buffer_puts(&b,s) == -1) _exit(111);
}

void main(int argc,char **argv)
{
  char *name;
  char *value;
  struct group *gr;
  char strnum[FMT_ULONG];

  name = argv[1];
  if (!name) _exit(100);
  value = argv[2];
  if (!value) _exit(100);

  gr = getgrnam(value);
  if (!gr) {
    buffer_puts(buffer_2,"fatal: unable to find group ");
    buffer_puts(buffer_2,value);
    buffer_puts(buffer_2,"\n");
    buffer_flush(buffer_2);
    _exit(111);
  }

  strnum[fmt_ulong(strnum,(unsigned long) gr->gr_gid)] = 0;

  puts("const int ");
  puts(name);
  puts(" = ");
  puts(strnum);
  puts(";\n");
  if (buffer_flush(&b) == -1) _exit(111);
  _exit(0);
}
