/*
 * Copyright (c) 2001-2002 TAKIZAWA Takashi <taki@cyber.email.ne.jp>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "strerr.h"
#include "exit.h"
#include <pwd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>

#define FATAL "vida-maildirmake: fatal: "

static void usage(void)
{
  strerr_die1x(100,"Usage: vida-maildirmake virtualuser maildir\n");
}

static char *getpwdir(void)
{
  uid_t pwuid;
  struct passwd *pw;

  pwuid = getuid();
  if (!pwuid)
    strerr_die2x(100,FATAL,"you must change user to the owner of domain");
  pw = getpwuid(pwuid);
  if (!pw)
    strerr_die2x(111,FATAL,"unable to read /etc/passwd");
  return pw->pw_dir;
}

static void maildirmake(char *homedir, char *user, char *maildir)
{
  if (chdir(homedir) == -1)
    strerr_die4sys(111,FATAL,"unable to chdir to ",homedir,": ");
  if (mkdir(user,0700) == -1)
    strerr_die4sys(111,FATAL,"unable to mkdir ",user,": ");
  if (chdir(user) == -1)
    strerr_die4sys(111,FATAL,"unable to chdir to ",user,": ");
  if (mkdir(maildir,0700) == -1)
    strerr_die4sys(111,FATAL,"unable to mkdir ",maildir,": ");
  if (chdir(maildir) == -1)
    strerr_die4sys(111,FATAL,"unable to chdir to ",maildir,": ");
  if (mkdir("tmp",0700) == -1)
    strerr_die4sys(111,FATAL,"unable to mkdir ",maildir,"/tmp: ");
  if (mkdir("new",0700) == -1)
    strerr_die4sys(111,FATAL,"unable to mkdir ",maildir,"/new: ");
  if (mkdir("cur",0700) == -1)
    strerr_die4sys(111,FATAL,"unable to mkdir ",maildir,"/cur: ");
}

int main(int argc,char **argv)
{
  char *homedir;

  umask(077);
  if(!argv[1] || !argv[2])
    usage();

  homedir = getpwdir();
  maildirmake(homedir,argv[1],argv[2]);

  _exit(0);
}
