--! \file
-- \brief 2D 戦闘の基本サンプル
--
-- \author Satofumi KAMIMURA
--
-- $Id: fightBasicSample.lua 241 2009-02-27 04:27:38Z satofumi $

require("scheduler")


-- 画面サイズの受け取り
screen = Screen()
local scr_w = screen:width()
local scr_h = screen:height()

-- LayerManager の初期化
LayerManager:clear()

-- Layer の配置
local layer = Layer(0, 0, scr_w, scr_h)
LayerManager:push_back(layer)

-- コルーチン用スケジューラ
local scheduler = Scheduler:new()

local side_width = 100

-- 2D 戦闘用のモジュール宣言
local unit_manager = UnitManager()
local map_handler = MapHandler("default_tile.txt")
if not map_handler:load("samples/grid_map.txt") then
--if not map_handler:load("samples/simple_map.txt") then
   print("map load: " .. map_handler:what())
   map_handler:setEmptyMap(32 * 20, 32 * 16)
end
unit_manager:initialize(scr_w - side_width, scr_h, map_handler)

-- 自機ユニットの追加
local user_ship = UserShip()
-- !!! -1 でなく luabind で割り振った値を使うように変更する
map_handler:insertUnit(user_ship, -1)
user_ship:setPosition(map_handler:unitBase(user_ship))

-- 描画中心を自機ユニットに設定
unit_manager:setViewUnit(user_ship)

-- 敵ユニットの追加
-- !!! map_handler:insertUnit(xxx)

unit_manager:setPosition(Grid(side_width, 0))
layer:push_back(unit_manager)

-- 隠面用のタイル配置
local tile_surface = ColorSurface(side_width, scr_h, Color(0.0, 0.0, 0.3, 1.0))
local tile_label = LabelComponent(tile_surface)
-- !!! 配置すると、重くなる
--layer:push_front(tile_label)

local bar_surface = ColorSurface(2, scr_h, Color(1.0, 1.0, 1.0, 1.0));
local bar_label = LabelComponent(bar_surface)
bar_label:setPosition(Grid(right(bar_label, side_width), 0))
layer:push_front(bar_label)

-- 状態ボードの配置
-- !!!

-- スコアボードの配置
-- !!!

-- 縮小マップの配置
-- !!!

-- メインループ
local cycle_timer = CycleTimer()
while true do

   LayerManager:redraw_pollEvent() -- 入力の更新
   scheduler:execute()          -- コルーチンの処理
   screen:clear();
   LayerManager:redraw_draw()  -- 再描画
   delay(cycle_timer:waitMsec()) -- 一定周期の待機
   LayerManager:redraw_swap()  -- 画面の入れ替え
end
