-- ステージを選択して再開
--
-- Satofumi KAMIMURA
--
-- $Id: stage_replay.lua 313 2009-03-18 11:00:10Z satofumi $

-- フラグの初期化
_G.flags.play_mode = "replay"
_G.flags.continue_left = 6


-- 画面サイズの受け取り
screen = Screen()
local scr_w = screen:width()
local scr_h = screen:height()

-- 描画まわりの初期化
LayerManager:clear()

-- レイヤーの作成
local layer = Layer(0, 0, scr_w, scr_h)
LayerManager:push_back(layer)
local back_layer = Layer(0, 0, scr_w, scr_h)
LayerManager:push_back(back_layer)


-- 画面の作成
local font = Font("resource/font.ttf", 16, true)

-- タイトル
font:setFontSize(40)
title_surface = TextSurface(font, "Stage replay")
local title_label = LabelComponent(title_surface)
title_label:setPosition(Grid(center(title_label, scr_w/2), 20))
layer:push_back(title_label)

-- メニュー
local button_group = ButtonGroupComponent(scr_w, scr_h)
button_group:enableNoSelect(false)

font:setFontSize(30)
local focused_font = font:duplicate()
focused_font:setBackgroundColor(Color(0.0, 0.0, 1.0, 1.0))
focused_font:setTransparent(false)

local titles = { "Stage 1",
                 "Stage 2",
                 "Stage 3",
                 "Stage 4",
                 "Stage 5",
                 "Stage 6",
                 "Stage 7" }
for index, title in ipairs(titles) do
   -- 現在クリアしているステージまでを表示する
   if index >_G.g_last_stage then
      break
   end
   local surface = TextSurface(font, title)
   local focused_surface = TextSurface(focused_font, title)
   local button = ButtonComponent(surface, surface, focused_surface)

   button_group:addButton(button, index)
end

-- !!! メニューの配置と幅について、仕様を書き出して実装を調整する
button_group:setOffset(Grid(0, 5))
button_group:setPosition(Grid(80, 120))
layer:push_back(button_group)


-- フェード処理
local decided = false
function fade()

   -- !!! fps で指定できるようにする
   local fade_count = 25

   -- フェードイン
   for i = 0, fade_count do
      local alpha = i / fade_count
      layer:setAlpha(alpha)
      back_layer:setAlpha(alpha)
      Scheduler:yield()
   end

   while not decided do
      -- メニューの決定待ち
      Scheduler:yield()
   end

   -- フェードアウト
   for i = 0, fade_count do
      local alpha = 1.0 - (i / fade_count)
      layer:setAlpha(alpha)
      back_layer:setAlpha(alpha)
      Scheduler:yield()
   end
end


-- 制御ループ
local scheduler = Scheduler:new()
local id = scheduler:registerFunction(fade)

local escape_detector = EventDetector()
escape_detector:setEvent(Event_escape())

_G.flags.select = 0
local cycle_timer = CycleTimer()
while scheduler:isActive(id) do

   if escape_detector:isActive() then
      -- chart: next first_menu [!!! below]
      _G.flags.select = 0
      decided = true
   end

   if not button_group:noClicked() then
      decided = true

      if button_group:isClicked(1) then
         -- chart: next move_tutorial [!!! below]
         _G.flags.select = 1

      elseif button_group:isClicked(2) then
         -- chart: next attack_tutorial [!!! below]
         _G.flags.select = 2

      elseif button_group:isClicked(3) then
         -- chart: next destroy_tutorial [!!! below]
         _G.flags.select = 3

      elseif button_group:isClicked(4) then
         -- chart: next scout_quest [!!! below]
         _G.flags.select = 4

      elseif button_group:isClicked(5) then
         -- chart: next fortress_quest [!!! below]
         _G.flags.select = 5

      elseif button_group:isClicked(6) then
         -- chart: next cloak_quest [!!! below]
         _G.flags.select = 6

      elseif button_group:isClicked(7) then
         -- chart: next escape_quest [!!! below]
         _G.flags.select = 7
      end
   end

   scheduler:execute()
   LayerManager:redraw_pollEvent()
   screen:clear()
   LayerManager:redraw_draw()
   delay(cycle_timer:waitMsec())
   LayerManager:redraw_swap()
end
