--! \file
-- \brief システム設定の読み出し
--
-- \author Satofumi KAMIMURA
--
-- $Id: system.lua 304 2009-03-16 12:59:59Z satofumi $


-- グローバル変数が初期化されているか、の確認用
function isTableInitialized(name)

   local is_found = false
   for key, val in pairs(_G) do
      if key == name then
         is_found = true
         break
      end
   end
   return is_found
end


-- グローバル変数の初期化
if not isTableInitialized("state") then
   _G.state = nil
end

if not isTableInitialized("flags") then
   _G.flags = {}
end

if not isTableInitialized("g_last_stage") then
   _G.g_last_stage = 0
end


function saveSystemSettings_item(name)

   -- 値の取り出し
   local value = assert(loadstring("return " .. name))()
   if type(value) == "boolean" then
      if value then
         value = "true"
      else
         value = "false"
      end
   else
      value = string.format("%d", value)
   end

   -- 設定用の関数名に変更
   local replace = ":set" .. string.upper(string.match(name, ":(.)"))
   local replaced = string.gsub(name, "(.+):.(.+).", "%1" .. replace .. "%2")

   return replaced .. value .. ")\n"
end


function saveSystemSettings(file)

   local fd = assert(io.open(file, "w"))

   -- 各変数の保存
   local buffer = ""
   buffer = buffer .. saveSystemSettings_item("SystemSettings:isFullscreen()")
   buffer = buffer .. saveSystemSettings_item("SystemSettings:isMute()")
   buffer = buffer .. saveSystemSettings_item("SystemSettings:musicVolume()")
   buffer = buffer .. saveSystemSettings_item("SystemSettings:effectVolume()")

   fd:write(buffer)
   fd:close()
end
