/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.qrcode.codec.reader;

import jp.sourceforge.qrcode.codec.util.DebugCanvas;

public class QRCodeDataBlockReader {
    int[] blocks;
    int version;
    int mode = -1;
    int blockPointer = 0;
    int bitPointer = 7;
    int dataLength = 0;
    DebugCanvas canvas;
    final int MODE_NUMBER = 1;
    final int MODE_ROMAN_AND_NUMBER = 2;
    final int MODE_8BIT_BYTE = 4;
    final int MODE_KANJI = 8;

    public QRCodeDataBlockReader(int[] blocks, int version) {
        this.blocks = blocks;
        this.version = version;
        this.canvas = DebugCanvas.getCanvas();
    }

    int getNextBits(int numBits) throws ArrayIndexOutOfBoundsException {
        if (numBits < this.bitPointer + 1) {
            int mask = 0;
            int i = 0;
            while (i < numBits) {
                mask += 1 << i;
                ++i;
            }
            int bits = (this.blocks[this.blockPointer] & (mask <<= this.bitPointer - numBits + 1)) >> this.bitPointer - numBits + 1;
            this.bitPointer -= numBits;
            return bits;
        }
        if (numBits < this.bitPointer + 1 + 8) {
            int mask1 = 0;
            boolean mask2 = false;
            int i = 0;
            while (i < this.bitPointer + 1) {
                mask1 += 1 << i;
                ++i;
            }
            int bits = (this.blocks[this.blockPointer] & mask1) << numBits - (this.bitPointer + 1);
            ++this.blockPointer;
            bits += this.blocks[this.blockPointer] >> 8 - (numBits - (this.bitPointer + 1));
            this.bitPointer -= numBits % 8;
            if (this.bitPointer < 0) {
                this.bitPointer += 8;
            }
            return bits;
        }
        if (numBits < this.bitPointer + 1 + 16) {
            int mask1 = 0;
            int mask3 = 0;
            int i = 0;
            while (i < this.bitPointer + 1) {
                mask1 += 1 << i;
                ++i;
            }
            int bitsFirstBlock = (this.blocks[this.blockPointer] & mask1) << numBits - (this.bitPointer + 1);
            ++this.blockPointer;
            int bitsSecondBlock = this.blocks[this.blockPointer] << numBits - (this.bitPointer + 1 + 8);
            ++this.blockPointer;
            int i2 = 0;
            while (i2 < numBits - (this.bitPointer + 1 + 8)) {
                mask3 += 1 << i2;
                ++i2;
            }
            int bitsThirdBlock = (this.blocks[this.blockPointer] & (mask3 <<= 8 - (numBits - (this.bitPointer + 1 + 8)))) >> 8 - (numBits - (this.bitPointer + 1 + 8));
            int bits = bitsFirstBlock + bitsSecondBlock + bitsThirdBlock;
            this.bitPointer -= (numBits - 8) % 8;
            if (this.bitPointer < 0) {
                this.bitPointer += 8;
            }
            return bits;
        }
        System.out.println("ERROR!");
        return 0;
    }

    int getNextMode() throws ArrayIndexOutOfBoundsException {
        return this.getNextBits(4);
    }

    int guessMode(int mode) {
        if (mode == 3) {
            return 2;
        }
        return 8;
    }

    int getDataLength(int mode) throws ArrayIndexOutOfBoundsException {
        switch (mode) {
            case 1: {
                if (this.version <= 9) {
                    return this.getNextBits(10);
                }
                if (this.version >= 10 && this.version <= 26) {
                    return this.getNextBits(12);
                }
            }
            case 2: {
                if (this.version <= 9) {
                    return this.getNextBits(9);
                }
                if (this.version >= 10 && this.version <= 26) {
                    return this.getNextBits(11);
                }
            }
            case 4: {
                if (this.version <= 9) {
                    return this.getNextBits(8);
                }
                if (this.version >= 10 && this.version <= 26) {
                    return this.getNextBits(16);
                }
            }
            case 8: {
                if (this.version <= 9) {
                    return this.getNextBits(8);
                }
                if (this.version < 10 || this.version > 26) break;
                return this.getNextBits(10);
            }
        }
        return 0;
    }

    public String getDataString() throws ArrayIndexOutOfBoundsException {
        this.canvas.println("Reading data blocks.");
        String dataString = "";
        while (true) {
            this.mode = this.getNextMode();
            if (this.mode == 0) break;
            if (this.mode != 1 && this.mode != 2 && this.mode != 4 && this.mode != 8) {
                this.mode = this.guessMode(this.mode);
            }
            this.dataLength = this.getDataLength(this.mode);
            switch (this.mode) {
                case 1: {
                    dataString = String.valueOf(dataString) + this.getFigureString(this.dataLength);
                    break;
                }
                case 2: {
                    dataString = String.valueOf(dataString) + this.getRomanAndFigureString(this.dataLength);
                    break;
                }
                case 4: {
                    dataString = String.valueOf(dataString) + this.get8bitByteString(this.dataLength);
                    break;
                }
                case 8: {
                    dataString = String.valueOf(dataString) + this.getKanjiString(this.dataLength);
                }
            }
        }
        System.out.println("");
        return dataString;
    }

    String getFigureString(int dataLength) throws ArrayIndexOutOfBoundsException {
        int length = dataLength;
        int intData = 0;
        String strData = "";
        do {
            if (length >= 3) {
                intData = this.getNextBits(10);
                if (intData < 100) {
                    strData = String.valueOf(strData) + "0";
                }
                if (intData < 10) {
                    strData = String.valueOf(strData) + "0";
                }
                length -= 3;
            } else if (length == 2) {
                intData = this.getNextBits(7);
                if (intData < 10) {
                    strData = String.valueOf(strData) + "0";
                }
                length -= 2;
            } else if (length == 1) {
                intData = this.getNextBits(4);
                --length;
            }
            strData = String.valueOf(strData) + Integer.toString(intData);
        } while (length > 0);
        return strData;
    }

    String getRomanAndFigureString(int dataLength) throws ArrayIndexOutOfBoundsException {
        int length = dataLength;
        int intData = 0;
        String strData = "";
        char[] tableRomanAndFigure = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', ' ', '$', '%', '*', '+', '-', '.', '/', ':'};
        do {
            if (length > 1) {
                intData = this.getNextBits(11);
                int firstLetter = intData / 45;
                int secondLetter = intData % 45;
                strData = String.valueOf(strData) + String.valueOf(tableRomanAndFigure[firstLetter]);
                strData = String.valueOf(strData) + String.valueOf(tableRomanAndFigure[secondLetter]);
                length -= 2;
                continue;
            }
            if (length != 1) continue;
            intData = this.getNextBits(6);
            strData = String.valueOf(strData) + String.valueOf(tableRomanAndFigure[intData]);
            --length;
        } while (length > 0);
        return strData;
    }

    String get8bitByteString(int dataLength) throws ArrayIndexOutOfBoundsException {
        int length = dataLength;
        int intData = 0;
        String strData = "";
        char[] table8bitByte = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', '\n', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', '\uff61', '\uff62', '\uff63', '\uff64', '\uff65', '\uff66', '\uff67', '\uff68', '\uff69', '\uff6a', '\uff6b', '\uff6c', '\uff6d', '\uff6e', '\uff6f', '-', '\uff71', '\uff72', '\uff73', '\uff74', '\uff75', '\uff76', '\uff77', '\uff78', '\uff79', '\uff7a', '\uff7b', '\uff7c', '\uff7d', '\uff7e', '\uff7f', '\uff80', '\uff81', '\uff82', '\uff83', '\uff84', '\uff85', '\uff86', '\uff87', '\uff88', '\uff89', '\uff8a', '\uff8b', '\uff8c', '\uff8d', '\uff8e', '\uff8f', '\uff90', '\uff91', '\uff92', '\uff93', '\uff94', '\uff95', '\uff96', '\uff97', '\uff98', '\uff99', '\uff9a', '\uff9b', '\uff9c', '\uff9d', '\uff9e', '\uff9f', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
        do {
            intData = this.getNextBits(8);
            strData = String.valueOf(strData) + String.valueOf(table8bitByte[intData]);
        } while (--length > 0);
        return strData;
    }

    String getKanjiString(int dataLength) throws ArrayIndexOutOfBoundsException {
        int length = dataLength;
        int intData = 0;
        String unicodeString = "";
        do {
            intData = this.getNextBits(13);
            int lowerByte = intData % 192;
            int higherByte = intData / 192;
            int tempWord = (higherByte << 8) + lowerByte;
            int shiftjisWord = 0;
            shiftjisWord = tempWord + 33088 <= 40956 ? tempWord + 33088 : tempWord + 49472;
            byte[] tempByte = new byte[]{(byte)(shiftjisWord >> 8), (byte)(shiftjisWord & 0xFF)};
            unicodeString = String.valueOf(unicodeString) + new String(tempByte);
        } while (--length > 0);
        return unicodeString;
    }
}

