/*
 * Decompiled with CFR 0.152.
 */
package example;

import example.QRCodeDecoderMIDletExample;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import jp.sourceforge.qrcode.codec.geom.Line;
import jp.sourceforge.qrcode.codec.geom.Point;
import jp.sourceforge.qrcode.codec.util.DebugCanvas;

class DisplayCanvas
extends Canvas
implements CommandListener,
DebugCanvas {
    private final QRCodeDecoderMIDletExample midlet;
    private Image image = null;
    private Command viewDecodedStringCommand = null;
    private String[] log = null;
    private int numCols;
    private int numRows;
    Font logFont = null;

    DisplayCanvas(QRCodeDecoderMIDletExample midlet) {
        this.midlet = midlet;
        this.addCommand(new Command("Camera", 2, 1));
        this.setCommandListener(this);
        this.logFont = Font.getDefaultFont();
        this.numRows = this.getHeight() / this.logFont.getHeight();
        this.numCols = this.getWidth() / this.logFont.charWidth('_');
        this.log = new String[this.numRows];
    }

    public void paint(Graphics g) {
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.image != null) {
            g.drawImage(this.image, this.getWidth() / 2, this.getHeight() / 2, 3);
        }
        g.setColor(0);
        int i = 0;
        while (i < this.log.length) {
            if (this.log[i] != null) {
                g.drawString(this.log[i], 0, i * this.logFont.getHeight(), 20);
            }
            ++i;
        }
    }

    void setImage(byte[] pngImage) {
        this.image = Image.createImage((byte[])pngImage, (int)0, (int)pngImage.length);
    }

    void addViewDecodedStringCommand() {
        if (this.viewDecodedStringCommand == null) {
            this.viewDecodedStringCommand = new Command("Result", 1, 1);
            this.addCommand(this.viewDecodedStringCommand);
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.viewDecodedStringCommand) {
            this.midlet.toDecodedTextBox();
        } else {
            this.midlet.displayCanvasBack();
        }
    }

    public void drawCross(Point point, int color) {
        Image bufImage = Image.createImage((int)this.image.getWidth(), (int)this.image.getHeight());
        Graphics g = bufImage.getGraphics();
        g.drawImage(this.image, 0, 0, 0);
        g.setColor(color);
        g.drawLine(point.getX() - 5, point.getY(), point.getX() + 5, point.getY());
        g.drawLine(point.getX(), point.getY() - 5, point.getX(), point.getY() + 5);
        this.image = bufImage;
        this.repaint();
    }

    public void drawLine(Line line, int color) {
        Image bufImage = Image.createImage((int)this.image.getWidth(), (int)this.image.getHeight());
        Graphics g = bufImage.getGraphics();
        g.drawImage(this.image, 0, 0, 0);
        g.setColor(color);
        g.drawLine(line.getP1().getX(), line.getP1().getY(), line.getP2().getX(), line.getP2().getY());
        this.image = bufImage;
        this.repaint();
    }

    public void drawLines(Line[] lines, int color) {
        Image bufImage = Image.createImage((int)this.image.getWidth(), (int)this.image.getHeight());
        Graphics g = bufImage.getGraphics();
        g.drawImage(this.image, 0, 0, 0);
        g.setColor(color);
        int i = 0;
        while (i < lines.length - 1) {
            g.drawLine(lines[i].getP1().getX(), lines[i].getP1().getY(), lines[i].getP2().getX(), lines[i].getP2().getY());
            ++i;
        }
        this.image = bufImage;
        this.repaint();
    }

    public void drawMatrix(boolean[][] matrix) {
        Image bufImage = Image.createImage((int)this.image.getWidth(), (int)this.image.getHeight());
        Graphics g = bufImage.getGraphics();
        g.setColor(0xCCCCCC);
        int y = 0;
        while (y < matrix[0].length) {
            int x = 0;
            while (x < matrix.length) {
                if (matrix[x][y]) {
                    g.drawLine(x, y, x + 1, y);
                }
                ++x;
            }
            ++y;
        }
        this.image = bufImage;
        this.repaint();
    }

    public void drawPoint(Point point, int color) {
    }

    public void drawPoints(Point[] points, int color) {
        Image bufImage = Image.createImage((int)this.image.getWidth(), (int)this.image.getHeight());
        Graphics g = bufImage.getGraphics();
        g.drawImage(this.image, 0, 0, 0);
        g.setColor(color);
        int i = 0;
        while (i < points.length - 1) {
            g.drawLine(points[i].getX(), points[i].getY(), points[i].getX() + 1, points[i].getY());
            ++i;
        }
        this.image = bufImage;
        this.repaint();
    }

    public void drawPolygon(Point[] points, int color) {
        Image bufImage = Image.createImage((int)this.image.getWidth(), (int)this.image.getHeight());
        Graphics g = bufImage.getGraphics();
        g.drawImage(this.image, 0, 0, 0);
        g.setColor(color);
        int i = 0;
        while (i < points.length - 1) {
            g.drawLine(points[i].getX(), points[i].getY(), points[i + 1].getX(), points[i + 1].getY());
            ++i;
        }
        g.drawLine(points[i].getX(), points[i].getY(), points[0].getX(), points[0].getY());
        this.image = bufImage;
        this.repaint();
    }

    public void println(String message) {
        System.out.println(message);
        int numParts = message.length() / this.numCols;
        if (message.length() % this.numCols > 0) {
            ++numParts;
        }
        String[] lineStrings = new String[numParts];
        int offset = 0;
        int i = 0;
        while (i < numParts - 1) {
            lineStrings[i] = message.substring(offset, offset + this.numCols);
            offset += this.numCols;
            ++i;
        }
        lineStrings[numParts - 1] = message.substring(offset);
        int numLoggedLine = 0;
        if (this.log[this.log.length - numParts] == null) {
            int i2 = 0;
            while (i2 < this.log.length) {
                if (this.log[i2] == null) {
                    this.log[i2] = lineStrings[numLoggedLine];
                    if (++numLoggedLine == lineStrings.length) break;
                }
                ++i2;
            }
        } else {
            int i3 = 0;
            while (i3 < this.log.length - numParts) {
                this.log[i3] = this.log[i3 + numParts];
                ++i3;
            }
            int start = i3;
            while (i3 < this.log.length) {
                this.log[i3] = lineStrings[i3 - start];
                ++i3;
            }
        }
        this.repaint();
    }
}

