#ifndef QRK_COMPONENT_H
#define QRK_COMPONENT_H

/*!
  \file
  \brief コンポーネントのインターフェース定義

  \author Satofumi KAMIMURA

  $Id: Component.h 708 2009-04-04 09:11:37Z satofumi $
*/

#include "Rect.h"
#include "Grid.h"


namespace qrk
{
  class Component
  {
    Grid<long> position_;

  public:
    virtual ~Component(void)
    {
    }


    virtual void setPosition(const Grid<long>& position)
    {
      position_ = position;
    }


    virtual Grid<long> position(void) const
    {
      return position_;
    }


    virtual void setEventAcceptable(bool acceptable) = 0;
    virtual void setAlpha(float alpha) = 0;
    virtual void draw(const Rect<long>& area) const = 0;
  };
}

#endif /* !QRK_COMPONENT_H */
