#ifndef QRK_LABLE_H

#define QRK_LABLE_H

/*!
  \file
  \brief ラベル

  \author Satofumi KAMIMURA

  $Id: Label.h 708 2009-04-04 09:11:37Z satofumi $
*/

#include "Component.h"
#include <memory>


namespace qrk
{
  class Surface;


  class Label : public Component
  {
    Label(const Label& rhs);
    Label& operator = (Label& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    explicit Label(Surface& surface);
    ~Label(void);

    void setEventAcceptable(bool acceptable);
    void setAlpha(float alpha);
    void draw(const Rect<long>& area) const;
  };
}

#endif /* !QRK_LABLE_H */
