/*!
  \file
  \brief 描画レイヤー

  \author Satofumi KAMIMURA

  $Id: Layer.cpp 708 2009-04-04 09:11:37Z satofumi $
*/

#include "Layer.h"
#include "Component.h"
#include "Screen.h"
#include <boost/bind.hpp>
#include <algorithm>
#include <list>

using namespace qrk;
using namespace std;


namespace
{
  typedef list<Component*> Components;
}


struct Layer::pImpl
{
  Components components_;
  Rect<long> draw_area_;


  pImpl(void)
  {
    Screen screen;
    draw_area_ = screen.rect();
  }


  void setAlpha(float alpha)
  {
    for_each(components_.begin(), components_.end(),
             bind(&Component::setAlpha, _1, alpha));
  }


  void draw(void)
  {
    for_each(components_.begin(), components_.end(),
             bind(&Component::draw, _1, draw_area_));
  }
};


Layer::Layer(void) : pimpl(new pImpl)
{
}


Layer::~Layer(void)
{
}


void Layer::clear(void)
{
  pimpl->components_.clear();
}


void Layer::push_front(Component* component)
{
  pimpl->components_.push_front(component);
}


void Layer::push_back(Component* component)
{
  pimpl->components_.push_back(component);
}


void Layer::remove(Component* component)
{
  pimpl->components_.remove(component);
}


void Layer::setAlpha(float alpha)
{
  pimpl->setAlpha(alpha);
}


void Layer::draw(void)
{
  pimpl->draw();
}
