/*!
  \file
  \brief Lua への gui モジュール登録

  \author Satofumi KAMIMURA

  $Id: luabindGui.cpp 709 2009-04-05 03:52:04Z satofumi $
*/

#include "luabindGui.h"
#include "luabindInit.h"
#include "Color.h"
#include "Screen.h"
#include "LayerManager.h"
#include "Layer.h"
#include "Font.h"
#include "TextSurface.h"
#include "ImageSurface.h"
#include "Label.h"
#include <luabind/luabind.hpp>

using namespace qrk;
using namespace luabind;


void qrk::luabindGui(void)
{
  lua_State* lua = luabindInit();

  module(lua)
    [
     class_<Color>("Color")
     .def(constructor<float, float, float, float>())
     .def_readwrite("r", &Color::r)
     .def_readwrite("g", &Color::g)
     .def_readwrite("b", &Color::b),

     class_<Screen>("Screen")
     .def(constructor<>())
     .def("rect", &Screen::rect)
     .def("showCursor", &Screen::showCursor)
     .def("isShowCursor", &Screen::isShowCursor)
     .def("setClearColor", &Screen::setClearColor)
     .def("clear", &Screen::clear),

     class_<LayerManager>("LayerManager")
     .def(constructor<>())
     .def("swap", &LayerManager::swap),

     class_<Layer>("Layer")
     .def(constructor<>())
     .def("clear", &Layer::clear)
     .def("push_front", &Layer::push_front)
     .def("push_back", &Layer::push_back)
     .def("remove", &Layer::remove)
     .def("setAlpha", &Layer::setAlpha)
     .def("draw", &Layer::draw),

     class_<Font>("Font")
     .def(constructor<const char*, size_t, bool>())
     .def("setFontSize", &Font::setFontSize),

     class_<Surface>("Surface"),

     class_<TextSurface, Surface>("TextSurface")
     .def(constructor<const Font&, const char*>())
     .def("rect", &TextSurface::rect)
     .def("setAlpha", &TextSurface::setAlpha)
     .def("draw", &TextSurface::draw),

     class_<ImageSurface, Surface>("ImageSurface")
     .def(constructor<const char*, bool>())
     .def("rect", &ImageSurface::rect)
     .def("setAlpha", &ImageSurface::setAlpha)
     .def("draw", &ImageSurface::draw),

     class_<Component>("Component"),

     class_<Label, Component>("Label")
     .def(constructor<Surface&>())
     .def("setPosition", &Label::setPosition)
     .def("position", &Label::position)
     ];
}
