<?php
class <!--{$class_name}-->_base extends myQuicty {


function pre_dispatch_index() {
	parent::pre_dispatch_index();
	$this->caching = 0; // caching page flag: 0 = none; 1 = simple; 2 = each query
	$this->cache_lifetime = 1800; // cache life time by seconds
	$this->cache_id = get_query_id();
	$this->page['data_name'] = '<!--{$data_name}-->';
	return true;
}

function assign_search_form($page_obj=NULL) {
	if($page_obj) {
		$my = $page_obj;
	} else {
		$my = $this;
	}
	$search_form = $my->new_search_obj('<!--{$data_name}-->_search',array('action'=>$my->page['base_url'].'<!--{if $dir_name}--><!--{$dir_name}--><!--{/if}-->/','method'=>'get'));
	$my->assign_form('search_form',$search_form);
}

function add_list_options($pager_option) {
	/* this method for override use when included by external class */
	return $pager_option;
}

function list_records($condition='',$perPage=20,$cond='AND') {
	require_once 'list_options.class.php';
	$this->list = $this->new_data_set('<!--{$data_name}-->');
	$options = new <!--{$class_name}-->_list_options($this);
	$options->perPage = $perPage;
	$pager_option = $options->get_pager_option($condition,$cond);
	$pager_option = $this->add_list_options($pager_option);
	// Uncomment below 1 line when grouping via select fields.
	//$this->list->count_condition = "GROUP BY <!--{$data_name}-->.id";
	$this->list->bind_pager($pager_option);
	
	$fields = $options->make_select_fields();
	$sort_condition = $options->make_sort_condition();
	// Uncomment below 2 line when grouping via select fields.
	//$group_condition = $options->make_grouping_condition();
	//$sort_condition = $group_condition.' '.$sort_condition;
	$list_table = $this->list->select_table_with_pager($sort_condition,$fields);
	return $list_table;
}

function set_pager() {
	$pager = $this->list->get_pager_links();
	$pager['pages_array'] = explode('&nbsp;&nbsp;',$pager['pages']);
	return $pager;
}

function add_form_options() {
	/* this method for override use when included by external class */
}

function display_record($condition='') {
	require_once 'form_options.class.php';
	$this->form = $this->new_data_set('<!--{$data_name}-->');
	$options = new <!--{$class_name}-->_form_options($this);
	$options->set_form_options();
	$this->add_form_options();
	$this->form->validate_and_freeze();
	$this->form->bind_button_control();
	
	$result = $this->form->automatic_form_handler($condition);
	$this-><!--{$data_name}--> = $result['<!--{$data_name}-->'] ? $result['<!--{$data_name}-->'] : $result['values'];
	return $result;
}


function assign_page_and_pathlist($page_name) {
	$this->set_pathlist('/',$this->W['top']);
<!--{if $dir_name}-->
	if($this->Quicty['action']!='index') {
		$upper_path = $this->W['<!--{$page_name}-->'].$this->W['list'];
		$this->add_pathlist('<!--{$dir_name}-->/index.html',$upper_path,false);
	}
	$this->add_pathlist('',$page_name);
<!--{/if}-->
	$this->page['name'] = $page_name;
	$this->assign('page',$this->page);
}

function batch_update($condition='') {
	require_once 'list_options.class.php';
	$this->list = $this->new_data_set('<!--{$data_name}-->');
	$options = new <!--{$class_name}-->_list_options($this);
	$pager_option = $options->get_pager_option($condition);
	$this->list->bind_pager($pager_option);
	$fields = $options->make_select_fields();
	$sort_condition = $options->make_sort_condition();
	$options->set_batch_list_option();
	
	$this->list->set_button_status('use_confirm',false);
	$this->list->bind_button_control();
	$list_table = $this->list->automatic_batch_handler($sort_condition,$fields);
	return $list_table;
}



} // end of <!--{$class_name}-->_base class
?>