<?php
/**
 *	Project:	Quicty: Quick application build environment depends on PEAR and Smarty
 *	File:		Quicty/modules/template/userauth/lib/Pages/index.class.php
 *
 *	@copyright	Tomoyuki Negishi and ZubaPitaTech, Inc.
 *	@author		Tomoyuki Negishi <tomoyu-n@zubapita.jp>
 *	@license	http://www.opensource.org/licenses/bsd-license.php The BSD License
 *	@package	Quicty
 *	@version	$Id:$
 */
class user extends myQuicty {

public function pre_dispatch_index() {
	parent::pre_dispatch_index();
	$this->page['base_url'] = quicty_base_url();
	
	return true;
}

function list_record() {
	$form = $this->new_data_set('user');
	$perPage = 10;
	$condition = '';
	$form->bind_pager(array('perPage'=>$perPage,'condition'=>$condition,'prevImg'=>''.$perPage.'','nextImg'=>''.$perPage.''));
	$table = $form->select_table_with_pager(' order by id');
	$this->assign('table_view',$form->display_table_value($table));
	$this->assign('display_cmd','info');
	$navi = $form->get_pager_links();
	$this->assign('pager_navi',$navi['all']);
	$this->assign('page',$this->page);
	//-- End of list_record
	$result = $this->display($this->current_template);
}

function display_record($condition='') {
	$form = $this->new_data_set('user');
	$form->set_base_link_addr(quicty_base_url().'/user/');
	$form->set_restart_link_addr(quicty_base_url().'/user/');
	$form->set_button_label('delete_confirm','');
	$form->set_button_label('delete','˼¹');
	$form->validate_and_freeze();
	$form->bind_button_control();
	$result = $form->automatic_form_handler($condition);
	switch($this->QuictyStatus) {
		case 'INSERT':
			$_SESSION['next'] = NULL;
			if(!$this->user['level']) {
				$_SESSION['regiserd_massege'] = "桼ϿǤޤ\n󤷤Ƥ\n";
				if($_REQUEST['next']) {
					redirect('/user/login?next='.$_REQUEST['next']);
				} else {
					redirect('/user/login');
				}
				exit;
			}
	}

	$this->user = $result['values'];
	$this->assign_form('input_form',$form);
	$this->assign('page',$this->page);
	//-- End of display_record
	if($this->user['level'] >= admin_user) {
		$upper_path = 'ڡ';
		$this->add_pathlist('/user/',$upper_path,false);
		$this->add_pathlist('',$this->page['name']);
	}
	$this->display($this->current_template);
}

//------------------------------------------------------------------

function dispatch_index() {
	if($this->user['level'] < admin_user) redirect('top');
	$this->page['name'] = '桼Ͽΰ';
	$this->list_record('');
}

function dispatch_add() {
	if($_REQUEST['next']) $this->assign('next',$_REQUEST['next']);
	if($this->user['level'] >= registerd_user and $this->user['level'] < admin_user)
		redirect('/usr/info');
	$this->page['name'] = '桼Ͽɲ';
	$this->display_record('');
}

function dispatch_info() {
	if($this->user['level'] < registerd_user) redirect('top');
	if(isset($_REQUEST['id']) and $_REQUEST['id']!=$this->user['id'] and $this->user['level'] < admin_user)
		redirect('top');
	$this->page['name'] = '桼Ͽɽ';
	if(!$_REQUEST['id']) {
		$this->display_record('where id='.$this->user['id']);
	} else {
		$this->display_record();
	}
}

function dispatch_edit() {
	if($this->user['level'] < registerd_user) redirect('top');
	if(isset($_REQUEST['id']) and $_REQUEST['id']!=$this->user['id'] and $this->user['level'] < admin_user)
		redirect('top');
	$this->page['name'] = '桼ϿԽ';
	if(!$_REQUEST['id']) {
		$this->display_record('where id='.$this->user['id']);
	} else {
		$this->display_record();
	}
}

function dispatch_delete() {
	if($this->user['level'] < registerd_user) redirect('top');
	if(isset($_REQUEST['id']) and $_REQUEST['id']!=$this->user['id'] and $this->user['level'] < admin_user)
		redirect('top');

	if($this->QuictyStatus=='DELETE' and $_REQUEST['id'] and 
		($_REQUEST['id']==$this->user['id'] or $this->user['level'] >= admin_user) ) {
		$form = $this->new_data_set('user');
		$condition = 'where id='.$_REQUEST['id'];
		$form->delete($condition);
		if($_REQUEST['id']==$this->user['id']) 
			redirect('/user/quit_member.html');
	}

	$this->page['name'] = '桼Ͽκ';
	if($_REQUEST['id']) {
		$this->display_record('where id='.$_REQUEST['id']);
	} else {
		$this->display_record('where id='.$this->user['id']);
	}
}

//------------------------------------------------------------------

function dispatch_login() {
	$this->page['name'] = '';
	if($_REQUEST['next']) $this->assign('next',$_REQUEST['next']);
	if($_SESSION['regiserd_massege']) {
		$this->assign('login_message',$_SESSION['regiserd_massege']);
		$_SESSION['regiserd_massege'] = '';
	}
	$auth = $this->get_auth_obj();
	if($auth->getAuth()) {
		$_SESSION['next'] = NULL;
		if($_POST['next']) {
			redirect('http://'.$_POST['next']);
		} else {
			redirect('top');
		}
	} else {
		$_FORM = $this->new_form_obj('login');
		$_FORM->bind_data_view('login.view.conf');
		$this->set_qs_status('SEND');
		$_FORM->bind_button_control();
		$auth_status = $auth->getStatus();
		if($auth_status==AUTH_WRONG_LOGIN) {
			$this->set_form_error("ID⤷ϥѥɤְäƤޤ");
		}
		$this->assign_form('form',$_FORM);
		$this->assign('page',$this->page);
		$this->display($this->current_template);
	}
}

function dispatch_logout() {
	$this->page['name'] = '';
	$auth = $this->get_auth_obj();
	$auth->logout();
	$user['authorized'] = false;
	$user['handle'] = '';
	$this->assign('user',$user);
	$this->assign('page',$this->page);
	$this->display($this->current_template);
}

function dispatch_quit_member() {
	$this->page['name'] = '';
	$auth = $this->get_auth_obj();
	$auth->logout();
	$user['authorized'] = false;
	$user['handle'] = '';
	$this->assign('user',$user);
	$this->assign('page',$this->page);
	$this->display($this->current_template);
}


} // end of user class
?>