Const ForReading = 1, ForWriting = 2, ForAppending = 8
CRLF = Chr(13) & Chr(10)

Set objFSO = WScript.CreateObject("Scripting.FileSystemObject")
If objFSO.FileExists("C:\xampp\apache\conf\httpd.conf") Then
	fileName = "C:\xampp\apache\conf\httpd.conf"
ElseIf objFSO.FileExists("C:\Program Files\xampp\apache\conf\httpd.conf") Then
	fileName = "C:\Program Files\xampp\apache\conf\httpd.conf"
Else
	Wscript.Echo "XAMPP܂" & CRLF & "C:\xampp  C:\Program Files\xampp ɃCXg[Ă"
	Wscript.Quit
End If
'Wscript.Echo fileName

pattern_rewrite = "^LoadModule rewrite_module modules/mod_rewrite.so$"
add_point_rewrite = "#.*LoadModule rewrite_module modules/mod_rewrite.so"
add_line_rewrite = "LoadModule rewrite_module modules/mod_rewrite.so"

pattern_vhost = "^[^#]*Include conf/extra/httpd-vhosts.conf"
add_line_vhost = "#" & CRLF
add_line_vhost = add_line_vhost & "# Virtual hosts" & CRLF
add_line_vhost = add_line_vhost & "Include conf/extra/httpd-vhosts.conf"


result = fileCheck(fileName,pattern_rewrite)
If result<>"" Then
	need_rewrite = False
	Wscript.Echo "Found : " & result
Else 
	need_rewrite = True
End If

result = fileCheck(fileName,pattern_vhost)
If result<>"" Then
	need_vhost = False
	Wscript.Echo "Found : " & result
Else 
	need_vhost = True
End If

If need_rewrite Then
	result = fileAdd(fileName,add_line_rewrite,add_point_rewrite)
	Wscript.Echo "Add LoadModule : '" & result & "' to " & fileName 
End if

If need_vhost Then
	result = fileWrite(fileName,add_line_vhost)
	Wscript.Echo "Add Include VirtualHost : '" & result & "' to " & fileName 
End if

Function fileCheck(fileName,pattern)
Set objFSO = WScript.CreateObject("Scripting.FileSystemObject")
Set objInput = objFSO.OpenTextFile(fileName, ForReading)
fileCheck = ""
Do Until objInput.AtEndOfStream
	strLine = objInput.ReadLine
	If rexpCheck(pattern,strLine) Then
		' Wscript.Echo StrLine
		fileCheck = StrLine
	End If
Loop
objInput.Close
End Function


Function fileWrite(fileName,addLine)
	Set objFSO = WScript.CreateObject("Scripting.FileSystemObject")
	Set objInput = objFSO.OpenTextFile(fileName, ForReading)
	tempFileName = fileName & "_temp" 
	' Wscript.Echo tempFileName
	Set objOutput = objFSO.OpenTextFile(tempFileName, ForWriting, True)
	Do Until objInput.AtEndOfStream
		strLine = objInput.ReadLine
		objOutput.WriteLine strLine
	Loop
	objOutput.WriteLine addLine
	objInput.Close
	objOutput.Close

	backupFileName = fileName & "_bak2"
	If objFSO.FileExists(backupFileName) Then
   		objFSO.DeleteFile backupFileName
	End If
   	objFSO.MoveFile fileName , backupFileName
   	objFSO.MoveFile tempFileName , fileName
	
	fileWrite = addLine
End Function

Function fileAdd(fileName,addLine,addPoint)
	Set objFSO = WScript.CreateObject("Scripting.FileSystemObject")
	Set objInput = objFSO.OpenTextFile(fileName, ForReading)
	tempFileName = fileName & "_temp" 
	Set objOutput = objFSO.OpenTextFile(tempFileName, ForWriting, True)
	Do Until objInput.AtEndOfStream
		strLine = objInput.ReadLine
		objOutput.WriteLine strLine
		If rexpCheck(addPoint,strLine) Then
			' Wscript.Echo StrLine
			objOutput.WriteLine addLine
		End If
	Loop
	objInput.Close
	objOutput.Close

	backupFileName = fileName & "_bak1"
	If objFSO.FileExists(backupFileName) Then
   		objFSO.DeleteFile backupFileName
	End If
   	objFSO.MoveFile fileName , backupFileName
   	objFSO.MoveFile tempFileName , fileName
	
	fileAdd = addLine
End Function


Function rexpCheck(pattern,strLine)
	Dim objRE
	Set objRE = new RegExp
	objRE.IgnoreCase = True
	objRE.pattern = pattern
	rexpCheck = objRE.Test(strLine)
End Function

