<?php
class send_trackback_ping extends QuictyPlugin {
	public $plugin_title = 'send trackback ping';

	protected function make_contents() {
		return $response = $this->trackback_ping(
			$this->params['target_url'],
			$this->params['url'],
			$this->params['title'],
			$this->params['blog_name'],
			$this->params['excerpt'],
			$this->params['x-rating'],
			$this->params['x-rating-icon']
		);
	}

	function trackback_ping($target_url,$url,$title,$blog_name,$excerpt,$x_rating,$x_rating_icon) {
		$port = 80;
		$query = "";
		
		$ping_data  = "url=".urlencode($url);
		$ping_data .= "&title=".urlencode( mb_convert_encoding( $title,'UTF-8','EUC-JP'));
		$ping_data .= "&blog_name=".urlencode( mb_convert_encoding($blog_name,'UTF-8','EUC-JP'));
		$ping_data .= "&excerpt=".urlencode( mb_convert_encoding( $excerpt,'UTF-8','EUC-JP'));
		if($x_rating) {
			$ping_data .= "&x-rating=".urlencode($x_rating);
			$ping_data .= "&x-rating-icon=".urlencode($x_rating_icon);
		}
		
		$ping_url = parse_url(trim($target_url));
		if(isset( $ping_url['query'])) $query = "?".$ping_url['query'];
		if(isset( $ping_url['port'])) $port = $ping_url['port'];
		
		$request  = "POST ".$ping_url['path'].$query." HTTP/1.0\r\n";
		$request .= "Host: ".$ping_url['host']."\r\n";
		$request .= "User-Agent: PHP/".phpversion()."\r\n";
		$request .= "Content-type: application/x-www-form-urlencoded\r\n";
		$request .= "Content-Length: ".strlen($ping_data)."\r\n\r\n";
		$request .= $ping_data."\r\n";

		//echo "target_url=$target_url\n";
		//echo "trackback to ="; print_r($ping_url); echo "\n";
		//echo "request=$request\n";
		
		$socket = fsockopen( $ping_url['host'], $port );
		if($socket) {
			fputs($socket,$request);
			$response = '';
			while(!feof($socket)) {
				$line = fgets($socket);
				echo $line;
				if($contents_started) {
					$response .= $line;
				} elseif(preg_match('/^<xml.*>$/',$line)) {
					$contents_started = true;
					$response .= $line;
				}
			}
			fclose($socket);
		}
		return $response;
	}

}
?>
