<?php
require_once 'index.options.php';
class index extends index_options {

function list_records() {
	if(!$this->is_cached($this->current_template,$this->cache_id)) {
		$this->assign_search_form();
		$this->list = $this->new_data_set('application');
		$perPage = 20;
		$fields = $this->make_select_fields();
		$where_condition = $this->make_where_condition();
		$sort_condition = $this->make_sort_condition();
		$join_condition = $this->make_join_condition();
		$select_condition = $join_condition.' '.$where_condition;
		$pager_option = $this->set_pager_option($perPage,$select_condition);
		
		$this->list->bind_pager($pager_option);
		$table = $this->list->select_table_with_pager($sort_condition,$fields);
		
		$this->assign('table_view',$this->list->display_table_value($table));
		$this->assign('display_cmd','info');
		$this->page['pager'] = $this->list->get_pager_links();
		$this->assign('page',$this->page);
	}
	return $this->display($this->current_template,$this->cache_id);
}


function display_record($condition='') {
	$this->assign_search_form();
	$this->form = $this->new_data_set('application');
	$this->set_form_options();
	$this->set_form_filters();
	$this->form->validate_and_freeze();
	$this->form->bind_button_control();
	
	$result = $this->form->automatic_form_handler($condition);
	$this->application = $result['application'] ? $result['application'] : $result['values'];
	$this->post_form_process();
	$this->assign_form('input_form',$this->form);

	if($_GET['id']) {
		$folder = $this->new_data_set('folder');
		$folders = $folder->select_table('where application_id='.$_GET['id'].' order by name');
	
		$page = $this->new_data_set('page');
		
		$fields = 'page.id as id,folder.name as folder_name,folder_id,page.name as name,title';
		$join_condition = 'left outer join folder on page.folder_id=folder.id';
		$where_condition = 'where page.application_id='.$_GET['id'];
		$sort_condition = 'order by folder.name,page.folder_id,page.name';
		$condition = $join_condition.' '.$where_condition.' '.$sort_condition;
		$pages = $page->select_table($condition,$fields);
		//$this->assign('pages',$page->display_table_value($pages));
	
		require_once 'includes/page_tree.class.php';
		$tree = new page_tree();
		$page_tree = $tree->make($this->application['id'],$folders,$pages);
		$this->assign('page_tree',$page_tree->toHTML());
	
		$dataset = $this->new_data_set('datasets');
		$datasets = $dataset->select_table('where application_id='.$_GET['id'].' order by name');
		$this->assign('datasets',$dataset->display_table_value($datasets));
	}

	$this->assign('page',$this->page);
	return $this->display($this->current_template,$this->cache_id);
}

//-----------------------------------------------------------------
// dispatch point

function dispatch_add_package() {
	$files = list_dir($this->Quicty_modules.'/templates');
	if($_POST['template']) {
		$application_id = $_POST['id'];
		$applications = $this->new_data_set('application');
		$application = $applications->select_table('where id='.$application_id);
		$app_root = $application[0]['application_root'];
		$app_name = $application[0]['name'];
		$db_name = $application[0]['db_name'];

		$folder_id = $_POST['folder_id'];
		if($folder_id) {
			$folders = $this->new_data_set('folder');
			$folder = $folders->select_table('where id='.$folder_id);
			$folder_name = '/'.$folder[0]['name'];
		} else {
			$folder_id = 0;
		}
		
		$this->assign('db_name',$db_name);
		$this->assign('folder_name',$folder_name);

		$template_id = $_POST['template'] -1;
		$template_name = $files[$template_id];
		$temp_root = $this->Quicty_modules.'/templates/'.$template_name;
		require_once 'includes/package_file.class.php';
		$package_file = new package_file();
		$package_file->add($temp_root,$app_root,$folder_name);
		require_once 'includes/import_app.class.php';
		$importer = new import_app;
		$importer->import_pages($temp_root,'',$application_id,$folder_id);
		$datasets_ids = $importer->import_datasets($temp_root,$application_id,$db_name);
		if(count($datasets_ids)>0)
			redirect('/info?id='.$application_id);

		$this->page['message'] = "add Package '$template_name' to application:$app_name<br />\n";
	}
	$form = new HTML_QuickForm('add_module','POST',$this->page['base_url'].'/add_package');
	foreach($files as $key=>$name) {
		$form->addElement('radio','template',$name,' ɲ',$key+1);
	}
	$form->setDefaults(array('templates'=>1));
	$form->addElement('hidden','id',$_REQUEST['id']);
	$folder_id = $_REQUEST['folder_id'] ? $_REQUEST['folder_id'] : 0;
	$form->addElement('hidden','folder_id',$folder_id);
	$form->addElement('submit','submit','ɲ');
	$renderer = new HTML_QuickForm_Renderer_ArraySmarty($form);
	$form->accept($renderer);
	$templates = $renderer->toArray();
	foreach($templates['template'] as $key=>$attributes) {
		$templates[' '.$key] = $attributes;
	}
	unset($templates['template']);
	$this->assign('input_form',$templates);
	$this->page['name'] = 'ѥåɲ';
	$this->assign('page',$this->page);
	return $this->display($this->current_template);
}

function dispatch_init_datasets() {
	$application_id = $_GET['id'];
	$app_datasets = $this->new_data_set('datasets');
	$datasets = $app_datasets->select_table("where application_id=$application_id and init_when_build=1");
	if(is_array($datasets) and count($datasets)>0) {
		require_once 'includes/datasets_conf/write.class.php';
		$write_conf = new datasets_conf_write();
		require_once 'includes/datasets_conf/create_table.class.php';
		$create_table = new datasets_conf_create_table();
		foreach($datasets as $each_dataset){
			$datasets_id = $each_dataset['id'];
			$write_result = $write_conf->write_conf($datasets_id,$all=true);
			$create_result = $create_table->create_table($datasets_id,$command='create_table');
		}
		$write_conf->write_all_init($datasets);
	}
	redirect("/info?id=$application_id");
}

function dispatch_unify_datasets() {
	$application_id = $_GET['id'];
	$applications = $this->new_data_set('application');
	$application = $applications->select_table('where id='.$application_id);
	$app_datasets = $this->new_data_set('datasets');
	$datasets = $app_datasets->select_table("where application_id=$application_id and init_when_build=1");
	if(is_array($datasets) and count($datasets)>0) {
		foreach($datasets as $each_dataset){
			$datasets_id = $each_dataset['id'];
			$update_set['system'] = $application[0]['system'];
			$update_set['dbname'] = $application[0]['db_name'];
			$update_set['path'] = $application[0]['path'];
			$update_set['host'] = $application[0]['host'];
			$update_set['port'] = $application[0]['port'];
			$update_set['user'] = $application[0]['user'];
			$update_set['password'] = $application[0]['password'];
			if($application[0]['persistent']) {
				$update_set['persistent'] = 1;
			}
			//var_check($update_set);
			$app_datasets->update_table($update_set,'WHERE id='.$datasets_id);
		}
	}
	redirect("/info?id=$application_id");
}


function dispatch_exec_test_app() {
	$application_id = $_GET['id'];
	$application = $this->new_data_set('application');
	$apps = $application->select_table("where id=$application_id");
	$app_name = $apps[0]['name'];
	redirect("http://quicty.local/$app_name/");
}

function dispatch_index() {
	$this->page['name'] = 'ץꥱΰ';
	$this->list_records('');
}

function dispatch_add() {
	$this->page['name'] = 'ץꥱɲ';
	$this->display_record('');
}

function dispatch_info() {
	$this->page['name'] = 'ץꥱɽ';
	$condition = ' where id='.$_GET['id'];
	$this->display_record($condition);
}

function dispatch_edit() {
	$this->page['name'] = 'ץꥱԽ';
	$this->display_record($condition);
}

function dispatch_delete() {
	$this->page['name'] = 'ץꥱκ';
	$this->display_record($condition);
}

} // end of index class
?>